/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers.opengl;

import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.opengl.GlTextureView;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL30C;

public class OpenGLHelper {
    private static boolean CHECKED_ANISOTROPY = false;
    private static boolean ANISOTROPY_SUPPORTED = false;
    private static int ANISOTROPY_LEVEL = -1;
    private static final int ANISOTROPY_PARAMETER = 34046;
    private static final int MAX_ANISOTROPY_PARAMETER = 34047;

    public static void bindTexture(int slot, GpuTextureView texture) {
        if (!(texture instanceof GlTextureView)) {
            throw new IllegalStateException("Vivecraft: only opengl textures are supported");
        }
        GlTextureView glTextureView = (GlTextureView)texture;
        GlStateManager._activeTexture((int)(33984 + slot));
        GlStateManager._bindTexture((int)glTextureView.texture().glId());
    }

    public static void genMipmaps(GpuTexture texture) {
        if (!(texture instanceof GlTexture)) {
            throw new IllegalStateException("Vivecraft: only opengl textures are supported");
        }
        GlTexture glTexture = (GlTexture)texture;
        int textureUnit = GlStateManager._getActiveTexture();
        int boundTexture = GlStateManager._getInteger((int)32873);
        GlStateManager._activeTexture((int)33984);
        GlStateManager._bindTexture((int)glTexture.glId());
        GL30C.glGenerateMipmap((int)3553);
        GlStateManager._activeTexture((int)textureUnit);
        GlStateManager._bindTexture((int)boundTexture);
    }

    public static void enableAnisotropicFiltering(GpuTexture texture) {
        if (OpenGLHelper.supportsAnisotropicFiltering()) {
            if (texture instanceof GlTexture) {
                GlTexture glTexture = (GlTexture)texture;
                int textureUnit = GlStateManager._getActiveTexture();
                int boundTexture = GlStateManager._getInteger((int)32873);
                GlStateManager._activeTexture((int)33984);
                GlStateManager._bindTexture((int)glTexture.glId());
                GlStateManager._texParameter((int)3553, (int)34046, (int)ANISOTROPY_LEVEL);
                GlStateManager._activeTexture((int)textureUnit);
                GlStateManager._bindTexture((int)boundTexture);
            } else {
                throw new IllegalStateException("Vivecraft: only opengl textures are supported");
            }
        }
    }

    public static boolean supportsAnisotropicFiltering() {
        if (!CHECKED_ANISOTROPY) {
            if (RenderSystem.getDevice() instanceof GlDevice && GLFW.glfwExtensionSupported((CharSequence)"GL_ARB_texture_filter_anisotropic") || GLFW.glfwExtensionSupported((CharSequence)"GL_EXT_texture_filter_anisotropic")) {
                ANISOTROPY_SUPPORTED = true;
                ANISOTROPY_LEVEL = Math.min(16, GlStateManager._getInteger((int)34047));
            }
            CHECKED_ANISOTROPY = true;
        }
        return ANISOTROPY_SUPPORTED;
    }
}

