/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.renderer;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.util.Mth;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_xr.render_pass.RenderPassType;
import org.vivecraft.common.utils.MathUtils;

@Mixin(value={ScreenEffectRenderer.class})
public class ScreenEffectRendererVRMixin {
    @WrapOperation(method={"renderItemActivationAnimation(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V")})
    private void vivecraft$noTranslateItemInVR(PoseStack instance, float x, float y, float z, Operation<Void> original) {
        if (RenderPassType.isVanilla()) {
            original.call(new Object[]{instance, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z)});
        } else {
            instance.mulPose((Matrix4fc)RenderHelper.getVRModelView(ClientDataHolderVR.getInstance().currentPass).invert());
        }
    }

    @WrapOperation(method={"renderItemActivationAnimation(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;scale(FFF)V")})
    private void vivecraft$noScaleItem(PoseStack poseStack, float x, float y, float z, Operation<Void> original, @Local(ordinal=5) float progress) {
        if (RenderPassType.isVanilla()) {
            original.call(new Object[]{poseStack, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z)});
        } else {
            float sinProgress = Mth.sin((float)progress) * 0.5f;
            poseStack.translate(0.0f, 0.0f, sinProgress - 1.0f);
            RenderPass pass = ClientDataHolderVR.getInstance().currentPass;
            if (pass == RenderPass.THIRD) {
                sinProgress *= ClientDataHolderVR.getInstance().vrSettings.mixedRealityFov / 70.0f;
            } else if (pass == RenderPass.CENTER) {
                sinProgress *= (float)((Integer)Minecraft.getInstance().options.fov().get()).intValue() / 70.0f;
            } else if (pass == RenderPass.LEFT || pass == RenderPass.RIGHT) {
                VRData data = ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld();
                Vector3f offset = MathUtils.subtractToVector3f(data.getEye(pass).getPosition(), data.getEye(RenderPass.CENTER).getPosition());
                data.getEye(RenderPass.CENTER).getMatrix().invert().transformPosition(offset);
                poseStack.translate(-offset.x, -offset.y, -offset.z);
            }
            original.call(new Object[]{poseStack, Float.valueOf(sinProgress), Float.valueOf(sinProgress), Float.valueOf(sinProgress)});
        }
    }

    @ModifyArg(method={"renderItemActivationAnimation(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/Lighting;setupFor(Lcom/mojang/blaze3d/platform/Lighting$Entry;)V"))
    private Lighting.Entry vivecraft$worldLighting(Lighting.Entry entry) {
        if (!RenderPassType.isVanilla()) {
            return Lighting.Entry.LEVEL;
        }
        return entry;
    }
}

