/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.vivecraft.client.gui.framework.TooltipRenderer;
import org.vivecraft.client.gui.framework.widgets.SettingsList;
import org.vivecraft.mixin.client.gui.GuiGraphicsAccessor;

public abstract class GuiListScreen
extends Screen {
    protected final Screen lastScreen;
    protected SettingsList list;
    protected EditBox searchBox;
    protected boolean searchable;
    protected int lastSelected = -1;
    protected boolean reinit = false;

    public GuiListScreen(Component title, Screen lastScreen) {
        super(title);
        this.lastScreen = lastScreen;
        this.searchable = true;
    }

    protected void rebuildWidgets() {
        this.lastSelected = this.list != null ? this.list.children().indexOf(this.list.getSelected()) : -1;
        super.rebuildWidgets();
    }

    protected void init() {
        this.clearWidgets();
        double scrollAmount = this.list != null ? this.list.scrollAmount() : 0.0;
        String filter = this.list != null ? this.list.getActiveFilter() : "";
        this.list = new SettingsList(this, this.minecraft, this.getEntries(), this.searchable);
        if (this.searchable) {
            this.list.filter(filter);
            this.searchBox = new EditBox(this.minecraft.font, this.width / 2 - 150, 20, 300, 20, (Component)Component.translatable((String)"vivecraft.options.screen.search"));
            this.searchBox.setHint((Component)Component.translatable((String)"vivecraft.options.screen.search").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
            this.searchBox.setValue(filter);
            this.searchBox.setResponder(search -> this.list.filter((String)search));
            this.addRenderableWidget((GuiEventListener)this.searchBox);
        } else {
            this.searchBox = null;
        }
        List children = this.list.children();
        this.list.setSelected((AbstractSelectionList.Entry)(this.lastSelected == -1 ? null : (SettingsList.BaseEntry)((Object)children.get(Math.min(children.size() - 1, this.lastSelected)))));
        this.list.setFocused((GuiEventListener)this.list.getSelected());
        this.list.setScrollAmount(scrollAmount);
        this.addRenderableWidget((GuiEventListener)this.list);
        this.addLowerButtons(this.height - 26);
    }

    protected void addLowerButtons(int top) {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.minecraft.setScreen(this.lastScreen)).bounds(this.width / 2 - 100, top, 200, 20).build());
    }

    protected abstract List<SettingsList.BaseEntry> getEntries();

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.reinit) {
            this.init();
            this.reinit = false;
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 8, -1);
        SettingsList.BaseEntry entry = null;
        if (this.minecraft.getLastInputType().isKeyboard() && this.list.getSelected() != null) {
            entry = (SettingsList.BaseEntry)this.list.getSelected();
        } else if (this.list.getHovered() != null) {
            entry = this.list.getHovered();
        }
        if (entry != null && this.list.isEntryVisible(entry) && ((GuiGraphicsAccessor)guiGraphics).getDeferredTooltip() == null) {
            TooltipRenderer.renderTooltip(guiGraphics, entry.getTooltip(), this.width / 2, this.list.getRowTop(this.list.children().indexOf((Object)entry)) + 2, this.list.getItemHeight());
        }
    }
}

