/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import org.vivecraft.client.gui.framework.screens.GuiListEditorScreen;

public class GuiStringListEditorScreen
extends GuiListEditorScreen<String> {
    public GuiStringListEditorScreen(Component title, Screen lastScreen, boolean fixedEntryCount, Supplier<List<String>> valuesSupplier, Runnable loadDefaults, Consumer<List<String>> save) {
        super(title, lastScreen, fixedEntryCount, valuesSupplier, loadDefaults, save);
        this.searchable = false;
    }

    @Override
    protected void addNewValue() {
        super.addNewValue();
        this.elements.add("");
    }

    @Override
    protected GuiListEditorScreen.ValueEntry<String> toEntry(String value, int index) {
        EditBox box = new EditBox(Minecraft.getInstance().font, 0, 0, 350, 20, (Component)Component.literal((String)value));
        box.setMaxLength(1000);
        box.setValue(value);
        box.setResponder(s -> this.elements.set(index, s));
        return new StringValueEntry((Component)Component.empty(), box, button -> {
            this.elements.remove(index);
            this.reinit = true;
        }, !this.fixedEntryCount);
    }

    private static class StringValueEntry
    extends GuiListEditorScreen.ValueEntry<String> {
        private final EditBox editBox;
        private final Button deleteButton;

        public StringValueEntry(Component name, EditBox editBox, Button.OnPress deleteAction, boolean deletable) {
            super(name, null);
            this.editBox = editBox;
            this.deleteButton = Button.builder((Component)Component.literal((String)(deletable ? "-" : "X")), (Button.OnPress)(deletable ? deleteAction : b -> this.editBox.setValue(""))).tooltip(Tooltip.create((Component)Component.translatable((String)"selectWorld.delete"))).bounds(0, 0, 20, 20).build();
        }

        @Override
        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.editBox.setX(this.getContentX());
            this.editBox.setY(this.getY());
            this.editBox.setWidth(this.getContentWidth() - 20);
            this.editBox.render(guiGraphics, mouseX, mouseY, partialTick);
            this.deleteButton.setX(this.getContentRight() - 20);
            this.deleteButton.setY(this.getY());
            this.deleteButton.render(guiGraphics, mouseX, mouseY, partialTick);
        }

        public boolean keyPressed(KeyEvent keyEvent) {
            if (this.getFocused() == this.editBox && keyEvent.key() == 262 && this.editBox.getValue().length() == this.editBox.getCursorPosition()) {
                return false;
            }
            return super.keyPressed(keyEvent);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.editBox, (Object)this.deleteButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.editBox, (Object)this.deleteButton);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.editBox.active = active;
            this.deleteButton.active = active;
        }

        @Override
        public String getValue() {
            return this.editBox.getValue();
        }
    }
}

