/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.widgets;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import org.vivecraft.client_vr.utils.RGBAColor;

public class ColorPicker
extends AbstractWidget {
    private static final int HUE_WIDTH = 10;
    private float hue;
    private float saturation = 0.0f;
    private float brightness = 1.0f;
    private boolean clickedHue;

    public ColorPicker(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.literal((String)"Color Picker"));
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -16777216);
        for (int i = 0; i < this.height - 2; ++i) {
            RGBAColor color = RGBAColor.fromHSB((float)i / (float)(this.height - 2), 1.0f, 1.0f);
            guiGraphics.fill(this.getX() + 1, this.getY() + i + 1, this.getX() + 10 - 1, this.getY() + i + 2, ARGB.colorFromFloat((float)1.0f, (float)color.r, (float)color.g, (float)color.b));
        }
        for (int x = 10; x < this.width - 2; ++x) {
            for (int y = 0; y < this.height - 2; ++y) {
                RGBAColor color = RGBAColor.fromHSB(this.hue, (float)(x - 10) / (float)(this.width - 10 - 2), 1.0f - (float)y / (float)(this.height - 3));
                int xPos = this.getX() + x + 1;
                int yPos = this.getY() + y + 1;
                guiGraphics.fill(xPos, yPos, xPos + 1, yPos + 1, ARGB.colorFromFloat((float)1.0f, (float)color.r, (float)color.g, (float)color.b));
            }
        }
        int satX = (int)((float)(this.getX() + 10 + 1) + this.saturation * (float)(this.width - 10 - 3));
        int satY = (int)((float)(this.getY() + 1) + (1.0f - this.brightness) * (float)(this.height - 3));
        guiGraphics.submitOutline(satX - 2, satY - 2, 5, 5, -1);
        int hueY = (int)((float)(this.getY() + 1) + this.hue * (float)(this.height - 3));
        guiGraphics.submitOutline(this.getX(), hueY - 2, 10, 5, -1);
    }

    public void onClick(MouseButtonEvent event, boolean isDoubleClick) {
        this.clickedHue = event.x() < (double)(this.getX() + 10);
        this.setColor(event.x(), event.y());
    }

    protected void onDrag(MouseButtonEvent event, double mouseX, double mouseY) {
        this.setColor(event.x(), event.y());
    }

    private void setColor(double mouseX, double mouseY) {
        if (this.clickedHue) {
            this.hue = (float)Math.clamp((mouseY - (double)(this.getY() + 1)) / (double)(this.height - 2), 0.0, 1.0);
        } else {
            this.brightness = 1.0f - (float)Math.clamp((mouseY - (double)this.getY() - 1.0) / (double)(this.height - 2), 0.0, 1.0);
            this.saturation = (float)Math.clamp((mouseX - (double)this.getX() - 10.0 - 1.0) / (double)(this.getWidth() - 10 - 2), 0.0, 1.0);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    public RGBAColor getColor() {
        return RGBAColor.fromHSB(this.hue, this.saturation, this.brightness);
    }

    public void setColor(RGBAColor color) {
        float max = Math.max(color.r, Math.max(color.g, color.b));
        float min = Math.min(color.r, Math.min(color.g, color.b));
        float dif = max - min;
        this.brightness = max;
        float f = this.saturation = max == 0.0f ? 0.0f : dif / max;
        if (dif == 0.0f) {
            this.hue = 0.0f;
            return;
        }
        this.hue = max == color.r ? (color.g - color.b) / dif : (max == color.g ? 2.0f + (color.b - color.r) / dif : 4.0f + (color.r - color.g) / dif);
        this.hue *= 60.0f;
        this.hue = (this.hue + 360.0f) % 360.0f / 360.0f;
    }
}

