/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.widgets;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class TextScrollWidget
extends AbstractWidget {
    private int maxLines = 0;
    private int currentLine = 0;
    private int scrollBarSize = 0;
    private int scrollBarOffset = 0;
    private int scrollSteps = 0;
    private boolean scrollDragActive;
    private final int scrollBarWidth = 5;
    private final int padding = 5;
    private final List<FormattedCharSequence> formattedChars;

    public TextScrollWidget(int x, int y, int width, int height, String text) {
        super(x, y, width, height, (Component)Component.literal((String)""));
        Font font = Minecraft.getInstance().font;
        MutableComponent mutableComponent = Component.literal((String)text);
        Objects.requireNonNull(this);
        this.formattedChars = font.split((FormattedText)mutableComponent, width - 5 * 2);
        this.initScroll();
    }

    public TextScrollWidget(int x, int y, int width, int height, Component text) {
        super(x, y, width, height, (Component)Component.literal((String)""));
        Font font = Minecraft.getInstance().font;
        Objects.requireNonNull(this);
        this.formattedChars = font.split((FormattedText)text, width - 5 * 2);
        this.initScroll();
    }

    private void initScroll() {
        Objects.requireNonNull(this);
        this.maxLines = (this.height - 2 - 5 + 3) / 12;
        this.currentLine = 0;
        this.scrollSteps = this.formattedChars.size() - this.maxLines;
        this.scrollSteps = Math.max(this.scrollSteps, 0);
        this.scrollBarSize = this.scrollSteps == 0 ? this.height - 2 : (int)((float)Math.max(this.formattedChars.size(), this.maxLines) / (float)this.scrollSteps * 12.0f);
        this.scrollBarOffset = this.height - this.scrollBarSize - 2;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float scrollbarStart;
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -6250336);
        guiGraphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.width - 1, this.getY() + this.height - 1, -16777216);
        for (int line = 0; line + this.currentLine < this.formattedChars.size() && line < this.maxLines; ++line) {
            Font font = Minecraft.getInstance().font;
            int n = this.getX();
            Objects.requireNonNull(this);
            int n2 = n + 5;
            int n3 = this.getY();
            Objects.requireNonNull(this);
            guiGraphics.drawString(font, this.formattedChars.get(line + this.currentLine), n2, n3 + 5 + line * 12, -1);
        }
        float f = scrollbarStart = this.scrollSteps == 0 ? 0.0f : (float)this.currentLine / (float)this.scrollSteps * (float)this.scrollBarOffset;
        if (this.isFocused() || this.isHovered) {
            int n = this.getX() + this.width;
            Objects.requireNonNull(this);
            guiGraphics.fill(n - 5 - 2, (int)((float)(this.getY() + 1) + scrollbarStart), this.getX() + this.width - 1, (int)((float)(this.getY() + 1) + scrollbarStart + (float)this.scrollBarSize), -1);
        }
        int n = this.getX() + this.width;
        Objects.requireNonNull(this);
        guiGraphics.fill(n - 5 - (this.isFocused() || this.isHovered ? 1 : 2), (int)((float)(this.getY() + (this.isFocused() || this.isHovered ? 2 : 1)) + scrollbarStart), this.getX() + this.width - (this.isFocused() || this.isHovered ? 2 : 1), (int)((float)(this.getY() + (this.isFocused() || this.isHovered ? 0 : 1)) + scrollbarStart + (float)this.scrollBarSize), -6250336);
        this.renderMouseover(guiGraphics, mouseX, mouseY);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void onClick(MouseButtonEvent mouseEvent, boolean doubleClick) {
        Style style;
        double d = mouseEvent.x();
        int n = this.getX() + this.width;
        Objects.requireNonNull(this);
        if (d >= (double)(n - 5) && mouseEvent.x() <= (double)(this.getX() + this.width) && mouseEvent.y() >= (double)this.getY() && mouseEvent.y() <= (double)(this.getY() + this.height)) {
            this.scrollDragActive = true;
            if (this.maxLines < this.formattedChars.size()) {
                this.setCurrentLineFromYPos(mouseEvent.y());
            }
        } else if (this.isMouseOver(mouseEvent.x(), mouseEvent.y()) && (style = this.getMouseoverStyle(mouseEvent.x(), mouseEvent.y())) != null && style.getClickEvent() != null) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null) {
                mc.screen.handleComponentClicked(style);
            } else {
                Screen.defaultHandleClickEvent((ClickEvent)style.getClickEvent(), (Minecraft)mc, (Screen)mc.screen);
            }
        }
    }

    public void onRelease(MouseButtonEvent mouseEvent) {
        this.scrollDragActive = false;
        super.onRelease(mouseEvent);
    }

    public void onDrag(MouseButtonEvent mouseEvent, double dragX, double dragY) {
        if (this.visible && this.active && this.scrollDragActive) {
            this.setCurrentLineFromYPos(mouseEvent.y());
        }
    }

    private void setCurrentLineFromYPos(double mouseY) {
        this.currentLine = mouseY < (double)this.getY() + (double)this.scrollBarSize * 0.5 ? 0 : (mouseY > (double)(this.getY() + this.height) - (double)this.scrollBarSize * 0.5 ? this.scrollSteps : (int)((mouseY - (double)this.getY() - (double)this.scrollBarSize * 0.5) / (double)(this.height - this.scrollBarSize) * (double)this.scrollSteps));
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY < 0.0 && this.currentLine < this.scrollSteps) {
            ++this.currentLine;
        } else if (scrollY > 0.0 && this.currentLine > 0) {
            --this.currentLine;
        } else {
            return false;
        }
        return true;
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if ((keyEvent.key() == 265 || keyEvent.key() == 264) && this.mouseScrolled(0.0, 0.0, 0.0, keyEvent.key() == 265 ? 1.0 : -1.0)) {
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    public Style getMouseoverStyle(double mouseX, double mouseY) {
        int lineIndex = this.getLineIndex(mouseX, mouseY);
        if (lineIndex >= 0 && lineIndex < this.formattedChars.size()) {
            FormattedCharSequence line = this.formattedChars.get(lineIndex);
            return Minecraft.getInstance().font.getSplitter().componentStyleAtWidth(line, Mth.floor((double)(mouseX - (double)this.getX())));
        }
        return null;
    }

    private int getLineIndex(double mouseX, double mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return -1;
        }
        double d = mouseY - (double)this.getY();
        Objects.requireNonNull(this);
        return (int)((d - 5.0 * 0.5) / 12.0);
    }

    public void renderMouseover(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Style style = this.getMouseoverStyle(mouseX, mouseY);
        if (style != null && style.getHoverEvent() != null) {
            guiGraphics.renderComponentHoverEffect(Minecraft.getInstance().font, style, mouseX, mouseY);
        }
    }
}

