/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.settings;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.vivecraft.client.gui.framework.screens.GuiSelectionListScreen;
import org.vivecraft.client.gui.framework.widgets.ColorPicker;
import org.vivecraft.client.gui.framework.widgets.ColoredButton;
import org.vivecraft.client.gui.framework.widgets.ColoredKeyButton;
import org.vivecraft.client_vr.gui.keyboard.CustomKeyboardTheme;
import org.vivecraft.client_vr.gui.keyboard.KeyboardKeys;
import org.vivecraft.client_vr.gui.keyboard.KeyboardTheme;

public class GuiKeyboardThemeEditor
extends Screen {
    private final Screen parent;
    private boolean isShift = false;
    private boolean reinit = false;
    private final CustomKeyboardTheme customTheme;
    private final ColorPicker colorPicker;

    protected GuiKeyboardThemeEditor(Screen parent) {
        super((Component)Component.translatable((String)"vivecraft.options.screen.customkeyboardthemeeditor"));
        this.customTheme = (CustomKeyboardTheme)KeyboardTheme.CUSTOM.theme;
        this.parent = parent;
        this.colorPicker = new ColorPicker(0, 0, 50, 40);
    }

    public void init() {
        int y;
        this.clearWidgets();
        KeyboardKeys.Layout layout = KeyboardKeys.getRegularKeys(this.isShift, () -> {});
        this.customTheme.reload();
        int spacing = 2;
        int buttonWidth = (int)(25.0f * Math.min((float)this.width / ((25.0f + (float)spacing) * ((float)layout.columns() + 5.0f)), 1.0f));
        int yMargin = 32 + this.height / 2 - (int)(((float)layout.rows() + 3.0f) / 2.0f * (float)(20 + spacing));
        int xMargin = this.width / 2 - (buttonWidth + spacing) * (layout.columns() + 5) / 2;
        this.colorPicker.setPosition(xMargin + (buttonWidth + spacing) * 15, yMargin - 42);
        this.addRenderableWidget((GuiEventListener)this.colorPicker);
        for (KeyboardKeys.Key key : layout.keys()) {
            y = key.y() < 0 ? layout.rows() - key.y() : key.y();
            this.addRenderableWidget((GuiEventListener)new ColoredKeyButton(key, xMargin + key.x() * (buttonWidth + spacing), yMargin + (y - 1) * (20 + spacing), buttonWidth, 20, b -> {
                if (Minecraft.getInstance().hasShiftDown()) {
                    this.colorPicker.setColor(((ColoredButton)b).getColor());
                } else {
                    this.customTheme.setColor(key.id(), this.colorPicker.getColor());
                    this.customTheme.save();
                }
            }, KeyboardTheme.CUSTOM));
        }
        for (KeyboardKeys.Key key : KeyboardKeys.getSpecialKeys()) {
            y = key.y() < 0 ? layout.rows() - key.y() : key.y();
            this.addRenderableWidget((GuiEventListener)new ColoredKeyButton(key, xMargin + key.x() * (buttonWidth + spacing), yMargin + (y - 1) * (20 + spacing), key.width() * buttonWidth + (key.width() - 1) * spacing, 20, b -> {
                if (Minecraft.getInstance().hasShiftDown()) {
                    this.colorPicker.setColor(((ColoredButton)b).getColor());
                } else {
                    this.customTheme.setColor(key.id(), this.colorPicker.getColor());
                    this.customTheme.save();
                }
            }, KeyboardTheme.CUSTOM));
        }
        this.addRenderableWidget((GuiEventListener)CycleButton.onOffBuilder((boolean)this.isShift).create(xMargin + 12 * (buttonWidth + spacing), yMargin - (20 + spacing), 3 * buttonWidth + 2 * spacing, 20, (Component)Component.translatable((String)"vivecraft.keyboard.key.shift"), (p, b) -> this.setShift(!this.isShift)));
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"vivecraft.options.screen.loadkeyboardtheme.button"), button -> this.minecraft.setScreen(new GuiSelectionListScreen<KeyboardTheme>((Component)Component.translatable((String)"vivecraft.options.screen.loadkeyboardtheme"), this, () -> Arrays.stream(KeyboardTheme.values()).filter(t -> t != KeyboardTheme.CUSTOM).toList(), theme -> Component.translatable((String)theme.getLangKey()), null, theme -> {
            this.customTheme.load(theme == null ? KeyboardTheme.DEFAULT : theme);
            this.customTheme.save();
        }, true, true, null))).bounds(this.width / 2 - 155, this.height - 30, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"gui.back"), p -> this.onClose()).bounds(this.width / 2 + 5, this.height - 30, 150, 20).build());
    }

    private void setShift(boolean shift) {
        if (shift != this.isShift) {
            this.isShift = shift;
            this.reinit = true;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.reinit) {
            this.init();
            this.reinit = false;
        }
        guiGraphics.drawCenteredString(this.font, this.getTitle(), this.width / 2, 15, -1);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"vivecraft.messages.shifttopickcolor"), this.width / 2, 30, -1);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }
}

