/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.extensions.EntityRenderStateExtension;
import org.vivecraft.client.render.VRPlayerModel;
import org.vivecraft.client.render.VRPlayerRenderData;
import org.vivecraft.client.render.models.HandModel;
import org.vivecraft.client.utils.ModelUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.settings.VRSettings;

public class VRPlayerModel_WithArms
extends VRPlayerModel
implements HandModel {
    public static final int LOWER_EXTENSION = 2;
    public static final int UPPER_EXTENSION = 3;
    public ModelPart leftHand;
    public ModelPart rightHand;
    public ModelPart leftHandSleeve;
    public ModelPart rightHandSleeve;
    private final Vector3f jointOffset = new Vector3f();

    public VRPlayerModel_WithArms(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.leftHand = root.getChild("left_hand");
        this.rightHand = root.getChild("right_hand");
        this.leftHandSleeve = this.leftHand.getChild("left_hand_sleeve");
        this.rightHandSleeve = this.rightHand.getChild("right_hand_sleeve");
        ModelUtils.textureHack(this.leftArm, this.leftHand);
        ModelUtils.textureHack(this.rightArm, this.rightHand);
        ModelUtils.textureHack(this.leftSleeve, this.leftHandSleeve);
        ModelUtils.textureHack(this.rightSleeve, this.rightHandSleeve);
    }

    public static MeshDefinition createMesh(CubeDeformation cubeDeformation, boolean slim) {
        float lowerShrinkage;
        MeshDefinition meshDefinition = VRPlayerModel.createMesh(cubeDeformation, slim);
        PartDefinition partDefinition = meshDefinition.getRoot();
        boolean connected = ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected;
        int upperExtension = connected ? 3 : 0;
        int lowerExtension = connected ? 2 : 0;
        float f = lowerShrinkage = connected ? -0.05f : 0.0f;
        if (slim) {
            PartDefinition leftHand = partDefinition.addOrReplaceChild("left_hand", CubeListBuilder.create().texOffs(32, 55 - lowerExtension).addBox(-1.5f, -5.0f - (float)lowerExtension, -2.0f, 3.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(lowerShrinkage)), PartPose.offset((float)5.5f, (float)12.0f, (float)0.0f));
            leftHand.addOrReplaceChild("left_hand_sleeve", CubeListBuilder.create().texOffs(48, 55 - lowerExtension).addBox(-1.5f, -5.0f - (float)lowerExtension, -2.0f, 3.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(0.25f + lowerShrinkage)), PartPose.ZERO);
            PartDefinition rightHand = partDefinition.addOrReplaceChild("right_hand", CubeListBuilder.create().texOffs(40, 23 - lowerExtension).addBox(-1.5f, -5.0f - (float)lowerExtension, -2.0f, 3.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(lowerShrinkage)), PartPose.offset((float)-5.5f, (float)12.0f, (float)0.0f));
            rightHand.addOrReplaceChild("right_hand_sleeve", CubeListBuilder.create().texOffs(40, 39 - lowerExtension).addBox(-1.5f, -5.0f - (float)lowerExtension, -2.0f, 3.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(0.25f + lowerShrinkage)), PartPose.ZERO);
            PartDefinition leftArm = partDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
            leftArm.addOrReplaceChild("left_sleeve", CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.extend(0.25f)), PartPose.ZERO);
            PartDefinition rightArm = partDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
            rightArm.addOrReplaceChild("right_sleeve", CubeListBuilder.create().texOffs(40, 32).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.extend(0.25f)), PartPose.ZERO);
        } else {
            PartDefinition leftHand = partDefinition.addOrReplaceChild("left_hand", CubeListBuilder.create().texOffs(32, 55 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(lowerShrinkage)), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
            leftHand.addOrReplaceChild("left_hand_sleeve", CubeListBuilder.create().texOffs(48, 55 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(0.25f + lowerShrinkage)), PartPose.ZERO);
            PartDefinition rightHand = partDefinition.addOrReplaceChild("right_hand", CubeListBuilder.create().texOffs(40, 23 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(lowerShrinkage)), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
            rightHand.addOrReplaceChild("right_hand_sleeve", CubeListBuilder.create().texOffs(40, 39 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(0.25f + lowerShrinkage)), PartPose.ZERO);
            PartDefinition leftArm = partDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
            leftArm.addOrReplaceChild("left_sleeve", CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.extend(0.25f)), PartPose.ZERO);
            PartDefinition rightArm = partDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
            rightArm.addOrReplaceChild("right_sleeve", CubeListBuilder.create().texOffs(40, 32).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.extend(0.25f)), PartPose.ZERO);
        }
        return meshDefinition;
    }

    @Override
    public void setupAnim(AvatarRenderState renderState) {
        ModelPart mainShoulder;
        super.setupAnim(renderState);
        ClientVRPlayers.RotInfo rotInfo = ((EntityRenderStateExtension)renderState).vivecraft$getRotInfo();
        VRPlayerRenderData data = ((EntityRenderStateExtension)renderState).vivecraft$getVRRenderData();
        if (rotInfo == null || data == null) {
            return;
        }
        ModelPart offHand = rotInfo.leftHanded ? this.rightHand : this.leftHand;
        ModelPart mainHand = rotInfo.leftHanded ? this.leftHand : this.rightHand;
        ModelPart offShoulder = rotInfo.leftHanded ? this.rightArm : this.leftArm;
        ModelPart modelPart = mainShoulder = rotInfo.leftHanded ? this.leftArm : this.rightArm;
        if (rotInfo.offHandPos.distanceSquared(rotInfo.mainHandPos) > 0.0f) {
            boolean useWorldScale;
            float offset = (this.slim ? 0.5f : 1.0f) * data.armScale() * (rotInfo.leftHanded ? -1.0f : 1.0f);
            boolean bl = useWorldScale = data.isMainPlayer() || ClientDataHolderVR.getInstance().vrSettings.applyPlayerWorldscale;
            if (ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected) {
                this.positionConnectedLimb(renderState, rotInfo, data, mainShoulder, mainHand, rotInfo.mainHandPos, rotInfo.mainHandQuat, -offset, rotInfo.rightElbowPos, true, data.mainArm(), useWorldScale);
            } else {
                this.positionSplitLimb(renderState, rotInfo, data, mainShoulder, mainHand, rotInfo.mainHandPos, rotInfo.mainHandQuat, 0.0f, -offset, rotInfo.rightElbowPos, true, data.mainArm(), useWorldScale);
            }
            if (ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected) {
                this.positionConnectedLimb(renderState, rotInfo, data, offShoulder, offHand, rotInfo.offHandPos, rotInfo.offHandQuat, offset, rotInfo.leftElbowPos, true, data.mainArm().getOpposite(), useWorldScale);
            } else {
                this.positionSplitLimb(renderState, rotInfo, data, offShoulder, offHand, rotInfo.offHandPos, rotInfo.offHandQuat, 0.0f, offset, rotInfo.leftElbowPos, true, data.mainArm().getOpposite(), useWorldScale);
            }
            if (data.isMainPlayer() && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.OFF) {
                this.tempM.rotateLocalX(data.xRot());
                GuiHandler.GUI_ROTATION_PLAYER_MODEL.set3x3((Matrix3fc)this.tempM);
                GuiHandler.GUI_ROTATION_PLAYER_MODEL.rotateX(-1.5707964f);
                GuiHandler.GUI_ROTATION_PLAYER_MODEL.rotateLocalY(-data.bodyYaw() - (float)Math.PI);
                ModelUtils.modelToWorld((HumanoidRenderState)renderState, offHand.x, offHand.y, offHand.z, rotInfo, data.bodyYaw(), true, true, this.tempV);
                GuiHandler.GUI_POS_PLAYER_MODEL = new Vec3(renderState.x, renderState.y, renderState.z).add((double)this.tempV.x, (double)this.tempV.y, (double)this.tempV.z);
            }
        } else {
            float offset = this.slim ? data.armScale() * 0.5f : data.armScale();
            this.tempV.set(-offset, 10.0f, 0.0f).rotateZ(mainShoulder.zRot).rotateY(mainShoulder.yRot).rotateX(mainShoulder.xRot);
            mainHand.loadPose(mainShoulder.storePose());
            mainHand.x += this.tempV.x;
            mainHand.y += this.tempV.y;
            mainHand.z += this.tempV.z;
            this.tempV.set(offset, 10.0f, 0.0f).rotateZ(offShoulder.zRot).rotateY(offShoulder.yRot).rotateX(offShoulder.xRot);
            offHand.loadPose(offShoulder.storePose());
            offHand.x += this.tempV.x;
            offHand.y += this.tempV.y;
            offHand.z += this.tempV.z;
            if (data.isMainPlayer() && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.OFF) {
                GuiHandler.GUI_POS_PLAYER_MODEL = Vec3.ZERO;
            }
        }
        this.rightHand.xScale = this.rightHand.zScale = data.armScale();
        this.leftHand.zScale = this.rightHand.zScale;
        this.leftHand.xScale = this.rightHand.zScale;
        if (data.layAmount() > 0.0f) {
            ModelUtils.applySwimRotationOffset((HumanoidRenderState)renderState, data.xRot(), this.tempV, this.tempV2, this.leftArm, this.rightArm, this.leftHand, this.rightHand);
        }
        if (renderState.isAutoSpinAttack) {
            VRPlayerModel_WithArms.spinOffset(this.leftArm, this.rightArm, this.leftHand, this.rightHand);
        }
        this.leftHandSleeve.visible = renderState.showLeftSleeve;
        this.rightHandSleeve.visible = renderState.showRightSleeve;
    }

    protected void positionSplitLimb(AvatarRenderState renderState, ClientVRPlayers.RotInfo rotInfo, VRPlayerRenderData data, ModelPart upper, ModelPart lower, Vector3fc lowerPos, Quaternionfc lowerRot, float lowerXRot, float lowerXOffset, Vector3fc jointPos, boolean jointDown, HumanoidArm arm, boolean useWorldScale) {
        ModelUtils.worldToModel((HumanoidRenderState)renderState, lowerPos, rotInfo, data.bodyYaw(), useWorldScale, this.tempV);
        lower.setPos(this.tempV.x, this.tempV.y, this.tempV.z);
        ModelUtils.estimateJointDir(upper, lower, lowerRot, data.bodyYaw(), jointDown, jointPos, (HumanoidRenderState)renderState, rotInfo, useWorldScale, this.tempV2, this.tempV);
        ModelUtils.estimateJoint(upper.x, upper.y, upper.z, lower.x, lower.y, lower.z, (Vector3fc)this.tempV2, 12.0f, this.tempV);
        if (jointDown) {
            this.tempV2.mul(-1.0f);
        }
        this.jointOffset.set(lower.x - upper.x, lower.y - upper.y, lower.z - upper.z);
        this.jointOffset.cross((Vector3fc)this.tempV2).normalize().mul(lowerXOffset * 0.5f);
        this.tempV.add((Vector3fc)this.jointOffset);
        ModelUtils.pointModelAtModelWithUp(upper, this.tempV.x, this.tempV.y, this.tempV.z, (Vector3fc)this.tempV2, this.tempV, this.tempM);
        this.tempM.rotateLocalX(-data.xRot());
        ModelUtils.setRotation(upper, (Matrix3fc)this.tempM, this.tempV);
        ModelUtils.toModelDir(data.bodyYaw(), lowerRot, this.tempM);
        if (ClientDataHolderVR.getInstance().vrSettings.playerArmAnim && arm != null && data.attackArm() == arm) {
            ModelUtils.swingAnimation(lower, arm, -3.0f, renderState.attackTime, data.isMainPlayer(), this.tempM, this.tempV, this.tempV2);
        }
        this.tempM.rotateLocalX(-data.xRot() + lowerXRot);
        ModelUtils.setRotation(lower, (Matrix3fc)this.tempM, this.tempV);
    }

    protected void positionConnectedLimb(AvatarRenderState renderState, ClientVRPlayers.RotInfo rotInfo, VRPlayerRenderData data, ModelPart upper, ModelPart lower, Vector3fc lowerPos, Quaternionfc lowerRot, float lowerXOffset, Vector3fc jointPos, boolean jointDown, HumanoidArm arm, boolean useWorldScale) {
        ModelUtils.worldToModel((HumanoidRenderState)renderState, lowerPos, rotInfo, data.bodyYaw(), useWorldScale, this.tempV);
        float armLength = 10.0f;
        if (arm != null) {
            this.tempV.normalize(this.tempV2);
            armLength += 2.0f * this.tempV2.z * this.tempV2.z;
        }
        this.tempV.sub(upper.x, upper.y, upper.z, this.tempV2);
        float length = this.tempV2.length();
        upper.y -= 2.0f * Math.min(1.0f, length / armLength) * Math.max(0.0f, -this.tempV2.y / length);
        if (ClientDataHolderVR.getInstance().vrSettings.playerLimbsLimit && length > armLength) {
            this.tempV.sub(upper.x, upper.y, upper.z);
            this.tempV.normalize().mul(armLength);
            this.tempV.add(upper.x, upper.y, upper.z);
        }
        lower.setPos(this.tempV.x, this.tempV.y, this.tempV.z);
        ModelUtils.estimateJointDir(upper, lower, lowerRot, data.bodyYaw(), jointDown, jointPos, (HumanoidRenderState)renderState, rotInfo, useWorldScale, this.tempV2, this.tempV);
        ModelUtils.estimateJoint(upper.x, upper.y, upper.z, lower.x, lower.y, lower.z, (Vector3fc)this.tempV2, armLength, this.tempV);
        if (jointDown) {
            this.tempV2.mul(-1.0f);
        }
        float jointX = this.tempV.x;
        float jointY = this.tempV.y;
        float jointZ = this.tempV.z;
        this.jointOffset.set(lower.x - upper.x, lower.y - upper.y, lower.z - upper.z);
        this.jointOffset.cross((Vector3fc)this.tempV2).normalize().mul(lowerXOffset * 0.5f);
        this.tempV.set(jointX - upper.x, jointY - upper.y, jointZ - upper.z);
        this.tempV.add((Vector3fc)this.jointOffset);
        ModelUtils.pointAtModel((Vector3fc)this.tempV, (Vector3fc)this.tempV2, this.tempM);
        this.tempM.rotateLocalX(-data.xRot());
        ModelUtils.setRotation(upper, (Matrix3fc)this.tempM, this.tempV);
        this.tempV.set(lower.x - jointX, lower.y - jointY, lower.z - jointZ);
        this.tempV.add((Vector3fc)this.jointOffset);
        ModelUtils.pointAtModel((Vector3fc)this.tempV, (Vector3fc)this.tempV2, this.tempM);
        if (ClientDataHolderVR.getInstance().vrSettings.playerArmAnim && arm != null && data.attackArm() == arm) {
            ModelUtils.swingAnimation(lower, arm, -armLength * 0.5f, renderState.attackTime, data.isMainPlayer(), this.tempM, this.tempV, this.tempV2);
        }
        this.tempM.rotateLocalX(-data.xRot());
        ModelUtils.setRotation(lower, (Matrix3fc)this.tempM, this.tempV);
    }

    public void setAllVisible(boolean visible) {
        super.setAllVisible(visible);
        this.leftHand.visible = visible;
        this.rightHand.visible = visible;
        this.leftHandSleeve.visible = visible;
        this.rightHandSleeve.visible = visible;
    }

    @Override
    public ModelPart getLeftHand() {
        return this.leftHand;
    }

    @Override
    public ModelPart getRightHand() {
        return this.rightHand;
    }

    @Override
    public void hideLeftArm(boolean completeArm) {
        this.leftHand.visible = false;
        this.leftHandSleeve.visible = false;
        if (completeArm) {
            super.hideLeftArm(false);
        }
    }

    @Override
    public void hideRightArm(boolean onlyHand) {
        this.rightHand.visible = false;
        this.rightHandSleeve.visible = false;
        if (onlyHand) {
            super.hideRightArm(false);
        }
    }

    protected ModelPart getArm(HumanoidArm side) {
        return side == HumanoidArm.RIGHT ? this.rightHand : this.leftHand;
    }

    @Override
    public void translateToHand(AvatarRenderState avatarRenderState, HumanoidArm side, PoseStack poseStack) {
        this.getArm(side).translateAndRotate(poseStack);
        poseStack.translate(side == HumanoidArm.LEFT ? -0.0625f : 0.0625f, -0.65f, 0.0f);
        this.doAttackAnim(avatarRenderState, side, poseStack);
    }
}

