/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.extensions.EntityRenderStateExtension;
import org.vivecraft.client.render.HMDLayer;
import org.vivecraft.client.render.VRPlayerModel;
import org.vivecraft.client.render.VRPlayerModel_WithArms;
import org.vivecraft.client.render.VRPlayerModel_WithArmsLegs;
import org.vivecraft.client.render.armor.VRArmorLayer;
import org.vivecraft.client_vr.ClientDataHolderVR;

public class VRPlayerRenderer
extends AvatarRenderer<AbstractClientPlayer> {
    private static final LayerDefinition VR_LAYER_DEF = LayerDefinition.create((MeshDefinition)VRPlayerModel.createMesh(CubeDeformation.NONE, false), (int)64, (int)64);
    private static final LayerDefinition VR_LAYER_DEF_SLIM = LayerDefinition.create((MeshDefinition)VRPlayerModel.createMesh(CubeDeformation.NONE, true), (int)64, (int)64);
    private static LayerDefinition VR_LAYER_DEF_ARMS;
    private static LayerDefinition VR_LAYER_DEF_ARMS_SLIM;
    private static LayerDefinition VR_LAYER_DEF_ARMS_LEGS;
    private static LayerDefinition VR_LAYER_DEF_ARMS_LEGS_SLIM;

    public static void createLayers() {
        VR_LAYER_DEF_ARMS = LayerDefinition.create((MeshDefinition)VRPlayerModel_WithArms.createMesh(CubeDeformation.NONE, false), (int)64, (int)64);
        VR_LAYER_DEF_ARMS_SLIM = LayerDefinition.create((MeshDefinition)VRPlayerModel_WithArms.createMesh(CubeDeformation.NONE, true), (int)64, (int)64);
        VR_LAYER_DEF_ARMS_LEGS = LayerDefinition.create((MeshDefinition)VRPlayerModel_WithArmsLegs.createMesh(CubeDeformation.NONE, false), (int)64, (int)64);
        VR_LAYER_DEF_ARMS_LEGS_SLIM = LayerDefinition.create((MeshDefinition)VRPlayerModel_WithArmsLegs.createMesh(CubeDeformation.NONE, true), (int)64, (int)64);
    }

    public VRPlayerRenderer(EntityRendererProvider.Context context, boolean slim, ModelType type) {
        super(context, slim);
        this.model = switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new VRPlayerModel(slim ? VR_LAYER_DEF_SLIM.bakeRoot() : VR_LAYER_DEF.bakeRoot(), slim);
            case 1 -> new VRPlayerModel_WithArms(slim ? VR_LAYER_DEF_ARMS_SLIM.bakeRoot() : VR_LAYER_DEF_ARMS.bakeRoot(), slim);
            case 2 -> new VRPlayerModel_WithArmsLegs(slim ? VR_LAYER_DEF_ARMS_LEGS_SLIM.bakeRoot() : VR_LAYER_DEF_ARMS_LEGS.bakeRoot(), slim);
        };
        this.addLayer(new HMDLayer((RenderLayerParent<AvatarRenderState, PlayerModel>)this));
        VRArmorLayer.createLayers();
        if (type != ModelType.VANILLA) {
            this.layers.stream().filter(layer -> layer.getClass() == HumanoidArmorLayer.class).findFirst().ifPresent(this.layers::remove);
            if (type == ModelType.SPLIT_ARMS) {
                this.addLayer((RenderLayer)new VRArmorLayer(this, VRArmorLayer.VR_ARMOR_DEF_ARMS.map(layerDefinition -> new VRPlayerModel_WithArms(layerDefinition.bakeRoot(), slim)), context.getEquipmentRenderer()));
            } else {
                this.addLayer((RenderLayer)new VRArmorLayer(this, VRArmorLayer.VR_ARMOR_DEF_ARMS_LEGS.map(layerDefinition -> new VRPlayerModel_WithArmsLegs(layerDefinition.bakeRoot(), slim)), context.getEquipmentRenderer()));
            }
        }
    }

    public boolean hasLayerType(RenderLayer<?, ?> renderLayer) {
        return this.layers.stream().anyMatch(layer -> {
            if (renderLayer.getClass() == HumanoidArmorLayer.class) {
                return layer.getClass() == renderLayer.getClass() || layer.getClass() == VRArmorLayer.class;
            }
            return layer.getClass() == renderLayer.getClass();
        });
    }

    public Vec3 getRenderOffset(AvatarRenderState renderState) {
        if (((EntityRenderStateExtension)renderState).vivecraft$isFirstPersonPlayer()) {
            return renderState.isVisuallySwimming ? new Vec3(0.0, (double)(-0.125f * ClientDataHolderVR.getInstance().vrPlayer.worldScale), 0.0) : Vec3.ZERO;
        }
        return renderState.isVisuallySwimming ? new Vec3(0.0, -0.125, 0.0) : Vec3.ZERO;
    }

    protected void setupRotations(AvatarRenderState renderState, PoseStack poseStack, float rotationYaw, float scale) {
        ClientVRPlayers.RotInfo rotInfo = ((EntityRenderStateExtension)renderState).vivecraft$getRotInfo();
        if (ClientDataHolderVR.getInstance().currentPass != RenderPass.GUI && rotInfo != null) {
            rotationYaw = ((EntityRenderStateExtension)renderState).vivecraft$isFirstPersonPlayer() ? ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getBodyYaw() : 57.295776f * rotInfo.getBodyYawRad();
        }
        super.setupRotations(renderState, poseStack, rotationYaw, scale);
    }

    static {
        VRPlayerRenderer.createLayers();
    }

    public static enum ModelType {
        VANILLA,
        SPLIT_ARMS,
        SPLIT_ARMS_LEGS;

    }
}

