/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.forge;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import org.vivecraft.Xloader;

public class XloaderImpl
implements Xloader {
    public static Xloader.ModLoader getModloader() {
        return Xloader.ModLoader.FORGE;
    }

    public static boolean isModLoaded(String name) {
        return FMLLoader.getLoadingModList().getModFileById(name) != null;
    }

    public static String getModVersion() {
        if (Xloader.isModLoadedSuccess()) {
            return FMLLoader.getLoadingModList().getModFileById("vivecraft").versionString();
        }
        return "no version";
    }

    public static Path getConfigPath(String fileName) {
        return FMLPaths.CONFIGDIR.get().resolve(fileName);
    }

    private static Path getJarPath() {
        return FMLLoader.getLoadingModList().getModFileById("vivecraft").getFile().getSecureJar().getPath("/", new String[0]);
    }

    public static InputStream getInJarFile(String sourcePath) throws IOException {
        return Files.newInputStream(XloaderImpl.getJarPath().resolve(sourcePath), new OpenOption[0]);
    }

    public static List<Path> getInJarFolderFiles(String folder) throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path root = XloaderImpl.getJarPath();
        try (Stream<Path> natives = Files.list(root.resolve(folder));){
            natives.forEach(file -> paths.add(root.relativize((Path)file)));
        }
        return paths;
    }

    public static boolean isDedicatedServer() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }
}

