/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vivecraft.Xloader;
import org.vivecraft.Xplat;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.common.CommonDataHolder;
import org.vivecraft.common.network.CommonNetworkHelper;
import org.vivecraft.common.network.NetworkVersion;
import org.vivecraft.common.network.VrPlayerState;
import org.vivecraft.common.network.packet.PayloadIdentifier;
import org.vivecraft.common.network.packet.c2s.ActiveBodyPartPayloadC2S;
import org.vivecraft.common.network.packet.c2s.CrawlPayloadC2S;
import org.vivecraft.common.network.packet.c2s.DrawPayloadC2S;
import org.vivecraft.common.network.packet.c2s.HeightPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyController0DataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyController1DataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyHeadDataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.TeleportPayloadC2S;
import org.vivecraft.common.network.packet.c2s.UnknownPayloadC2S;
import org.vivecraft.common.network.packet.c2s.VRActivePayloadC2S;
import org.vivecraft.common.network.packet.c2s.VRPlayerStatePayloadC2S;
import org.vivecraft.common.network.packet.c2s.VersionPayloadC2S;
import org.vivecraft.common.network.packet.c2s.VivecraftPayloadC2S;
import org.vivecraft.common.network.packet.c2s.WorldScalePayloadC2S;
import org.vivecraft.common.network.packet.s2c.AttackWhileBlockingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.ClimbingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.CrawlPayloadS2C;
import org.vivecraft.common.network.packet.s2c.DualWieldingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.HapticPayloadS2C;
import org.vivecraft.common.network.packet.s2c.NetworkVersionPayloadS2C;
import org.vivecraft.common.network.packet.s2c.RequestDataPayloadS2C;
import org.vivecraft.common.network.packet.s2c.ServerVrChangesS2CPacket;
import org.vivecraft.common.network.packet.s2c.SettingOverridePayloadS2C;
import org.vivecraft.common.network.packet.s2c.TeleportPayloadS2C;
import org.vivecraft.common.network.packet.s2c.UberPacketPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VRActivePayloadS2C;
import org.vivecraft.common.network.packet.s2c.VRSwitchingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VersionPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VivecraftPayloadS2C;
import org.vivecraft.mixin.server.ChunkMapAccessor;
import org.vivecraft.mixin.server.TrackedEntityAccessor;
import org.vivecraft.server.ServerUtil;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ConfigBuilder;
import org.vivecraft.server.config.ServerConfig;
import org.vivecraft.server.config.enums.ClimbeyBlockmode;

public class ServerNetworking {
    private static final Map<UUID, Map<PayloadIdentifier, VivecraftPayloadC2S>> LEGACY_DATA_MAP = new HashMap<UUID, Map<PayloadIdentifier, VivecraftPayloadC2S>>();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"VivecraftServer");

    /*
     * Unable to fully structure code
     */
    public static void handlePacket(VivecraftPayloadC2S c2sPayload, ServerPlayer player, Consumer<VivecraftPayloadS2C> packetConsumer) {
        if (c2sPayload instanceof UnknownPayloadC2S) {
            return;
        }
        vivePlayer = ServerVRPlayers.getVivePlayer(player);
        if (vivePlayer == null && c2sPayload.payloadId() != PayloadIdentifier.VERSION) {
            return;
        }
        if (vivePlayer != null) {
            vivePlayer.player = player;
        }
        switch (1.$SwitchMap$org$vivecraft$common$network$packet$PayloadIdentifier[c2sPayload.payloadId().ordinal()]) {
            case 1: {
                vivePlayer = new ServerVivePlayer(player);
                payload = (VersionPayloadC2S)c2sPayload;
                if (((Boolean)ServerConfig.DEBUG.get()).booleanValue()) {
                    ServerNetworking.LOGGER.info("Vivecraft: player '{}' joined with {}", (Object)player.getName().getString(), (Object)payload.version());
                }
                if (payload.legacy()) ** GOTO lbl24
                if (CommonNetworkHelper.MIN_SUPPORTED_NETWORK_PROTOCOL <= payload.maxVersion() && payload.minVersion() <= CommonNetworkHelper.MAX_SUPPORTED_NETWORK_PROTOCOL) {
                    vivePlayer.networkVersion = NetworkVersion.fromProtocolVersion(Math.min(payload.maxVersion(), CommonNetworkHelper.MAX_SUPPORTED_NETWORK_PROTOCOL));
                    if (((Boolean)ServerConfig.DEBUG.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("Vivecraft: {} networking supported, using version {}", (Object)player.getName().getString(), (Object)vivePlayer.networkVersion);
                    }
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)"Unsupported vivecraft version, VR features will not work"));
                    if (((Boolean)ServerConfig.DEBUG.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("Vivecraft: {} networking not supported. client range [{},{}], server range [{},{}]", new Object[]{player.getScoreboardName(), payload.minVersion(), payload.maxVersion(), CommonNetworkHelper.MIN_SUPPORTED_NETWORK_PROTOCOL, CommonNetworkHelper.MAX_SUPPORTED_NETWORK_PROTOCOL});
                    }
                    return;
lbl24:
                    // 1 sources

                    vivePlayer.networkVersion = NetworkVersion.LEGACY;
                    if (((Boolean)ServerConfig.DEBUG.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("Vivecraft: {} using legacy networking", (Object)player.getScoreboardName());
                    }
                }
                vivePlayer.setVR(payload.vr());
                ServerVRPlayers.getPlayersWithVivecraft(player.server).put(player.getUUID(), vivePlayer);
                packetConsumer.accept(new VersionPayloadS2C(CommonDataHolder.getInstance().versionIdentifier));
                packetConsumer.accept(new RequestDataPayloadS2C());
                if (((Boolean)ServerConfig.CLIMBEY_ENABLED.get()).booleanValue()) {
                    packetConsumer.accept(ServerNetworking.getClimbeyServerPayload());
                }
                if (((Boolean)ServerConfig.TELEPORT_ENABLED.get()).booleanValue() || NetworkVersion.OPTION_TOGGLE.accepts(vivePlayer.networkVersion)) {
                    packetConsumer.accept(new TeleportPayloadS2C((Boolean)ServerConfig.TELEPORT_ENABLED.get(), vivePlayer.networkVersion));
                }
                if (((Boolean)ServerConfig.TELEPORT_LIMITED_SURVIVAL.get()).booleanValue()) {
                    packetConsumer.accept(ServerNetworking.getSurvivalTeleportOverridePayload());
                }
                if (((Boolean)ServerConfig.WORLDSCALE_LIMITED.get()).booleanValue()) {
                    packetConsumer.accept(ServerNetworking.getWorldScaleOverridePayload());
                }
                if (((Boolean)ServerConfig.FORCE_THIRD_PERSON_ITEMS.get()).booleanValue()) {
                    packetConsumer.accept(ServerNetworking.getThirdPersonItemsOverridePayload());
                }
                if (((Boolean)ServerConfig.FORCE_THIRD_PERSON_ITEMS_CUSTOM.get()).booleanValue()) {
                    packetConsumer.accept(ServerNetworking.getThirdPersonItemsCustomOverridePayload());
                }
                if (((Boolean)ServerConfig.CRAWLING_ENABLED.get()).booleanValue()) {
                    packetConsumer.accept(new CrawlPayloadS2C(true, vivePlayer.networkVersion));
                }
                packetConsumer.accept(ServerNetworking.getVRSwitchingPayload());
                if (NetworkVersion.DUAL_WIELDING.accepts(vivePlayer.networkVersion)) {
                    packetConsumer.accept(new DualWieldingPayloadS2C((Boolean)ServerConfig.DUAL_WIELDING.get()));
                }
                if (NetworkVersion.SERVER_VR_CHANGES.accepts(vivePlayer.networkVersion)) {
                    settings = new HashMap<String, String>();
                    for (ConfigBuilder.ConfigValue config : ServerConfig.getConfigValues()) {
                        if (!config.getPath().startsWith("vrChanges") || config.isDefault()) continue;
                        settings.put(config.getPath(), String.valueOf(config.get()));
                    }
                    if (!settings.isEmpty()) {
                        packetConsumer.accept(new ServerVrChangesS2CPacket(settings));
                    }
                }
                if (NetworkVersion.OPTION_TOGGLE.accepts(vivePlayer.networkVersion)) {
                    packetConsumer.accept(new AttackWhileBlockingPayloadS2C((Boolean)ServerConfig.ALLOW_ATTACKS_WHILE_BLOCKING.get()));
                }
                packetConsumer.accept(new NetworkVersionPayloadS2C(vivePlayer.networkVersion));
                break;
            }
            case 2: {
                payload = (VRActivePayloadC2S)c2sPayload;
                if (vivePlayer.isVR() == payload.vr()) break;
                vivePlayer.setVR(vivePlayer.isVR() == false);
                if (vivePlayer.isVR()) break;
                ServerNetworking.sendPacketToTrackingPlayers(vivePlayer, new VRActivePayloadS2C(false, player.getUUID()));
                break;
            }
            case 3: {
                vivePlayer.draw = ((DrawPayloadC2S)c2sPayload).draw();
                break;
            }
            case 4: {
                vivePlayer.setVrPlayerState(((VRPlayerStatePayloadC2S)c2sPayload).playerState());
                break;
            }
            case 5: {
                vivePlayer.worldScale = ((WorldScalePayloadC2S)c2sPayload).worldScale();
                break;
            }
            case 6: {
                vivePlayer.heightScale = ((HeightPayloadC2S)c2sPayload).heightScale();
                break;
            }
            case 7: {
                if (!((Boolean)ServerConfig.TELEPORT_ENABLED.get()).booleanValue()) break;
                payload = (TeleportPayloadC2S)c2sPayload;
                player.absSnapTo((double)payload.x(), (double)payload.y(), (double)payload.z(), player.getYRot(), player.getXRot());
                break;
            }
            case 8: {
                if (!((Boolean)ServerConfig.CLIMBEY_ENABLED.get()).booleanValue()) break;
                player.fallDistance = 0.0;
                player.connection.aboveGroundTickCount = 0;
                break;
            }
            case 9: {
                activeBodypart = (ActiveBodyPartPayloadC2S)c2sPayload;
                newBodyPart = activeBodypart.bodyPart();
                if (vivePlayer.isSeated() && newBodyPart != VRBodyPart.HEAD) {
                    newBodyPart = VRBodyPart.MAIN_HAND;
                }
                vivePlayer.useBodyPartForAim = activeBodypart.useForAim();
                if (vivePlayer.activeBodyPart == newBodyPart || !((Boolean)ServerConfig.DUAL_WIELDING.get()).booleanValue() || !NetworkVersion.DUAL_WIELDING.accepts(vivePlayer.networkVersion)) break;
                oldItem = player.getItemBySlot(EquipmentSlot.MAINHAND);
                vivePlayer.activeBodyPart = newBodyPart;
                newItem = player.getItemBySlot(EquipmentSlot.MAINHAND);
                ServerNetworking.applyEquipmentChange(player, vivePlayer.activeItemOverride, oldItem);
                ServerNetworking.applyEquipmentChange(player, oldItem, newItem);
                vivePlayer.activeItemOverride = newItem.copy();
                break;
            }
            case 10: {
                if (!((Boolean)ServerConfig.CRAWLING_ENABLED.get()).booleanValue()) break;
                vivePlayer.crawling = ((CrawlPayloadC2S)c2sPayload).crawling();
                if (!vivePlayer.crawling) break;
                player.setPose(Pose.SWIMMING);
                break;
            }
            case 11: {
                vivePlayer.wantsDamageDirection = true;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                playerData = ServerNetworking.LEGACY_DATA_MAP.get(player.getUUID());
                if (playerData == null) {
                    playerData = new HashMap<PayloadIdentifier, VivecraftPayloadC2S>();
                    ServerNetworking.LEGACY_DATA_MAP.put(player.getUUID(), playerData);
                }
                playerData.put(c2sPayload.payloadId(), c2sPayload);
                if (playerData.size() != 3) break;
                controller0Data = (LegacyController0DataPayloadC2S)playerData.get((Object)PayloadIdentifier.CONTROLLER0DATA);
                controller1Data = (LegacyController1DataPayloadC2S)playerData.get((Object)PayloadIdentifier.CONTROLLER1DATA);
                headData = (LegacyHeadDataPayloadC2S)playerData.get((Object)PayloadIdentifier.HEADDATA);
                vivePlayer.setVrPlayerState(new VrPlayerState(headData.seated(), headData.hmdPose(), controller0Data.leftHanded(), controller0Data.mainHand(), controller1Data.leftHanded(), controller1Data.offHand(), FBTMode.ARMS_ONLY, null, null, null, null, null, null, null));
                ServerNetworking.LEGACY_DATA_MAP.remove(player.getUUID());
                break;
            }
            default: {
                throw new IllegalStateException("Vivecraft: got unexpected packet on server: " + String.valueOf((Object)c2sPayload.payloadId()));
            }
        }
    }

    private static void applyEquipmentChange(ServerPlayer player, ItemStack oldItem, ItemStack newItem) {
        if (player.equipmentHasChanged(oldItem, newItem)) {
            AttributeMap attributeMap = player.getAttributes();
            if (!oldItem.isEmpty()) {
                oldItem.forEachModifier(EquipmentSlot.MAINHAND, (holder, attributeModifier) -> {
                    AttributeInstance attributeInstance = attributeMap.getInstance(holder);
                    if (attributeInstance != null) {
                        attributeInstance.removeModifier(attributeModifier);
                    }
                });
            }
            if (!newItem.isEmpty()) {
                newItem.forEachModifier(EquipmentSlot.MAINHAND, (holder, attributeModifier) -> {
                    AttributeInstance attributeInstance = attributeMap.getInstance(holder);
                    if (attributeInstance != null) {
                        attributeInstance.removeModifier(attributeModifier.id());
                        attributeInstance.addTransientModifier(attributeModifier);
                    }
                });
            }
        }
    }

    public static VivecraftPayloadS2C getClimbeyServerPayload() {
        ArrayList<String> blocks = null;
        if (ServerConfig.CLIMBEY_BLOCKMODE.get() != ClimbeyBlockmode.DISABLED) {
            blocks = new ArrayList<String>();
            for (String block : (List)ServerConfig.CLIMBEY_BLOCKLIST.get()) {
                try {
                    Holder.Reference b = BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)block)).orElseGet(() -> null);
                    if (b == null || b.value() == Blocks.AIR) continue;
                    blocks.add(block);
                }
                catch (ResourceLocationException resourceLocationException) {}
            }
        }
        return new ClimbingPayloadS2C((Boolean)ServerConfig.CLIMBEY_ENABLED.get(), (ClimbeyBlockmode)((Object)ServerConfig.CLIMBEY_BLOCKMODE.get()), blocks);
    }

    public static VivecraftPayloadS2C getVRSwitchingPayload() {
        return new VRSwitchingPayloadS2C((Boolean)ServerConfig.VR_SWITCHING_ENABLED.get() != false && (Boolean)ServerConfig.VR_ONLY.get() == false);
    }

    public static VivecraftPayloadS2C getSurvivalTeleportOverridePayload() {
        return new SettingOverridePayloadS2C(Map.of("limitedTeleport", "true", "teleportLimitUp", String.valueOf(ServerConfig.TELEPORT_UP_LIMIT.get()), "teleportLimitDown", String.valueOf(ServerConfig.TELEPORT_DOWN_LIMIT.get()), "teleportLimitHoriz", String.valueOf(ServerConfig.TELEPORT_HORIZONTAL_LIMIT.get())), (Boolean)ServerConfig.TELEPORT_LIMITED_SURVIVAL.get() == false);
    }

    public static VivecraftPayloadS2C getWorldScaleOverridePayload() {
        return new SettingOverridePayloadS2C(Map.of("worldScale.min", String.valueOf(ServerConfig.WORLDSCALE_MIN.get()), "worldScale.max", String.valueOf(ServerConfig.WORLDSCALE_MAX.get())), (Boolean)ServerConfig.WORLDSCALE_LIMITED.get() == false);
    }

    public static VivecraftPayloadS2C getThirdPersonItemsOverridePayload() {
        return new SettingOverridePayloadS2C(Map.of("thirdPersonItems", "true"), (Boolean)ServerConfig.FORCE_THIRD_PERSON_ITEMS.get() == false);
    }

    public static VivecraftPayloadS2C getThirdPersonItemsCustomOverridePayload() {
        return new SettingOverridePayloadS2C(Map.of("thirdPersonItemsCustom", "true"), (Boolean)ServerConfig.FORCE_THIRD_PERSON_ITEMS_CUSTOM.get() == false);
    }

    public static void sendUpdatePacketToAll(MinecraftServer server, ConfigBuilder.ConfigValue<?> config) {
        Function<ServerVivePlayer, VivecraftPayloadS2C> function = config.getPacketFunction();
        if (function != null) {
            for (ServerVivePlayer vivePlayer : ServerVRPlayers.getPlayersWithVivecraft(server).values()) {
                TeleportPayloadS2C tp;
                CrawlPayloadS2C crawl;
                SettingOverridePayloadS2C override;
                VivecraftPayloadS2C payload = function.apply(vivePlayer);
                if (!NetworkVersion.OPTION_TOGGLE.accepts(vivePlayer.networkVersion) && (payload instanceof SettingOverridePayloadS2C && (override = (SettingOverridePayloadS2C)payload).clear() || payload instanceof CrawlPayloadS2C && !(crawl = (CrawlPayloadS2C)payload).allowed() || payload instanceof TeleportPayloadS2C && !(tp = (TeleportPayloadS2C)payload).allowed())) continue;
                vivePlayer.player.connection.send(Xplat.getS2CPacket(payload));
            }
        }
    }

    public static void updateViveVROnly(MinecraftServer server) {
        for (ServerPlayer player : new ArrayList(server.getPlayerList().getPlayers())) {
            ServerUtil.kickIfNotAllowed(player);
        }
        for (ServerVivePlayer vivePlayer : ServerVRPlayers.getPlayersWithVivecraft(server).values()) {
            vivePlayer.player.connection.send(Xplat.getS2CPacket(ServerNetworking.getVRSwitchingPayload()));
        }
    }

    public static void updateCrawling(MinecraftServer server) {
        if (!((Boolean)ServerConfig.CRAWLING_ENABLED.get()).booleanValue()) {
            for (ServerVivePlayer vivePlayer : ServerVRPlayers.getPlayersWithVivecraft(server).values()) {
                vivePlayer.crawling = false;
            }
        }
    }

    public static void sendHapticToClient(ServerPlayer player, VRBodyPart bodyPart, float duration, float frequency, float amplitude, float delay) {
        ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer(player);
        if (vivePlayer != null && vivePlayer.isVR() && NetworkVersion.HAPTIC_PACKET.accepts(vivePlayer.networkVersion)) {
            vivePlayer.player.connection.send(Xplat.getS2CPacket(new HapticPayloadS2C(bodyPart, duration, frequency, amplitude, delay)));
        }
    }

    public static void sendVrPlayerStateToClients(ServerVivePlayer vivePlayer) {
        Packet<?> legacyPacket = Xplat.getS2CPacket(new UberPacketPayloadS2C(vivePlayer.player.getUUID(), new VrPlayerState(vivePlayer.vrPlayerState(), NetworkVersion.LEGACY), vivePlayer.worldScale, vivePlayer.heightScale));
        Packet<?> newPacket = Xplat.getS2CPacket(new UberPacketPayloadS2C(vivePlayer.player.getUUID(), vivePlayer.vrPlayerState(), vivePlayer.worldScale, vivePlayer.heightScale));
        ServerNetworking.sendPacketToTrackingPlayers(vivePlayer, (NetworkVersion version) -> version == NetworkVersion.LEGACY ? legacyPacket : newPacket);
    }

    public static Set<ServerPlayerConnection> getTrackingPlayers(ServerPlayer player) {
        ChunkMap chunkMap = player.serverLevel().getChunkSource().chunkMap;
        TrackedEntityAccessor playerTracker = (TrackedEntityAccessor)((ChunkMapAccessor)chunkMap).getTrackedEntities().get(player.getId());
        return playerTracker != null ? Collections.unmodifiableSet(playerTracker.getPlayersTracking()) : Collections.emptySet();
    }

    private static void sendPacketToTrackingPlayers(ServerVivePlayer vivePlayer, VivecraftPayloadS2C payload) {
        Packet<?> packet = Xplat.getS2CPacket(payload);
        ServerNetworking.sendPacketToTrackingPlayers(vivePlayer, (NetworkVersion v) -> packet);
    }

    private static void sendPacketToTrackingPlayers(ServerVivePlayer vivePlayer, Function<NetworkVersion, Packet<?>> packetProvider) {
        Map<UUID, ServerVivePlayer> vivePlayers = ServerVRPlayers.getPlayersWithVivecraft(vivePlayer.player.server);
        for (ServerPlayerConnection trackedPlayer : ServerNetworking.getTrackingPlayers(vivePlayer.player)) {
            if (!vivePlayers.containsKey(trackedPlayer.getPlayer().getUUID()) || trackedPlayer.getPlayer() == vivePlayer.player) continue;
            trackedPlayer.send(packetProvider.apply(vivePlayer.networkVersion));
        }
        if (((Boolean)ServerConfig.SEND_DATA_TO_OWNER.get()).booleanValue() || Xloader.isModLoaded("replaymod") || Xloader.isModLoaded("reforgedplaymod") || Xloader.isModLoaded("flashback")) {
            vivePlayer.player.connection.send(packetProvider.apply(vivePlayer.networkVersion));
        }
    }
}

