/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.vivecraft.client.gui.framework.screens.GuiListScreen;
import org.vivecraft.client.gui.framework.widgets.SettingsList;

public abstract class GuiListEditorScreen<T>
extends GuiListScreen {
    private final Supplier<List<T>> valuesSupplier;
    private final Runnable loadDefaults;
    private final Consumer<List<T>> save;
    protected final boolean fixedEntryCount;
    protected List<T> elements;

    public GuiListEditorScreen(class_2561 title, class_437 lastScreen, boolean fixedEntryCount, Supplier<List<T>> valuesSupplier, Runnable loadDefaults, Consumer<List<T>> save) {
        super(title, lastScreen);
        this.fixedEntryCount = fixedEntryCount;
        this.valuesSupplier = valuesSupplier;
        this.loadDefaults = loadDefaults;
        this.save = save;
    }

    @Override
    protected void addLowerButtons(int top) {
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 155, top, 150, 20, (class_2561)class_2561.method_43471((String)"vivecraft.gui.loaddefaults"), button -> {
            this.loadDefaults.run();
            this.elements = null;
            this.reinit = true;
        }));
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 5, top, 150, 20, (class_2561)class_2561.method_43471((String)"gui.back"), button -> this.method_25419()));
    }

    @Override
    public void method_25419() {
        this.save.accept(this.elements);
        super.method_25419();
    }

    protected List<T> getCurrentValues() {
        return this.list.method_25396().stream().map(entry -> {
            if (entry instanceof ValueEntry) {
                ValueEntry valueEntry = (ValueEntry)((Object)entry);
                return valueEntry.getValue();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    protected List<SettingsList.BaseEntry> getEntries() {
        LinkedList<SettingsList.BaseEntry> entries = new LinkedList<SettingsList.BaseEntry>();
        if (this.elements == null) {
            this.elements = new ArrayList<T>((Collection)this.valuesSupplier.get());
        }
        int index = 0;
        for (T item : this.elements) {
            entries.add(this.toEntry(item, index++));
        }
        if (!this.fixedEntryCount) {
            entries.add(new SettingsList.WidgetEntry((class_2561)class_2561.method_43470((String)""), (class_339)new class_4185(0, 0, 145, 20, (class_2561)class_2561.method_43471((String)"vivecraft.options.addnew"), button -> this.addNewValue())));
        }
        return entries;
    }

    protected void addNewValue() {
        this.elements = this.getCurrentValues();
        this.reinit = true;
    }

    protected abstract ValueEntry<T> toEntry(T var1, int var2);

    protected static abstract class ValueEntry<T>
    extends SettingsList.BaseEntry {
        public ValueEntry(class_2561 name, Supplier<String> tooltipSupplier) {
            super(name, tooltipSupplier);
        }

        public abstract T getValue();
    }
}

