/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.widgets;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;

public class TextScrollWidget
extends class_339 {
    private int maxLines = 0;
    private int currentLine = 0;
    private int scrollBarSize = 0;
    private int scrollBarOffset = 0;
    private int scrollSteps = 0;
    private boolean scrollDragActive;
    private final int scrollBarWidth = 5;
    private final int padding = 5;
    private final List<class_5481> formattedChars;

    public TextScrollWidget(int x, int y, int width, int height, String text) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)""));
        class_327 class_3272 = class_310.method_1551().field_1772;
        class_5250 class_52502 = class_2561.method_43470((String)text);
        Objects.requireNonNull(this);
        this.formattedChars = class_3272.method_1728((class_5348)class_52502, width - 5 * 2);
        this.initScroll();
    }

    public TextScrollWidget(int x, int y, int width, int height, class_2561 text) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)""));
        class_327 class_3272 = class_310.method_1551().field_1772;
        Objects.requireNonNull(this);
        this.formattedChars = class_3272.method_1728((class_5348)text, width - 5 * 2);
        this.initScroll();
    }

    private void initScroll() {
        Objects.requireNonNull(this);
        this.maxLines = (this.field_22759 - 2 - 5 + 3) / 12;
        this.currentLine = 0;
        this.scrollSteps = this.formattedChars.size() - this.maxLines;
        this.scrollSteps = Math.max(this.scrollSteps, 0);
        this.scrollBarSize = this.scrollSteps == 0 ? this.field_22759 - 2 : (int)((float)Math.max(this.formattedChars.size(), this.maxLines) / (float)this.scrollSteps * 12.0f);
        this.scrollBarOffset = this.field_22759 - this.scrollBarSize - 2;
    }

    public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        float scrollbarStart;
        TextScrollWidget.method_25294((class_4587)poseStack, (int)this.field_22760, (int)this.field_22761, (int)(this.field_22760 + this.field_22758), (int)(this.field_22761 + this.field_22759), (int)-6250336);
        TextScrollWidget.method_25294((class_4587)poseStack, (int)(this.field_22760 + 1), (int)(this.field_22761 + 1), (int)(this.field_22760 + this.field_22758 - 1), (int)(this.field_22761 + this.field_22759 - 1), (int)-16777216);
        for (int line = 0; line + this.currentLine < this.formattedChars.size() && line < this.maxLines; ++line) {
            class_327 class_3272 = class_310.method_1551().field_1772;
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            TextScrollWidget.method_35720((class_4587)poseStack, (class_327)class_3272, (class_5481)this.formattedChars.get(line + this.currentLine), (int)(this.field_22760 + 5), (int)(this.field_22761 + 5 + line * 12), (int)-1);
        }
        float f = scrollbarStart = this.scrollSteps == 0 ? 0.0f : (float)this.currentLine / (float)this.scrollSteps * (float)this.scrollBarOffset;
        if (this.method_25370() || this.field_22762) {
            Objects.requireNonNull(this);
            TextScrollWidget.method_25294((class_4587)poseStack, (int)(this.field_22760 + this.field_22758 - 5 - 2), (int)((int)((float)(this.field_22761 + 1) + scrollbarStart)), (int)(this.field_22760 + this.field_22758 - 1), (int)((int)((float)(this.field_22761 + 1) + scrollbarStart + (float)this.scrollBarSize)), (int)-1);
        }
        Objects.requireNonNull(this);
        TextScrollWidget.method_25294((class_4587)poseStack, (int)(this.field_22760 + this.field_22758 - 5 - (this.method_25370() || this.field_22762 ? 1 : 2)), (int)((int)((float)(this.field_22761 + (this.method_25370() || this.field_22762 ? 2 : 1)) + scrollbarStart)), (int)(this.field_22760 + this.field_22758 - (this.method_25370() || this.field_22762 ? 2 : 1)), (int)((int)((float)(this.field_22761 + (this.method_25370() || this.field_22762 ? 0 : 1)) + scrollbarStart + (float)this.scrollBarSize)), (int)-6250336);
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public void method_25348(double mouseX, double mouseY) {
        class_2583 style;
        Objects.requireNonNull(this);
        if (mouseX >= (double)(this.field_22760 + this.field_22758 - 5) && mouseX <= (double)(this.field_22760 + this.field_22758) && mouseY >= (double)this.field_22761 && mouseY <= (double)(this.field_22761 + this.field_22759)) {
            this.scrollDragActive = true;
            if (this.maxLines < this.formattedChars.size()) {
                this.setCurrentLineFromYPos(mouseY);
            }
        } else if (this.method_25361(mouseX, mouseY) && (style = this.getMouseoverStyle(mouseX, mouseY)) != null && style.method_10970() != null) {
            class_310.method_1551().field_1755.method_25430(style);
        }
    }

    public void method_25357(double mouseX, double mouseY) {
        this.scrollDragActive = false;
        super.method_25357(mouseX, mouseY);
    }

    public void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.field_22764 && this.field_22763 && this.scrollDragActive) {
            this.setCurrentLineFromYPos(mouseY);
        }
    }

    private void setCurrentLineFromYPos(double mouseY) {
        this.currentLine = mouseY < (double)this.field_22761 + (double)this.scrollBarSize * 0.5 ? 0 : (mouseY > (double)(this.field_22761 + this.field_22759) - (double)this.scrollBarSize * 0.5 ? this.scrollSteps : (int)((mouseY - (double)this.field_22761 - (double)this.scrollBarSize * 0.5) / (double)(this.field_22759 - this.scrollBarSize) * (double)this.scrollSteps));
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollY) {
        if (scrollY < 0.0 && this.currentLine < this.scrollSteps) {
            ++this.currentLine;
        } else if (scrollY > 0.0 && this.currentLine > 0) {
            --this.currentLine;
        } else {
            return false;
        }
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 265 || keyCode == 264) && this.method_25401(0.0, 0.0, keyCode == 265 ? 1.0 : -1.0)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public class_2583 getMouseoverStyle(double mouseX, double mouseY) {
        int lineIndex = this.getLineIndex(mouseX, mouseY);
        if (lineIndex >= 0 && lineIndex < this.formattedChars.size()) {
            class_5481 line = this.formattedChars.get(lineIndex);
            return class_310.method_1551().field_1772.method_27527().method_30876(line, class_3532.method_15357((double)(mouseX - (double)this.field_22760)));
        }
        return null;
    }

    private int getLineIndex(double mouseX, double mouseY) {
        if (!this.method_25361(mouseX, mouseY)) {
            return -1;
        }
        double d = mouseY - (double)this.field_22761;
        Objects.requireNonNull(this);
        return (int)((d - 5.0 * 0.5) / 12.0);
    }
}

