/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.provider;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_276;
import net.minecraft.class_285;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4494;
import net.minecraft.class_5365;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;
import org.vivecraft.Xplat;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.extensions.RenderTargetExtension;
import org.vivecraft.client.utils.StencilHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRTextureTarget;
import org.vivecraft.client_vr.extensions.WindowExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.RenderConfigException;
import org.vivecraft.client_vr.render.VRShaders;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassManager;
import org.vivecraft.client_xr.render_pass.WorldRenderPass;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.resolutioncontrol.ResolutionControlHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;
import oshi.SystemInfo;
import oshi.hardware.GraphicsCard;

public abstract class VRRenderer {
    public class_1159[] eyeProj = new class_1159[2];
    private float lastFarClip = 0.0f;
    public class_276 framebufferEye0;
    public class_276 framebufferEye1;
    protected int LeftEyeTextureId = -1;
    protected int RightEyeTextureId = -1;
    public class_276 framebufferMR;
    public class_276 framebufferUndistorted;
    public class_276 framebufferVrRender;
    public class_276 fsaaFirstPassResultFBO;
    public class_276 fsaaLastPassResultFBO;
    public class_276 cameraFramebuffer;
    public class_276 cameraRenderFramebuffer;
    public class_276 telescopeFramebufferL;
    public class_276 telescopeFramebufferR;
    public class_276 mirrorFramebuffer;
    protected float[][] hiddenMeshVertices = new float[2][];
    private class_5365 previousGraphics = null;
    protected VRSettings.MirrorMode lastMirror;
    public long lastWindow = 0L;
    public int mirrorFBHeight;
    public int mirrorFBWidth;
    protected boolean reinitFrameBuffers = true;
    protected boolean resizeFrameBuffers = false;
    public float renderScale;
    protected class_3545<Integer, Integer> resolution;
    public float ss = -1.0f;
    protected MCVR vr;
    protected String lastError = "";

    public VRRenderer(MCVR vr) {
        this.vr = vr;
    }

    public abstract void createRenderTexture(int var1, int var2);

    public class_1159 getCachedProjectionMatrix(int eyeType, float nearClip, float farClip) {
        if (farClip != this.lastFarClip) {
            this.lastFarClip = farClip;
            this.eyeProj[0] = MathUtils.toMcMat4((Matrix4fc)this.getProjectionMatrix(0, nearClip, farClip));
            this.eyeProj[1] = MathUtils.toMcMat4((Matrix4fc)this.getProjectionMatrix(1, nearClip, farClip));
        }
        return this.eyeProj[eyeType];
    }

    protected abstract Matrix4f getProjectionMatrix(int var1, float var2, float var3);

    public abstract void endFrame() throws RenderConfigException;

    public abstract boolean providesStencilMask();

    public float[] getStencilMask(RenderPass eye) {
        if (eye == RenderPass.LEFT || eye == RenderPass.RIGHT) {
            return eye == RenderPass.LEFT ? this.hiddenMeshVertices[0] : this.hiddenMeshVertices[1];
        }
        return null;
    }

    public void doStencil(boolean inverse) {
        class_310 minecraft = class_310.method_1551();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        if (StencilHelper.stencilBufferSupported()) {
            GL11.glEnable((int)2960);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
            RenderSystem.stencilMask((int)255);
        }
        if (inverse) {
            RenderSystem.clearStencil((int)255);
            RenderSystem.clearDepth((double)0.0);
            RenderSystem.stencilFunc((int)519, (int)0, (int)255);
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        } else {
            RenderSystem.clearStencil((int)0);
            RenderSystem.clearDepth((double)1.0);
            RenderSystem.stencilFunc((int)519, (int)255, (int)255);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        if (StencilHelper.stencilBufferSupported()) {
            RenderSystem.clear((int)1280, (boolean)false);
        } else {
            RenderSystem.clear((int)256, (boolean)false);
        }
        RenderSystem.clearStencil((int)0);
        RenderSystem.clearDepth((double)1.0);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        RenderSystem.disableTexture();
        RenderSystem.disableCull();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        class_276 fb = minecraft.method_1522();
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((class_1159)class_1159.method_34239((float)0.0f, (float)fb.field_1480, (float)fb.field_1477, (float)0.0f, (float)0.0f, (float)20.0f));
        RenderSystem.getModelViewStack().method_22903();
        RenderSystem.getModelViewStack().method_34426();
        if (inverse) {
            RenderSystem.getModelViewStack().method_22904(0.0, 0.0, -20.0);
        }
        RenderSystem.applyModelViewMatrix();
        int program = GlStateManager._getInteger((int)35725);
        if (dataholder.currentPass == RenderPass.SCOPEL || dataholder.currentPass == RenderPass.SCOPER) {
            this.drawCircle(fb.field_1480, fb.field_1477);
        } else if (this.providesStencilMask() && (dataholder.currentPass == RenderPass.LEFT || dataholder.currentPass == RenderPass.RIGHT)) {
            this.drawMask();
        }
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.getModelViewStack().method_22909();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableTexture();
        RenderSystem.enableCull();
        class_285.method_22094((int)program);
        if (StencilHelper.stencilBufferSupported()) {
            RenderSystem.stencilFunc((int)517, (int)255, (int)1);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
            RenderSystem.stencilMask((int)0);
        }
        RenderSystem.depthFunc((int)515);
    }

    private void drawCircle(float width, float height) {
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27381, class_290.field_1592);
        float edges = 32.0f;
        float radius = width / 2.0f;
        builder.method_22912((double)radius, (double)radius, 0.0).method_1344();
        int i = 0;
        while ((float)i < 33.0f) {
            float startAngle = (float)i / 32.0f * ((float)Math.PI * 2);
            builder.method_22912((double)(radius + class_3532.method_15362((float)startAngle) * radius), (double)(radius + class_3532.method_15374((float)startAngle) * radius), 0.0).method_1344();
            ++i;
        }
        class_286.method_43433((class_287.class_7433)builder.method_1326());
    }

    private void drawMask() {
        float[] verts = this.getStencilMask(ClientDataHolderVR.getInstance().currentPass);
        if (verts == null) {
            return;
        }
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27379, class_290.field_1592);
        ShadersHelper.bindTexture(RenderHelper.BLACK_TEXTURE);
        for (int i = 0; i < verts.length; i += 2) {
            builder.method_22912((double)(verts[i] * this.renderScale + 0.5f), (double)(verts[i + 1] * this.renderScale + 0.5f), 0.0).method_1344();
        }
        RenderSystem.setShader(class_757::method_34539);
        class_286.method_43433((class_287.class_7433)builder.method_1326());
    }

    public String getInitError() {
        return this.vr.initStatus;
    }

    public String getLastError() {
        return this.lastError;
    }

    public abstract String getName();

    public List<RenderPass> getRenderPasses(boolean includeNonRendered) {
        class_310 minecraft = class_310.method_1551();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        ArrayList<RenderPass> passes = new ArrayList<RenderPass>();
        passes.add(RenderPass.LEFT);
        passes.add(RenderPass.RIGHT);
        WindowExtension window = (WindowExtension)minecraft.method_22683();
        if (includeNonRendered || window.vivecraft$getActualScreenWidth() > 0 && window.vivecraft$getActualScreenHeight() > 0) {
            if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.FIRST_PERSON) {
                passes.add(RenderPass.CENTER);
            } else if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
                if (dataholder.vrSettings.mixedRealityUndistorted && dataholder.vrSettings.mixedRealityUnityLike) {
                    passes.add(RenderPass.CENTER);
                }
                passes.add(RenderPass.THIRD);
            } else if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON) {
                passes.add(RenderPass.THIRD);
            }
        }
        if (minecraft.field_1724 != null) {
            if (TelescopeTracker.isTelescope(minecraft.field_1724.method_6047()) && TelescopeTracker.isViewing(0)) {
                passes.add(RenderPass.SCOPER);
            }
            if (TelescopeTracker.isTelescope(minecraft.field_1724.method_6079()) && TelescopeTracker.isViewing(1)) {
                passes.add(RenderPass.SCOPEL);
            }
            if (dataholder.cameraTracker.isVisible()) {
                passes.add(RenderPass.CAMERA);
            }
        }
        return passes;
    }

    public abstract class_3545<Integer, Integer> getRenderTextureSizes();

    public class_3545<Integer, Integer> getMirrorTextureSize(int eyeFBWidth, int eyeFBHeight, float resolutionScale) {
        this.mirrorFBWidth = (int)Math.ceil((float)((WindowExtension)class_310.method_1551().method_22683()).vivecraft$getActualScreenWidth() * resolutionScale);
        this.mirrorFBHeight = (int)Math.ceil((float)((WindowExtension)class_310.method_1551().method_22683()).vivecraft$getActualScreenHeight() * resolutionScale);
        if (ClientDataHolderVR.getInstance().vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
            this.mirrorFBWidth /= 2;
            if (ClientDataHolderVR.getInstance().vrSettings.mixedRealityUnityLike) {
                this.mirrorFBHeight /= 2;
            }
        }
        if (ShadersHelper.needsSameSizeBuffers()) {
            this.mirrorFBWidth = eyeFBWidth;
            this.mirrorFBHeight = eyeFBHeight;
        }
        return new class_3545((Object)this.mirrorFBWidth, (Object)this.mirrorFBHeight);
    }

    public class_3545<Integer, Integer> getTelescopeTextureSize(int eyeFBWidth, int eyeFBHeight) {
        int telescopeFBwidth = 720;
        int telescopeFBheight = 720;
        if (ShadersHelper.needsSameSizeBuffers()) {
            telescopeFBwidth = eyeFBWidth;
            telescopeFBheight = eyeFBHeight;
        }
        return new class_3545((Object)telescopeFBwidth, (Object)telescopeFBheight);
    }

    public class_3545<Integer, Integer> getCameraTextureSize(int eyeFBWidth, int eyeFBHeight) {
        int cameraFBwidth = Math.round(1920.0f * ClientDataHolderVR.getInstance().vrSettings.handCameraResScale);
        int cameraFBheight = Math.round(1080.0f * ClientDataHolderVR.getInstance().vrSettings.handCameraResScale);
        if (ShadersHelper.needsSameSizeBuffers()) {
            float aspect = (float)cameraFBwidth / (float)cameraFBheight;
            if (aspect > (float)(eyeFBWidth / eyeFBHeight)) {
                cameraFBwidth = eyeFBWidth;
                cameraFBheight = Math.round((float)eyeFBWidth / aspect);
            } else {
                cameraFBwidth = Math.round((float)eyeFBHeight * aspect);
                cameraFBheight = eyeFBHeight;
            }
        }
        return new class_3545((Object)cameraFBwidth, (Object)cameraFBheight);
    }

    public boolean isInitialized() {
        return this.vr.initSuccess;
    }

    public void reinitFrameBuffersMaybe(String cause) {
        if (this.allFramebuffersInitialized()) {
            this.resizeFrameBuffers(cause);
        } else {
            this.reinitFrameBuffers(cause);
        }
    }

    public void reinitFrameBuffers(String cause) {
        if (!this.reinitFrameBuffers) {
            VRSettings.LOGGER.info("Vivecraft: Reinit Render: {}", (Object)cause);
        }
        this.reinitFrameBuffers = true;
    }

    public void resizeFrameBuffers(String cause) {
        if (!cause.isEmpty() && !this.resizeFrameBuffers) {
            VRSettings.LOGGER.info("Vivecraft: Resizing Buffers: {}", (Object)cause);
        }
        this.resizeFrameBuffers = true;
    }

    private boolean allFramebuffersInitialized() {
        return ShadersHelper.isShaderActive() || ClientDataHolderVR.getInstance().vrSettings.fullReloadOnInit;
    }

    public void setupRenderConfiguration() throws RenderConfigException, IOException {
        class_3545<Integer, Integer> cameraSize;
        class_3545<Integer, Integer> telescopeSize;
        int eyeFBHeight;
        int eyeFBWidth;
        float resolutionScale;
        int eyeh;
        int eyew;
        class_3545<Integer, Integer> tuple;
        class_310 minecraft = class_310.method_1551();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        if (minecraft.method_22683().method_4490() != this.lastWindow) {
            this.lastWindow = minecraft.method_22683().method_4490();
            this.reinitFrameBuffers("Window Handle Changed");
        }
        if (this.lastMirror != dataholder.vrSettings.displayMirrorMode) {
            this.reinitFrameBuffersMaybe("Mirror Changed");
            this.lastMirror = dataholder.vrSettings.displayMirrorMode;
        }
        if ((this.framebufferMR == null || this.framebufferUndistorted == null) && this.allFramebuffersInitialized()) {
            this.reinitFrameBuffers("All buffers needed, but some buffers not initialized");
        }
        if (minecraft.field_1690.method_42534().method_41753() != this.previousGraphics) {
            this.previousGraphics = (class_5365)minecraft.field_1690.method_42534().method_41753();
            this.reinitFrameBuffers("gfx setting changed to: " + this.previousGraphics);
        }
        if (this.resizeFrameBuffers && !this.reinitFrameBuffers) {
            boolean mipmapChanged;
            tuple = this.getRenderTextureSizes();
            eyew = (Integer)tuple.method_15442();
            eyeh = (Integer)tuple.method_15441();
            resolutionScale = ResolutionControlHelper.isLoaded() ? ResolutionControlHelper.getCurrentScaleFactor() : 1.0f;
            this.renderScale = (float)Math.sqrt(dataholder.vrSettings.renderScaleFactor) * resolutionScale;
            eyeFBWidth = (int)Math.ceil((float)eyew * this.renderScale);
            eyeFBHeight = (int)Math.ceil((float)eyeh * this.renderScale);
            class_3545<Integer, Integer> mirrorSize = this.getMirrorTextureSize(eyeFBWidth, eyeFBHeight, resolutionScale);
            telescopeSize = this.getTelescopeTextureSize(eyeFBWidth, eyeFBHeight);
            cameraSize = this.getCameraTextureSize(eyeFBWidth, eyeFBHeight);
            if (dataholder.vrSettings.vrUseStencil && StencilHelper.stencilBufferSupported()) {
                ((RenderTargetExtension)WorldRenderPass.STEREO_XR.target).vivecraft$setStencil(!Xplat.enableRenderTargetStencil(WorldRenderPass.STEREO_XR.target));
            } else {
                ((RenderTargetExtension)WorldRenderPass.STEREO_XR.target).vivecraft$setStencil(false);
            }
            WorldRenderPass.STEREO_XR.resize(eyeFBWidth, eyeFBHeight);
            if (dataholder.vrSettings.useFsaa) {
                this.fsaaFirstPassResultFBO.method_1234(eyew, eyeFBHeight, class_310.field_1703);
            }
            if ((Integer)mirrorSize.method_15442() > 0 && (Integer)mirrorSize.method_15441() > 0) {
                if (WorldRenderPass.CENTER != null) {
                    WorldRenderPass.CENTER.resize((Integer)mirrorSize.method_15442(), (Integer)mirrorSize.method_15441());
                }
                if (WorldRenderPass.MIXED_REALITY != null) {
                    WorldRenderPass.MIXED_REALITY.resize((Integer)mirrorSize.method_15442(), (Integer)mirrorSize.method_15441());
                }
                this.mirrorFramebuffer.method_1234(Math.max(1, ((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenWidth()), Math.max(1, ((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenHeight()), class_310.field_1703);
            }
            WorldRenderPass.LEFT_TELESCOPE.resize((Integer)telescopeSize.method_15442(), (Integer)telescopeSize.method_15441());
            WorldRenderPass.RIGHT_TELESCOPE.resize((Integer)telescopeSize.method_15442(), (Integer)telescopeSize.method_15441());
            this.cameraFramebuffer.method_1234(((Integer)cameraSize.method_15442()).intValue(), ((Integer)cameraSize.method_15441()).intValue(), class_310.field_1703);
            if (ShadersHelper.needsSameSizeBuffers()) {
                WorldRenderPass.CAMERA.resize(eyeFBWidth, eyeFBHeight);
            } else {
                WorldRenderPass.CAMERA.resize((Integer)cameraSize.method_15442(), (Integer)cameraSize.method_15441());
            }
            boolean mipmaps = dataholder.vrSettings.guiMipmaps;
            boolean anisotropicFiltering = dataholder.vrSettings.guiAnisotropicFiltering;
            boolean bl = mipmapChanged = mipmaps != ((RenderTargetExtension)GuiHandler.GUI_FRAMEBUFFER).vivecraft$hasMipmaps() || anisotropicFiltering != ((VRTextureTarget)GuiHandler.GUI_FRAMEBUFFER).anisotropicFiltering;
            if (GuiHandler.updateResolution() || mipmapChanged) {
                ((RenderTargetExtension)GuiHandler.GUI_FRAMEBUFFER).vivecraft$setMipmaps(mipmaps);
                ((VRTextureTarget)GuiHandler.GUI_FRAMEBUFFER).anisotropicFiltering = anisotropicFiltering;
                GuiHandler.GUI_FRAMEBUFFER.method_1234(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT, class_310.field_1703);
                ((RenderTargetExtension)RadialHandler.FRAMEBUFFER).vivecraft$setMipmaps(mipmaps);
                ((VRTextureTarget)RadialHandler.FRAMEBUFFER).anisotropicFiltering = anisotropicFiltering;
                RadialHandler.FRAMEBUFFER.method_1234(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT, class_310.field_1703);
                ((RenderTargetExtension)KeyboardHandler.FRAMEBUFFER).vivecraft$setMipmaps(mipmaps);
                ((VRTextureTarget)KeyboardHandler.FRAMEBUFFER).anisotropicFiltering = anisotropicFiltering;
                KeyboardHandler.FRAMEBUFFER.method_1234(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT, class_310.field_1703);
                if (minecraft.field_1755 != null) {
                    int guiWidth = minecraft.method_22683().method_4486();
                    int guiHeight = minecraft.method_22683().method_4502();
                    minecraft.field_1755.method_25423(minecraft, guiWidth, guiHeight);
                }
            }
            minecraft.method_15993();
            this.resizeFrameBuffers = false;
        }
        if (this.reinitFrameBuffers) {
            RenderHelper.checkGLError("Start Init");
            if (class_156.method_668() == class_156.class_158.field_1133 && class_4494.method_22090().toLowerCase().contains("intel") && dataholder.vrSettings.blockIntelWindows) {
                StringBuilder gpus = new StringBuilder();
                boolean onlyIntel = true;
                for (GraphicsCard gpu : new SystemInfo().getHardware().getGraphicsCards()) {
                    gpus.append("\n");
                    if (gpu.getVendor().toLowerCase().contains("intel") || gpu.getName().toLowerCase().contains("intel")) {
                        gpus.append("\u00a7c\u274c\u00a7r ");
                    } else {
                        onlyIntel = false;
                        gpus.append("\u00a7a\u2714\u00a7r ");
                    }
                    gpus.append(gpu.getVendor()).append(": ").append(gpu.getName());
                }
                throw new RenderConfigException((class_2561)class_2561.method_43471((String)"vivecraft.messages.incompatiblegpu"), (class_2561)class_2561.method_43469((String)"vivecraft.messages.intelgraphics1", (Object[])new Object[]{class_2561.method_43470((String)class_4494.method_22090()).method_27692(class_124.field_1065), gpus.toString(), onlyIntel ? class_2561.method_43473() : class_2561.method_43469((String)"vivecraft.messages.intelgraphics2", (Object[])new Object[]{class_2561.method_43470((String)"https://www.vivecraft.org/faq/#gpu").method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1060).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.link.open"))).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://www.vivecraft.org/faq/#gpu")))})}));
            }
            if (!this.isInitialized()) {
                throw new RenderConfigException((class_2561)class_2561.method_43469((String)"vivecraft.messages.renderiniterror", (Object[])new Object[]{this.getName()}), (class_2561)class_2561.method_43470((String)this.getInitError()));
            }
            tuple = this.getRenderTextureSizes();
            eyew = (Integer)tuple.method_15442();
            eyeh = (Integer)tuple.method_15441();
            this.destroyBuffers();
            if (this.LeftEyeTextureId == -1) {
                this.createRenderTexture(eyew, eyeh);
                if (this.LeftEyeTextureId == -1) {
                    throw new RenderConfigException((class_2561)class_2561.method_43469((String)"vivecraft.messages.renderiniterror", (Object[])new Object[]{this.getName()}), (class_2561)class_2561.method_43470((String)this.getLastError()));
                }
                VRSettings.LOGGER.info("Vivecraft: VR Provider supplied render texture IDs: {}, {}", (Object)this.LeftEyeTextureId, (Object)this.RightEyeTextureId);
                VRSettings.LOGGER.info("Vivecraft: VR Provider supplied texture resolution: {} x {}", (Object)eyew, (Object)eyeh);
            }
            RenderHelper.checkGLError("Render Texture setup");
            if (this.framebufferEye0 == null) {
                this.framebufferEye0 = VRTextureTarget.builder("L Eye").withSize(eyew, eyeh).withTexId(this.LeftEyeTextureId).withLinearFilter().build();
                VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.framebufferEye0);
                RenderHelper.checkGLError("Left Eye framebuffer setup");
            }
            if (this.framebufferEye1 == null) {
                this.framebufferEye1 = VRTextureTarget.builder("R Eye").withSize(eyew, eyeh).withTexId(this.RightEyeTextureId).withLinearFilter().build();
                VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.framebufferEye1);
                RenderHelper.checkGLError("Right Eye framebuffer setup");
            }
            resolutionScale = ResolutionControlHelper.isLoaded() ? ResolutionControlHelper.getCurrentScaleFactor() : 1.0f;
            this.renderScale = (float)Math.sqrt(dataholder.vrSettings.renderScaleFactor) * resolutionScale;
            eyeFBWidth = (int)Math.ceil((float)eyew * this.renderScale);
            eyeFBHeight = (int)Math.ceil((float)eyeh * this.renderScale);
            this.framebufferVrRender = VRTextureTarget.builder("3D Render").withSize(eyeFBWidth, eyeFBHeight).withDepth().withLinearFilter().withStencil(dataholder.vrSettings.vrUseStencil && StencilHelper.stencilBufferSupported()).build();
            WorldRenderPass.STEREO_XR = new WorldRenderPass(this.framebufferVrRender);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.framebufferVrRender);
            RenderHelper.checkGLError("3D framebuffer setup");
            this.getMirrorTextureSize(eyeFBWidth, eyeFBHeight, resolutionScale);
            List<RenderPass> list = this.getRenderPasses(true);
            VRSettings.LOGGER.info("Vivecraft: Active RenderPasses: {}", (Object)list.stream().map(Enum::toString).collect(Collectors.joining(", ")));
            if (list.contains((Object)RenderPass.THIRD) || this.allFramebuffersInitialized()) {
                this.framebufferMR = VRTextureTarget.builder("Mixed Reality Render").withSize(Math.max(1, this.mirrorFBWidth), Math.max(1, this.mirrorFBHeight)).withDepth().withLinearFilter().build();
                WorldRenderPass.MIXED_REALITY = new WorldRenderPass(this.framebufferMR);
                VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.framebufferMR);
                RenderHelper.checkGLError("Mixed reality framebuffer setup");
            }
            if (list.contains((Object)RenderPass.CENTER) || this.allFramebuffersInitialized()) {
                this.framebufferUndistorted = VRTextureTarget.builder("Undistorted View Render").withSize(Math.max(1, this.mirrorFBWidth), Math.max(1, this.mirrorFBHeight)).withDepth().withLinearFilter().build();
                WorldRenderPass.CENTER = new WorldRenderPass(this.framebufferUndistorted);
                VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.framebufferUndistorted);
                RenderHelper.checkGLError("Undistorted view framebuffer setup");
            }
            this.mirrorFramebuffer = VRTextureTarget.builder("Mirror").withSize(Math.max(1, ((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenWidth()), Math.max(1, ((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenHeight())).withClearColor(0.0f, 0.0f, 0.0f, 1.0f).build();
            this.mirrorFramebuffer.method_1236(0.0f, 0.0f, 0.0f, 1.0f);
            this.mirrorFramebuffer.method_1230(class_310.field_1703);
            GuiHandler.updateResolution();
            GuiHandler.GUI_FRAMEBUFFER = VRTextureTarget.builder("GUI").withSize(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT).withDepth().withLinearFilter().withMipmaps(dataholder.vrSettings.guiMipmaps).withAnisotropicFiltering(dataholder.vrSettings.guiAnisotropicFiltering).build();
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)GuiHandler.GUI_FRAMEBUFFER);
            RenderHelper.checkGLError("GUI framebuffer setup");
            KeyboardHandler.FRAMEBUFFER = VRTextureTarget.builder("Keyboard").withSize(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT).withDepth().withLinearFilter().withMipmaps(dataholder.vrSettings.guiMipmaps).withAnisotropicFiltering(dataholder.vrSettings.guiAnisotropicFiltering).build();
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)KeyboardHandler.FRAMEBUFFER);
            RenderHelper.checkGLError("Keyboard framebuffer setup");
            RadialHandler.FRAMEBUFFER = VRTextureTarget.builder("Radial Menu").withSize(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT).withDepth().withLinearFilter().withMipmaps(dataholder.vrSettings.guiMipmaps).withAnisotropicFiltering(dataholder.vrSettings.guiAnisotropicFiltering).build();
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)RadialHandler.FRAMEBUFFER);
            RenderHelper.checkGLError("Radial framebuffer setup");
            telescopeSize = this.getTelescopeTextureSize(eyeFBWidth, eyeFBHeight);
            this.telescopeFramebufferR = VRTextureTarget.builder("TelescopeR").withSize((Integer)telescopeSize.method_15442(), (Integer)telescopeSize.method_15441()).withDepth().withClearColor(0.0f, 0.0f, 0.0f, 1.0f).build();
            WorldRenderPass.RIGHT_TELESCOPE = new WorldRenderPass(this.telescopeFramebufferR);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.telescopeFramebufferR);
            RenderHelper.checkGLError("TelescopeR framebuffer setup");
            this.telescopeFramebufferL = VRTextureTarget.builder("TelescopeL").withSize((Integer)telescopeSize.method_15442(), (Integer)telescopeSize.method_15441()).withDepth().withClearColor(0.0f, 0.0f, 0.0f, 1.0f).build();
            WorldRenderPass.LEFT_TELESCOPE = new WorldRenderPass(this.telescopeFramebufferL);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.telescopeFramebufferL);
            RenderHelper.checkGLError("TelescopeL framebuffer setup");
            cameraSize = this.getCameraTextureSize(eyeFBWidth, eyeFBHeight);
            int cameraRenderFBwidth = (Integer)cameraSize.method_15442();
            int cameraRenderFBheight = (Integer)cameraSize.method_15441();
            if (ShadersHelper.needsSameSizeBuffers()) {
                cameraRenderFBwidth = eyeFBWidth;
                cameraRenderFBheight = eyeFBHeight;
            }
            this.cameraFramebuffer = VRTextureTarget.builder("Handheld Camera").withSize((Integer)cameraSize.method_15442(), (Integer)cameraSize.method_15441()).withDepth().build();
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.cameraFramebuffer);
            RenderHelper.checkGLError("Camera framebuffer setup");
            this.cameraRenderFramebuffer = VRTextureTarget.builder("Handheld Camera Render").withSize(cameraRenderFBwidth, cameraRenderFBheight).withDepth().withLinearFilter().build();
            WorldRenderPass.CAMERA = new WorldRenderPass(this.cameraRenderFramebuffer);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.cameraRenderFramebuffer);
            RenderHelper.checkGLError("Camera render framebuffer setup");
            if (dataholder.vrSettings.useFsaa) {
                try {
                    RenderHelper.checkGLError("pre FSAA FBO creation");
                    this.fsaaFirstPassResultFBO = VRTextureTarget.builder("FSAA Pass1 FBO").withSize(eyew, eyeFBHeight).withDepth().build();
                    this.fsaaLastPassResultFBO = VRTextureTarget.builder("FSAA Pass2 FBO").withSize(eyew, eyeh).withDepth().build();
                    VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.fsaaFirstPassResultFBO);
                    VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.fsaaLastPassResultFBO);
                    RenderHelper.checkGLError("FSAA FBO creation");
                }
                catch (Exception exception) {
                    dataholder.vrSettings.useFsaa = false;
                    dataholder.vrSettings.saveOptions();
                    VRSettings.LOGGER.error("Vivecraft: FSAA init failed: ", (Throwable)exception);
                    this.reinitFrameBuffers = true;
                    return;
                }
            }
            if (!VRShaders.isReady()) {
                throw new RenderConfigException((class_2561)class_2561.method_43469((String)"vivecraft.messages.renderiniterror", (Object[])new Object[]{this.getName()}), (class_2561)class_2561.method_43470((String)"Failed to load VR shaders, see log for full error."));
            }
            RenderPassManager.setGUIRenderPass();
            minecraft.field_1773.method_3167(minecraft.method_1560());
            if (minecraft.field_1755 != null) {
                int w = minecraft.method_22683().method_4486();
                int h = minecraft.method_22683().method_4502();
                minecraft.field_1755.method_25423(minecraft, w, h);
            }
            long windowPixels = (long)((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenWidth() * (long)((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenHeight();
            long mirrorPixels = (long)this.mirrorFBWidth * (long)this.mirrorFBHeight;
            long vrPixels = (long)eyeFBWidth * (long)eyeFBHeight;
            long pixelsPerFrame = vrPixels * 2L;
            if (list.contains((Object)RenderPass.CENTER)) {
                pixelsPerFrame += mirrorPixels;
            }
            if (list.contains((Object)RenderPass.THIRD)) {
                pixelsPerFrame += mirrorPixels;
            }
            VRSettings.LOGGER.info("Vivecraft:\nNew VR render config:\nVR target: {}x{} [{}MP]\nRender target: {}x{} [Render scale: {}%, {}MP]\nMain window: {}x{} [{}MP]\nTotal shaded pixels per frame: {}MP (eye stencil not accounted for)", new Object[]{eyew, eyeh, String.format("%.1f", Float.valueOf((float)(eyew * eyeh) / 1000000.0f)), eyeFBWidth, eyeFBHeight, Float.valueOf(dataholder.vrSettings.renderScaleFactor * 100.0f), String.format("%.1f", Float.valueOf((float)vrPixels / 1000000.0f)), ((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenWidth(), ((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenHeight(), String.format("%.1f", Float.valueOf((float)windowPixels / 1000000.0f)), String.format("%.1f", Float.valueOf((float)pixelsPerFrame / 1000000.0f))});
            if (ClientDataHolderVR.getInstance().vrSettings.fullReloadOnInit) {
                minecraft.method_1521();
            } else {
                minecraft.field_1769.method_14491(minecraft.method_1478());
                dataholder.updateActivePostChains();
            }
            ShadersHelper.maybeReloadShaders();
            this.reinitFrameBuffers = false;
            this.resizeFrameBuffers = false;
        }
    }

    protected void destroyBuffers() {
        if (this.framebufferVrRender != null) {
            WorldRenderPass.STEREO_XR.close();
            WorldRenderPass.STEREO_XR = null;
            this.framebufferVrRender.method_1238();
            this.framebufferVrRender = null;
        }
        if (this.framebufferMR != null) {
            WorldRenderPass.MIXED_REALITY.close();
            WorldRenderPass.MIXED_REALITY = null;
            this.framebufferMR.method_1238();
            this.framebufferMR = null;
        }
        if (this.framebufferUndistorted != null) {
            WorldRenderPass.CENTER.close();
            WorldRenderPass.CENTER = null;
            this.framebufferUndistorted.method_1238();
            this.framebufferUndistorted = null;
        }
        if (GuiHandler.GUI_FRAMEBUFFER != null) {
            GuiHandler.GUI_FRAMEBUFFER.method_1238();
            GuiHandler.GUI_FRAMEBUFFER = null;
        }
        if (KeyboardHandler.FRAMEBUFFER != null) {
            KeyboardHandler.FRAMEBUFFER.method_1238();
            KeyboardHandler.FRAMEBUFFER = null;
        }
        if (RadialHandler.FRAMEBUFFER != null) {
            RadialHandler.FRAMEBUFFER.method_1238();
            RadialHandler.FRAMEBUFFER = null;
        }
        if (this.telescopeFramebufferL != null) {
            WorldRenderPass.LEFT_TELESCOPE.close();
            WorldRenderPass.LEFT_TELESCOPE = null;
            this.telescopeFramebufferL.method_1238();
            this.telescopeFramebufferL = null;
        }
        if (this.telescopeFramebufferR != null) {
            WorldRenderPass.RIGHT_TELESCOPE.close();
            WorldRenderPass.RIGHT_TELESCOPE = null;
            this.telescopeFramebufferR.method_1238();
            this.telescopeFramebufferR = null;
        }
        if (this.cameraFramebuffer != null) {
            this.cameraFramebuffer.method_1238();
            this.cameraFramebuffer = null;
        }
        if (this.cameraRenderFramebuffer != null) {
            WorldRenderPass.CAMERA.close();
            WorldRenderPass.CAMERA = null;
            this.cameraRenderFramebuffer.method_1238();
            this.cameraRenderFramebuffer = null;
        }
        if (this.fsaaFirstPassResultFBO != null) {
            this.fsaaFirstPassResultFBO.method_1238();
            this.fsaaFirstPassResultFBO = null;
        }
        if (this.fsaaLastPassResultFBO != null) {
            this.fsaaLastPassResultFBO.method_1238();
            this.fsaaLastPassResultFBO = null;
        }
        if (this.framebufferEye0 != null) {
            this.framebufferEye0.method_1238();
            this.framebufferEye0 = null;
            this.LeftEyeTextureId = -1;
        }
        if (this.framebufferEye1 != null) {
            this.framebufferEye1.method_1238();
            this.framebufferEye1 = null;
            this.RightEyeTextureId = -1;
        }
        if (this.mirrorFramebuffer != null) {
            this.mirrorFramebuffer.method_1238();
            this.mirrorFramebuffer = null;
        }
    }

    public void destroy() {
        this.destroyBuffers();
    }
}

