/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.provider;

import java.util.Arrays;
import net.minecraft.client.KeyMapping;
import org.vivecraft.client_vr.provider.ControllerType;

public class HandedKeyBinding
extends KeyMapping {
    private final boolean[] pressed = new boolean[ControllerType.values().length];
    private final int[] pressTime = new int[ControllerType.values().length];

    public HandedKeyBinding(String name, int keyCode, String category) {
        super(name, keyCode, category);
    }

    public boolean consumeClick() {
        return Arrays.stream(ControllerType.values()).map(this::consumeClick).reduce(false, (a, b) -> a != false || b != false);
    }

    public boolean isDown() {
        return Arrays.stream(ControllerType.values()).map(this::isDown).reduce(false, (a, b) -> a != false || b != false);
    }

    public boolean consumeClick(ControllerType hand) {
        if (this.pressTime[hand.ordinal()] > 0) {
            int n = hand.ordinal();
            this.pressTime[n] = this.pressTime[n] - 1;
            return true;
        }
        return false;
    }

    public boolean isDown(ControllerType hand) {
        return this.pressed[hand.ordinal()];
    }

    public void pressKey(ControllerType hand) {
        this.pressed[hand.ordinal()] = true;
        int n = hand.ordinal();
        this.pressTime[n] = this.pressTime[n] + 1;
    }

    public void unpressKey(ControllerType hand) {
        this.pressTime[hand.ordinal()] = 0;
        this.pressed[hand.ordinal()] = false;
    }

    public boolean isPriorityOnController(ControllerType type) {
        return true;
    }
}

