/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.render.MirrorNotification;
import org.vivecraft.client_vr.render.VRShaders;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.iris.IrisHelper;

public class ShaderHelper {
    private static final Minecraft MC = Minecraft.getInstance();
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static float FOV_REDUCTION = 1.0f;
    private static float WATER_EFFECT;
    private static boolean WAS_IN_WATER;
    private static float PUMPKIN_EFFECT;
    private static float PORTAL_EFFECT;
    private static float RED;
    private static float BLACK;
    private static float BLUE;
    private static float TIME;
    private static GpuBuffer SCREEN_VBO;

    public static void renderFullscreenQuad(@NotNull Supplier<String> name, @NotNull RenderPipeline instance, @NotNull Consumer<com.mojang.blaze3d.systems.RenderPass> uniformSetter, @Nullable GpuTextureView target) {
        if (instance.getVertexFormat() != DefaultVertexFormat.POSITION_TEX) {
            throw new IllegalStateException("Vertex format needs to be 'POSITION_TEX'");
        }
        GpuBuffer quad = ShaderHelper.getFullscreenQuad();
        RenderSystem.AutoStorageIndexBuffer indexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
        GpuBuffer indexGpuBuffer = indexBuffer.getBuffer(6);
        try (com.mojang.blaze3d.systems.RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(name, target != null ? target : MC.getMainRenderTarget().getColorTextureView(), OptionalInt.empty());){
            renderPass.setPipeline(instance);
            renderPass.setVertexBuffer(0, quad);
            uniformSetter.accept(renderPass);
            renderPass.setIndexBuffer(indexGpuBuffer, indexBuffer.type());
            renderPass.drawIndexed(0, 0, 6, 1);
        }
    }

    private static GpuBuffer getFullscreenQuad() {
        if (SCREEN_VBO == null) {
            BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            builder.addVertex(-1.0f, -1.0f, 0.0f).setUv(0.0f, 0.0f);
            builder.addVertex(1.0f, -1.0f, 0.0f).setUv(1.0f, 0.0f);
            builder.addVertex(1.0f, 1.0f, 0.0f).setUv(1.0f, 1.0f);
            builder.addVertex(-1.0f, 1.0f, 0.0f).setUv(0.0f, 1.0f);
            try (MeshData meshData = builder.buildOrThrow();){
                SCREEN_VBO = RenderSystem.getDevice().createBuffer(() -> "fullscreen vr vertex buffer", 32, meshData.vertexBuffer());
            }
        }
        return SCREEN_VBO;
    }

    public static void doVrPostProcess(RenderPass eye, RenderTarget source, RenderTarget target, float partialTick) {
        if (eye == RenderPass.LEFT) {
            RED = 0.0f;
            BLACK = 0.0f;
            BLUE = 0.0f;
            TIME = (float)Util.getMillis() / 1000.0f;
            PUMPKIN_EFFECT = 0.0f;
            PORTAL_EFFECT = 0.0f;
            if (ShaderHelper.MC.player != null && ShaderHelper.MC.level != null) {
                boolean isInWater = ((GameRendererExtension)ShaderHelper.MC.gameRenderer).vivecraft$isInWater();
                if (ShaderHelper.DATA_HOLDER.vrSettings.waterEffect && WAS_IN_WATER != isInWater) {
                    WATER_EFFECT = 2.3f;
                } else {
                    WATER_EFFECT = isInWater ? (WATER_EFFECT -= 0.008333334f) : (WATER_EFFECT -= 0.016666668f);
                    if (WATER_EFFECT < 0.0f) {
                        WATER_EFFECT = 0.0f;
                    }
                }
                WAS_IN_WATER = isInWater;
                if (IrisHelper.isLoaded() && !IrisHelper.hasWaterEffect()) {
                    WATER_EFFECT = 0.0f;
                }
                float portalTime = Mth.lerp((float)partialTick, (float)ShaderHelper.MC.player.oPortalEffectIntensity, (float)ShaderHelper.MC.player.portalEffectIntensity);
                PORTAL_EFFECT = ShaderHelper.DATA_HOLDER.vrSettings.portalEffect && portalTime > 0.0f ? portalTime : 0.0f;
                ItemStack itemstack = ShaderHelper.MC.player.getItemBySlot(EquipmentSlot.HEAD);
                PUMPKIN_EFFECT = ShaderHelper.DATA_HOLDER.vrSettings.pumpkinEffect && itemstack.getItem() == Blocks.CARVED_PUMPKIN.asItem() && !itemstack.has(DataComponents.CUSTOM_MODEL_DATA) ? 1.0f : 0.0f;
                float hurtTimer = (float)ShaderHelper.MC.player.hurtTime - partialTick;
                float healthPercent = 1.0f - ShaderHelper.MC.player.getHealth() / ShaderHelper.MC.player.getMaxHealth();
                healthPercent = (healthPercent - 0.5f) * 0.75f;
                if (ShaderHelper.DATA_HOLDER.vrSettings.hitIndicator && hurtTimer > 0.0f) {
                    hurtTimer /= (float)ShaderHelper.MC.player.hurtDuration;
                    RED = hurtTimer = healthPercent + Mth.sin((float)(hurtTimer * hurtTimer * hurtTimer * hurtTimer * (float)Math.PI)) * 0.5f;
                } else if (ShaderHelper.DATA_HOLDER.vrSettings.lowHealthIndicator) {
                    RED = healthPercent * Mth.abs((float)Mth.sin((float)(2.5f * TIME / (1.0f - healthPercent + 0.1f))));
                    if (ShaderHelper.MC.player.isCreative()) {
                        RED = 0.0f;
                    }
                }
                float freeze = ShaderHelper.MC.player.getPercentFrozen();
                if (ShaderHelper.DATA_HOLDER.vrSettings.freezeEffect && freeze > 0.0f) {
                    BLUE = RED;
                    BLUE = Math.max(freeze / 2.0f, BLUE);
                    RED = 0.0f;
                }
                if (ShaderHelper.MC.player.isSleeping()) {
                    BLACK = 0.5f + 0.3f * (float)ShaderHelper.MC.player.getSleepTimer() * 0.01f;
                }
                if (ShaderHelper.DATA_HOLDER.vr.isWalkingAbout && BLACK < 0.8f) {
                    BLACK = 0.5f;
                }
                if (ShaderHelper.DATA_HOLDER.vrSettings.useFOVReduction && ShaderHelper.DATA_HOLDER.vrPlayer.getFreeMove()) {
                    FOV_REDUCTION = Math.abs(ShaderHelper.MC.player.zza) > 0.0f || Math.abs(ShaderHelper.MC.player.xxa) > 0.0f ? (FOV_REDUCTION -= 0.05f) : (FOV_REDUCTION += 0.01f);
                    FOV_REDUCTION = Mth.clamp((float)FOV_REDUCTION, (float)ShaderHelper.DATA_HOLDER.vrSettings.fovReductionMin, (float)0.8f);
                } else {
                    FOV_REDUCTION = 1.0f;
                }
            } else {
                WATER_EFFECT = 0.0f;
                FOV_REDUCTION = 1.0f;
            }
        }
        VRShaders.POST_PROCESS_UBO.updateBuffer(PUMPKIN_EFFECT > 0.0f ? 0.3f : FOV_REDUCTION, ShaderHelper.DATA_HOLDER.vrSettings.fovRedutioncOffset, PUMPKIN_EFFECT > 0.0f ? 0.0f : 0.06f, WATER_EFFECT, PORTAL_EFFECT, TIME, PUMPKIN_EFFECT, RED, BLUE, BLACK, eye == RenderPass.LEFT ? 1 : -1);
        ShaderHelper.renderFullscreenQuad(() -> "Vive postprocessing", VRShaders.POST_PROCESSING_PIPELINE, renderPass -> {
            renderPass.setUniform("PostProcessUbo", VRShaders.POST_PROCESS_UBO.getBuffer());
            renderPass.bindSampler("Sampler0", source.getColorTextureView());
        }, target.getColorTextureView());
        VRShaders.POST_PROCESS_UBO.endFrame();
    }

    public static void drawMirror() {
        if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.OFF && ShaderHelper.DATA_HOLDER.vr.isHMDTracking()) {
            MirrorNotification.notify("Mirror is OFF", true, 1000);
        } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
            ShaderHelper.doMixedRealityMirror();
        } else if (!(ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode != VRSettings.MirrorMode.DUAL || ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && ShaderHelper.DATA_HOLDER.cameraTracker.isVisible())) {
            RenderTarget leftEye = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye0;
            RenderTarget rightEye = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1;
            int screenWidth = ShaderHelper.MC.mainRenderTarget.width / 2;
            int screenHeight = ShaderHelper.MC.mainRenderTarget.height;
            if (leftEye != null) {
                ShaderHelper.blitToScreen(leftEye, 0, screenWidth, screenHeight, 0, 0.0f, 0.0f, false);
            }
            if (rightEye != null) {
                ShaderHelper.blitToScreen(rightEye, screenWidth, screenWidth, screenHeight, 0, 0.0f, 0.0f, false);
            }
        } else {
            float xCrop = 0.0f;
            float yCrop = 0.0f;
            boolean keepAspect = false;
            RenderTarget source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye0;
            if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && ShaderHelper.DATA_HOLDER.cameraTracker.isVisible()) {
                source = ShaderHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer;
                keepAspect = true;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.FIRST_PERSON) {
                source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferUndistorted;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON) {
                source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferMR;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.GUI) {
                source = GuiHandler.GUI_FRAMEBUFFER;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.SINGLE || ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.OFF) {
                if (!ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye) {
                    source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1;
                }
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.CROPPED) {
                if (!ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye) {
                    source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1;
                }
                xCrop = ShaderHelper.DATA_HOLDER.vrSettings.mirrorCrop;
                yCrop = ShaderHelper.DATA_HOLDER.vrSettings.mirrorCrop;
                keepAspect = true;
            }
            if (source != null) {
                ShaderHelper.blitToScreen(source, 0, ShaderHelper.MC.mainRenderTarget.width, ShaderHelper.MC.mainRenderTarget.height, 0, xCrop, yCrop, keepAspect);
            }
        }
        MirrorNotification.render();
    }

    public static void doMixedRealityMirror() {
        Vector3f camPlayer = ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getHeadPivotF().sub((Vector3fc)ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getEye(RenderPass.THIRD).getPositionF());
        Matrix4f viewMatrix = ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getEye(RenderPass.THIRD).getMatrix().transpose();
        Vector3f cameraLook = ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getEye(RenderPass.THIRD).getDirection();
        cameraLook.set(-cameraLook.x, 0.0f, -cameraLook.z);
        boolean alphaMask = ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUnityLike && ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityAlphaMask;
        VRShaders.MIXED_REALITY_UBO.updateBuffer((Matrix4fc)((GameRendererExtension)ShaderHelper.MC.gameRenderer).vivecraft$getThirdPassProjectionMatrix(), (Matrix4fc)viewMatrix, (Vector3fc)camPlayer, (Vector3fc)cameraLook, ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUnityLike, (Vector3fc)(alphaMask ? MathUtils.ZERO : new Vector3f((float)ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityKeyColor.getRed() / 255.0f, (float)ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityKeyColor.getGreen() / 255.0f, (float)ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityKeyColor.getBlue() / 255.0f)), alphaMask);
        GpuTextureView black = RenderHelper.getGpuTexture(RenderHelper.BLACK_TEXTURE);
        ShaderHelper.renderFullscreenQuad(() -> "Vive mixed reality", VRShaders.MIXED_REALITY_PIPELINE, renderPass -> {
            renderPass.setUniform("MixedRealityUbo", VRShaders.MIXED_REALITY_UBO.getBuffer());
            renderPass.bindSampler("thirdPersonColor", ShaderHelper.DATA_HOLDER.vrRenderer.framebufferMR.getColorTextureView());
            renderPass.bindSampler("thirdPersonDepth", ShaderHelper.DATA_HOLDER.vrRenderer.framebufferMR.getDepthTextureView());
            if (ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUnityLike) {
                RenderTarget source = ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && ShaderHelper.DATA_HOLDER.cameraTracker.isVisible() ? ShaderHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer : (ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUndistorted ? ShaderHelper.DATA_HOLDER.vrRenderer.framebufferUndistorted : (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye ? ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye0 : ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1));
                renderPass.bindSampler("firstPersonColor", source.getColorTextureView());
            } else {
                renderPass.bindSampler("firstPersonColor", black);
            }
        }, null);
        VRShaders.MIXED_REALITY_UBO.endFrame();
    }

    public static void doFSAA(RenderTarget source, RenderTarget firstPass, RenderTarget secondPass) {
        if (firstPass == null) {
            ShaderHelper.DATA_HOLDER.vrRenderer.reinitFrameBuffers("FSAA Setting Changed");
        } else {
            VRShaders.LANCZOS_UBO.updateBuffer(1.0f / (3.0f * (float)firstPass.viewWidth), 0.0f);
            ShaderHelper.renderFullscreenQuad(() -> "Vive Lanczos 1", VRShaders.LANCZOS_PIPELINE, renderPass -> {
                renderPass.bindSampler("Sampler0", source.getColorTextureView());
                renderPass.bindSampler("Sampler1", source.getDepthTextureView());
                renderPass.setUniform("LanczosUbo", VRShaders.LANCZOS_UBO.getBuffer());
            }, firstPass.getColorTextureView());
            VRShaders.LANCZOS_UBO.endFrame();
            VRShaders.LANCZOS_UBO.updateBuffer(0.0f, 1.0f / (3.0f * (float)secondPass.viewHeight));
            ShaderHelper.renderFullscreenQuad(() -> "Vive Lanczos 2", VRShaders.LANCZOS_PIPELINE, renderPass -> {
                renderPass.bindSampler("Sampler0", firstPass.getColorTextureView());
                renderPass.bindSampler("Sampler1", firstPass.getDepthTextureView());
                renderPass.setUniform("LanczosUbo", VRShaders.LANCZOS_UBO.getBuffer());
            }, secondPass.getColorTextureView());
        }
    }

    public static void blitToScreen(RenderTarget source, int left, int width, int height, int top, float xCropFactor, float yCropFactor, boolean keepAspect) {
        RenderSystem.assertOnRenderThread();
        float drawAspect = (float)width / (float)height;
        float bufferAspect = (float)source.viewWidth / (float)source.viewHeight;
        float xMin = xCropFactor;
        float yMin = yCropFactor;
        float xMax = 1.0f - xCropFactor;
        float yMax = 1.0f - yCropFactor;
        if (keepAspect) {
            if (drawAspect > bufferAspect) {
                float heightAspect = bufferAspect / drawAspect * (0.5f - yCropFactor);
                yMin = 0.5f - heightAspect;
                yMax = 0.5f + heightAspect;
            } else {
                float widthAspect = drawAspect / bufferAspect * (0.5f - xCropFactor);
                xMin = 0.5f - widthAspect;
                xMax = 0.5f + widthAspect;
            }
        }
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, VRShaders.BLIT_VR_PIPELINE.getVertexFormat());
        float xMinPos = (float)left / (float)ShaderHelper.MC.getMainRenderTarget().viewWidth * 2.0f - 1.0f;
        float yMinPos = (float)top / (float)ShaderHelper.MC.getMainRenderTarget().viewHeight * 2.0f - 1.0f;
        float xMaxPos = xMinPos + (float)width / (float)ShaderHelper.MC.getMainRenderTarget().viewWidth * 2.0f;
        float yMaxPos = yMinPos + (float)height / (float)ShaderHelper.MC.getMainRenderTarget().viewHeight * 2.0f;
        bufferBuilder.addVertex(xMinPos, yMinPos, 0.0f).setUv(xMin, yMin);
        bufferBuilder.addVertex(xMaxPos, yMinPos, 0.0f).setUv(xMax, yMin);
        bufferBuilder.addVertex(xMaxPos, yMaxPos, 0.0f).setUv(xMax, yMax);
        bufferBuilder.addVertex(xMinPos, yMaxPos, 0.0f).setUv(xMin, yMax);
        try (MeshData meshData = bufferBuilder.buildOrThrow();){
            VertexFormat.IndexType indexType;
            GpuBuffer indexBuffer;
            GpuBuffer gpuBuffer = VRShaders.BLIT_VR_PIPELINE.getVertexFormat().uploadImmediateVertexBuffer(meshData.vertexBuffer());
            if (meshData.indexBuffer() == null) {
                RenderSystem.AutoStorageIndexBuffer autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
                indexBuffer = autoStorageIndexBuffer.getBuffer(6);
                indexType = autoStorageIndexBuffer.type();
            } else {
                indexBuffer = VRShaders.BLIT_VR_PIPELINE.getVertexFormat().uploadImmediateIndexBuffer(meshData.indexBuffer());
                indexType = meshData.drawState().indexType();
            }
            try (com.mojang.blaze3d.systems.RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Vive Blit", MC.getMainRenderTarget().getColorTextureView(), OptionalInt.empty());){
                renderPass.setPipeline(VRShaders.BLIT_VR_PIPELINE);
                renderPass.setVertexBuffer(0, gpuBuffer);
                renderPass.bindSampler("DiffuseSampler", source.getColorTextureView());
                renderPass.setIndexBuffer(indexBuffer, indexType);
                renderPass.drawIndexed(0, 0, 6, 1);
            }
        }
    }
}

