/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import org.vivecraft.forge.XloaderImpl;

public interface Xloader {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ModLoader getModloader() {
        return XloaderImpl.getModloader();
    }

    public static boolean isModLoadedSuccess() {
        return Xloader.isModLoaded("vivecraft");
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String name) {
        return XloaderImpl.isModLoaded(name);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getModVersion() {
        return XloaderImpl.getModVersion();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigPath(String file) {
        return XloaderImpl.getConfigPath(file);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getJarPath() {
        return XloaderImpl.getJarPath();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDedicatedServer() {
        return XloaderImpl.isDedicatedServer();
    }

    public static enum ModLoader {
        FABRIC("fabric"),
        FORGE("forge"),
        NEOFORGE("neoforge"),
        QUILT("quilt");

        public final String name;

        private ModLoader(String name) {
            this.name = name;
        }
    }
}

