/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.client.render.VRPlayerModel_WithArms;
import org.vivecraft.client.render.models.FeetModel;
import org.vivecraft.client.utils.ModelUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.common.utils.MathUtils;

public class VRPlayerModel_WithArmsLegs<T extends LivingEntity>
extends VRPlayerModel_WithArms<T>
implements FeetModel {
    public static final int LOWER_EXTENSION = 2;
    public static final int UPPER_EXTENSION = 2;
    public ModelPart leftFoot;
    public ModelPart rightFoot;
    public ModelPart leftFootPants;
    public ModelPart rightFootPants;
    private final Vector3f footDir = new Vector3f();
    private final Vector3f footOffset = new Vector3f();
    private final Vector3f kneeOffset = new Vector3f();
    private final Vector3f footPos = new Vector3f();
    private final Vector3f kneePosTemp = new Vector3f();
    private final Quaternionf footQuat = new Quaternionf();

    public VRPlayerModel_WithArmsLegs(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.leftFoot = root.m_171324_("left_foot");
        this.rightFoot = root.m_171324_("right_foot");
        this.leftFootPants = root.m_171324_("left_foot_pants");
        this.rightFootPants = root.m_171324_("right_foot_pants");
        ModelUtils.textureHackUpper(this.f_102814_, this.leftFoot);
        ModelUtils.textureHackUpper(this.f_102813_, this.rightFoot);
        ModelUtils.textureHackUpper(this.f_103376_, this.rightFootPants);
        ModelUtils.textureHackUpper(this.f_103377_, this.leftFootPants);
    }

    public static MeshDefinition createMesh(CubeDeformation cubeDeformation, boolean slim) {
        MeshDefinition meshDefinition = VRPlayerModel_WithArms.createMesh(cubeDeformation, slim);
        PartDefinition partDefinition = meshDefinition.m_171576_();
        boolean connected = ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected;
        int upperExtension = connected ? 2 : 0;
        int lowerExtension = connected ? 2 : 0;
        float lowerShrinkage = connected ? -0.05f : 0.0f;
        partDefinition.m_171599_("left_foot", CubeListBuilder.m_171558_().m_171514_(16, 55 - lowerExtension).m_171488_(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.m_171469_(lowerShrinkage)), PartPose.m_171419_((float)1.9f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_("left_foot_pants", CubeListBuilder.m_171558_().m_171514_(0, 55 - lowerExtension).m_171488_(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.m_171469_(0.25f + lowerShrinkage)), PartPose.m_171419_((float)1.9f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_("right_foot", CubeListBuilder.m_171558_().m_171514_(0, 23 - lowerExtension).m_171488_(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.m_171469_(lowerShrinkage)), PartPose.m_171419_((float)-1.9f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_("right_foot_pants", CubeListBuilder.m_171558_().m_171514_(0, 39 - lowerExtension).m_171488_(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.m_171469_(0.25f + lowerShrinkage)), PartPose.m_171419_((float)-1.9f, (float)24.0f, (float)0.0f));
        partDefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        partDefinition.m_171599_("left_pants", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        partDefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        partDefinition.m_171599_("right_pants", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        return meshDefinition;
    }

    @Override
    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat(super.m_5608_(), (Iterable)ImmutableList.of((Object)this.leftFoot, (Object)this.rightFoot, (Object)this.leftFootPants, (Object)this.rightFootPants));
    }

    @Override
    public void m_6973_(T player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean noLegs;
        super.m_6973_(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.rotInfo == null) {
            return;
        }
        boolean bl = noLegs = this.f_102609_ || this.laying && (player.m_20069_() || this.rotInfo.fbtMode == FBTMode.ARMS_ONLY) || player.m_21255_();
        if (!noLegs) {
            Vector3f kneePos;
            if (ClientDataHolderVR.getInstance().vrSettings.playerWalkAnim) {
                float limbRotation = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
                this.footOffset.set(0.0f, -0.5f, 0.0f).rotateX(limbRotation).sub(0.0f, -0.5f, 0.0f).mul(1.0f, 0.75f, 1.0f).rotateY(-this.bodyYaw);
                this.kneeOffset.set(0.0f, -0.5f, 0.0f).rotateX(-Math.abs(limbRotation)).sub(0.0f, -0.5f, 0.0f).rotateY(-this.bodyYaw);
            } else {
                this.footOffset.zero();
                this.kneeOffset.zero();
            }
            if (this.rotInfo.fbtMode == FBTMode.ARMS_ONLY) {
                this.footPos.set(this.f_102814_.f_104200_, 24.0f + Math.min(this.f_102810_.f_104201_, 0.0f), this.f_102814_.f_104202_);
                ModelUtils.modelToWorld(player, (Vector3fc)this.footPos, this.rotInfo, this.bodyYaw, true, true, this.footPos);
                this.footQuat.identity().rotateY((float)Math.PI - this.bodyYaw);
                if (player.m_21209_()) {
                    this.footPos.y -= 1.0f;
                }
            } else {
                this.footPos.set(this.rotInfo.leftFootPos);
                this.footQuat.set(this.rotInfo.leftFootQuat);
            }
            if (this.rotInfo.fbtMode == FBTMode.WITH_JOINTS) {
                this.kneePosTemp.set(this.rotInfo.leftKneePos);
                this.kneePosTemp.add((Vector3fc)this.kneeOffset);
                kneePos = this.kneePosTemp;
            } else {
                kneePos = null;
            }
            this.footPos.add((Vector3fc)this.footOffset);
            if (ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected) {
                this.positionConnectedLimb((LivingEntity)player, this.f_102814_, this.leftFoot, (Vector3fc)this.footPos, (Quaternionfc)this.footQuat, 0.0f, (Vector3fc)kneePos, false, null, true);
            } else {
                this.footQuat.transform(MathUtils.BACK, this.footDir);
                this.positionSplitLimb((LivingEntity)player, this.f_102814_, this.leftFoot, (Vector3fc)this.footPos, (Quaternionfc)this.footQuat, -1.5707964f, 0.0f, (Vector3fc)kneePos, false, null, true);
            }
            if (this.rotInfo.fbtMode == FBTMode.ARMS_ONLY) {
                this.footPos.set(this.f_102813_.f_104200_, 24.0f + Math.min(this.f_102810_.f_104201_, 0.0f), this.f_102813_.f_104202_);
                ModelUtils.modelToWorld(player, (Vector3fc)this.footPos, this.rotInfo, this.bodyYaw, true, true, this.footPos);
                if (player.m_21209_()) {
                    this.footPos.y -= 1.0f;
                }
            } else {
                this.footPos.set(this.rotInfo.rightFootPos);
                this.footQuat.set(this.rotInfo.rightFootQuat);
            }
            if (this.rotInfo.fbtMode == FBTMode.WITH_JOINTS) {
                this.kneePosTemp.set(this.rotInfo.rightKneePos);
                this.kneePosTemp.add((Vector3fc)this.kneeOffset);
                kneePos = this.kneePosTemp;
            } else {
                kneePos = null;
            }
            this.footPos.add(-this.footOffset.x, this.footOffset.y, -this.footOffset.z);
            if (ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected) {
                this.positionConnectedLimb((LivingEntity)player, this.f_102813_, this.rightFoot, (Vector3fc)this.footPos, (Quaternionfc)this.footQuat, 0.0f, (Vector3fc)kneePos, false, null, true);
            } else {
                this.footQuat.transform(MathUtils.BACK, this.footDir);
                this.positionSplitLimb((LivingEntity)player, this.f_102813_, this.rightFoot, (Vector3fc)this.footPos, (Quaternionfc)this.footQuat, -1.5707964f, 0.0f, (Vector3fc)kneePos, false, null, true);
            }
        }
        if (this.layAmount > 0.0f) {
            ModelUtils.applySwimRotationOffset(player, this.xRot, this.tempV, this.tempV2, new ModelPart[]{this.f_102814_, this.f_102813_, this.leftFoot, this.rightFoot});
        }
        if (noLegs) {
            this.footQuat.rotationZYX(this.f_102814_.f_104205_, this.f_102814_.f_104204_, this.f_102814_.f_104203_);
            this.footQuat.transform(0.0f, 12.0f, 0.0f, this.tempV);
            this.leftFoot.m_104227_(this.f_102814_.f_104200_ + this.tempV.x, this.f_102814_.f_104201_ + this.tempV.y, this.f_102814_.f_104202_ + this.tempV.z);
            this.rightFoot.m_104227_(this.f_102813_.f_104200_ - this.tempV.x, this.f_102813_.f_104201_ + this.tempV.y, this.f_102813_.f_104202_ + (this.f_102609_ ? this.tempV.z : -this.tempV.z));
            this.leftFoot.m_171327_(this.f_102814_.f_104203_, this.f_102814_.f_104204_, this.f_102814_.f_104205_);
            this.rightFoot.m_171327_(this.f_102813_.f_104203_, this.f_102813_.f_104204_, this.f_102813_.f_104205_);
        }
        this.rightFoot.f_233553_ = this.rightFoot.f_233555_ = this.legScale;
        this.leftFoot.f_233555_ = this.rightFoot.f_233555_;
        this.leftFoot.f_233553_ = this.rightFoot.f_233555_;
        if (player.m_21209_()) {
            VRPlayerModel_WithArmsLegs.spinOffset(this.f_102814_, this.f_102813_, this.leftFoot, this.rightFoot);
        }
        this.f_103376_.m_104315_(this.f_102814_);
        this.f_103377_.m_104315_(this.f_102813_);
        this.leftFootPants.m_104315_(this.leftFoot);
        this.rightFootPants.m_104315_(this.rightFoot);
        this.leftFootPants.f_104207_ = this.f_103376_.f_104207_;
        this.rightFootPants.f_104207_ = this.f_103377_.f_104207_;
    }

    @Override
    public ModelPart getLeftFoot() {
        return this.leftFoot;
    }

    @Override
    public ModelPart getRightFoot() {
        return this.rightFoot;
    }

    @Override
    public void m_102872_(HumanoidModel<T> model) {
        super.m_102872_(model);
        if (model instanceof FeetModel) {
            FeetModel feetModel = (FeetModel)model;
            feetModel.getLeftFoot().m_104315_(this.leftFoot);
            feetModel.getRightFoot().m_104315_(this.rightFoot);
        }
    }

    @Override
    public void m_8009_(boolean visible) {
        super.m_8009_(visible);
        this.leftFoot.f_104207_ = visible;
        this.rightFoot.f_104207_ = visible;
        this.leftFootPants.f_104207_ = visible;
        this.rightFootPants.f_104207_ = visible;
    }
}

