/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.utils;

import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.ScaleHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.render.VRFirstPersonArmSwing;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.mca.MCAHelper;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;
import org.vivecraft.mod_compat_vr.sodium.SodiumHelper;

public class ModelUtils {
    public static void textureHack(ModelPart source, ModelPart target) {
        if (source.f_104212_.isEmpty()) {
            return;
        }
        ModelUtils.copyUV(((ModelPart.Cube)source.f_104212_.get((int)0)).f_104341_[1], ((ModelPart.Cube)target.f_104212_.get((int)0)).f_104341_[1]);
        ModelUtils.copyUV(((ModelPart.Cube)source.f_104212_.get((int)0)).f_104341_[1], ((ModelPart.Cube)target.f_104212_.get((int)0)).f_104341_[0]);
        if (SodiumHelper.isLoaded()) {
            SodiumHelper.copyModelCuboidUV(source, target, 3, 3);
            SodiumHelper.copyModelCuboidUV(source, target, 3, 2);
        }
    }

    public static void textureHackUpper(ModelPart source, ModelPart target) {
        if (source.f_104212_.isEmpty()) {
            return;
        }
        ModelUtils.copyUV(((ModelPart.Cube)source.f_104212_.get((int)0)).f_104341_[1], ((ModelPart.Cube)target.f_104212_.get((int)0)).f_104341_[1]);
        ModelUtils.copyUV(((ModelPart.Cube)source.f_104212_.get((int)0)).f_104341_[0], ((ModelPart.Cube)target.f_104212_.get((int)0)).f_104341_[0]);
        ModelUtils.copyUV(((ModelPart.Cube)source.f_104212_.get((int)0)).f_104341_[0], ((ModelPart.Cube)source.f_104212_.get((int)0)).f_104341_[1]);
        if (SodiumHelper.isLoaded()) {
            SodiumHelper.copyModelCuboidUV(source, target, 3, 3);
            SodiumHelper.copyModelCuboidUV(source, target, 2, 2);
            SodiumHelper.copyModelCuboidUV(source, source, 2, 3);
        }
    }

    private static void copyUV(ModelPart.Polygon source, ModelPart.Polygon target) {
        for (int i = 0; i < source.f_104359_.length; ++i) {
            ModelPart.Vertex newVertex = new ModelPart.Vertex(target.f_104359_[i].f_104371_, source.f_104359_[i].f_104372_, source.f_104359_[i].f_104373_);
            if (OptifineHelper.isOptifineLoaded()) {
                OptifineHelper.copyRenderPositions(target.f_104359_[i], newVertex);
            }
            target.f_104359_[i] = newVertex;
        }
    }

    public static float getBendProgress(LivingEntity entity, ClientVRPlayers.RotInfo rotInfo, Vector3fc headPivot) {
        if (entity.m_21209_()) {
            return 0.0f;
        }
        float eyeHeight = 1.42f * rotInfo.worldScale;
        float heightOffset = Mth.m_14036_((float)(headPivot.y() - eyeHeight * rotInfo.heightScale), (float)(-eyeHeight), (float)0.0f);
        float progress = heightOffset / -eyeHeight;
        if (entity.m_6047_()) {
            progress = Math.max(progress, 0.125f);
        }
        if (entity.m_20159_()) {
            progress = Math.min(progress, 0.5f);
        }
        return progress;
    }

    public static void worldToModel(LivingEntity player, Vector3fc position, ClientVRPlayers.RotInfo rotInfo, float bodyYaw, boolean useWorldScale, Vector3f out) {
        out.set(position);
        if (player.m_21209_()) {
            out.y += 1.0f;
        }
        if (useWorldScale) {
            out.div(rotInfo.worldScale);
        } else {
            out.div(ScaleHelper.getEntityEyeHeightScale(player, ClientUtils.getCurrentPartialTick()));
        }
        if (MCAHelper.isLoaded()) {
            MCAHelper.undoPlayerScale(player, out);
        }
        float scale = 0.9375f * rotInfo.heightScale;
        out.sub(0.0f, 1.501f * scale, 0.0f).rotateY((float)(-Math.PI) + bodyYaw).mul(16.0f / scale).mul(-1.0f, -1.0f, 1.0f);
    }

    public static void worldToModelDirection(Vector3fc direction, float bodyYaw, Vector3f out) {
        direction.rotateY((float)(-Math.PI) + bodyYaw, out);
        out.set(-out.x(), -out.y(), out.z());
    }

    public static void modelToWorldDirection(Vector3fc direction, float bodyYaw, Vector3f out) {
        out.set(-direction.x(), -direction.y(), direction.z()).rotateY((float)Math.PI - bodyYaw);
    }

    public static Vector3f modelToWorld(LivingEntity player, Vector3fc modelPosition, ClientVRPlayers.RotInfo rotInfo, float bodyYaw, boolean applyScale, boolean useWorldScale, Vector3f out) {
        return ModelUtils.modelToWorld(player, modelPosition.x(), modelPosition.y(), modelPosition.z(), rotInfo, bodyYaw, applyScale, useWorldScale, out);
    }

    public static Vector3f modelToWorld(LivingEntity player, float x, float y, float z, ClientVRPlayers.RotInfo rotInfo, float bodyYaw, boolean applyScale, boolean useWorldScale, Vector3f out) {
        float scale = 0.9375f * rotInfo.heightScale;
        out.set(-x, -y, z).mul(scale / 16.0f).rotateY((float)Math.PI - bodyYaw).add(0.0f, 1.501f * scale, 0.0f);
        if (MCAHelper.isLoaded()) {
            MCAHelper.applyPlayerScale(player, out);
        }
        if (applyScale) {
            if (useWorldScale) {
                out.mul(rotInfo.worldScale);
            } else {
                out.mul(ScaleHelper.getEntityEyeHeightScale(player, ClientUtils.getCurrentPartialTick()));
            }
        }
        return out;
    }

    public static void pointModelAtLocal(LivingEntity player, ModelPart part, Vector3fc target, Quaternionfc targetRot, ClientVRPlayers.RotInfo rotInfo, float bodyYaw, boolean useWorldScale, Vector3f tempVDir, Vector3f tempVUp, Matrix3f tempM) {
        ModelUtils.worldToModel(player, target, rotInfo, bodyYaw, useWorldScale, tempVDir);
        tempVDir.sub(part.f_104200_, part.f_104201_, part.f_104202_);
        targetRot.transform(MathUtils.RIGHT, tempVUp);
        ModelUtils.worldToModelDirection((Vector3fc)tempVUp, bodyYaw, tempVUp);
        tempVDir.cross((Vector3fc)tempVUp, tempVUp);
        ModelUtils.pointAtModel((Vector3fc)tempVDir, (Vector3fc)tempVUp, tempM);
    }

    public static void pointAtModelWithLocal(Quaternionfc targetRot, float bodyYaw, Vector3fc dir, Vector3f tempVUp, Matrix3f tempM) {
        targetRot.transform(MathUtils.RIGHT, tempVUp);
        ModelUtils.worldToModelDirection((Vector3fc)tempVUp, bodyYaw, tempVUp);
        dir.cross((Vector3fc)tempVUp, tempVUp);
        ModelUtils.pointAtModel(dir, (Vector3fc)tempVUp, tempM);
    }

    public static void pointModelAtModelForward(ModelPart part, float targetX, float targetY, float targetZ, Vector3f tempVDir, Vector3f tempVUp, Matrix3f tempM) {
        tempVDir.set(targetX - part.f_104200_, targetY - part.f_104201_, targetZ - part.f_104202_);
        tempVDir.cross(MathUtils.LEFT, tempVUp);
        ModelUtils.pointAtModel((Vector3fc)tempVDir, (Vector3fc)tempVUp, tempM);
    }

    public static void pointModelAtModelWithUp(ModelPart part, float targetX, float targetY, float targetZ, Vector3fc up, Vector3f tempVDir, Matrix3f tempM) {
        tempVDir.set(targetX - part.f_104200_, targetY - part.f_104201_, targetZ - part.f_104202_);
        ModelUtils.pointAtModel((Vector3fc)tempVDir, up, tempM);
    }

    public static void pointAtModel(Vector3fc dir, Vector3fc upDir, Matrix3f tempM) {
        tempM.setLookAlong(-dir.x(), -dir.y(), dir.z(), -upDir.x(), -upDir.y(), upDir.z()).transpose();
        tempM.rotateX(1.5707964f);
    }

    public static void toModelDir(float bodyYaw, Quaternionfc direction, Matrix3f tempM) {
        tempM.set(direction);
        tempM.rotateLocalY(bodyYaw + (float)Math.PI);
        tempM.rotateX(1.5707964f);
    }

    public static void setRotation(ModelPart part, Matrix3fc rotation, Vector3f tempV) {
        rotation.getEulerAnglesZYX(tempV);
        part.m_171327_(-tempV.x, Float.isNaN(tempV.y) ? 0.0f : -tempV.y, tempV.z);
    }

    public static void estimateJointDir(ModelPart upper, ModelPart lower, Quaternionfc lowerRot, float bodyYaw, boolean jointDown, @Nullable Vector3fc jointPos, LivingEntity player, ClientVRPlayers.RotInfo rotInfo, boolean useWorldScale, Vector3f tempV, Vector3f tempV2) {
        if (jointPos != null) {
            tempV.set(upper.f_104200_ + lower.f_104200_, upper.f_104201_ + lower.f_104201_, upper.f_104202_ + lower.f_104202_).mul(0.5f);
            ModelUtils.worldToModel(player, jointPos, rotInfo, bodyYaw, useWorldScale, tempV2);
            tempV2.sub((Vector3fc)tempV, tempV);
        } else {
            lowerRot.transform(0.0f, jointDown ? -1.0f : 1.0f, jointDown ? 1.0f : -1.0f, tempV);
            ModelUtils.worldToModelDirection((Vector3fc)tempV, bodyYaw, tempV);
        }
        tempV2.set(lower.f_104200_ - upper.f_104200_, lower.f_104201_ - upper.f_104201_, lower.f_104202_ - upper.f_104202_);
        float dot = tempV2.dot((Vector3fc)tempV) / tempV2.dot((Vector3fc)tempV2);
        tempV2.mul(dot);
        tempV.sub((Vector3fc)tempV2).normalize();
    }

    public static void estimateJoint(float startX, float startY, float startZ, float endX, float endY, float endZ, Vector3fc preferredDirection, float limbLength, Vector3f tempV) {
        tempV.set(startX, startY, startZ);
        float distance = tempV.distance(endX, endY, endZ);
        tempV.add(endX, endY, endZ).mul(0.5f);
        if (distance < limbLength) {
            float offsetDistance = (float)Math.sqrt((limbLength * limbLength - distance * distance) * 0.25f);
            tempV.add(preferredDirection.x() * offsetDistance, preferredDirection.y() * offsetDistance, preferredDirection.z() * offsetDistance);
        }
    }

    public static void swingAnimation(HumanoidArm arm, float attackTime, boolean isMainPlayer, Matrix3f tempM, Vector3f tempV) {
        tempV.zero();
        if (attackTime > 0.0f) {
            if (!isMainPlayer || ClientDataHolderVR.getInstance().swingType == VRFirstPersonArmSwing.ATTACK) {
                float rotation = attackTime > 0.5f ? Mth.m_14031_((float)(attackTime * (float)Math.PI + (float)Math.PI)) : Mth.m_14031_((float)(attackTime * 3.0f * (float)Math.PI));
                tempM.rotateX(rotation * 30.0f * ((float)Math.PI / 180));
            } else {
                switch (ClientDataHolderVR.getInstance().swingType) {
                    case USE: {
                        float movement = attackTime > 0.25f ? Mth.m_14031_((float)(attackTime * 1.5707964f + (float)Math.PI)) : Mth.m_14031_((float)(attackTime * ((float)Math.PI * 2)));
                        tempM.transform(MathUtils.DOWN, tempV).mul((1.0f + movement) * 1.6f);
                        break;
                    }
                    case INTERACT: {
                        float rotation = attackTime > 0.5f ? Mth.m_14031_((float)(attackTime * (float)Math.PI + (float)Math.PI)) : Mth.m_14031_((float)(attackTime * 3.0f * (float)Math.PI));
                        tempM.rotateY((arm == HumanoidArm.RIGHT ? -40.0f : 40.0f) * rotation * ((float)Math.PI / 180));
                    }
                }
            }
        }
    }

    public static void swingAnimation(ModelPart part, HumanoidArm arm, float offset, float attackTime, boolean isMainPlayer, Matrix3f tempM, Vector3f tempV, Vector3f tempV2) {
        if (attackTime > 0.0f) {
            tempM.transform(0.0f, offset, 0.0f, tempV2);
            ModelUtils.swingAnimation(arm, attackTime, isMainPlayer, tempM, tempV);
            part.f_104200_ -= tempV.x;
            part.f_104201_ -= tempV.y;
            part.f_104202_ += tempV.z;
            tempM.transform(0.0f, offset, 0.0f, tempV);
            part.f_104200_ += tempV2.x - tempV.x;
            part.f_104201_ += tempV2.y - tempV.y;
            part.f_104202_ -= tempV2.z - tempV.z;
        }
    }

    public static void applySwimRotationOffset(LivingEntity player, float xRot, Vector3f tempV, Vector3f tempV2, ModelPart ... parts) {
        float sin = Mth.m_14031_((float)xRot);
        float cos = Mth.m_14089_((float)xRot);
        if (player.m_6067_() && !player.m_21209_() && !player.m_21255_()) {
            tempV2.set(0.0f, 17.06125f, 5.125f);
            MathUtils.rotateX(tempV2, -sin, cos);
            tempV2.y += 2.0f;
        } else {
            tempV2.set(0.0f, 0.0f, 0.0f);
        }
        for (ModelPart part : parts) {
            tempV.set(part.f_104200_, part.f_104201_, part.f_104202_);
            tempV.sub((Vector3fc)tempV2);
            tempV.y -= 24.0f;
            MathUtils.rotateX(tempV, sin, cos);
            tempV.y += 24.0f;
            part.m_104227_(tempV.x, tempV.y, tempV.z);
        }
    }
}

