/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.api.data.VRBodyPartData;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.client.gui.screens.FBTCalibrationScreen;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.api_impl.data.VRBodyPartDataImpl;
import org.vivecraft.common.api_impl.data.VRPoseImpl;
import org.vivecraft.common.utils.MathUtils;

public class VRData {
    public VRDevicePose hmd;
    public VRDevicePose center;
    public VRDevicePose eye0;
    public VRDevicePose eye1;
    public VRDevicePose c0;
    public VRDevicePose c1;
    public VRDevicePose c2;
    public VRDevicePose h0;
    public VRDevicePose h1;
    public VRDevicePose t0;
    public VRDevicePose t1;
    public VRDevicePose cam;
    public VRDevicePose waist;
    public VRDevicePose foot_left;
    public VRDevicePose foot_right;
    public VRDevicePose knee_left;
    public VRDevicePose knee_right;
    public VRDevicePose elbow_left;
    public VRDevicePose elbow_right;
    public FBTMode fbtMode = FBTMode.ARMS_ONLY;
    public Vec3 origin;
    public float rotation_radians;
    public float worldScale;
    private VRPose vrPose;

    public VRData(Vec3 origin, float walkMul, float worldScale, float rotation) {
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        MCVR mcVR = dataHolder.vr;
        this.origin = origin;
        this.worldScale = worldScale;
        this.rotation_radians = rotation;
        Vector3f hmd_raw = mcVR.getEyePosition(RenderPass.CENTER);
        Vector3f scaledPos = new Vector3f(hmd_raw.x * walkMul, hmd_raw.y, hmd_raw.z * walkMul);
        Vector3f scaleOffset = new Vector3f(scaledPos.x - hmd_raw.x, 0.0f, scaledPos.z - hmd_raw.z);
        this.hmd = new VRDevicePose(this, (Matrix4fc)mcVR.hmdRotation, (Vector3fc)scaledPos, (Vector3fc)mcVR.getHmdVector());
        float smoothing = dataHolder.vrSettings.displayMirrorCenterSmooth;
        if (smoothing > 0.0f && (dataHolder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.FIRST_PERSON || dataHolder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY && dataHolder.vrSettings.mixedRealityUndistorted)) {
            Matrix4f smoothedRotation = new Matrix4f().rotation(mcVR.hmdRotHistory.averageRotation(smoothing)).rotateY(this.rotation_radians).transpose();
            this.center = new VRDevicePose(this, (Matrix4fc)smoothedRotation, (Vector3fc)mcVR.hmdHistory.averagePosition(smoothing).add((Vector3fc)scaleOffset), (Vector3fc)smoothedRotation.transformDirection(MathUtils.BACK, new Vector3f()));
        } else {
            this.center = this.hmd;
        }
        this.eye0 = new VRDevicePose(this, mcVR.getEyeRotation(RenderPass.LEFT), (Vector3fc)mcVR.getEyePosition(RenderPass.LEFT).add((Vector3fc)scaleOffset), (Vector3fc)mcVR.getHmdVector());
        this.eye1 = new VRDevicePose(this, mcVR.getEyeRotation(RenderPass.RIGHT), (Vector3fc)mcVR.getEyePosition(RenderPass.RIGHT).add((Vector3fc)scaleOffset), (Vector3fc)mcVR.getHmdVector());
        Vector3f mainAimSource = mcVR.getAimSource(0).add((Vector3fc)scaleOffset, new Vector3f());
        Vector3f offAimSource = mcVR.getAimSource(1).add((Vector3fc)scaleOffset, new Vector3f());
        this.c0 = new VRDevicePose(this, mcVR.getAimRotation(0), (Vector3fc)mainAimSource, (Vector3fc)mcVR.getAimVector(0));
        this.c1 = new VRDevicePose(this, mcVR.getAimRotation(1), (Vector3fc)offAimSource, (Vector3fc)mcVR.getAimVector(1));
        this.h0 = new VRDevicePose(this, mcVR.getHandRotation(0), (Vector3fc)mainAimSource, (Vector3fc)mcVR.getHandVector(0));
        this.h1 = new VRDevicePose(this, mcVR.getHandRotation(1), (Vector3fc)offAimSource, (Vector3fc)mcVR.getHandVector(1));
        if (dataHolder.vrSettings.seated) {
            this.t0 = this.eye0;
            this.t1 = this.eye1;
        } else {
            Matrix4f scopeMain = this.getSmoothedRotation(0, 0.2f);
            Matrix4f scopeOff = this.getSmoothedRotation(1, 0.2f);
            this.t0 = new VRDevicePose(this, (Matrix4fc)scopeMain, (Vector3fc)mainAimSource, (Vector3fc)scopeMain.transformDirection(MathUtils.BACK, new Vector3f()));
            this.t1 = new VRDevicePose(this, (Matrix4fc)scopeOff, (Vector3fc)offAimSource, (Vector3fc)scopeOff.transformDirection(MathUtils.BACK, new Vector3f()));
        }
        Matrix4f camRot = new Matrix4f().rotationY(-rotation).mul((Matrix4fc)dataHolder.cameraTracker.getRotation().get(new Matrix4f()));
        this.cam = new VRDevicePose(this, (Matrix4fc)camRot, (Vector3fc)dataHolder.cameraTracker.getRoomPosition(origin).rotateY(-rotation).div(worldScale).add((Vector3fc)scaleOffset), (Vector3fc)camRot.transformDirection(MathUtils.BACK, new Vector3f()));
        if (mcVR.mrMovingCamActive) {
            this.c2 = new VRDevicePose(this, mcVR.getAimRotation(2), (Vector3fc)mcVR.getAimSource(2).add((Vector3fc)scaleOffset, new Vector3f()), (Vector3fc)mcVR.getAimVector(2));
        } else {
            VRSettings vrsettings = dataHolder.vrSettings;
            Matrix4f rot = vrsettings.vrFixedCamrotQuat.get(new Matrix4f());
            Vector3f pos = new Vector3f((Vector3fc)vrsettings.vrFixedCampos);
            Vector3f dir = rot.transformDirection(MathUtils.BACK, new Vector3f());
            this.c2 = new VRDevicePose(this, (Matrix4fc)rot, (Vector3fc)pos.add((Vector3fc)scaleOffset), (Vector3fc)dir);
        }
        if (mcVR.hasFBT() && dataHolder.vrSettings.fbtCalibrated && !(Minecraft.m_91087_().f_91080_ instanceof FBTCalibrationScreen)) {
            this.fbtMode = FBTMode.ARMS_LEGS;
            this.waist = new VRDevicePose(this, mcVR.getAimRotation(3), (Vector3fc)mcVR.getAimSource(3).add((Vector3fc)scaleOffset, new Vector3f()), (Vector3fc)mcVR.getAimVector(3));
            this.foot_left = new VRDevicePose(this, mcVR.getAimRotation(5), (Vector3fc)mcVR.getAimSource(5).add((Vector3fc)scaleOffset, new Vector3f()), (Vector3fc)mcVR.getAimVector(5));
            this.foot_right = new VRDevicePose(this, mcVR.getAimRotation(4), (Vector3fc)mcVR.getAimSource(4).add((Vector3fc)scaleOffset, new Vector3f()), (Vector3fc)mcVR.getAimVector(4));
            if (mcVR.hasExtendedFBT() && dataHolder.vrSettings.fbtExtendedCalibrated) {
                this.fbtMode = FBTMode.WITH_JOINTS;
                this.knee_left = new VRDevicePose(this, mcVR.getAimRotation(9), (Vector3fc)mcVR.getAimSource(9).add((Vector3fc)scaleOffset, new Vector3f()), (Vector3fc)mcVR.getAimVector(9));
                this.knee_right = new VRDevicePose(this, mcVR.getAimRotation(8), (Vector3fc)mcVR.getAimSource(8).add((Vector3fc)scaleOffset, new Vector3f()), (Vector3fc)mcVR.getAimVector(8));
                this.elbow_left = new VRDevicePose(this, mcVR.getAimRotation(7), (Vector3fc)mcVR.getAimSource(7).add((Vector3fc)scaleOffset, new Vector3f()), (Vector3fc)mcVR.getAimVector(7));
                this.elbow_right = new VRDevicePose(this, mcVR.getAimRotation(6), (Vector3fc)mcVR.getAimSource(6).add((Vector3fc)scaleOffset, new Vector3f()), (Vector3fc)mcVR.getAimVector(6));
            }
        }
    }

    private Matrix4f getSmoothedRotation(int c, float lenSec) {
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        Vector3f forward = dataHolder.vr.controllerForwardHistory[c].averagePosition(lenSec);
        Vector3f up = dataHolder.vr.controllerUpHistory[c].averagePosition(lenSec);
        Vector3f right = forward.cross((Vector3fc)up, new Vector3f());
        return new Matrix4f((Matrix3fc)new Matrix3f((Vector3fc)right, (Vector3fc)forward, (Vector3fc)up));
    }

    public VRDevicePose getController(int c) {
        return c == 1 ? this.c1 : (c == 2 ? this.c2 : this.c0);
    }

    @Nullable
    public VRDevicePose getHand(int c) {
        return c > 1 ? this.getDevice(c) : (c == 0 ? this.h0 : this.h1);
    }

    @Nullable
    public VRDevicePose getDevice(int d) {
        return switch (d) {
            case 1 -> this.c1;
            case 2 -> this.c2;
            case 3 -> this.waist;
            case 5 -> this.foot_left;
            case 4 -> this.foot_right;
            case 9 -> this.knee_left;
            case 8 -> this.knee_right;
            case 7 -> this.elbow_left;
            case 6 -> this.elbow_right;
            default -> this.c0;
        };
    }

    @Nullable
    public VRDevicePose getBodyPart(VRBodyPart bodyPart) {
        return switch (bodyPart) {
            default -> throw new IncompatibleClassChangeError();
            case VRBodyPart.MAIN_HAND -> this.c0;
            case VRBodyPart.OFF_HAND -> this.c1;
            case VRBodyPart.WAIST -> this.waist;
            case VRBodyPart.LEFT_FOOT -> this.foot_left;
            case VRBodyPart.RIGHT_FOOT -> this.foot_right;
            case VRBodyPart.LEFT_KNEE -> this.knee_left;
            case VRBodyPart.RIGHT_KNEE -> this.knee_right;
            case VRBodyPart.LEFT_ELBOW -> this.elbow_left;
            case VRBodyPart.RIGHT_ELBOW -> this.elbow_right;
            case VRBodyPart.HEAD -> this.hmd;
        };
    }

    public VRDevicePose getAim() {
        return switch (ClientDataHolderVR.getInstance().vrSettings.aimDevice) {
            default -> throw new IncompatibleClassChangeError();
            case VRSettings.AimDevice.CONTROLLER -> this.c0;
            case VRSettings.AimDevice.HMD -> this.hmd;
        };
    }

    public float getBodyYaw() {
        return 57.295776f * this.getBodyYawRad();
    }

    public float getBodyYawRad() {
        if (ClientDataHolderVR.getInstance().vrSettings.seated) {
            return this.hmd.getYawRad();
        }
        if (this.fbtMode != FBTMode.ARMS_ONLY) {
            Vector3f dir = this.waist.getDirection().lerp((Vector3fc)this.hmd.getDirection(), 0.5f);
            return (float)Math.atan2(-dir.x, dir.z);
        }
        if (!ClientDataHolderVR.getInstance().vr.isControllerTracking(0) || !ClientDataHolderVR.getInstance().vr.isControllerTracking(1)) {
            return this.hmd.getYawRad();
        }
        Vec3 headPos = this.hmd.getPosition();
        Vector3f c1Pos = MathUtils.subtractToVector3f(this.c1.getPosition(), headPos);
        Vector3f c0Pos = MathUtils.subtractToVector3f(this.c0.getPosition(), headPos);
        Vector3f head = this.hmd.getDirection();
        return MathUtils.bodyYawRad((Vector3fc)c0Pos, (Vector3fc)c1Pos, (Vector3fc)head);
    }

    public float getFacingYaw() {
        return 57.295776f * this.getFacingYawRad();
    }

    public float getFacingYawRad() {
        if (ClientDataHolderVR.getInstance().vrSettings.seated) {
            return this.hmd.getYawRad();
        }
        Vector3f arms = MathUtils.subtractToVector3f(this.c1.getPosition(), this.c0.getPosition()).normalize().rotateY(-1.5707964f);
        if (ClientDataHolderVR.getInstance().vrSettings.reverseHands) {
            return (float)Math.atan2(arms.x, -arms.z);
        }
        return (float)Math.atan2(-arms.x, arms.z);
    }

    private Vector3f getHeadPivotOffset() {
        return this.hmd.getMatrix().transformPosition(new Vector3f(0.0f, -0.1f * this.worldScale, 0.1f * this.worldScale));
    }

    public Vec3 getHeadPivot() {
        Vector3f headPivotOffset = this.getHeadPivotOffset();
        return this.hmd.getPosition().m_82520_((double)headPivotOffset.x, (double)headPivotOffset.y, (double)headPivotOffset.z);
    }

    public Vector3f getHeadPivotF() {
        return this.hmd.getPositionF().add((Vector3fc)this.getHeadPivotOffset());
    }

    public Vec3 getNewHeadPivot(Vec3 newOrigin, float newWorldScale) {
        Vec3 newEye = this.hmd.getPosition().m_82546_(this.origin).m_82549_(newOrigin);
        Vector3f headPivotOffset = this.hmd.getMatrix().transformPosition(new Vector3f(0.0f, -0.1f * newWorldScale, 0.1f * newWorldScale));
        return newEye.m_82520_((double)headPivotOffset.x, (double)headPivotOffset.y, (double)headPivotOffset.z);
    }

    public Vec3 getHeadRear() {
        Vec3 eye = this.hmd.getPosition();
        Vector3f headBackOffset = this.hmd.getMatrix().transformPosition(new Vector3f(0.0f, -0.2f * this.worldScale, 0.2f * this.worldScale));
        return eye.m_82520_((double)headBackOffset.x, (double)headBackOffset.y, (double)headBackOffset.z);
    }

    public VRDevicePose getEye(RenderPass pass) {
        return switch (pass) {
            case RenderPass.CENTER -> this.center;
            case RenderPass.LEFT -> this.eye0;
            case RenderPass.RIGHT -> this.eye1;
            case RenderPass.THIRD -> this.c2;
            case RenderPass.SCOPER -> this.t0;
            case RenderPass.SCOPEL -> this.t1;
            case RenderPass.CAMERA -> this.cam;
            default -> this.hmd;
        };
    }

    public VRPose asVRPose() {
        if (this.vrPose == null) {
            this.vrPose = new VRPoseImpl(this.hmd.asVRBodyPart(), this.c0.asVRBodyPart(), this.c1.asVRBodyPart(), VRData.getDataIfAvailable(this.foot_right, this.fbtMode.bodyPartAvailable(VRBodyPart.RIGHT_FOOT)), VRData.getDataIfAvailable(this.foot_left, this.fbtMode.bodyPartAvailable(VRBodyPart.LEFT_FOOT)), VRData.getDataIfAvailable(this.waist, this.fbtMode.bodyPartAvailable(VRBodyPart.WAIST)), VRData.getDataIfAvailable(this.knee_right, this.fbtMode.bodyPartAvailable(VRBodyPart.RIGHT_KNEE)), VRData.getDataIfAvailable(this.knee_left, this.fbtMode.bodyPartAvailable(VRBodyPart.LEFT_KNEE)), VRData.getDataIfAvailable(this.elbow_right, this.fbtMode.bodyPartAvailable(VRBodyPart.RIGHT_ELBOW)), VRData.getDataIfAvailable(this.elbow_left, this.fbtMode.bodyPartAvailable(VRBodyPart.LEFT_ELBOW)), ClientDataHolderVR.getInstance().vrSettings.seated, ClientDataHolderVR.getInstance().vrSettings.reverseHands, this.fbtMode);
        }
        return this.vrPose;
    }

    @Nullable
    private static VRBodyPartData getDataIfAvailable(VRDevicePose pose, boolean partAvailable) {
        return partAvailable ? pose.asVRBodyPart() : null;
    }

    public String toString() {
        return "VRData:\n    origin: %s\n    rotation: %.2f\n    scale: %.2f\n    hmd: %s\n    c0: %s\n    c1: %s\n    c2: %s\n".formatted(this.origin, Float.valueOf(this.rotation_radians), Float.valueOf(this.worldScale), this.hmd, this.c0, this.c1, this.c2);
    }

    public class VRDevicePose {
        private final VRData data;
        private final Vector3fc pos;
        private final Vector3fc dir;
        private final Matrix4fc matrix;

        public VRDevicePose(VRData data, Matrix4fc matrix, Vector3fc pos, Vector3fc dir) {
            this.data = data;
            this.matrix = new Matrix4f(matrix);
            this.pos = pos;
            this.dir = dir;
        }

        public Vec3 getPosition() {
            Vector3f localPos = this.pos.mul(VRData.this.worldScale, new Vector3f()).rotateY(this.data.rotation_radians);
            return this.data.origin.m_82520_((double)localPos.x, (double)localPos.y, (double)localPos.z);
        }

        public Vector3f getPositionF() {
            Vector3f localPos = this.pos.mul(VRData.this.worldScale, new Vector3f()).rotateY(this.data.rotation_radians);
            return localPos.add((float)this.data.origin.f_82479_, (float)this.data.origin.f_82480_, (float)this.data.origin.f_82481_);
        }

        public Vector3f getScalePositionOffset(float newWorldScale) {
            Vector3f oldPos = this.pos.mul(VRData.this.worldScale, new Vector3f()).rotateY(this.data.rotation_radians);
            Vector3f newPos = this.pos.mul(newWorldScale, new Vector3f()).rotateY(this.data.rotation_radians);
            return newPos.sub((Vector3fc)oldPos);
        }

        public Vector3f getDirection() {
            return this.dir.rotateY(this.data.rotation_radians, new Vector3f());
        }

        public Vector3f getCustomVector(Vector3fc axis) {
            return this.matrix.transformDirection(axis, new Vector3f()).rotateY(this.data.rotation_radians);
        }

        public float getYaw() {
            return 57.295776f * this.getYawRad();
        }

        public float getYawRad() {
            Vector3f dir = this.getDirection();
            return (float)Math.atan2(-dir.x, dir.z);
        }

        public float getPitch() {
            return 57.295776f * this.getPitchRad();
        }

        public float getPitchRad() {
            Vector3f dir = this.getDirection();
            return (float)Math.asin(dir.y / dir.length());
        }

        public float getRoll() {
            return 57.295776f * this.getRollRad();
        }

        public float getRollRad() {
            return (float)(-Math.atan2(this.matrix.m01(), this.matrix.m11()));
        }

        public Matrix4f getMatrix() {
            return new Matrix4f().rotationY(VRData.this.rotation_radians).mul(this.matrix);
        }

        public VRBodyPartData asVRBodyPart() {
            return new VRBodyPartDataImpl(this.getPosition(), new Vec3(this.getDirection()), (Quaternionfc)new Quaternionf().setFromUnnormalized((Matrix4fc)this.getMatrix()));
        }

        public String toString() {
            return "Device: pos:" + this.getPosition() + ", dir: " + this.getDirection();
        }
    }
}

