/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.api_impl.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.api.data.VRBodyPartData;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.api.data.VRPoseHistory;
import org.vivecraft.common.api_impl.data.VRPoseImpl;

public class VRPoseHistoryImpl
implements VRPoseHistory {
    private final LinkedList<PoseData> dataQueue = new LinkedList();

    public void addPose(VRPose pose, Vec3 playerPos) {
        this.dataQueue.addFirst(new PoseData(pose, playerPos));
        if (this.dataQueue.size() > 201) {
            this.dataQueue.removeLast();
        }
    }

    public void clear() {
        this.dataQueue.clear();
    }

    public boolean isEmpty() {
        return this.dataQueue.isEmpty();
    }

    @Override
    public int ticksOfHistory() {
        return this.dataQueue.size() - 1;
    }

    @Override
    public List<VRPose> getAllHistoricalData() {
        return this.dataQueue.stream().map(PoseData::pose).toList();
    }

    @Override
    public VRPose getHistoricalData(int ticksBack, boolean playerPositionRelative) throws IllegalArgumentException {
        this.checkTicksBack(ticksBack);
        if (this.dataQueue.size() <= ticksBack) {
            return null;
        }
        return this.dataQueue.get(ticksBack).getPose(playerPositionRelative);
    }

    @Override
    public Vec3 netMovement(VRBodyPart bodyPart, int maxTicksBack, boolean playerPositionRelative) throws IllegalArgumentException {
        this.checkPartNonNull(bodyPart);
        this.checkTicksBack(maxTicksBack);
        if (this.dataQueue.size() <= 1) {
            return Vec3.f_82478_;
        }
        Vec3 current = this.dataQueue.getFirst().getPos(bodyPart, playerPositionRelative);
        if (current == null) {
            return null;
        }
        Vec3 old = this.dataQueue.get(maxTicksBack).getPos(bodyPart, playerPositionRelative);
        if (old == null) {
            return null;
        }
        return current.m_82546_(old);
    }

    @Override
    public Vec3 averageVelocity(VRBodyPart bodyPart, int maxTicksBack, boolean playerPositionRelative) throws IllegalArgumentException {
        this.checkPartNonNull(bodyPart);
        this.checkTicksBack(maxTicksBack);
        if (this.dataQueue.size() <= 1) {
            return Vec3.f_82478_;
        }
        maxTicksBack = this.getNumTicksBack(maxTicksBack);
        ArrayList<Vec3> diffs = new ArrayList<Vec3>(maxTicksBack);
        for (int i = 0; i < maxTicksBack; ++i) {
            Vec3 newer = this.dataQueue.get(i).getPos(bodyPart, playerPositionRelative);
            Vec3 older = this.dataQueue.get(i + 1).getPos(bodyPart, playerPositionRelative);
            if (newer == null || older == null) break;
            diffs.add(newer.m_82546_(older));
        }
        if (diffs.isEmpty()) {
            return this.dataQueue.getFirst().pose.getBodyPartData(bodyPart) != null ? Vec3.f_82478_ : null;
        }
        return new Vec3(diffs.stream().mapToDouble(vec -> vec.f_82479_).average().orElse(0.0), diffs.stream().mapToDouble(vec -> vec.f_82480_).average().orElse(0.0), diffs.stream().mapToDouble(vec -> vec.f_82481_).average().orElse(0.0));
    }

    @Override
    public double averageSpeed(VRBodyPart bodyPart, int maxTicksBack, boolean playerPositionRelative) throws IllegalArgumentException {
        this.checkPartNonNull(bodyPart);
        this.checkTicksBack(maxTicksBack);
        if (this.dataQueue.size() <= 1) {
            return 0.0;
        }
        maxTicksBack = this.getNumTicksBack(maxTicksBack);
        ArrayList<Double> speeds = new ArrayList<Double>(maxTicksBack);
        for (int i = 0; i < maxTicksBack; ++i) {
            Vec3 newer = this.dataQueue.get(i).getPos(bodyPart, playerPositionRelative);
            Vec3 older = this.dataQueue.get(i + 1).getPos(bodyPart, playerPositionRelative);
            if (newer == null || older == null) break;
            speeds.add(newer.m_82554_(older));
        }
        return speeds.stream().mapToDouble(Double::valueOf).average().orElse(0.0);
    }

    @Override
    public Vec3 averagePosition(VRBodyPart bodyPart, int maxTicksBack, boolean playerPositionRelative) throws IllegalArgumentException {
        PoseData poseData;
        Vec3 pos;
        this.checkPartNonNull(bodyPart);
        this.checkTicksBack(maxTicksBack);
        if (this.dataQueue.isEmpty()) {
            return null;
        }
        maxTicksBack = this.getNumTicksBack(maxTicksBack);
        ArrayList<Vec3> positions = new ArrayList<Vec3>(maxTicksBack);
        int i = 0;
        Iterator iterator = this.dataQueue.iterator();
        while (iterator.hasNext() && (pos = (poseData = (PoseData)iterator.next()).getPos(bodyPart, playerPositionRelative)) != null) {
            positions.add(pos);
            if (++i < maxTicksBack) continue;
            break;
        }
        if (positions.isEmpty()) {
            return null;
        }
        return new Vec3(positions.stream().mapToDouble(vec -> vec.f_82479_).average().orElse(0.0), positions.stream().mapToDouble(vec -> vec.f_82480_).average().orElse(0.0), positions.stream().mapToDouble(vec -> vec.f_82481_).average().orElse(0.0));
    }

    private void checkTicksBack(int ticksBack) {
        if (ticksBack < 0 || ticksBack > 200) {
            throw new IllegalArgumentException("Value must be between 0 and 200.");
        }
    }

    private void checkPartNonNull(VRBodyPart bodyPart) {
        if (bodyPart == null) {
            throw new IllegalArgumentException("Cannot get data for a null body part!");
        }
    }

    private int getNumTicksBack(int maxTicksBack) {
        if (this.dataQueue.size() <= maxTicksBack) {
            return this.dataQueue.size() - 1;
        }
        return maxTicksBack;
    }

    private record PoseData(VRPose pose, Vec3 playerPosition) {
        @Nullable
        public Vec3 getPos(VRBodyPart vrBodyPart, boolean playerPositionRelative) {
            VRBodyPartData vrBodyPartData = this.pose.getBodyPartData(vrBodyPart);
            if (vrBodyPartData == null) {
                return null;
            }
            if (playerPositionRelative) {
                return vrBodyPartData.getPos().m_82546_(this.playerPosition);
            }
            return vrBodyPartData.getPos();
        }

        public VRPose getPose(boolean playerPositionRelative) {
            if (playerPositionRelative) {
                return ((VRPoseImpl)this.pose).relativeToPosition(this.playerPosition);
            }
            return this.pose;
        }
    }
}

