/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.multiplayer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPacketListenerVRMixin {
    @Unique
    private String vivecraft$lastMsg = null;
    @Final
    @Shadow
    private Minecraft f_104888_;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void vivecraft$init(CallbackInfo ci) {
        if (ClientNetworking.NEEDS_RESET) {
            ClientNetworking.resetServerSettings();
            ClientNetworking.resetOnceServerSettings();
            ClientNetworking.NEEDS_RESET = false;
        }
    }

    @Inject(method={"handleLogin"}, at={@At(value="TAIL")})
    private void vivecraft$resetOnLogin(CallbackInfo ci) {
        this.vivecraft$resetServerState();
    }

    @Inject(method={"handleRespawn"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setLevel(Lnet/minecraft/client/multiplayer/ClientLevel;)V", shift=At.Shift.AFTER)})
    private void vivecraft$resetOnDimensionChange(CallbackInfo ci) {
        this.vivecraft$resetServerState();
    }

    @Unique
    private void vivecraft$resetServerState() {
        ClientNetworking.resetServerSettings();
        ClientNetworking.sendVersionInfo();
        ClientNetworking.CHAT_WARNING_TIMER = 200;
        ClientNetworking.ABLE_TO_DISPLAY_CHAT_WARNINGS = false;
        ClientNetworking.TELEPORT_WARNING = true;
        ClientNetworking.VR_SWITCHING_WARNING = false;
        ClientNetworking.HEAD_AIM_WARNING = false;
        ClientNetworking.REQUESTED_DAMAGE_DIRECTION = false;
    }

    @Inject(method={"close"}, at={@At(value="TAIL")})
    private void vivecraft$cleanup(CallbackInfo ci) {
        ClientNetworking.resetServerSettings();
        ClientNetworking.resetOnceServerSettings();
        ClientNetworking.NEEDS_RESET = true;
    }

    @Inject(method={"sendChat"}, at={@At(value="TAIL")})
    private void vivecraft$storeChatMsg(String message, CallbackInfo ci) {
        this.vivecraft$lastMsg = message;
    }

    @Inject(method={"sendCommand"}, at={@At(value="TAIL")})
    private void vivecraft$storeCommandMsg(String command, CallbackInfo ci) {
        this.vivecraft$lastMsg = command;
    }

    @Inject(method={"handlePlayerChat"}, at={@At(value="TAIL")})
    private void vivecraft$chatHapticsPlayer(ClientboundPlayerChatPacket packet, CallbackInfo ci) {
        if (VRState.VR_RUNNING && (this.f_104888_.f_91074_ == null || this.vivecraft$lastMsg == null || packet.f_243918_() == this.f_104888_.f_91074_.m_20148_())) {
            ClientUtils.triggerChatHapticSound();
        }
        this.vivecraft$lastMsg = null;
    }

    @Inject(method={"handleSystemChat"}, at={@At(value="TAIL")})
    private void vivecraft$chatHapticsSystem(ClientboundSystemChatPacket packet, CallbackInfo ci) {
        if (VRState.VR_RUNNING && (this.f_104888_.f_91074_ == null || this.vivecraft$lastMsg == null || packet.f_237849_().getString().contains(this.vivecraft$lastMsg))) {
            ClientUtils.triggerChatHapticSound();
        }
        this.vivecraft$lastMsg = null;
    }

    @Inject(method={"handleOpenScreen"}, at={@At(value="HEAD")})
    private void vivecraft$markScreenActive(CallbackInfo ci) {
        GuiHandler.GUI_APPEAR_OVER_BLOCK_ACTIVE = true;
    }

    @Inject(at={@At(value="TAIL")}, method={"handleExplosion"})
    public void vivecraft$handleExplosion(ClientboundExplodePacket clientboundExplodePacket, CallbackInfo ci) {
        if (VRState.VR_INITIALIZED) {
            ClientDataHolderVR.getInstance().hapticTracker.handleExplode(new Vec3(clientboundExplodePacket.m_132132_(), clientboundExplodePacket.m_132133_(), clientboundExplodePacket.m_132134_()));
        }
    }
}

