/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.world.entity.projectile;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.common.utils.Utils;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ServerConfig;
import org.vivecraft.server.config.enums.HeadshotIndicator;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
extends Entity {
    @Shadow
    private double f_36698_;

    public AbstractArrowMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="RETURN")})
    private void vivecraft$startPos(CallbackInfo ci, @Local(argsOnly=true) LivingEntity owner) {
        ServerPlayer player;
        ServerVivePlayer serverVivePlayer;
        if (owner instanceof ServerPlayer && (serverVivePlayer = ServerVRPlayers.getVivePlayer(player = (ServerPlayer)owner)) != null && serverVivePlayer.isVR()) {
            this.m_146884_(serverVivePlayer.getAimPos(true));
        }
    }

    @Inject(method={"onHitEntity"}, at={@At(value="HEAD")})
    private void vivecraft$damageMultiplier(EntityHitResult entityHitResult, CallbackInfo ci) {
        Entity entity = ((Projectile)this).m_19749_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer owner = (ServerPlayer)entity;
            ServerVivePlayer serverVivePlayer = ServerVRPlayers.getVivePlayer(owner);
            double multiplier = 1.0;
            Vec3 hitPos = this.vivecraft$isHeadshot(entityHitResult);
            if (hitPos != null) {
                multiplier = serverVivePlayer != null && serverVivePlayer.isVR() ? (serverVivePlayer.isSeated() ? ((Double)ServerConfig.BOW_SEATED_HEADSHOT_MULTIPLIER.get()).doubleValue() : ((Double)ServerConfig.BOW_STANDING_HEADSHOT_MULTIPLIER.get()).doubleValue()) : (Double)ServerConfig.BOW_VANILLA_HEADSHOT_MULTIPLIER.get();
                if (multiplier > 1.0 && ServerConfig.BOW_HEADSHOT_INDICATOR.get() != HeadshotIndicator.NONE) {
                    if (ServerConfig.BOW_HEADSHOT_INDICATOR.get() != HeadshotIndicator.AUDIO) {
                        ((ServerLevel)this.m_9236_()).m_8624_(owner, (ParticleOptions)ParticleTypes.f_123797_, true, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 5, -this.m_20184_().f_82479_, -this.m_20184_().f_82480_, -this.m_20184_().f_82481_, 0.1);
                    }
                    if (ServerConfig.BOW_HEADSHOT_INDICATOR.get() != HeadshotIndicator.VISUAL) {
                        owner.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_12018_), SoundSource.PLAYERS, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), 0.7f, 0.5f, owner.m_9236_().f_46441_.m_188505_()));
                    }
                }
            }
            if (serverVivePlayer != null && serverVivePlayer.isVR()) {
                multiplier = serverVivePlayer.isSeated() ? Math.max(multiplier, (Double)ServerConfig.BOW_SEATED_MULTIPLIER.get()) : Math.max(multiplier, (Double)ServerConfig.BOW_STANDING_MULTIPLIER.get());
            }
            this.f_36698_ *= multiplier;
        }
    }

    @Unique
    private Vec3 vivecraft$isHeadshot(EntityHitResult hit) {
        AABB headBox = Utils.getEntityHeadHitbox(hit.m_82443_(), 0.3);
        if (headBox != null) {
            Vec3 originalHitPos = hit.m_82443_().m_20191_().m_82371_(this.m_20182_(), this.m_20182_().m_82549_(this.m_20184_().m_82490_(2.0))).orElse(this.m_20182_().m_82549_(this.m_20184_()));
            return headBox.m_82371_(this.m_20182_(), originalHitPos).orElse(headBox.m_82390_(this.m_20182_()) ? this.m_20182_() : null);
        }
        return null;
    }
}

