/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.extensions.EntityRenderStateExtension;
import org.vivecraft.client.render.HMDModel;

public class HMDLayer
extends RenderLayer<AvatarRenderState, PlayerModel> {
    private final HMDModel model = new HMDModel(HMD_LAYER_DEF.bakeRoot());
    private static final ResourceLocation DIAMOND_HMD = ResourceLocation.parse((String)"vivecraft:textures/diamond_hmd.png");
    private static final ResourceLocation GOLD_HMD = ResourceLocation.parse((String)"vivecraft:textures/gold_hmd.png");
    private static final ResourceLocation BLACK_HMD = ResourceLocation.parse((String)"vivecraft:textures/black_hmd.png");
    private static final LayerDefinition HMD_LAYER_DEF = HMDModel.createHMDLayer();

    public HMDLayer(RenderLayerParent<AvatarRenderState, PlayerModel> renderer) {
        super(renderer);
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight, AvatarRenderState entityState, float yRot, float xRot) {
        ClientVRPlayers.RotInfo rotinfo;
        if (((PlayerModel)this.getParentModel()).head.visible && (rotinfo = ((EntityRenderStateExtension)entityState).vivecraft$getRotInfo()) != null) {
            ResourceLocation hmd;
            switch (rotinfo.hmd) {
                case 1: {
                    ResourceLocation resourceLocation = BLACK_HMD;
                    break;
                }
                case 2: {
                    ResourceLocation resourceLocation = GOLD_HMD;
                    break;
                }
                case 3: 
                case 4: {
                    ResourceLocation resourceLocation = DIAMOND_HMD;
                    break;
                }
                default: {
                    ResourceLocation resourceLocation = hmd = null;
                }
            }
            if (hmd == null) {
                return;
            }
            ((PlayerModel)this.getParentModel()).root().translateAndRotate(poseStack);
            ((PlayerModel)this.getParentModel()).translateToHead(poseStack);
            submitNodeCollector.order(0).submitModelPart(this.model.head, poseStack, RenderType.entitySolid((ResourceLocation)hmd), packedLight, OverlayTexture.NO_OVERLAY, null, -1, null);
        }
    }
}

