/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.extensions.EntityRenderStateExtension;
import org.vivecraft.client.render.VRPlayerModel_WithArms;
import org.vivecraft.client.render.VRPlayerRenderData;
import org.vivecraft.client.render.models.FeetModel;
import org.vivecraft.client.utils.ModelUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.common.utils.MathUtils;

public class VRPlayerModel_WithArmsLegs
extends VRPlayerModel_WithArms
implements FeetModel {
    public static final int LOWER_EXTENSION = 2;
    public static final int UPPER_EXTENSION = 2;
    public ModelPart leftFoot;
    public ModelPart rightFoot;
    public ModelPart leftFootPants;
    public ModelPart rightFootPants;
    private final Vector3f footDir = new Vector3f();
    private final Vector3f footOffset = new Vector3f();
    private final Vector3f kneeOffset = new Vector3f();
    private final Vector3f footPos = new Vector3f();
    private final Vector3f kneePosTemp = new Vector3f();
    private final Quaternionf footQuat = new Quaternionf();

    public VRPlayerModel_WithArmsLegs(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.leftFoot = root.getChild("left_foot");
        this.rightFoot = root.getChild("right_foot");
        this.leftFootPants = this.leftFoot.getChild("left_foot_pants");
        this.rightFootPants = this.rightFoot.getChild("right_foot_pants");
        ModelUtils.textureHackUpper(this.leftLeg, this.leftFoot);
        ModelUtils.textureHackUpper(this.rightLeg, this.rightFoot);
        ModelUtils.textureHackUpper(this.leftPants, this.rightFootPants);
        ModelUtils.textureHackUpper(this.rightPants, this.leftFootPants);
    }

    public static MeshDefinition createMesh(CubeDeformation cubeDeformation, boolean slim) {
        MeshDefinition meshDefinition = VRPlayerModel_WithArms.createMesh(cubeDeformation, slim);
        PartDefinition partDefinition = meshDefinition.getRoot();
        boolean connected = ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected;
        int upperExtension = connected ? 2 : 0;
        int lowerExtension = connected ? 2 : 0;
        float lowerShrinkage = connected ? -0.05f : 0.0f;
        PartDefinition leftFoot = partDefinition.addOrReplaceChild("left_foot", CubeListBuilder.create().texOffs(16, 55 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(lowerShrinkage)), PartPose.offset((float)1.9f, (float)24.0f, (float)0.0f));
        leftFoot.addOrReplaceChild("left_foot_pants", CubeListBuilder.create().texOffs(0, 55 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(0.25f + lowerShrinkage)), PartPose.ZERO);
        PartDefinition rightFoot = partDefinition.addOrReplaceChild("right_foot", CubeListBuilder.create().texOffs(0, 23 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(lowerShrinkage)), PartPose.offset((float)-1.9f, (float)24.0f, (float)0.0f));
        rightFoot.addOrReplaceChild("right_foot_pants", CubeListBuilder.create().texOffs(0, 39 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(0.25f + lowerShrinkage)), PartPose.ZERO);
        PartDefinition leftThigh = partDefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        leftThigh.addOrReplaceChild("left_pants", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.extend(0.25f)), PartPose.ZERO);
        PartDefinition rightThigh = partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        rightThigh.addOrReplaceChild("right_pants", CubeListBuilder.create().texOffs(0, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.extend(0.25f)), PartPose.ZERO);
        return meshDefinition;
    }

    @Override
    public void setupAnim(AvatarRenderState renderState) {
        boolean noLegs;
        super.setupAnim(renderState);
        ClientVRPlayers.RotInfo rotInfo = ((EntityRenderStateExtension)renderState).vivecraft$getRotInfo();
        VRPlayerRenderData data = ((EntityRenderStateExtension)renderState).vivecraft$getVRRenderData();
        if (rotInfo == null || data == null) {
            return;
        }
        boolean bl = noLegs = renderState.isPassenger || data.laying() && (renderState.isInWater || rotInfo.fbtMode == FBTMode.ARMS_ONLY) || renderState.isFallFlying;
        if (!noLegs) {
            Vector3f kneePos;
            if (ClientDataHolderVR.getInstance().vrSettings.playerWalkAnim) {
                float limbRotation = Mth.cos((float)(renderState.walkAnimationPos * 0.6662f)) * renderState.walkAnimationSpeed;
                this.footOffset.set(0.0f, -0.5f, 0.0f).rotateX(limbRotation).sub(0.0f, -0.5f, 0.0f).mul(1.0f, 0.75f, 1.0f).rotateY(-data.bodyYaw());
                this.kneeOffset.set(0.0f, -0.5f, 0.0f).rotateX(-Math.abs(limbRotation)).sub(0.0f, -0.5f, 0.0f).rotateY(-data.bodyYaw());
            } else {
                this.footOffset.zero();
                this.kneeOffset.zero();
            }
            if (rotInfo.fbtMode == FBTMode.ARMS_ONLY) {
                this.footPos.set(this.leftLeg.x, 24.0f + Math.min(this.body.y, 0.0f), this.leftLeg.z);
                ModelUtils.modelToWorld((HumanoidRenderState)renderState, (Vector3fc)this.footPos, rotInfo, data.bodyYaw(), true, true, this.footPos);
                this.footQuat.identity().rotateY((float)Math.PI - data.bodyYaw());
                if (renderState.isAutoSpinAttack) {
                    this.footPos.y -= 1.0f;
                }
            } else {
                this.footPos.set(rotInfo.leftFootPos);
                this.footQuat.set(rotInfo.leftFootQuat);
            }
            if (rotInfo.fbtMode == FBTMode.WITH_JOINTS) {
                this.kneePosTemp.set(rotInfo.leftKneePos);
                this.kneePosTemp.add((Vector3fc)this.kneeOffset);
                kneePos = this.kneePosTemp;
            } else {
                kneePos = null;
            }
            this.footPos.add((Vector3fc)this.footOffset);
            if (ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected) {
                this.positionConnectedLimb(renderState, rotInfo, data, this.leftLeg, this.leftFoot, (Vector3fc)this.footPos, (Quaternionfc)this.footQuat, 0.0f, (Vector3fc)kneePos, false, null, true);
            } else {
                this.footQuat.transform(MathUtils.BACK, this.footDir);
                this.positionSplitLimb(renderState, rotInfo, data, this.leftLeg, this.leftFoot, (Vector3fc)this.footPos, (Quaternionfc)this.footQuat, -1.5707964f, 0.0f, (Vector3fc)kneePos, false, null, true);
            }
            if (rotInfo.fbtMode == FBTMode.ARMS_ONLY) {
                this.footPos.set(this.rightLeg.x, 24.0f + Math.min(this.body.y, 0.0f), this.rightLeg.z);
                ModelUtils.modelToWorld((HumanoidRenderState)renderState, (Vector3fc)this.footPos, rotInfo, data.bodyYaw(), true, true, this.footPos);
                if (renderState.isAutoSpinAttack) {
                    this.footPos.y -= 1.0f;
                }
            } else {
                this.footPos.set(rotInfo.rightFootPos);
                this.footQuat.set(rotInfo.rightFootQuat);
            }
            if (rotInfo.fbtMode == FBTMode.WITH_JOINTS) {
                this.kneePosTemp.set(rotInfo.rightKneePos);
                this.kneePosTemp.add((Vector3fc)this.kneeOffset);
                kneePos = this.kneePosTemp;
            } else {
                kneePos = null;
            }
            this.footPos.add(-this.footOffset.x, this.footOffset.y, -this.footOffset.z);
            if (ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected) {
                this.positionConnectedLimb(renderState, rotInfo, data, this.rightLeg, this.rightFoot, (Vector3fc)this.footPos, (Quaternionfc)this.footQuat, 0.0f, (Vector3fc)kneePos, false, null, true);
            } else {
                this.footQuat.transform(MathUtils.BACK, this.footDir);
                this.positionSplitLimb(renderState, rotInfo, data, this.rightLeg, this.rightFoot, (Vector3fc)this.footPos, (Quaternionfc)this.footQuat, -1.5707964f, 0.0f, (Vector3fc)kneePos, false, null, true);
            }
        }
        if (data.layAmount() > 0.0f) {
            ModelUtils.applySwimRotationOffset((HumanoidRenderState)renderState, data.xRot(), this.tempV, this.tempV2, this.leftLeg, this.rightLeg, this.leftFoot, this.rightFoot);
        }
        if (noLegs) {
            this.footQuat.rotationZYX(this.leftLeg.zRot, this.leftLeg.yRot, this.leftLeg.xRot);
            this.footQuat.transform(0.0f, 12.0f, 0.0f, this.tempV);
            this.leftFoot.setPos(this.leftLeg.x + this.tempV.x, this.leftLeg.y + this.tempV.y, this.leftLeg.z + this.tempV.z);
            this.rightFoot.setPos(this.rightLeg.x - this.tempV.x, this.rightLeg.y + this.tempV.y, this.rightLeg.z + (renderState.isPassenger ? this.tempV.z : -this.tempV.z));
            this.leftFoot.setRotation(this.leftLeg.xRot, this.leftLeg.yRot, this.leftLeg.zRot);
            this.rightFoot.setRotation(this.rightLeg.xRot, this.rightLeg.yRot, this.rightLeg.zRot);
        }
        this.rightFoot.xScale = this.rightFoot.zScale = data.legScale();
        this.leftFoot.zScale = this.rightFoot.zScale;
        this.leftFoot.xScale = this.rightFoot.zScale;
        if (renderState.isAutoSpinAttack) {
            VRPlayerModel_WithArmsLegs.spinOffset(this.leftLeg, this.rightLeg, this.leftFoot, this.rightFoot);
        }
        this.leftFootPants.visible = renderState.showLeftPants;
        this.rightFootPants.visible = renderState.showRightPants;
    }

    @Override
    public ModelPart getLeftFoot() {
        return this.leftFoot;
    }

    @Override
    public ModelPart getRightFoot() {
        return this.rightFoot;
    }

    @Override
    public void setAllVisible(boolean visible) {
        super.setAllVisible(visible);
        this.leftFoot.visible = visible;
        this.rightFoot.visible = visible;
        this.leftFootPants.visible = visible;
        this.rightFootPants.visible = visible;
    }
}

