/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.function.Consumer;
import java.util.function.Function;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_xr.render_pass.RenderPassType;

public class MultiPassRenderTarget
extends RenderTarget {
    private final RenderTarget mainTarget;
    private final Function<RenderPass, RenderTarget> vrTargets;

    public MultiPassRenderTarget(String name, RenderTarget mainTarget, Function<RenderPass, RenderTarget> vrTargets) {
        super(name, mainTarget.useDepth);
        this.mainTarget = mainTarget;
        this.vrTargets = vrTargets;
        this.width = mainTarget.width;
        this.height = mainTarget.height;
        this.filterMode = mainTarget.filterMode;
    }

    public void resize(int width, int height) {
        this.callOnTarget(r -> r.resize(width, height));
    }

    public void destroyBuffers() {
        this.callOnAllTargets(RenderTarget::destroyBuffers);
    }

    public void copyDepthFrom(RenderTarget otherTarget) {
        this.callOnTarget(r -> r.copyDepthFrom(otherTarget));
    }

    public void createBuffers(int width, int height) {
        this.callOnTarget(r -> r.createBuffers(width, height));
    }

    public void setFilterMode(FilterMode filterMode) {
        this.callOnTarget(r -> r.setFilterMode(filterMode));
    }

    public void blitToScreen() {
        this.callOnTarget(RenderTarget::blitToScreen);
    }

    public void blitAndBlendToTexture(GpuTextureView gpuTextureView) {
        this.callOnTarget(r -> r.blitAndBlendToTexture(gpuTextureView));
    }

    public GpuTexture getColorTexture() {
        return this.callOnTargetRet(RenderTarget::getColorTexture);
    }

    public GpuTextureView getColorTextureView() {
        return this.callOnTargetRet(RenderTarget::getColorTextureView);
    }

    public GpuTexture getDepthTexture() {
        return this.callOnTargetRet(RenderTarget::getDepthTexture);
    }

    public GpuTextureView getDepthTextureView() {
        return this.callOnTargetRet(RenderTarget::getDepthTextureView);
    }

    private void callOnTarget(Consumer<RenderTarget> consumer) {
        consumer.accept(this.getCurrent());
    }

    private <T> T callOnTargetRet(Function<RenderTarget, T> function) {
        return function.apply(this.getCurrent());
    }

    private void callOnAllTargets(Consumer<RenderTarget> consumer) {
        consumer.accept(this.mainTarget);
        for (RenderPass pass : RenderPass.values()) {
            RenderTarget target = this.vrTargets.apply(pass);
            if (target == null) continue;
            consumer.accept(target);
        }
    }

    private RenderTarget getCurrent() {
        if (RenderPassType.isVanilla()) {
            return this.mainTarget;
        }
        RenderTarget target = this.vrTargets.apply(ClientDataHolderVR.getInstance().currentPass);
        return target != null ? target : this.mainTarget;
    }
}

