/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.menuworlds;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.SharedConstants;
import org.vivecraft.client.utils.FileUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.menuworlds.MenuWorldExporter;
import org.vivecraft.client_vr.settings.VRSettings;

public class MenuWorldDownloader {
    private static final String BASE_URL = "https://cache.techjargaming.com/vivecraft/115/";
    public static final String CUSTOM_WORLD_FOLDER = "menuworlds/custom_121";
    private static String LAST_WORLD = "";
    private static boolean INIT;
    private static Random RAND;

    public static void init() {
        if (INIT) {
            return;
        }
        RAND = new Random();
        RAND.nextInt();
        INIT = true;
    }

    public static void downloadWorld(String path) throws IOException, NoSuchAlgorithmException {
        String remoteSha1;
        String localSha1;
        File file = new File(path);
        file.getParentFile().mkdirs();
        if (file.exists() && (localSha1 = FileUtils.getFileChecksum(file, "SHA-1")).equals(remoteSha1 = FileUtils.httpReadLine("https://cache.techjargaming.com/vivecraft/115/checksum.php?file=" + path))) {
            VRSettings.LOGGER.info("Vivecraft: MenuWorlds: SHA-1 matches for {}", (Object)path);
            return;
        }
        VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Downloading world {}", (Object)path);
        FileUtils.httpReadToFile(BASE_URL + path, file);
    }

    public static InputStream getRandomWorld() {
        MenuWorldDownloader.init();
        VRSettings settings = ClientDataHolderVR.getInstance().vrSettings;
        try {
            ArrayList<MenuWorldItem> worldList = new ArrayList<MenuWorldItem>();
            if (settings.menuWorldSelection == VRSettings.MenuWorld.BOTH || settings.menuWorldSelection == VRSettings.MenuWorld.CUSTOM) {
                worldList.addAll(MenuWorldDownloader.getCustomWorlds());
            }
            if (settings.menuWorldSelection == VRSettings.MenuWorld.BOTH || settings.menuWorldSelection == VRSettings.MenuWorld.OFFICIAL || worldList.isEmpty()) {
                worldList.addAll(MenuWorldDownloader.getOfficialWorlds());
            }
            if (worldList.size() > 1) {
                worldList.removeIf(world -> LAST_WORLD.equals(world.path) || world.file != null && LAST_WORLD.equals(world.file.getPath()));
            }
            if (worldList.isEmpty()) {
                return MenuWorldDownloader.getRandomWorldFallback();
            }
            MenuWorldItem world2 = MenuWorldDownloader.getRandomWorldFromList(worldList);
            if (world2 != null) {
                LAST_WORLD = world2.file != null ? world2.file.getPath() : world2.path;
            }
            return MenuWorldDownloader.getStreamForWorld(world2);
        }
        catch (IOException | UncheckedIOException | NoSuchAlgorithmException e) {
            VRSettings.LOGGER.error("Vivecraft: error getting random menuworld:", (Throwable)e);
            try {
                return MenuWorldDownloader.getRandomWorldFallback();
            }
            catch (IOException | NoSuchAlgorithmException e2) {
                VRSettings.LOGGER.error("Vivecraft: error getting random menuworld fallback:", (Throwable)e);
                return null;
            }
        }
    }

    private static InputStream getStreamForWorld(MenuWorldItem world) throws IOException, NoSuchAlgorithmException {
        if (world.file != null) {
            VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Using world {}", (Object)world.file.getName());
            return new FileInputStream(world.file);
        }
        if (world.path != null) {
            MenuWorldDownloader.downloadWorld(world.path);
            VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Using official world {}", (Object)world.path);
            return new FileInputStream(world.path);
        }
        throw new IllegalArgumentException("File or path must be assigned");
    }

    private static List<MenuWorldItem> getCustomWorlds() throws IOException {
        File dir = new File(CUSTOM_WORLD_FOLDER);
        if (dir.exists()) {
            return MenuWorldDownloader.getWorldsInDirectory(dir);
        }
        return new ArrayList<MenuWorldItem>();
    }

    private static List<MenuWorldItem> getOfficialWorlds() throws IOException, UncheckedIOException {
        ArrayList<MenuWorldItem> list = new ArrayList<MenuWorldItem>();
        List<String> resultList = FileUtils.httpReadAllLines("https://cache.techjargaming.com/vivecraft/115/menuworlds_list.php?minver=2&maxver=6&mcver=" + SharedConstants.getCurrentVersion().name());
        for (String str : resultList) {
            list.add(new MenuWorldItem("menuworlds/" + str, null));
        }
        return list;
    }

    private static InputStream getRandomWorldFallback() throws IOException, NoSuchAlgorithmException {
        MenuWorldItem world;
        VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Couldn't find a world, trying random file from directory");
        File dir = new File("menuworlds");
        if (dir.exists() && (world = MenuWorldDownloader.getRandomWorldFromList(MenuWorldDownloader.getWorldsInDirectory(dir))) != null) {
            return MenuWorldDownloader.getStreamForWorld(world);
        }
        return null;
    }

    private static List<MenuWorldItem> getWorldsInDirectory(File dir) throws IOException {
        ArrayList<MenuWorldItem> worlds = new ArrayList<MenuWorldItem>();
        for (File file2 : dir.listFiles(file -> file.isFile() && file.getName().toLowerCase().endsWith(".mmw"))) {
            int version = MenuWorldExporter.readVersion(file2);
            if (version < 2 || version > 6) continue;
            worlds.add(new MenuWorldItem(null, file2));
        }
        return worlds;
    }

    private static MenuWorldItem getRandomWorldFromList(List<MenuWorldItem> list) {
        if (!list.isEmpty()) {
            return list.get(RAND.nextInt(list.size()));
        }
        return null;
    }

    private record MenuWorldItem(String path, File file) {
    }
}

