/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.network.packet.s2c;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import org.vivecraft.common.network.packet.PayloadIdentifier;
import org.vivecraft.common.network.packet.s2c.VivecraftPayloadS2C;

public record SettingOverridePayloadS2C(Map<String, String> overrides, boolean clear) implements VivecraftPayloadS2C
{
    @Override
    public PayloadIdentifier payloadId() {
        return PayloadIdentifier.SETTING_OVERRIDE;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeByte(this.payloadId().ordinal());
        for (Map.Entry<String, String> entry : this.overrides.entrySet()) {
            buffer.writeUtf(entry.getKey());
            buffer.writeUtf(entry.getValue());
        }
        buffer.writeUtf("clearOverrides");
        buffer.writeUtf(String.valueOf(this.clear));
    }

    public static SettingOverridePayloadS2C read(FriendlyByteBuf buffer) {
        HashMap<String, String> overrides = new HashMap<String, String>();
        while (buffer.readableBytes() > 0) {
            overrides.put(buffer.readUtf(), buffer.readUtf());
        }
        return new SettingOverridePayloadS2C(overrides, overrides.containsKey("clearOverrides") && ((String)overrides.get("clearOverrides")).equals("true"));
    }
}

