/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client.blaze3d.opengl;

import com.mojang.blaze3d.GpuOutOfMemoryException;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlDebugLabel;
import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.vivecraft.client.extensions.GlDeviceExtension;

@Mixin(value={GlDevice.class})
public class GlDeviceMixin
implements GlDeviceExtension {
    @Shadow
    @Final
    private GlDebugLabel debugLabels;

    @Override
    public GpuTexture vivecraft$createFixedIdTexture(@Nullable Supplier<String> labelSupplier, int usageFlags, TextureFormat textureFormat, int width, int height, int depthLayers, int mipmapLevels, int texId) {
        String label;
        if (mipmapLevels < 1) {
            throw new IllegalArgumentException("mipLevels must be at least 1");
        }
        if (depthLayers < 1) {
            throw new IllegalArgumentException("depthOrLayers must be at least 1");
        }
        if ((usageFlags & 0x10) != 0) {
            throw new UnsupportedOperationException("CubeMap textures are not supported");
        }
        if (depthLayers > 1) {
            throw new UnsupportedOperationException("Array or 3D textures are not supported");
        }
        GlStateManager.clearGlErrors();
        String string = label = this.debugLabels.exists() && labelSupplier != null ? labelSupplier.get() : null;
        if (label == null) {
            label = String.valueOf(texId);
        }
        GlStateManager._bindTexture((int)texId);
        GlStateManager._texParameter((int)3553, (int)33085, (int)(mipmapLevels - 1));
        GlStateManager._texParameter((int)3553, (int)33082, (int)0);
        GlStateManager._texParameter((int)3553, (int)33083, (int)(mipmapLevels - 1));
        if (textureFormat.hasDepthAspect()) {
            GlStateManager._texParameter((int)3553, (int)34892, (int)0);
        }
        for (int m = 0; m < mipmapLevels; ++m) {
            GlStateManager._texImage2D((int)3553, (int)m, (int)GlConst.toGlInternalId((TextureFormat)textureFormat), (int)(width >> m), (int)(height >> m), (int)0, (int)GlConst.toGlExternalId((TextureFormat)textureFormat), (int)GlConst.toGlType((TextureFormat)textureFormat), null);
        }
        int error = GlStateManager._getError();
        if (error == 1285) {
            throw new GpuOutOfMemoryException("Could not allocate texture of " + width + "x" + height + " for " + label);
        }
        if (error != 0) {
            throw new IllegalStateException("OpenGL error " + error);
        }
        GlTexture glTexture = new GlTexture(usageFlags, label, textureFormat, width, height, depthLayers, mipmapLevels, texId);
        this.debugLabels.applyLabel(glTexture);
        return glTexture;
    }
}

