/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client.renderer.entity;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.extensions.EntityRenderDispatcherExtension;
import org.vivecraft.client.extensions.EntityRenderStateExtension;
import org.vivecraft.client.extensions.RenderLayerExtension;
import org.vivecraft.client.render.VRPlayerRenderData;
import org.vivecraft.client.render.VRPlayerRenderer;
import org.vivecraft.client.utils.RenderLayerType;
import org.vivecraft.client.utils.ScaleHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mixin.client.renderer.entity.LivingEntityRendererMixin;
import org.vivecraft.mod_compat_vr.immersiveportals.ImmersivePortalsHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

@Mixin(value={AvatarRenderer.class})
public abstract class AvatarRendererMixin
extends LivingEntityRendererMixin<AbstractClientPlayer, AvatarRenderState, PlayerModel> {
    protected AvatarRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/Avatar;Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;F)V"}, at={@At(value="HEAD")})
    private void vivecraft$addRotInfo(Avatar entity, AvatarRenderState reusedState, float partialTick, CallbackInfo ci) {
        if (entity.getClass() == LocalPlayer.class || entity.getClass() == RemotePlayer.class) {
            ((EntityRenderStateExtension)reusedState).vivecraft$setRotInfo(ClientVRPlayers.getInstance().getRotationsForPlayer(entity.getUUID()));
        } else {
            ((EntityRenderStateExtension)reusedState).vivecraft$setRotInfo(null);
        }
        ((EntityRenderStateExtension)reusedState).vivecraft$setFirstPersonPlayer(VREffectsHelper.isFirstPersonPlayer((Entity)entity));
        ((EntityRenderStateExtension)reusedState).vivecraft$setTotalScale(ScaleHelper.getEntityEyeHeightScale((LivingEntity)entity, partialTick));
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/Avatar;Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;F)V"}, at={@At(value="TAIL")})
    private void vivecraft$vrPlayerState(Avatar entity, AvatarRenderState reusedState, float partialTick, CallbackInfo ci) {
        ClientVRPlayers.RotInfo rotInfo = ((EntityRenderStateExtension)reusedState).vivecraft$getRotInfo();
        if (rotInfo != null) {
            ((EntityRenderStateExtension)reusedState).vivecraft$setVRRenderData(this.vivecraft$extractVRModelData(VREffectsHelper.isFirstPersonPlayer((Entity)entity), rotInfo, reusedState));
        } else {
            ((EntityRenderStateExtension)reusedState).vivecraft$setVRRenderData(null);
        }
    }

    @Unique
    private VRPlayerRenderData vivecraft$extractVRModelData(boolean isMainPlayer, ClientVRPlayers.RotInfo rotInfo, AvatarRenderState renderState) {
        boolean laying = renderState.swimAmount > 0.0f || renderState.isFallFlying;
        float layAmount = renderState.isFallFlying ? 1.0f : renderState.swimAmount;
        boolean swimming = laying && renderState.isInWater || renderState.isFallFlying;
        boolean noLowerBodyAnimation = swimming || rotInfo.fbtMode == FBTMode.ARMS_ONLY;
        float bodyYaw = isMainPlayer ? ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getBodyYawRad() : rotInfo.getBodyYawRad();
        float xRot = swimming ? layAmount * (-1.5707964f - (float)Math.PI / 180 * renderState.xRot) : layAmount * -1.5707964f;
        float bodyScale = 1.0f;
        float armScale = 1.0f;
        float legScale = 1.0f;
        if (isMainPlayer && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && (!ImmersivePortalsHelper.isLoaded() || !ImmersivePortalsHelper.isRenderingPortal()) && !ShadersHelper.isRenderingShadows() && RenderPass.isFirstPerson(ClientDataHolderVR.getInstance().currentPass) || ShadersHelper.isRenderingShadows() && ClientDataHolderVR.getInstance().vrSettings.shaderFullSizeShadowLimbs) {
            bodyScale = ClientDataHolderVR.getInstance().vrSettings.playerModelBodyScale;
            armScale = ClientDataHolderVR.getInstance().vrSettings.playerModelArmsScale;
            legScale = ClientDataHolderVR.getInstance().vrSettings.playerModelLegScale;
        }
        HumanoidArm attackArm = null;
        if (renderState.attackTime > 0.0f) {
            attackArm = renderState.attackArm;
            if (rotInfo.leftHanded) {
                attackArm = attackArm.getOpposite();
            }
        }
        return new VRPlayerRenderData(isMainPlayer, bodyYaw, xRot, laying, layAmount, swimming, noLowerBodyAnimation, attackArm, rotInfo.leftHanded ? HumanoidArm.LEFT : HumanoidArm.RIGHT, bodyScale, armScale, legScale);
    }

    @Override
    protected void vivecraft$onAddLayer(RenderLayer<AvatarRenderState, PlayerModel> renderLayer, CallbackInfoReturnable<Boolean> cir) {
        EntityRenderDispatcherExtension renderExtension = (EntityRenderDispatcherExtension)this.entityRenderDispatcher;
        if (((Object)((Object)this)).getClass() == AvatarRenderer.class && !renderExtension.vivecraft$getSkinMapVRVanilla().isEmpty()) {
            PlayerModelType modelType;
            Constructor<RenderLayer<AvatarRenderState, PlayerModel>> constructor = null;
            RenderLayerType type = RenderLayerType.OTHER;
            for (Constructor<RenderLayer<AvatarRenderState, PlayerModel>> constructor2 : renderLayer.getClass().getConstructors()) {
                if (constructor2.getParameterCount() == 1 && RenderLayerParent.class.isAssignableFrom(constructor2.getParameterTypes()[0])) {
                    constructor = constructor2;
                    type = RenderLayerType.PARENT_ONLY;
                    break;
                }
                if (constructor2.getParameterCount() != 2 || !RenderLayerParent.class.isAssignableFrom(constructor2.getParameterTypes()[0]) || !EntityModelSet.class.isAssignableFrom(constructor2.getParameterTypes()[1])) continue;
                constructor = constructor2;
                type = RenderLayerType.PARENT_MODELSET;
            }
            PlayerModelType playerModelType = modelType = ((PlayerModel)this.model).slim ? PlayerModelType.SLIM : PlayerModelType.WIDE;
            if (constructor == null) {
                this.vivecraft$addLayerClone(renderLayer, renderExtension.vivecraft$getSkinMapVRVanilla().get(modelType));
                this.vivecraft$addLayerClone(renderLayer, renderExtension.vivecraft$getSkinMapVRArms().get(modelType));
                this.vivecraft$addLayerClone(renderLayer, renderExtension.vivecraft$getSkinMapVRLegs().get(modelType));
            } else {
                if (!constructor.canAccess(null)) {
                    VRSettings.LOGGER.warn("Vivecraft: layer constructor of '{}' was private, making it accessible", renderLayer.getClass());
                    constructor.setAccessible(true);
                }
                this.vivecraft$addLayerConstructor(renderLayer, constructor, type, renderExtension.vivecraft$getSkinMapVRVanilla().get(modelType));
                this.vivecraft$addLayerConstructor(renderLayer, constructor, type, renderExtension.vivecraft$getSkinMapVRArms().get(modelType));
                this.vivecraft$addLayerConstructor(renderLayer, constructor, type, renderExtension.vivecraft$getSkinMapVRLegs().get(modelType));
            }
        }
    }

    @Unique
    private void vivecraft$addLayerClone(RenderLayer<AvatarRenderState, PlayerModel> renderLayer, VRPlayerRenderer target) {
        if (target.hasLayerType(renderLayer)) {
            return;
        }
        try {
            VRSettings.LOGGER.warn("Vivecraft: Copying layer: {} with Object.copy, this could cause issues", renderLayer.getClass());
            RenderLayer newLayer = (RenderLayer)((RenderLayerExtension)renderLayer).clone();
            newLayer.renderer = target;
            target.addLayer(newLayer);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Unique
    private void vivecraft$addLayerConstructor(RenderLayer<AvatarRenderState, PlayerModel> renderLayer, Constructor<RenderLayer<AvatarRenderState, PlayerModel>> constructor, RenderLayerType type, VRPlayerRenderer target) {
        if (target.hasLayerType(renderLayer)) {
            return;
        }
        EntityModelSet modelSet = Minecraft.getInstance().getEntityModels();
        try {
            switch (type) {
                case PARENT_ONLY: {
                    target.addLayer(constructor.newInstance(new Object[]{target}));
                    break;
                }
                case PARENT_MODELSET: {
                    target.addLayer(constructor.newInstance(new Object[]{target, modelSet}));
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

