/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.renderer;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.framegraph.FrameGraphBuilder;
import com.mojang.blaze3d.framegraph.FramePass;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.resource.RenderTargetDescriptor;
import com.mojang.blaze3d.resource.ResourceDescriptor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LevelTargetBundle;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderManager;
import net.minecraft.client.renderer.state.BlockOutlineRenderState;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.client.extensions.LevelRenderStateExtension;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MultiPassTextureTarget;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.LevelTargetBundleExtension;
import org.vivecraft.client_vr.gameplay.interact_modules.BlockInteractionModule;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassType;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

@Mixin(value={LevelRenderer.class}, priority=990)
public abstract class LevelRendererVRMixin
implements ResourceManagerReloadListener,
AutoCloseable {
    @Unique
    private static final ResourceLocation vivecraft$VR_TRANSPARENCY_POST_CHAIN_ID = ResourceLocation.fromNamespaceAndPath((String)"vivecraft", (String)"vrtransparency");
    @Unique
    private boolean vivecraft$guiRendered = false;
    @Shadow
    private ClientLevel level;
    @Final
    @Shadow
    private RenderBuffers renderBuffers;
    @Shadow
    @Final
    private LevelTargetBundle targets;

    @Shadow
    protected abstract void renderHitOutline(PoseStack var1, VertexConsumer var2, double var3, double var5, double var7, BlockOutlineRenderState var9, int var10);

    @Inject(method={"onResourceManagerReload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"}, at={@At(value="TAIL")})
    private void vivecraft$reinitVR(ResourceManager resourceManager, CallbackInfo ci) {
        if (VRState.VR_INITIALIZED) {
            ClientDataHolderVR.getInstance().vrRenderer.reinitFrameBuffersMaybe("Resource Reload");
        }
    }

    @WrapOperation(method={"renderLevel(Lcom/mojang/blaze3d/resource/GraphicsResourceAllocator;Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;Lorg/joml/Vector4f;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;pollLightUpdates()V")})
    private void vivecraft$onePollLightUpdates(ClientLevel instance, Operation<Void> original) {
        if (RenderPassType.isVanilla() || ClientDataHolderVR.getInstance().isFirstPass) {
            original.call(new Object[]{instance});
        }
    }

    @WrapOperation(method={"renderLevel(Lcom/mojang/blaze3d/resource/GraphicsResourceAllocator;Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;Lorg/joml/Vector4f;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/lighting/LevelLightEngine;runLightUpdates()I")})
    private int vivecraft$oneLightingUpdates(LevelLightEngine instance, Operation<Integer> original) {
        if (RenderPassType.isVanilla() || ClientDataHolderVR.getInstance().isFirstPass) {
            return (Integer)original.call(new Object[]{instance});
        }
        return 0;
    }

    @Inject(method={"renderLevel(Lcom/mojang/blaze3d/resource/GraphicsResourceAllocator;Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;Lorg/joml/Vector4f;Z)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/framegraph/FrameGraphBuilder;createInternal(Ljava/lang/String;Lcom/mojang/blaze3d/resource/ResourceDescriptor;)Lcom/mojang/blaze3d/resource/ResourceHandle;", ordinal=0)})
    private void vivecraft$addVRTargets(CallbackInfo ci, @Local FrameGraphBuilder frameGraphBuilder, @Local RenderTargetDescriptor renderTargetDescriptor) {
        if (VRState.VR_RUNNING) {
            this.targets.replace(LevelTargetBundleExtension.OCCLUDED_TARGET_ID, frameGraphBuilder.createInternal("vroccluded", (ResourceDescriptor)renderTargetDescriptor));
            this.targets.replace(LevelTargetBundleExtension.UNOCCLUDED_TARGET_ID, frameGraphBuilder.createInternal("vrunoccluded", (ResourceDescriptor)renderTargetDescriptor));
            this.targets.replace(LevelTargetBundleExtension.HANDS_TARGET_ID, frameGraphBuilder.createInternal("vrhands", (ResourceDescriptor)renderTargetDescriptor));
        }
    }

    @Inject(method={"renderLevel(Lcom/mojang/blaze3d/resource/GraphicsResourceAllocator;Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;Lorg/joml/Vector4f;Z)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/framegraph/FramePass;executes(Ljava/lang/Runnable;)V", shift=At.Shift.AFTER)})
    private void vivecraft$addStencilPass(CallbackInfo ci, @Local FrameGraphBuilder frameGraphBuilder) {
        if (!RenderPassType.isVanilla() && ClientDataHolderVR.getInstance().vrSettings.vrUseStencil) {
            FramePass framePass = frameGraphBuilder.addPass("vr_stencil");
            this.targets.main = framePass.readsAndWrites(this.targets.main);
            framePass.executes(() -> {
                Profiler.get().popPush("stencil");
                VREffectsHelper.drawEyeStencil();
            });
        }
    }

    @ModifyExpressionValue(method={"extractVisibleEntities(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;Lnet/minecraft/client/DeltaTracker;Lnet/minecraft/client/renderer/state/LevelRenderState;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;shouldRender(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/client/renderer/culling/Frustum;DDD)Z")})
    private boolean vivecraft$dontCullPlayer(boolean doRender, @Local Entity entity) {
        return doRender || ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && entity == Minecraft.getInstance().player;
    }

    @ModifyExpressionValue(method={"extractVisibleEntities(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;Lnet/minecraft/client/DeltaTracker;Lnet/minecraft/client/renderer/state/LevelRenderState;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isSleeping()Z")})
    private boolean vivecraft$noPlayerWhenSleeping(boolean isSleeping) {
        return isSleeping && RenderPassType.isVanilla();
    }

    @Inject(method={"method_62202*", "addMainPass*"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/framegraph/FramePass;readsAndWrites(Lcom/mojang/blaze3d/resource/ResourceHandle;)Lcom/mojang/blaze3d/resource/ResourceHandle;", ordinal=0, remap=true)}, remap=false)
    public void vivecraft$markVRTargetsForWrite(CallbackInfo ci, @Local FramePass framePass) {
        LevelTargetBundle levelTargetBundle;
        if (VRState.VR_RUNNING && (levelTargetBundle = this.targets) instanceof LevelTargetBundleExtension) {
            LevelTargetBundleExtension ext = (LevelTargetBundleExtension)levelTargetBundle;
            if (ext.vivecraft$getOccluded() != null) {
                this.targets.replace(LevelTargetBundleExtension.OCCLUDED_TARGET_ID, framePass.readsAndWrites(ext.vivecraft$getOccluded()));
            }
            if (ext.vivecraft$getUnoccluded() != null) {
                this.targets.replace(LevelTargetBundleExtension.UNOCCLUDED_TARGET_ID, framePass.readsAndWrites(ext.vivecraft$getUnoccluded()));
            }
            if (ext.vivecraft$getHands() != null) {
                this.targets.replace(LevelTargetBundleExtension.HANDS_TARGET_ID, framePass.readsAndWrites(ext.vivecraft$getHands()));
            }
        }
    }

    @Inject(method={"lambda$addMainPass$1*", "lambda$addMainPass$2*", "lambda$addMainPass$1*"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/OutlineBufferSource;endOutlineBatch()V", shift=At.Shift.AFTER, remap=true)}, remap=false)
    private void vivecraft$interactOutlineSolid(CallbackInfo ci, @Local(argsOnly=true) LevelRenderState levelRenderState, @Local PoseStack poseStack) {
        this.vivecraft$interactOutline(levelRenderState, poseStack, false);
    }

    @Inject(method={"lambda$addMainPass$1*", "lambda$addMainPass$2*", "lambda$addMainPass$1*"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;endBatch()V", ordinal=2, remap=true)}, remap=false)
    private void vivecraft$interactOutlineTranslucent(CallbackInfo ci, @Local(argsOnly=true) LevelRenderState levelRenderState, @Local PoseStack poseStack) {
        this.vivecraft$interactOutline(levelRenderState, poseStack, true);
    }

    @Unique
    private void vivecraft$interactOutline(LevelRenderState levelRenderState, PoseStack poseStack, boolean sort) {
        if (RenderPassType.isVanilla()) {
            return;
        }
        Profiler.get().popPush("interact outline");
        if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
            OptifineHelper.beginOutlineShader();
        }
        BlockOutlineRenderState[] outlines = ((LevelRenderStateExtension)levelRenderState).vivecraft$getInteractOutlineStates();
        for (int c = 0; c < 2; ++c) {
            if (outlines[c] == null || sort != outlines[c].isTranslucent()) continue;
            this.renderHitOutline(poseStack, this.renderBuffers.bufferSource().getBuffer(RenderType.lines()), levelRenderState.cameraRenderState.pos.x, levelRenderState.cameraRenderState.pos.y, levelRenderState.cameraRenderState.pos.z, outlines[c], 0x66FFFFFF);
        }
        this.renderBuffers.bufferSource().endBatch(RenderType.lines());
        if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
            OptifineHelper.endOutlineShader();
        }
    }

    @Inject(method={"extractBlockOutline(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/state/LevelRenderState;Z)V"}, at={@At(value="HEAD")})
    private void vivecraft$extractInteractOutline(CallbackInfo ci, @Local(argsOnly=true) Camera camera, @Local(argsOnly=true) LevelRenderState levelRenderState) {
        if (RenderPassType.isVanilla()) {
            return;
        }
        BlockInteractionModule blockModule = ClientDataHolderVR.getInstance().blockModule;
        for (int c = 0; c < 2; ++c) {
            if (blockModule.isActive(c)) {
                BlockPos blockPos = blockModule.inBlockHit[c] != null ? blockModule.inBlockHit[c].getBlockPos() : BlockPos.containing((Position)ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_render.getController(c).getPosition());
                BlockState blockState = this.level.getBlockState(blockPos);
                ((LevelRenderStateExtension)levelRenderState).vivecraft$setInteractOutlineState(c, new BlockOutlineRenderState(blockPos, ItemBlockRenderTypes.getChunkRenderType((BlockState)blockState).sortOnUpload(), false, blockState.getShape((BlockGetter)this.level, blockPos, CollisionContext.of((Entity)camera.getEntity()))));
                continue;
            }
            ((LevelRenderStateExtension)levelRenderState).vivecraft$setInteractOutlineState(c, null);
        }
    }

    @Inject(method={"lambda$addMainPass$1*", "lambda$addMainPass$2*", "lambda$addMainPass$1*"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;endBatch()V", ordinal=0, shift=At.Shift.AFTER, remap=true)}, remap=false)
    private void vivecraft$renderVrStuffPart1(CallbackInfo ci) {
        if (RenderPassType.isVanilla()) {
            return;
        }
        float partialTick = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(false);
        if (this.targets.translucent != null) {
            VREffectsHelper.renderVRFabulous(partialTick, this.targets);
        } else {
            VREffectsHelper.renderVrFast(partialTick, false);
            if (ShadersHelper.isShaderActive() && ClientDataHolderVR.getInstance().vrSettings.shaderGUIRender == VRSettings.ShaderGUIRender.BEFORE_TRANSLUCENT_SOLID) {
                VREffectsHelper.renderVrFast(partialTick, true);
                this.vivecraft$guiRendered = true;
            }
        }
    }

    @Inject(method={"renderLevel(Lcom/mojang/blaze3d/resource/GraphicsResourceAllocator;Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;Lorg/joml/Vector4f;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Options;getCloudsType()Lnet/minecraft/client/CloudStatus;")})
    private void vivecraft$renderVrStuffPart2(CallbackInfo ci, @Local(ordinal=0) float partialTick, @Local FrameGraphBuilder frameGraphBuilder) {
        if (RenderPassType.isVanilla()) {
            return;
        }
        if (!(this.targets.translucent != null || ShadersHelper.isShaderActive() && ClientDataHolderVR.getInstance().vrSettings.shaderGUIRender != VRSettings.ShaderGUIRender.AFTER_TRANSLUCENT)) {
            FramePass framePass = frameGraphBuilder.addPass("vr stuff part2");
            this.targets.main = framePass.readsAndWrites(this.targets.main);
            framePass.executes(() -> VREffectsHelper.renderVrFast(partialTick, true));
            this.vivecraft$guiRendered = true;
        }
    }

    @Inject(method={"renderLevel(Lcom/mojang/blaze3d/resource/GraphicsResourceAllocator;Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;Lorg/joml/Vector4f;Z)V"}, at={@At(value="RETURN")})
    private void vivecraft$renderVrStuffFinal(CallbackInfo ci, @Local(ordinal=0) float partialTick) {
        if (RenderPassType.isVanilla()) {
            return;
        }
        if (!this.vivecraft$guiRendered && !Minecraft.useShaderTransparency()) {
            RenderSystem.getModelViewStack().pushMatrix().identity();
            RenderHelper.applyVRModelView(ClientDataHolderVR.getInstance().currentPass, (Matrix4f)RenderSystem.getModelViewStack());
            VREffectsHelper.renderVrFast(partialTick, true);
            RenderSystem.getModelViewStack().popMatrix();
        }
        this.vivecraft$guiRendered = false;
    }

    @WrapOperation(method={"initOutline()V"}, at={@At(value="NEW", target="Lcom/mojang/blaze3d/pipeline/TextureTarget;")})
    private TextureTarget vivecraft$multiPassOutlineTarget(String name, int width, int height, boolean useDepth, Operation<TextureTarget> original) {
        if (VRState.VR_INITIALIZED) {
            return new MultiPassTextureTarget(name, width, height, useDepth);
        }
        return (TextureTarget)original.call(new Object[]{name, width, height, useDepth});
    }

    @WrapOperation(method={"getTransparencyChain()Lnet/minecraft/client/renderer/PostChain;"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ShaderManager;getPostChain(Lnet/minecraft/resources/ResourceLocation;Ljava/util/Set;)Lnet/minecraft/client/renderer/PostChain;")})
    private PostChain vivecraft$vrTransparency(ShaderManager instance, ResourceLocation id, Set<ResourceLocation> externalTargets, Operation<PostChain> original) {
        if (VRState.VR_RUNNING) {
            return (PostChain)original.call(new Object[]{instance, vivecraft$VR_TRANSPARENCY_POST_CHAIN_ID, LevelTargetBundleExtension.VR_TARGETS});
        }
        return (PostChain)original.call(new Object[]{instance, id, externalTargets});
    }

    @Inject(method={"getCloudsTarget()Lcom/mojang/blaze3d/pipeline/RenderTarget;"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$getCloudsTarget(CallbackInfoReturnable<RenderTarget> cir) {
        if (ClientDataHolderVR.getInstance().menuWorldRenderer != null && ClientDataHolderVR.getInstance().menuWorldRenderer.isRendering()) {
            cir.setReturnValue(null);
        }
    }
}

