/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.vivecraft.client.gui.framework.TooltipRenderer;
import org.vivecraft.client.gui.framework.VROptionEntry;
import org.vivecraft.client.gui.framework.VROptionLayout;
import org.vivecraft.client.gui.framework.widgets.GuiVROption;
import org.vivecraft.client.gui.framework.widgets.GuiVROptionButton;
import org.vivecraft.client.gui.framework.widgets.GuiVROptionSlider;
import org.vivecraft.client.gui.settings.GuiAllSettings;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.TooltipUtil;

public abstract class GuiVROptionsBase
extends Screen {
    private static final ResourceLocation VIVE_WIDGETS_LOCATION = new ResourceLocation("vivecraft", "textures/gui/widgets.png");
    protected ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
    protected final Screen lastScreen;
    protected final VRSettings vrSettings;
    protected boolean reinit;
    protected boolean drawDefaultButtons = true;
    protected ObjectSelectionList visibleList = null;
    private int nextButtonIndex = 0;
    public String vrTitle = "Title";
    private Button btnDone;
    private Button btnDefaults;

    public GuiVROptionsBase(Screen lastScreen) {
        super((Component)Component.m_237113_((String)""));
        this.lastScreen = lastScreen;
        this.vrSettings = ClientDataHolderVR.getInstance().vrSettings;
    }

    protected void addDefaultButtons() {
        ImageButton search = new ImageButton(this.f_96543_ / 2 - 180, (int)Math.ceil((float)(this.f_96544_ / 6) - 10.0f), 20, 20, 0, 0, 20, VIVE_WIDGETS_LOCATION, 64, 64, p -> this.f_96541_.m_91152_((Screen)new GuiAllSettings(this)), (Component)Component.m_237115_((String)"vivecraft.options.screen.search"));
        search.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"vivecraft.options.screen.search")));
        this.m_142416_((GuiEventListener)search);
        this.btnDone = new Button.Builder((Component)Component.m_237115_((String)"gui.back"), p -> {
            if (!this.onDoneClicked()) {
                this.dataHolder.vrSettings.saveOptions();
                this.f_96541_.m_91152_(this.lastScreen);
            }
        }).m_252794_(this.f_96543_ / 2 + 5, this.f_96544_ - 30).m_253046_(150, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnDone);
        this.btnDefaults = new Button.Builder((Component)Component.m_237115_((String)"vivecraft.gui.loaddefaults"), p -> {
            this.loadDefaults();
            this.dataHolder.vrSettings.saveOptions();
            this.reinit = true;
        }).m_252794_(this.f_96543_ / 2 - 155, this.f_96544_ - 30).m_253046_(150, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnDefaults);
        this.m_6702_().sort((a, b) -> {
            if (a instanceof AbstractWidget) {
                AbstractWidget wA = (AbstractWidget)a;
                if (b instanceof AbstractWidget) {
                    AbstractWidget wB = (AbstractWidget)b;
                    if (wA.m_252907_() < wB.m_252907_() || wA.m_252907_() == wB.m_252907_() && wA.m_252754_() < wB.m_252754_()) {
                        return -1;
                    }
                    return 1;
                }
            }
            return 0;
        });
    }

    protected boolean onDoneClicked() {
        return false;
    }

    protected void init(VROptionLayout[] settings, boolean clear) {
        if (clear) {
            this.m_169413_();
        }
        for (final VROptionLayout layout : settings) {
            if (layout.getOption() != null && layout.getOption().getEnumFloat()) {
                this.m_142416_((GuiEventListener)new GuiVROptionSlider(layout.getOrdinal(), layout.getX(this.f_96543_), layout.getY(this.f_96544_), layout.getOption()){

                    public void m_5716_(double mouseX, double mouseY) {
                        if (layout.getCustomHandler() == null || !layout.getCustomHandler().apply(this, new Vec2((float)mouseX, (float)mouseY)).booleanValue()) {
                            super.m_5716_(mouseX, mouseY);
                        }
                    }
                });
                continue;
            }
            if (layout.getOption() != null) {
                this.m_142416_((GuiEventListener)new GuiVROptionButton(layout.getOrdinal(), layout.getX(this.f_96543_), layout.getY(this.f_96544_), layout.getOption(), layout.getButtonText(), p -> {
                    if (layout.getCustomHandler() == null || !layout.getCustomHandler().apply((GuiVROptionButton)p, new Vec2(0.0f, 0.0f)).booleanValue()) {
                        this.vrSettings.setOptionValue(((GuiVROptionButton)p).getOption());
                        p.m_93666_((Component)Component.m_237113_((String)layout.getButtonText()));
                    }
                }));
                continue;
            }
            if (layout.getScreen() != null) {
                this.m_142416_((GuiEventListener)new GuiVROptionButton(layout.getOrdinal(), layout.getX(this.f_96543_), layout.getY(this.f_96544_), layout.getButtonText(), p -> {
                    try {
                        if (layout.getCustomHandler() != null && layout.getCustomHandler().apply((GuiVROptionButton)p, new Vec2(0.0f, 0.0f)).booleanValue()) {
                            return;
                        }
                        this.vrSettings.saveOptions();
                        this.f_96541_.m_91152_(layout.getScreen().getConstructor(Screen.class).newInstance(new Object[]{this}));
                    }
                    catch (ReflectiveOperationException e) {
                        VRSettings.LOGGER.error("Vivecraft: error setting screen: ", (Throwable)e);
                    }
                }));
                continue;
            }
            if (layout.getCustomHandler() != null) {
                this.m_142416_((GuiEventListener)new GuiVROptionButton(layout.getOrdinal(), layout.getX(this.f_96543_), layout.getY(this.f_96544_), layout.getButtonText(), p -> layout.getCustomHandler().apply((GuiVROptionButton)p, new Vec2(0.0f, 0.0f))));
                continue;
            }
            this.m_142416_((GuiEventListener)new GuiVROptionButton(layout.getOrdinal(), layout.getX(this.f_96543_), layout.getY(this.f_96544_), layout.getButtonText(), p -> {}));
        }
    }

    protected void loadDefaults() {
        for (GuiEventListener child : this.m_6702_()) {
            if (!(child instanceof GuiVROption)) continue;
            GuiVROption optionButton = (GuiVROption)child;
            this.vrSettings.loadDefault(optionButton.getOption());
        }
    }

    protected void init(VROptionEntry[] settings, boolean clear) {
        if (clear) {
            this.m_169413_();
            this.nextButtonIndex = 0;
        }
        ArrayList<VROptionLayout> layouts = new ArrayList<VROptionLayout>();
        if (this.nextButtonIndex < this.m_6702_().size()) {
            this.nextButtonIndex = this.m_6702_().size();
        }
        int nextIndex = this.nextButtonIndex;
        for (VROptionEntry setting : settings) {
            VROptionLayout.Position pos;
            VROptionLayout.Position position = setting.center ? VROptionLayout.Position.POS_CENTER : (pos = nextIndex % 2 == 0 ? VROptionLayout.Position.POS_LEFT : VROptionLayout.Position.POS_RIGHT);
            if (setting.center && nextIndex % 2 != 0) {
                ++nextIndex;
            }
            if (setting.option != null) {
                if (setting.option != VRSettings.VrOptions.DUMMY) {
                    layouts.add(new VROptionLayout(setting.option, setting.customHandler, pos, (float)Math.floor((float)nextIndex / 2.0f), true, setting.title));
                }
            } else if (setting.customHandler != null) {
                layouts.add(new VROptionLayout(setting.customHandler, pos, (float)Math.floor((float)nextIndex / 2.0f), true, setting.title));
            }
            if (setting.center) {
                ++nextIndex;
            }
            ++nextIndex;
        }
        this.nextButtonIndex = nextIndex;
        this.init(layouts.toArray(new VROptionLayout[0]), false);
    }

    protected void init(VRSettings.VrOptions[] settings, boolean clear) {
        VROptionEntry[] entries = new VROptionEntry[settings.length];
        for (int i = 0; i < settings.length; ++i) {
            entries[i] = new VROptionEntry(settings[i]);
        }
        this.init(entries, clear);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.reinit) {
            VRSettings.VrOptions vrOptions;
            this.reinit = false;
            GuiEventListener guiEventListener = this.m_7222_();
            if (guiEventListener instanceof GuiVROption) {
                GuiVROption option = (GuiVROption)guiEventListener;
                vrOptions = option.getOption();
            } else {
                vrOptions = null;
            }
            VRSettings.VrOptions selected = vrOptions;
            this.m_7856_();
            if (selected != null) {
                GuiEventListener newButton = this.m_6702_().stream().filter(listener -> {
                    GuiVROption option;
                    return listener instanceof GuiVROption && (option = (GuiVROption)listener).getOption() == selected;
                }).findFirst().orElse(null);
                this.m_7522_(newButton);
            }
        }
        this.m_280273_(guiGraphics);
        if (this.visibleList != null) {
            this.visibleList.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)this.vrTitle), this.f_96543_ / 2, 15, -1);
        if (this.btnDefaults != null) {
            this.btnDefaults.f_93624_ = this.drawDefaultButtons;
        }
        if (this.btnDone != null) {
            this.btnDone.f_93624_ = this.drawDefaultButtons;
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void actionPerformed(AbstractWidget widget) {
    }

    protected void actionPerformedRightClick(AbstractWidget widget) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        GuiEventListener guiEventListener;
        boolean success = super.m_6375_(mouseX, mouseY, button);
        if (success && (guiEventListener = this.m_7222_()) instanceof AbstractWidget) {
            AbstractWidget widget = (AbstractWidget)guiEventListener;
            if (button == 0) {
                this.actionPerformed(widget);
            } else if (button == 1) {
                this.actionPerformedRightClick(widget);
            }
        } else if (this.visibleList != null) {
            return this.visibleList.m_6375_(mouseX, mouseY, button);
        }
        return success;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.visibleList != null ? this.visibleList.m_6348_(mouseX, mouseY, button) : super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.visibleList != null ? this.visibleList.m_7979_(mouseX, mouseY, button, dragX, dragY) : super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (this.visibleList != null) {
            this.visibleList.m_6050_(mouseX, mouseY, scrollY);
        }
        return super.m_6050_(mouseX, mouseY, scrollY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (!this.onDoneClicked()) {
                this.dataHolder.vrSettings.saveOptions();
                this.f_96541_.m_91152_(this.lastScreen);
            }
            return true;
        }
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            GuiEventListener guiEventListener = this.m_7222_();
            if (guiEventListener instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)guiEventListener;
                this.actionPerformed(widget);
            }
            return true;
        }
        return this.visibleList != null && this.visibleList.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        return this.visibleList != null && this.visibleList.m_5534_(codePoint, modifiers) || super.m_5534_(codePoint, modifiers);
    }

    private void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        GuiVROption guiHover;
        GuiEventListener hover = null;
        if (this.f_96541_.m_264529_().m_264505_()) {
            hover = this.m_7222_();
        }
        if (hover == null) {
            for (GuiEventListener child : this.m_6702_()) {
                AbstractWidget widget;
                if (!(child instanceof AbstractWidget) || !this.isMouseOver(widget = (AbstractWidget)child, mouseX, mouseY)) continue;
                hover = child;
            }
        }
        if (hover instanceof GuiVROption && (guiHover = (GuiVROption)hover).getOption() != null && this.f_262730_ == null) {
            TooltipRenderer.renderTooltip(guiGraphics, TooltipUtil.getClientConfigTooltip(guiHover.getOption()), this.f_96543_ / 2, guiHover.m_252907_(), guiHover.m_93694_());
        }
    }

    private boolean isMouseOver(AbstractWidget widget, double mouseX, double mouseY) {
        return widget.f_93624_ && mouseX >= (double)widget.m_252754_() && mouseY >= (double)widget.m_252907_() && mouseX < (double)(widget.m_252754_() + widget.m_5711_()) && mouseY < (double)(widget.m_252907_() + widget.m_93694_());
    }
}

