/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdVector2;
import org.lwjgl.openvr.HmdVector3;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VROverlayIntersectionResults_t")
public class VROverlayIntersectionResults
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VPOINT;
    public static final int VNORMAL;
    public static final int VUVS;
    public static final int FDISTANCE;

    public VROverlayIntersectionResults(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VROverlayIntersectionResults.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vPoint() {
        return VROverlayIntersectionResults.nvPoint(this.address());
    }

    public VROverlayIntersectionResults vPoint(Consumer<HmdVector3> consumer) {
        consumer.accept(this.vPoint());
        return this;
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vNormal() {
        return VROverlayIntersectionResults.nvNormal(this.address());
    }

    public VROverlayIntersectionResults vNormal(Consumer<HmdVector3> consumer) {
        consumer.accept(this.vNormal());
        return this;
    }

    @NativeType(value="HmdVector2_t")
    public HmdVector2 vUVs() {
        return VROverlayIntersectionResults.nvUVs(this.address());
    }

    public VROverlayIntersectionResults vUVs(Consumer<HmdVector2> consumer) {
        consumer.accept(this.vUVs());
        return this;
    }

    public float fDistance() {
        return VROverlayIntersectionResults.nfDistance(this.address());
    }

    public static VROverlayIntersectionResults malloc() {
        return (VROverlayIntersectionResults)VROverlayIntersectionResults.wrap(VROverlayIntersectionResults.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VROverlayIntersectionResults calloc() {
        return (VROverlayIntersectionResults)VROverlayIntersectionResults.wrap(VROverlayIntersectionResults.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VROverlayIntersectionResults create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VROverlayIntersectionResults)VROverlayIntersectionResults.wrap(VROverlayIntersectionResults.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VROverlayIntersectionResults create(long address) {
        return (VROverlayIntersectionResults)VROverlayIntersectionResults.wrap(VROverlayIntersectionResults.class, (long)address);
    }

    @Nullable
    public static VROverlayIntersectionResults createSafe(long address) {
        return address == 0L ? null : (VROverlayIntersectionResults)VROverlayIntersectionResults.wrap(VROverlayIntersectionResults.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VROverlayIntersectionResults.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VROverlayIntersectionResults.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VROverlayIntersectionResults.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VROverlayIntersectionResults.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VROverlayIntersectionResults.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VROverlayIntersectionResults.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VROverlayIntersectionResults.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VROverlayIntersectionResults mallocStack() {
        return VROverlayIntersectionResults.mallocStack(MemoryStack.stackGet());
    }

    public static VROverlayIntersectionResults callocStack() {
        return VROverlayIntersectionResults.callocStack(MemoryStack.stackGet());
    }

    public static VROverlayIntersectionResults mallocStack(MemoryStack stack) {
        return (VROverlayIntersectionResults)VROverlayIntersectionResults.wrap(VROverlayIntersectionResults.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VROverlayIntersectionResults callocStack(MemoryStack stack) {
        return (VROverlayIntersectionResults)VROverlayIntersectionResults.wrap(VROverlayIntersectionResults.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VROverlayIntersectionResults.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VROverlayIntersectionResults.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VROverlayIntersectionResults.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VROverlayIntersectionResults.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static HmdVector3 nvPoint(long struct) {
        return HmdVector3.create(struct + (long)VPOINT);
    }

    public static HmdVector3 nvNormal(long struct) {
        return HmdVector3.create(struct + (long)VNORMAL);
    }

    public static HmdVector2 nvUVs(long struct) {
        return HmdVector2.create(struct + (long)VUVS);
    }

    public static float nfDistance(long struct) {
        return UNSAFE.getFloat(null, struct + (long)FDISTANCE);
    }

    static {
        Struct.Layout layout = VROverlayIntersectionResults.__struct((Struct.Member[])new Struct.Member[]{VROverlayIntersectionResults.__member((int)HmdVector3.SIZEOF, (int)HmdVector3.ALIGNOF), VROverlayIntersectionResults.__member((int)HmdVector3.SIZEOF, (int)HmdVector3.ALIGNOF), VROverlayIntersectionResults.__member((int)HmdVector2.SIZEOF, (int)HmdVector2.ALIGNOF), VROverlayIntersectionResults.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VPOINT = layout.offsetof(0);
        VNORMAL = layout.offsetof(1);
        VUVS = layout.offsetof(2);
        FDISTANCE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VROverlayIntersectionResults, Buffer>
    implements NativeResource {
        private static final VROverlayIntersectionResults ELEMENT_FACTORY = VROverlayIntersectionResults.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VROverlayIntersectionResults getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vPoint() {
            return VROverlayIntersectionResults.nvPoint(this.address());
        }

        public Buffer vPoint(Consumer<HmdVector3> consumer) {
            consumer.accept(this.vPoint());
            return this;
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vNormal() {
            return VROverlayIntersectionResults.nvNormal(this.address());
        }

        public Buffer vNormal(Consumer<HmdVector3> consumer) {
            consumer.accept(this.vNormal());
            return this;
        }

        @NativeType(value="HmdVector2_t")
        public HmdVector2 vUVs() {
            return VROverlayIntersectionResults.nvUVs(this.address());
        }

        public Buffer vUVs(Consumer<HmdVector2> consumer) {
            consumer.accept(this.vUVs());
            return this;
        }

        public float fDistance() {
            return VROverlayIntersectionResults.nfDistance(this.address());
        }
    }
}

