/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.vivecraft.client.gui.framework.screens.GuiListScreen;
import org.vivecraft.client.gui.framework.widgets.SettingsList;

public class GuiSelectionListScreen<T>
extends GuiListScreen {
    private final Supplier<List<T>> valuesSupplier;
    private final Function<T, Component> componentSupplier;
    private final Function<T, String> categorySupplier;
    private final Consumer<T> consumer;
    private final boolean resettable;
    private final Function<T, AbstractWidget> widgetSupplier;

    public GuiSelectionListScreen(Component title, Screen lastScreen, Supplier<List<T>> valuesSupplier, Function<T, Component> componentSupplier, @Nullable Function<T, String> categorySupplier, Consumer<T> consumer, boolean resettable, @Nullable Function<T, AbstractWidget> widgetSupplier) {
        super(title, lastScreen);
        this.valuesSupplier = valuesSupplier;
        this.componentSupplier = componentSupplier;
        this.categorySupplier = categorySupplier != null ? categorySupplier : item -> "";
        this.consumer = consumer;
        this.resettable = resettable;
        this.widgetSupplier = widgetSupplier != null ? widgetSupplier : item -> null;
    }

    @Override
    protected void addLowerButtons(int top) {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155, top, 150, 20, (Component)new TranslatableComponent(this.resettable ? "controls.reset" : "vivecraft.gui.clear"), p -> {
            this.consumer.accept(null);
            this.m_7379_();
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, top, 150, 20, (Component)new TranslatableComponent("gui.cancel"), p -> this.m_7379_()));
    }

    @Override
    protected List<SettingsList.BaseEntry> getEntries() {
        LinkedList<SettingsList.BaseEntry> entries = new LinkedList<SettingsList.BaseEntry>();
        String currentCategory = "";
        SettingsList.GroupedEntry activeCategory = null;
        for (T item : this.valuesSupplier.get()) {
            String newCategory = this.categorySupplier.apply(item);
            if (!currentCategory.equals(newCategory)) {
                currentCategory = newCategory;
                activeCategory = new SettingsList.GroupedEntry((Component)new TranslatableComponent(newCategory));
                entries.add(activeCategory);
            }
            SettingsList.SelectableEntry entry = new SettingsList.SelectableEntry(this.componentSupplier.apply(item), this.widgetSupplier.apply(item), () -> {
                this.consumer.accept(item);
                this.m_7379_();
            });
            if (activeCategory != null) {
                activeCategory.add(entry);
                continue;
            }
            entries.add(entry);
        }
        return entries;
    }
}

