/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.ComponentCollector;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class TextUtils {
    private static final char[] ILLEGAL_CHARS = new char[]{'\"', '<', '>', '|', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ':', '*', '?', '\\', '/'};

    public static String sanitizeFileName(String fileName) {
        StringBuilder sanitized = new StringBuilder();
        for (int i = 0; i < fileName.length(); ++i) {
            char ch = fileName.charAt(i);
            if (Arrays.binarySearch(ILLEGAL_CHARS, ch) < 0) {
                sanitized.append(ch);
                continue;
            }
            sanitized.append('_');
        }
        return sanitized.toString();
    }

    public static void wordWrap(String in, int length, ArrayList<String> wrapped) {
        if (length == 0) {
            wrapped.add(in);
            return;
        }
        String newLine = "\n";
        boolean quickExit = false;
        if ((in = in.replace("\r", "")).length() < length) {
            quickExit = true;
            length = in.length();
        }
        if (in.substring(0, length).contains(newLine)) {
            String wrappedLine = in.substring(0, in.indexOf(newLine)).trim();
            wrapped.add(wrappedLine);
            TextUtils.wordWrap(in.substring(in.indexOf(newLine) + 1), length, wrapped);
        } else if (quickExit) {
            wrapped.add(in);
        } else {
            int spaceIndex = Math.max(Math.max(in.lastIndexOf(" ", length), in.lastIndexOf("\t", length)), in.lastIndexOf("-", length));
            if (spaceIndex == -1) {
                spaceIndex = length;
            }
            String wrappedLine = in.substring(0, spaceIndex).trim();
            wrapped.add(wrappedLine);
            TextUtils.wordWrap(in.substring(spaceIndex), length, wrapped);
        }
    }

    public static List<FormattedText> wrapText(FormattedText text, int width, Font font, @Nullable FormattedText linePrefix) {
        ComponentCollector componentcollector = new ComponentCollector();
        text.m_7451_((style, str) -> {
            componentcollector.m_90675_(FormattedText.m_130762_((String)str, (Style)style));
            return Optional.empty();
        }, Style.f_131099_);
        ArrayList list = Lists.newArrayList();
        font.m_92865_().m_92393_(componentcollector.m_90677_(), width, Style.f_131099_, (lineText, sameLine) -> list.add(sameLine != false && linePrefix != null ? FormattedText.m_130773_((FormattedText[])new FormattedText[]{linePrefix, lineText}) : lineText));
        return list.isEmpty() ? Lists.newArrayList((Object[])new FormattedText[]{FormattedText.f_130760_}) : list;
    }

    public static List<ChatFormatting> styleToFormats(Style style) {
        if (style.m_131179_()) {
            return new ArrayList<ChatFormatting>();
        }
        ArrayList<ChatFormatting> arraylist = new ArrayList<ChatFormatting>();
        if (style.m_131135_() != null) {
            arraylist.add(ChatFormatting.m_126657_((String)style.m_131135_().m_131274_()));
        }
        if (style.m_131154_()) {
            arraylist.add(ChatFormatting.BOLD);
        }
        if (style.m_131161_()) {
            arraylist.add(ChatFormatting.ITALIC);
        }
        if (style.m_131168_()) {
            arraylist.add(ChatFormatting.STRIKETHROUGH);
        }
        if (style.m_131171_()) {
            arraylist.add(ChatFormatting.UNDERLINE);
        }
        if (style.m_131176_()) {
            arraylist.add(ChatFormatting.OBFUSCATED);
        }
        return arraylist;
    }

    public static String formatsToString(List<ChatFormatting> formats) {
        if (formats.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        formats.forEach(builder::append);
        return builder.toString();
    }

    public static String styleToFormatString(Style style) {
        return TextUtils.formatsToString(TextUtils.styleToFormats(style));
    }

    public static Component throwableToComponent(Throwable throwable) {
        TextComponent result = new TextComponent(throwable.getClass().getName() + (String)(throwable.getMessage() == null ? "" : ": " + throwable.getMessage()));
        for (StackTraceElement element : throwable.getStackTrace()) {
            result.m_7220_((Component)new TextComponent("\n" + element.toString()));
        }
        return result;
    }

    static {
        Arrays.sort(ILLEGAL_CHARS);
    }
}

