/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.screenhandlers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.data.CloseKeyboardContext;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MethodHolder;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.WindowExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.HandedKeyBinding;
import org.vivecraft.client_vr.provider.InputSimulator;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.AutoCalibration;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;

public class GuiHandler {
    public static final Minecraft MC = Minecraft.m_91087_();
    public static final ClientDataHolderVR DH = ClientDataHolderVR.getInstance();
    private static double CONTROLLER_MOUSE_X = -1.0;
    private static double CONTROLLER_MOUSE_Y = -1.0;
    private static boolean CONTROLLER_MOUSE_VALID;
    private static boolean LAST_PRESSED_LEFT_CLICK;
    private static boolean LAST_PRESSED_RIGHT_CLICK;
    private static boolean LAST_PRESSED_MIDDLE_CLICK;
    private static boolean LAST_PRESSED_SHIFT;
    private static boolean LAST_PRESSED_CRTL;
    private static boolean LAST_PRESSED_ALT;
    public static final KeyMapping KEY_LEFT_CLICK;
    public static final KeyMapping KEY_RIGHT_CLICK;
    public static final KeyMapping KEY_MIDDLE_CLICK;
    public static final KeyMapping KEY_SHIFT;
    public static final KeyMapping KEY_CTRL;
    public static final KeyMapping KEY_ALT;
    public static final KeyMapping KEY_SCROLL_UP;
    public static final KeyMapping KEY_SCROLL_DOWN;
    public static final KeyMapping KEY_SCROLL_AXIS;
    public static final HandedKeyBinding KEY_KEYBOARD_CLICK;
    public static final HandedKeyBinding KEY_KEYBOARD_SHIFT;
    public static RenderTarget GUI_FRAMEBUFFER;
    public static boolean GUI_APPEAR_OVER_BLOCK_ACTIVE;
    public static float GUI_SCALE;
    public static float GUI_SCALE_APPLIED;
    public static Vector3f GUI_POS_ROOM;
    public static Matrix4f GUI_ROTATION_ROOM;
    public static Vector3f GUI_RENDER_POS_ROOM;
    public static Vector3f GUI_OFFSET_LOCAL;
    public static Matrix4f GUI_RENDER_ROTATION_ROOM;
    public static Matrix4f GUI_ROTATION_PLAYER_MODEL;
    public static Vec3 GUI_POS_PLAYER_MODEL;
    public static boolean HUD_POPUP;
    public static int GUI_WIDTH;
    public static int GUI_HEIGHT;
    public static int GUI_SCALE_FACTOR_MAX;
    public static int GUI_SCALE_FACTOR;
    public static int SCALED_WIDTH;
    public static int SCALED_HEIGHT;
    public static int SCALED_WIDTH_MAX;
    public static int SCALED_HEIGHT_MAX;
    private static int PREVIOUS_GUI_SCALE;

    public static int calculateScale(int scaleIn, boolean forceUnicode, int framebufferWidth, int framebufferHeight) {
        int maxScale;
        int scale = 1;
        for (maxScale = 1; maxScale < framebufferWidth && maxScale < framebufferHeight && framebufferWidth / (maxScale + 1) >= 320 && framebufferHeight / (maxScale + 1) >= 240; ++maxScale) {
            if (scale >= scaleIn && scaleIn != 0) continue;
            ++scale;
        }
        if (forceUnicode) {
            if (scale % 2 != 0) {
                ++scale;
            }
            if (maxScale % 2 != 0) {
                ++maxScale;
            }
        }
        GUI_SCALE_FACTOR_MAX = maxScale;
        SCALED_WIDTH = Mth.m_14167_((float)((float)framebufferWidth / (float)scale));
        SCALED_WIDTH_MAX = Mth.m_14167_((float)((float)framebufferWidth / (float)maxScale));
        SCALED_HEIGHT = Mth.m_14167_((float)((float)framebufferHeight / (float)scale));
        SCALED_HEIGHT_MAX = Mth.m_14167_((float)((float)framebufferHeight / (float)maxScale));
        return scale;
    }

    public static boolean updateResolution() {
        int newGuiScale;
        int oldWidth = GUI_WIDTH;
        int oldHeight = GUI_HEIGHT;
        int oldGuiScale = GUI_SCALE_FACTOR;
        GUI_WIDTH = GuiHandler.DH.vrSettings.doubleGUIResolution ? 2560 : 1280;
        GUI_HEIGHT = GuiHandler.DH.vrSettings.doubleGUIResolution ? 1440 : 720;
        int n = newGuiScale = GuiHandler.DH.vrSettings.doubleGUIResolution ? GuiHandler.DH.vrSettings.guiScale : (int)Math.ceil((float)GuiHandler.DH.vrSettings.guiScale * 0.5f);
        if (oldWidth != GUI_WIDTH || PREVIOUS_GUI_SCALE != newGuiScale) {
            GUI_SCALE_FACTOR = GuiHandler.calculateScale(newGuiScale, false, GUI_WIDTH, GUI_HEIGHT);
            PREVIOUS_GUI_SCALE = newGuiScale;
        }
        if (oldWidth != GUI_WIDTH) {
            InputSimulator.setMousePos(GuiHandler.MC.f_91067_.m_91589_() * (double)((WindowExtension)MC.m_91268_()).vivecraft$getActualScreenWidth() / (double)oldWidth, GuiHandler.MC.f_91067_.m_91594_() * (double)((WindowExtension)MC.m_91268_()).vivecraft$getActualScreenHeight() / (double)oldHeight);
            CONTROLLER_MOUSE_X *= (double)GUI_WIDTH / (double)oldWidth;
            CONTROLLER_MOUSE_Y *= (double)GUI_HEIGHT / (double)oldHeight;
            return true;
        }
        return oldGuiScale != GUI_SCALE_FACTOR;
    }

    public static void processGui() {
        if (GUI_ROTATION_ROOM == null) {
            return;
        }
        if (GuiHandler.DH.vrSettings.seated) {
            return;
        }
        if (!MCVR.get().isControllerTracking(0)) {
            return;
        }
        if (GuiHandler.MC.f_91080_ == null && GuiHandler.MC.f_91067_.m_91600_()) {
            return;
        }
        Vector2f tex = GuiHandler.getTexCoordsForCursor(GUI_POS_ROOM, GUI_ROTATION_ROOM, GUI_SCALE, GuiHandler.DH.vrPlayer.vrdata_room_pre.getController(0));
        float u = tex.x;
        float v = tex.y;
        if (u < 0.0f || v < 0.0f || u > 1.0f || v > 1.0f) {
            CONTROLLER_MOUSE_X = -1.0;
            CONTROLLER_MOUSE_Y = -1.0;
            CONTROLLER_MOUSE_VALID = false;
        } else if (!CONTROLLER_MOUSE_VALID) {
            CONTROLLER_MOUSE_X = (int)(u * (float)MC.m_91268_().m_85441_());
            CONTROLLER_MOUSE_Y = (int)(v * (float)MC.m_91268_().m_85442_());
            CONTROLLER_MOUSE_VALID = true;
        } else {
            float newX = (int)(u * (float)MC.m_91268_().m_85441_());
            float newY = (int)(v * (float)MC.m_91268_().m_85442_());
            CONTROLLER_MOUSE_X = CONTROLLER_MOUSE_X * (double)0.7f + (double)(newX * 0.3f);
            CONTROLLER_MOUSE_Y = CONTROLLER_MOUSE_Y * (double)0.7f + (double)(newY * 0.3f);
            CONTROLLER_MOUSE_VALID = true;
        }
        if (CONTROLLER_MOUSE_VALID) {
            InputSimulator.setMousePos(CONTROLLER_MOUSE_X * ((double)((WindowExtension)MC.m_91268_()).vivecraft$getActualScreenWidth() / (double)MC.m_91268_().m_85443_()), CONTROLLER_MOUSE_Y * ((double)((WindowExtension)MC.m_91268_()).vivecraft$getActualScreenHeight() / (double)MC.m_91268_().m_85444_()));
        }
    }

    public static Vector2f getTexCoordsForCursor(Vector3f guiPos_room, Matrix4f guiRotation_room, float guiScale, VRData.VRDevicePose controller) {
        Vector3f guiPos;
        Vector3f guiTopLeft;
        float intersectDist;
        Vector3f controllerPos = controller.getPositionF();
        Vector3f controllerDir = controller.getDirection();
        Vector3f guiNormal = guiRotation_room.transformDirection(MathUtils.FORWARD, new Vector3f());
        Vector3f guiRight = guiRotation_room.transformDirection(MathUtils.LEFT, new Vector3f());
        Vector3f guiUp = guiRotation_room.transformDirection(MathUtils.UP, new Vector3f());
        float guiDotController = guiNormal.dot((Vector3fc)controllerDir);
        if (Math.abs(guiDotController) > 1.0E-5f && (intersectDist = -guiNormal.dot((Vector3fc)controllerPos.sub((Vector3fc)(guiTopLeft = (guiPos = new Vector3f((Vector3fc)guiPos_room)).sub((Vector3fc)guiUp.mul(0.5f, new Vector3f())).sub((Vector3fc)guiRight.mul(0.5f, new Vector3f()))), new Vector3f())) / guiDotController) > 0.0f) {
            Vector3f pointOnPlane = controllerPos.add((Vector3fc)controllerDir.mul(intersectDist), new Vector3f());
            pointOnPlane.sub((Vector3fc)guiTopLeft);
            float u = pointOnPlane.dot((Vector3fc)guiRight);
            float v = pointOnPlane.dot((Vector3fc)guiUp);
            float aspect = (float)MC.m_91268_().m_85446_() / (float)MC.m_91268_().m_85445_();
            u = (u - 0.5f) / 1.5f / guiScale + 0.5f;
            v = (v - 0.5f) / aspect / 1.5f / guiScale + 0.5f;
            v = 1.0f - v;
            return new Vector2f(u, v);
        }
        return new Vector2f(-1.0f, -1.0f);
    }

    public static void processBindingsGui() {
        boolean mouseValid;
        boolean bl = mouseValid = CONTROLLER_MOUSE_X >= 0.0 && CONTROLLER_MOUSE_X < (double)MC.m_91268_().m_85443_() && CONTROLLER_MOUSE_Y >= 0.0 && CONTROLLER_MOUSE_Y < (double)MC.m_91268_().m_85443_();
        if (KEY_LEFT_CLICK.m_90859_() && GuiHandler.MC.f_91080_ != null && mouseValid) {
            InputSimulator.pressMouse(0);
            LAST_PRESSED_LEFT_CLICK = true;
        }
        if (!KEY_LEFT_CLICK.m_90857_() && LAST_PRESSED_LEFT_CLICK) {
            InputSimulator.releaseMouse(0);
            LAST_PRESSED_LEFT_CLICK = false;
        }
        if (KEY_RIGHT_CLICK.m_90859_() && GuiHandler.MC.f_91080_ != null && mouseValid) {
            InputSimulator.pressMouse(1);
            LAST_PRESSED_RIGHT_CLICK = true;
        }
        if (!KEY_RIGHT_CLICK.m_90857_() && LAST_PRESSED_RIGHT_CLICK) {
            InputSimulator.releaseMouse(1);
            LAST_PRESSED_RIGHT_CLICK = false;
        }
        if (KEY_MIDDLE_CLICK.m_90859_() && GuiHandler.MC.f_91080_ != null && mouseValid) {
            InputSimulator.pressMouse(2);
            LAST_PRESSED_MIDDLE_CLICK = true;
        }
        if (!KEY_MIDDLE_CLICK.m_90857_() && LAST_PRESSED_MIDDLE_CLICK) {
            InputSimulator.releaseMouse(2);
            LAST_PRESSED_MIDDLE_CLICK = false;
        }
        if (KEY_SHIFT.m_90859_() && GuiHandler.MC.f_91080_ != null) {
            InputSimulator.pressKey(340);
            LAST_PRESSED_SHIFT = true;
        }
        if (!KEY_SHIFT.m_90857_() && LAST_PRESSED_SHIFT) {
            InputSimulator.releaseKey(340);
            LAST_PRESSED_SHIFT = false;
        }
        if (KEY_CTRL.m_90859_() && GuiHandler.MC.f_91080_ != null) {
            InputSimulator.pressKey(341);
            LAST_PRESSED_CRTL = true;
        }
        if (!KEY_CTRL.m_90857_() && LAST_PRESSED_CRTL) {
            InputSimulator.releaseKey(341);
            LAST_PRESSED_CRTL = false;
        }
        if (KEY_ALT.m_90859_() && GuiHandler.MC.f_91080_ != null) {
            InputSimulator.pressKey(342);
            LAST_PRESSED_ALT = true;
        }
        if (!KEY_ALT.m_90857_() && LAST_PRESSED_ALT) {
            InputSimulator.releaseKey(342);
            LAST_PRESSED_ALT = false;
        }
        if (KEY_SCROLL_UP.m_90859_() && GuiHandler.MC.f_91080_ != null) {
            InputSimulator.scrollMouse(0.0, 4.0);
        }
        if (KEY_SCROLL_DOWN.m_90859_() && GuiHandler.MC.f_91080_ != null) {
            InputSimulator.scrollMouse(0.0, -4.0);
        }
    }

    public static void onScreenChanged(Screen previousGuiScreen, Screen newScreen, boolean unpressKeys) {
        GuiHandler.onScreenChanged(previousGuiScreen, newScreen, unpressKeys, false);
    }

    public static void onScreenChanged(Screen previousGuiScreen, Screen newScreen, boolean unpressKeys, boolean infrontOfHand) {
        if (!VRState.VR_RUNNING) {
            return;
        }
        if (unpressKeys) {
            GuiHandler.DH.vr.ignorePressesNextFrame = true;
        }
        if (newScreen == null) {
            GUI_POS_ROOM = null;
            GUI_ROTATION_ROOM = null;
            GUI_SCALE = 1.0f;
            if (KeyboardHandler.KEYBOARD_FOR_GUI) {
                KeyboardHandler.hideOverlay(CloseKeyboardContext.ACTION_COMPLETE);
            }
        } else {
            RadialHandler.setOverlayShowing(false, null);
        }
        if (GuiHandler.MC.f_91073_ == null || newScreen instanceof WinScreen) {
            GuiHandler.DH.vrSettings.worldRotationCached = GuiHandler.DH.vrSettings.worldRotation;
            GuiHandler.DH.vrSettings.worldRotation = 0.0f;
        } else if (GuiHandler.DH.vrSettings.worldRotationCached != 0.0f) {
            GuiHandler.DH.vrSettings.worldRotation = GuiHandler.DH.vrSettings.worldRotationCached;
            GuiHandler.DH.vrSettings.worldRotationCached = 0.0f;
        }
        boolean staticScreen = MethodHolder.willBeInMenuRoom(newScreen);
        if (staticScreen &= !GuiHandler.DH.vrSettings.seated && !GuiHandler.DH.vrSettings.menuAlwaysFollowFace) {
            GUI_SCALE = 2.0f;
            Vector2fc playArea = MCVR.get().getPlayAreaSize();
            GUI_POS_ROOM = new Vector3f(0.02f, 1.3f, -Math.max(playArea != null ? playArea.y() * 0.5f : 0.0f, 1.5f));
            GUI_ROTATION_ROOM = new Matrix4f();
            return;
        }
        if (previousGuiScreen == null && newScreen != null || newScreen instanceof ChatScreen || newScreen instanceof BookEditScreen || newScreen instanceof SignEditScreen) {
            VRData.VRDevicePose facingDevice;
            boolean isBlockScreen = newScreen instanceof AbstractContainerScreen && GuiHandler.MC.f_91077_ != null && GuiHandler.MC.f_91077_.m_6662_() == HitResult.Type.BLOCK;
            boolean isEntityScreen = newScreen instanceof AbstractContainerScreen && GuiHandler.MC.f_91077_ instanceof EntityHitResult && ((EntityHitResult)GuiHandler.MC.f_91077_).m_82443_() instanceof Container;
            VRData.VRDevicePose vRDevicePose = facingDevice = infrontOfHand ? GuiHandler.DH.vrPlayer.vrdata_room_pre.getController(0) : GuiHandler.DH.vrPlayer.vrdata_room_pre.hmd;
            if (GUI_APPEAR_OVER_BLOCK_ACTIVE && (isBlockScreen || isEntityScreen) && GuiHandler.DH.vrSettings.guiAppearOverBlock) {
                Vec3 sourcePos;
                if (isEntityScreen) {
                    EntityHitResult entityHitResult = (EntityHitResult)GuiHandler.MC.f_91077_;
                    sourcePos = entityHitResult.m_82443_().m_20182_();
                } else {
                    BlockHitResult blockHitResult = (BlockHitResult)GuiHandler.MC.f_91077_;
                    sourcePos = new Vec3((double)blockHitResult.m_82425_().m_123341_() + 0.5, (double)blockHitResult.m_82425_().m_123342_(), (double)blockHitResult.m_82425_().m_123343_() + 0.5);
                }
                Vector3f roomPos = VRPlayer.worldToRoomPos(sourcePos, GuiHandler.DH.vrPlayer.vrdata_world_pre);
                Vector3f hmdPos = GuiHandler.DH.vrPlayer.vrdata_room_pre.hmd.getPositionF();
                float distance = roomPos.sub((Vector3fc)hmdPos).length();
                GUI_SCALE = (float)Math.sqrt(distance);
                Vec3 sourcePosWorld = new Vec3(sourcePos.f_82479_, sourcePos.f_82480_ + (double)1.1f + (double)(GUI_SCALE * 0.25f), sourcePos.f_82481_);
                GUI_POS_ROOM = VRPlayer.worldToRoomPos(sourcePosWorld, GuiHandler.DH.vrPlayer.vrdata_world_pre);
            } else {
                Vector3f offset = new Vector3f(0.0f, 0.0f, -2.0f);
                if (newScreen instanceof ChatScreen) {
                    offset.set(0.0f, 0.5f, -2.0f);
                } else if (newScreen instanceof BookEditScreen || newScreen instanceof SignEditScreen) {
                    offset.set(0.0f, 0.25f, -2.0f);
                }
                Vector3f hmdPos = facingDevice.getPositionF();
                Vector3f look = facingDevice.getCustomVector((Vector3fc)offset);
                GUI_POS_ROOM = new Vector3f(look.x * 0.5f + hmdPos.x, look.y * 0.5f + hmdPos.y, look.z * 0.5f + hmdPos.z);
                if (GuiHandler.DH.vrSettings.physicalKeyboard && KeyboardHandler.SHOWING && GuiHandler.GUI_POS_ROOM.y < hmdPos.y + 0.2f) {
                    GUI_POS_ROOM.set(GuiHandler.GUI_POS_ROOM.x, hmdPos.y + 0.2f, GuiHandler.GUI_POS_ROOM.z);
                }
            }
            Vector3f hmdPos = facingDevice.getPositionF();
            Vector3f look = GUI_POS_ROOM.sub((Vector3fc)hmdPos, new Vector3f());
            float pitch = (float)Math.asin(look.y / look.length());
            float yaw = (float)Math.PI + (float)Math.atan2(look.x, look.z);
            GUI_ROTATION_ROOM = new Matrix4f().rotationY(yaw);
            GUI_ROTATION_ROOM.rotateX(pitch);
        }
        KeyboardHandler.orientOverlay(newScreen != null);
    }

    public static Vec3 applyGUIModelView(RenderPass currentPass, PoseStack poseStack) {
        MC.m_91307_().m_6180_("applyGUIModelView");
        if (GuiHandler.MC.f_91080_ != null && GUI_POS_ROOM == null) {
            GuiHandler.onScreenChanged(null, GuiHandler.MC.f_91080_, false);
        } else if (GuiHandler.MC.f_91080_ == null && !GuiHandler.MC.f_91067_.m_91600_()) {
            if (GUI_POS_ROOM == null) {
                GuiHandler.onScreenChanged(null, new Screen(TextComponent.f_131282_){}, false, true);
            }
        } else if (GuiHandler.MC.f_91080_ == null && GUI_POS_ROOM != null) {
            GuiHandler.onScreenChanged(null, null, false);
        }
        Vec3 guipos = null;
        Matrix4f guirot = GUI_ROTATION_ROOM;
        Vector3f guilocal = new Vector3f();
        float scale = GUI_SCALE;
        if (GUI_POS_ROOM == null) {
            guirot = null;
            scale = 1.0f;
            if (!(GuiHandler.MC.f_91073_ == null || GuiHandler.MC.f_91080_ != null && GuiHandler.DH.vrSettings.floatInventory)) {
                int side = 1;
                if (GuiHandler.DH.vrSettings.reverseHands) {
                    side = -1;
                }
                if (GuiHandler.DH.vrSettings.seated || GuiHandler.DH.vrSettings.vrHudLockMode == VRSettings.HUDLock.HEAD) {
                    guirot = new Matrix4f().rotationY(GuiHandler.DH.vrPlayer.vrdata_world_render.rotation_radians);
                    Vec3 position = GuiHandler.DH.vrPlayer.vrdata_world_render.hmd.getPosition();
                    Vector3f direction = GuiHandler.DH.vrPlayer.vrdata_world_render.hmd.getDirection();
                    if (GuiHandler.DH.vrSettings.seated && GuiHandler.DH.vrSettings.seatedHudAltMode) {
                        direction = GuiHandler.DH.vrPlayer.vrdata_world_render.getController(0).getDirection();
                        guirot = guirot.mul(GuiHandler.DH.vr.getAimRotation(0), guirot);
                    } else {
                        guirot = guirot.mul((Matrix4fc)GuiHandler.DH.vr.hmdRotation, guirot);
                    }
                    guipos = new Vec3(position.f_82479_ + (double)(direction.x * GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale * GuiHandler.DH.vrSettings.hudDistance), position.f_82480_ + (double)(direction.y * GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale * GuiHandler.DH.vrSettings.hudDistance), position.f_82481_ + (double)(direction.z * GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale * GuiHandler.DH.vrSettings.hudDistance));
                    scale = GuiHandler.DH.vrSettings.hudScale;
                } else {
                    boolean modelArms;
                    boolean bl = modelArms = GUI_POS_PLAYER_MODEL != Vec3.f_82478_ && GuiHandler.DH.vrSettings.shouldRenderSelf && GuiHandler.DH.vrSettings.modelArmsMode == VRSettings.ModelArmsMode.COMPLETE;
                    if (modelArms) {
                        guirot = new Matrix4f().set3x3((Matrix4fc)GUI_ROTATION_PLAYER_MODEL);
                        guipos = GUI_POS_PLAYER_MODEL;
                    } else {
                        guirot = new Matrix4f().rotationY(GuiHandler.DH.vrPlayer.vrdata_world_render.rotation_radians);
                        guirot.mul(GuiHandler.DH.vr.getAimRotation(1));
                        guipos = RenderHelper.getControllerRenderPos(1);
                    }
                    HUD_POPUP = true;
                    if (GuiHandler.DH.vrSettings.vrHudLockMode == VRSettings.HUDLock.HAND) {
                        scale = 0.58823526f;
                        guirot.rotateX(-0.62831855f);
                        guirot.rotateY(0.31415927f * (float)side);
                        guilocal = new Vector3f(guilocal.x, 0.32f * GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale, guilocal.z);
                    } else {
                        scale = 0.4f;
                        boolean slim = GuiHandler.MC.f_91074_.m_108564_().equals("slim");
                        float xOffset = -0.136f;
                        float yOffset = slim ? 0.085f : 0.055f;
                        float yScaleOffset = slim ? 0.0825f : 0.1125f;
                        float armScale = 0.42f;
                        if (modelArms) {
                            armScale = GuiHandler.DH.vrSettings.playerModelArmsScale;
                            if (GuiHandler.DH.vrSettings.playerModelType == VRSettings.PlayerModelType.VANILLA) {
                                yOffset = 0.11f;
                                yScaleOffset = 0.0575f;
                            }
                        }
                        guilocal.set(xOffset * (float)side, yOffset + yScaleOffset * (1.0f - armScale), (0.12f + 0.02f * GuiHandler.DH.vrSettings.vrHudWristOffset) * armScale);
                        guilocal.mul(GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale);
                        if (modelArms) {
                            float playerScale = AutoCalibration.getPlayerHeight() / 1.52f;
                            scale *= playerScale;
                            guilocal.mul(playerScale);
                        }
                        guirot.rotateZ(1.5707964f * (float)side);
                        guirot.rotateY(1.5707964f * (float)side);
                    }
                }
            }
        } else {
            guipos = VRPlayer.roomToWorldPos((Vector3fc)GUI_POS_ROOM, GuiHandler.DH.vrPlayer.vrdata_world_render);
            guirot = new Matrix4f().rotationY(GuiHandler.DH.vrPlayer.vrdata_world_render.rotation_radians).mul((Matrix4fc)guirot);
        }
        if ((GuiHandler.DH.vrSettings.seated || GuiHandler.DH.vrSettings.menuAlwaysFollowFace) && MethodHolder.isInMenuRoom()) {
            scale = 2.0f;
            Vector3f posAvg = new Vector3f();
            for (Vector3f sample : GuiHandler.DH.vr.hmdPosSamples) {
                posAvg.add((Vector3fc)sample);
            }
            posAvg.div((float)GuiHandler.DH.vr.hmdPosSamples.size());
            float yawAvg = 0.0f;
            Iterator sample = GuiHandler.DH.vr.hmdYawSamples.iterator();
            while (sample.hasNext()) {
                float sample2 = ((Float)sample.next()).floatValue();
                yawAvg += sample2;
            }
            yawAvg /= (float)GuiHandler.DH.vr.hmdYawSamples.size();
            yawAvg = (float)Math.PI / 180 * yawAvg;
            Vector3f dir = new Vector3f(-Mth.m_14031_((float)yawAvg), 0.0f, Mth.m_14089_((float)yawAvg));
            float dist = MethodHolder.isInMenuRoom() ? 2.5f * GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale : GuiHandler.DH.vrSettings.hudDistance;
            posAvg.add(dir.x * dist, dir.y * dist, dir.z * dist);
            Matrix4f guiRotation = new Matrix4f().rotationY((float)Math.PI - yawAvg);
            guirot = guiRotation.rotateY(GuiHandler.DH.vrPlayer.vrdata_world_render.rotation_radians, new Matrix4f());
            guipos = VRPlayer.roomToWorldPos((Vector3fc)posAvg, GuiHandler.DH.vrPlayer.vrdata_world_render);
            GUI_ROTATION_ROOM = guiRotation;
            GUI_SCALE = 2.0f;
            GUI_POS_ROOM = posAvg;
        }
        if (guipos == null) {
            VRSettings.LOGGER.error("Vivecraft: guipos was null, how did that happen. vrRunning: {}: ", (Object)VRState.VR_RUNNING, (Object)new RuntimeException());
            GUI_POS_ROOM = new Vector3f();
            guipos = VRPlayer.roomToWorldPos((Vector3fc)GUI_POS_ROOM, GuiHandler.DH.vrPlayer.vrdata_world_render);
            GUI_ROTATION_ROOM = new Matrix4f();
            guirot = new Matrix4f();
            GUI_SCALE = 1.0f;
        }
        Vec3 eye = GuiHandler.DH.vrPlayer.vrdata_world_render.getEye(GuiHandler.DH.currentPass).getPosition();
        Vec3 translation = guipos.m_82546_(eye);
        poseStack.m_85837_(translation.f_82479_, translation.f_82480_, translation.f_82481_);
        poseStack.m_166854_(MathUtils.toMcMat4((Matrix4fc)guirot));
        poseStack.m_85837_((double)guilocal.x, (double)guilocal.y, (double)guilocal.z);
        GUI_SCALE_APPLIED = scale;
        GUI_OFFSET_LOCAL.set((Vector3fc)guilocal).div(GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale);
        float thescale = scale * GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale;
        poseStack.m_85841_(thescale, thescale, thescale);
        GUI_RENDER_POS_ROOM = VRPlayer.worldToRoomPos(guipos, GuiHandler.DH.vrPlayer.vrdata_world_render);
        GUI_RENDER_ROTATION_ROOM.rotationY(-GuiHandler.DH.vrPlayer.vrdata_world_render.rotation_radians).mul((Matrix4fc)guirot);
        MC.m_91307_().m_7238_();
        return guipos;
    }

    static {
        KEY_LEFT_CLICK = new KeyMapping("vivecraft.key.guiLeftClick", -1, "vivecraft.key.category.gui");
        KEY_RIGHT_CLICK = new KeyMapping("vivecraft.key.guiRightClick", -1, "vivecraft.key.category.gui");
        KEY_MIDDLE_CLICK = new KeyMapping("vivecraft.key.guiMiddleClick", -1, "vivecraft.key.category.gui");
        KEY_SHIFT = new KeyMapping("vivecraft.key.guiShift", -1, "vivecraft.key.category.gui");
        KEY_CTRL = new KeyMapping("vivecraft.key.guiCtrl", -1, "vivecraft.key.category.gui");
        KEY_ALT = new KeyMapping("vivecraft.key.guiAlt", -1, "vivecraft.key.category.gui");
        KEY_SCROLL_UP = new KeyMapping("vivecraft.key.guiScrollUp", -1, "vivecraft.key.category.gui");
        KEY_SCROLL_DOWN = new KeyMapping("vivecraft.key.guiScrollDown", -1, "vivecraft.key.category.gui");
        KEY_SCROLL_AXIS = new KeyMapping("vivecraft.key.guiScrollAxis", -1, "vivecraft.key.category.gui");
        KEY_KEYBOARD_CLICK = new HandedKeyBinding("vivecraft.key.keyboardClick", -1, "vivecraft.key.category.keyboard"){

            @Override
            public boolean isPriorityOnController(ControllerType type) {
                if (KeyboardHandler.SHOWING && !GuiHandler.DH.vrSettings.physicalKeyboard) {
                    return KeyboardHandler.isUsingController(type);
                }
                return RadialHandler.isShowing() && RadialHandler.isUsingController(type);
            }
        };
        KEY_KEYBOARD_SHIFT = new HandedKeyBinding("vivecraft.key.keyboardShift", -1, "vivecraft.key.category.keyboard"){

            @Override
            public boolean isPriorityOnController(ControllerType type) {
                if (KeyboardHandler.SHOWING) {
                    return GuiHandler.DH.vrSettings.physicalKeyboard || KeyboardHandler.isUsingController(type);
                }
                return RadialHandler.isShowing() && RadialHandler.isUsingController(type);
            }
        };
        GUI_FRAMEBUFFER = null;
        GUI_APPEAR_OVER_BLOCK_ACTIVE = false;
        GUI_SCALE = 1.0f;
        GUI_SCALE_APPLIED = 1.0f;
        GUI_POS_ROOM = null;
        GUI_ROTATION_ROOM = null;
        GUI_RENDER_POS_ROOM = null;
        GUI_OFFSET_LOCAL = new Vector3f();
        GUI_RENDER_ROTATION_ROOM = new Matrix4f();
        GUI_ROTATION_PLAYER_MODEL = new Matrix4f();
        GUI_POS_PLAYER_MODEL = Vec3.f_82478_;
        GUI_WIDTH = 1280;
        GUI_HEIGHT = 720;
        GUI_SCALE_FACTOR = GuiHandler.calculateScale(0, false, GUI_WIDTH, GUI_HEIGHT);
        PREVIOUS_GUI_SCALE = -1;
    }
}

