/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.ItemInUseTracker;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.ScaleHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.trackers.DebugRenderTracker;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.ViveItemTags;

public class BowTracker
implements ItemInUseTracker,
DebugRenderTracker {
    private static final long MAX_DRAW_MILLIS = 1100L;
    private static final double NOTCH_DOT_THRESHOLD = 20.0;
    public long startDrawTime;
    private boolean wasDrawing;
    private boolean canDraw;
    private float currentDraw;
    private float maxDraw;
    private Vector3f aim;
    private float tsNotch = 0.0f;
    private int hapCounter = 0;
    private int lastHapStep = 0;
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public BowTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    public Vector3fc getAimVector() {
        return this.aim;
    }

    public float getDrawPercent() {
        return this.currentDraw / this.maxDraw;
    }

    public boolean isNotched() {
        return this.canDraw || this.isDrawing();
    }

    public boolean isCharged() {
        return Util.m_137550_() - this.startDrawTime >= 1100L;
    }

    public boolean isDrawing() {
        return this.dh.bowModule.isPressed();
    }

    public static boolean isBow(ItemStack itemStack) {
        if (itemStack == ItemStack.f_41583_) {
            return false;
        }
        if (ClientDataHolderVR.getInstance().vrSettings.bowMode == VRSettings.BowMode.OFF) {
            return false;
        }
        if (ClientDataHolderVR.getInstance().vrSettings.bowMode == VRSettings.BowMode.VANILLA) {
            return itemStack.m_41720_() == Items.f_42411_;
        }
        return itemStack.m_41720_().m_6164_(itemStack) == UseAnim.BOW && !itemStack.m_204117_(ViveItemTags.VIVECRAFT_BOW_EXCLUSION);
    }

    public static boolean isHoldingBow(LivingEntity entity, InteractionHand hand) {
        return !ClientDataHolderVR.getInstance().vrSettings.seated && BowTracker.isBow(entity.m_21120_(hand));
    }

    public static boolean isHoldingBowEither(LivingEntity entity) {
        return BowTracker.isHoldingBow(entity, InteractionHand.MAIN_HAND) || BowTracker.isHoldingBow(entity, InteractionHand.OFF_HAND);
    }

    @Override
    public boolean itemInUse(LocalPlayer player) {
        return this.isDrawing();
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (player == null) {
            return false;
        }
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (this.mc.f_91080_ != null) {
            return false;
        }
        if (KeyboardHandler.SHOWING) {
            return false;
        }
        if (!player.m_6084_()) {
            return false;
        }
        if (player.m_5803_()) {
            return false;
        }
        return BowTracker.isHoldingBowEither((LivingEntity)player);
    }

    @Override
    public void inactiveProcess(LocalPlayer player) {
        this.wasDrawing = false;
        this.canDraw = false;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_FRAME;
    }

    @Override
    public void activeProcess(LocalPlayer player) {
        VRData vrData = this.dh.vrPlayer.getVRDataWorld();
        boolean lastCanDraw = this.canDraw;
        this.maxDraw = this.mc.f_91074_.m_20206_() * 0.22f;
        this.maxDraw /= ScaleHelper.getEntityBbScale((LivingEntity)player, ClientUtils.getCurrentPartialTick());
        int bowHand = 1;
        int arrowHand = 0;
        if (this.dh.vrSettings.reverseShootingEye && ClientNetworking.supportsReversedBow()) {
            bowHand = 0;
            arrowHand = 1;
        }
        Vec3 arrowPos = vrData.getController(arrowHand).getPosition();
        Vec3 bowPos = vrData.getController(bowHand).getPosition();
        float controllersDist = (float)bowPos.m_82554_(arrowPos);
        Vector3f up = new Vector3f(0.0f, vrData.worldScale, 0.0f);
        Vec3 stringPos = MathUtils.toMcVec3((Vector3fc)vrData.getHand(bowHand).getCustomVector((Vector3fc)up).mul(this.maxDraw * 0.5f)).m_82549_(bowPos);
        double notchDist = arrowPos.m_82554_(stringPos);
        this.aim = MathUtils.subtractToVector3f(bowPos, arrowPos).normalize();
        Vector3f arrowAim = vrData.getController(arrowHand).getCustomVector(MathUtils.BACK);
        Vector3f bowAim = vrData.getHand(bowHand).getCustomVector(MathUtils.DOWN);
        double controllersDot = Math.toDegrees(Math.acos(bowAim.dot((Vector3fc)arrowAim)));
        float notchDistThreshold = 0.15f * vrData.worldScale;
        boolean main = BowTracker.isHoldingBow((LivingEntity)player, InteractionHand.MAIN_HAND);
        ItemStack ammo = ItemStack.f_41583_;
        ItemStack bow = ItemStack.f_41583_;
        if (main) {
            bow = player.m_21205_();
            ammo = player.m_6298_(bow);
        } else {
            if (player.m_21205_().m_204117_(ItemTags.f_13161_)) {
                ammo = player.m_21205_();
            }
            bow = player.m_21206_();
        }
        int stage0 = bow.m_41779_();
        int stage1 = bow.m_41779_() - 15;
        int stage2 = 0;
        if (ammo != ItemStack.f_41583_ && notchDist <= (double)notchDistThreshold && controllersDot <= 20.0) {
            this.canDraw = true;
            this.tsNotch = Util.m_137550_();
            if (!this.isDrawing()) {
                ((PlayerExtension)player).vivecraft$setItemInUseRemainingClient(stage0);
            }
        } else if (!this.isDrawing() && (float)Util.m_137550_() - this.tsNotch > 500.0f) {
            this.canDraw = false;
        }
        if (this.isDrawing() && !this.wasDrawing) {
            this.startDrawTime = Util.m_137550_();
        }
        if (!this.isDrawing() && this.canDraw && !lastCanDraw) {
            this.dh.vr.triggerHapticPulse(arrowHand, 800);
            this.dh.vr.triggerHapticPulse(bowHand, 800);
        }
        if (this.isDrawing()) {
            double drawPercent;
            this.currentDraw = (controllersDist - notchDistThreshold) / vrData.worldScale;
            if (this.currentDraw > this.maxDraw) {
                this.currentDraw = this.maxDraw;
            }
            int hapStrength = 0;
            if (this.getDrawPercent() > 0.0f) {
                hapStrength = (int)(this.getDrawPercent() * 500.0f) + 700;
            }
            if ((drawPercent = (double)this.getDrawPercent()) >= 1.0) {
                ((PlayerExtension)player).vivecraft$setItemInUseRemainingClient(stage2);
            } else if (drawPercent > 0.4) {
                ((PlayerExtension)player).vivecraft$setItemInUseRemainingClient(stage1);
            } else {
                ((PlayerExtension)player).vivecraft$setItemInUseRemainingClient(stage0);
            }
            int hapStep = (int)(drawPercent * 4.0 * 4.0 * 3.0);
            if (hapStep % 2 == 0 && this.lastHapStep != hapStep) {
                this.dh.vr.triggerHapticPulse(arrowHand, hapStrength);
                if (drawPercent == 1.0) {
                    this.dh.vr.triggerHapticPulse(bowHand, hapStrength);
                }
            }
            if (this.isCharged() && this.hapCounter % 4 == 0) {
                this.dh.vr.triggerHapticPulse(bowHand, 200);
            }
            this.lastHapStep = hapStep;
            ++this.hapCounter;
        } else {
            this.hapCounter = 0;
            this.lastHapStep = 0;
        }
        this.wasDrawing = this.isDrawing();
    }

    @Override
    public void renderDebug(PoseStack poseStack) {
        VRData world = this.dh.vrPlayer.getVRDataWorld();
        Vec3 cam = world.getEye(this.dh.currentPass).getPosition();
        int bowHand = this.dh.vrSettings.reverseShootingEye && ClientNetworking.supportsReversedBow() ? 0 : 1;
        Vector3f bowPos = MathUtils.subtractToVector3f(world.getController(bowHand).getPosition(), cam);
        if (this.isDrawing() || this.dh.vrSettings.seated) {
            DebugRenderHelper.renderLine(poseStack, MathUtils.RED, new Vector3fc[]{bowPos, this.aim.mul(-1.0f, new Vector3f()).add((Vector3fc)bowPos)});
        } else {
            float dist = 0.15f * world.worldScale;
            VRData.VRDevicePose bowHandPose = world.getHand(bowHand);
            VRData.VRDevicePose arrowPose = world.getController(1 - bowHand);
            Vector3f stringPos = bowHandPose.getCustomVector(MathUtils.UP).mul(world.worldScale * this.maxDraw * 0.5f).add((Vector3fc)bowPos);
            DebugRenderHelper.renderSphere(poseStack, (Vector3fc)stringPos, dist, this.isNotched() ? MathUtils.GREEN : MathUtils.RED);
            Vector3f bowDir = bowHandPose.getCustomVector(MathUtils.DOWN);
            DebugRenderHelper.renderCone(poseStack, (Vector3fc)bowDir.mul(-dist, new Vector3f()).add((Vector3fc)stringPos), (Vector3fc)bowDir, 20.0f, 0.25f * world.worldScale, this.isNotched() ? MathUtils.GREEN : MathUtils.RED);
            DebugRenderHelper.renderLine(poseStack, this.isNotched() ? MathUtils.GREEN : MathUtils.RED, new Vector3fc[]{MathUtils.subtractToVector3f(arrowPose.getPosition(), cam), MathUtils.subtractToVector3f(arrowPose.getPosition(), cam).add((Vector3fc)arrowPose.getDirection().mul(world.worldScale))});
        }
    }
}

