/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;

public class HorseTracker
implements Tracker {
    private static final double BOOST_TRIGGER = 1.4;
    private static final double PULL_TRIGGER = 0.8;
    private static final int MAX_SPEED_LEVEL = 3;
    private static final long COOL_DOWN_MILLIS = 500L;
    private static final double TURN_SPEED = 6.0;
    private static final double BODY_TURN_SPEED = 0.2;
    private static final double BASE_SPEED = 0.2;
    private int speedLevel = 0;
    private long lastBoostMillis = -1L;
    private Horse horse = null;
    private final ModelInfo info = new ModelInfo();
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public HorseTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        return false;
    }

    @Override
    public void inactiveProcess(LocalPlayer player) {
        if (this.horse != null) {
            this.horse.m_21557_(false);
        }
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(LocalPlayer player) {
        this.horse = (Horse)player.m_20202_();
        this.horse.m_21557_(true);
        float absYaw = (this.horse.m_146908_() + 360.0f) % 360.0f;
        float absYawOffset = (this.horse.f_20883_ + 360.0f) % 360.0f;
        Vector3f speedLeft = this.dh.vr.controllerHistory[1].netMovement(0.1).mul(10.0f);
        Vector3f speedRight = this.dh.vr.controllerHistory[0].netMovement(0.1).mul(10.0f);
        float speedDown = Math.min(-speedLeft.y, -speedRight.y);
        if ((double)speedDown > 1.4) {
            this.doBoost();
        }
        Vector3f back = MathUtils.BACK.rotateY(-this.horse.f_20883_, new Vector3f());
        Vector3f left = MathUtils.LEFT.rotateY(-this.horse.f_20883_, new Vector3f());
        Vector3f right = MathUtils.RIGHT.rotateY(-this.horse.f_20883_, new Vector3f());
        Vector3f roomPosL = this.dh.vr.controllerHistory[1].latest().rotateY(VRSettings.INSTANCE.worldRotation, new Vector3f());
        Vector3f roomPosR = this.dh.vr.controllerHistory[0].latest().rotateY(VRSettings.INSTANCE.worldRotation, new Vector3f());
        Vec3 posL = VRPlayer.get().roomOrigin.m_82520_((double)roomPosL.x, (double)roomPosL.y, (double)roomPosL.z);
        Vec3 posR = VRPlayer.get().roomOrigin.m_82520_((double)roomPosR.x, (double)roomPosR.y, (double)roomPosR.z);
        Vector3f offsetL = MathUtils.subtractToVector3f(posL, this.info.leftReinPos);
        Vector3f offsetR = MathUtils.subtractToVector3f(posR, this.info.leftReinPos);
        double distanceL = offsetL.dot((Vector3fc)back) + offsetL.dot((Vector3fc)left);
        double distanceR = offsetR.dot((Vector3fc)back) + offsetR.dot((Vector3fc)right);
        if (this.speedLevel < 0) {
            this.speedLevel = 0;
        }
        if (distanceL > 1.1 && distanceR > 1.1 && Math.abs(distanceR - distanceL) < 0.1) {
            if (this.speedLevel == 0 && System.currentTimeMillis() > this.lastBoostMillis + 500L) {
                this.speedLevel = -1;
            } else {
                this.doBreak();
            }
        } else {
            double pullL = 0.0;
            double pullR = 0.0;
            if (distanceL > 0.8) {
                pullL = distanceL - 0.8;
            }
            if (distanceR > 0.8) {
                pullR = distanceR - 0.8;
            }
            this.horse.m_146922_((float)((double)absYaw + (pullR - pullL) * 6.0));
        }
        this.horse.f_20883_ = (float)MathUtils.lerpMod(absYawOffset, absYaw, 0.2, 360.0);
        this.horse.f_20885_ = absYaw;
        Vec3 movement = new Vec3(0.0, 0.0, (double)this.speedLevel * 0.2).m_82524_(-this.horse.f_20883_);
        this.horse.m_20334_(movement.f_82479_, this.horse.m_20184_().f_82480_, movement.f_82481_);
    }

    private boolean doBoost() {
        if (this.speedLevel >= 3) {
            return false;
        }
        if (System.currentTimeMillis() < this.lastBoostMillis + 500L) {
            return false;
        }
        ++this.speedLevel;
        this.lastBoostMillis = System.currentTimeMillis();
        return true;
    }

    private boolean doBreak() {
        if (this.speedLevel <= 0) {
            return false;
        }
        if (System.currentTimeMillis() < this.lastBoostMillis + 500L) {
            return false;
        }
        System.out.println("Breaking");
        --this.speedLevel;
        this.lastBoostMillis = System.currentTimeMillis();
        return true;
    }

    public ModelInfo getModelInfo() {
        return this.info;
    }

    public static class ModelInfo {
        public Vec3 leftReinPos = Vec3.f_82478_;
        public Vec3 rightReinPos = Vec3.f_82478_;
    }
}

