/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.common.utils.MathUtils;

public class RowTracker
implements Tracker {
    private static final double TRANSMISSION_EFFICIENCY = 0.9;
    public double[] forces = new double[]{0.0, 0.0};
    public float LOar;
    public float ROar;
    public float FOar;
    private final Vec3[] lastUWPs = new Vec3[2];
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public RowTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (!this.dh.vrSettings.realisticRowEnabled) {
            return false;
        }
        if (player == null || !player.m_6084_()) {
            return false;
        }
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (this.mc.f_91066_.f_92085_.m_90857_()) {
            return false;
        }
        if (!(player.m_20202_() instanceof Boat)) {
            return false;
        }
        return !this.dh.bowTracker.isNotched();
    }

    public boolean isRowing() {
        return this.ROar + this.LOar + this.FOar > 0.0f;
    }

    @Override
    public void inactiveProcess(LocalPlayer player) {
        this.LOar = 0.0f;
        this.ROar = 0.0f;
        this.FOar = 0.0f;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(LocalPlayer player) {
        float c0Move = this.dh.vr.controllerHistory[0].averageSpeed(0.5);
        float c1Move = this.dh.vr.controllerHistory[1].averageSpeed(0.5);
        float minSpeed = 0.5f;
        float maxSpeed = 2.0f;
        this.ROar = Math.max(c0Move - 0.5f, 0.0f);
        this.LOar = Math.max(c1Move - 0.5f, 0.0f);
        float f = this.FOar = this.ROar > 0.0f && this.LOar > 0.0f ? (this.ROar + this.LOar) / 2.0f : 0.0f;
        if (this.FOar > 2.0f) {
            this.FOar = 2.0f;
        }
        if (this.ROar > 2.0f) {
            this.ROar = 2.0f;
        }
        if (this.LOar > 2.0f) {
            this.LOar = 2.0f;
        }
    }

    public void doProcessFinaltransmithastofixthis(LocalPlayer player) {
        Boat boat = (Boat)player.m_20202_();
        Quaternionf boatRot = new Quaternionf().rotationYXZ((float)Math.PI / 180 * -(boat.m_146908_() % 360.0f), (float)Math.PI / 180 * boat.m_146909_(), 0.0f).normalize();
        for (int paddle = 0; paddle <= 1; ++paddle) {
            if (this.isPaddleUnderWater(paddle, boat)) {
                Vec3 arm2Pad = this.getArmToPaddleVector(paddle, boat);
                Vec3 attach = this.getAttachmentPoint(paddle, boat);
                Vec3 underWaterPoint = attach.m_82549_(arm2Pad.m_82541_()).m_82546_(boat.m_20182_());
                if (this.lastUWPs[paddle] != null) {
                    Vector3f forward;
                    Vector3f forceVector = MathUtils.subtractToVector3f(this.lastUWPs[paddle], underWaterPoint);
                    double force = (double)(forceVector = forceVector.sub((float)boat.m_20184_().f_82479_, (float)boat.m_20184_().f_82480_, (float)boat.m_20184_().f_82481_)).dot((Vector3fc)(forward = boatRot.transform(MathUtils.FORWARD, new Vector3f()))) * 0.9 / 5.0;
                    this.forces[paddle] = force < 0.0 && this.forces[paddle] > 0.0 || force > 0.0 && this.forces[paddle] < 0.0 ? 0.0 : Math.min(Math.max(force, -0.1), 0.1);
                }
                this.lastUWPs[paddle] = underWaterPoint;
                continue;
            }
            this.forces[paddle] = 0.0;
            this.lastUWPs[paddle] = null;
        }
    }

    private Vec3 getArmToPaddleVector(int paddle, Boat boat) {
        Vec3 attachAbs = this.getAttachmentPoint(paddle, boat);
        Vec3 armAbs = this.getAbsArmPos(paddle == 0 ? 1 : 0);
        return attachAbs.m_82546_(armAbs);
    }

    private Vec3 getAttachmentPoint(int paddle, Boat boat) {
        Vector3f attachmentPoint = new Vector3f((paddle == 0 ? 9.0f : -9.0f) / 16.0f, 0.625f, 0.1875f);
        Quaternionf boatRot = new Quaternionf().rotationYXZ((float)Math.PI / 180 * -(boat.m_146908_() % 360.0f), (float)Math.PI / 180 * boat.m_146909_(), 0.0f).normalize();
        return boat.m_20182_().m_82549_(MathUtils.toMcVec3((Vector3fc)boatRot.transform(attachmentPoint)));
    }

    private Vec3 getAbsArmPos(int side) {
        Vector3f arm = this.dh.vr.controllerHistory[side].averagePosition(0.1).rotateY((float)Math.PI / 180 * this.dh.vrSettings.worldRotation);
        return this.dh.vrPlayer.roomOrigin.m_82520_((double)arm.x, (double)arm.y, (double)arm.z);
    }

    private boolean isPaddleUnderWater(int paddle, Boat boat) {
        Vec3 attachAbs = this.getAttachmentPoint(paddle, boat);
        Vec3 armToPaddle = this.getArmToPaddleVector(paddle, boat).m_82541_();
        BlockPos blockPos = new BlockPos(attachAbs.m_82549_(armToPaddle));
        return boat.f_19853_.m_8055_(blockPos).m_60767_().m_76332_();
    }
}

