/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.menuworlds;

import com.google.common.io.Files;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import org.vivecraft.Xplat;
import org.vivecraft.client_vr.menuworlds.FakeBlockAccess;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mixin.client_vr.world.level.biome.BiomeAccessor;

public class MenuWorldExporter {
    public static final int VERSION = 5;
    public static final int MIN_VERSION = 2;
    private static final DataFixer DATA_FIXER = DataFixers.m_14512_();
    private static final BiomeGenerationSettings DUMMY_GENERATION_SETTINGS = new BiomeGenerationSettings.Builder().m_47831_();
    private static final MobSpawnSettings DUMMY_MOB_SPAWN_SETTINGS = new MobSpawnSettings.Builder().m_48381_();

    public static byte[] saveArea(Level level, int xMin, int zMin, int xSize, int zSize, int ground) throws IOException {
        int i;
        BlockStateMapper blockStateMapper = new BlockStateMapper();
        PaletteBiomeMapper biomeMapper = new PaletteBiomeMapper();
        int yMin = level.m_141937_();
        int ySize = level.m_141928_();
        int[] blocks = new int[xSize * ySize * zSize];
        byte[] skylightmap = new byte[xSize * ySize * zSize];
        byte[] blocklightmap = new byte[xSize * ySize * zSize];
        int[] biomemap = new int[xSize * ySize * zSize / 64];
        for (int x = xMin; x < xMin + xSize; ++x) {
            int xl = x - xMin;
            for (int z = zMin; z < zMin + zSize; ++z) {
                int zl = z - zMin;
                for (int y = yMin; y < yMin + ySize; ++y) {
                    int yl = y - yMin;
                    int index3 = (yl * zSize + zl) * xSize + xl;
                    BlockPos pos3 = new BlockPos(x, y, z);
                    BlockState state = level.m_8055_(pos3);
                    blocks[index3] = blockStateMapper.getId(state);
                    skylightmap[index3] = (byte)level.m_45517_(LightLayer.SKY, pos3);
                    blocklightmap[index3] = (byte)level.m_45517_(LightLayer.BLOCK, pos3);
                    if (x % 4 != 0 || y % 4 != 0 || z % 4 != 0) continue;
                    int indexBiome = (yl / 4 * (zSize / 4) + zl / 4) * (xSize / 4) + xl / 4;
                    biomemap[indexBiome] = biomeMapper.getId((Biome)level.m_203495_(x / 4, y / 4, z / 4).m_203334_());
                }
            }
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(data);
        dos.writeInt(xSize);
        dos.writeInt(ySize);
        dos.writeInt(zSize);
        dos.writeInt(ground);
        dos.writeUTF(level.m_6042_().m_63969_().toString());
        if (level instanceof ServerLevel) {
            dos.writeBoolean(((ServerLevel)level).m_8584_());
        } else {
            dos.writeBoolean(((ClientLevel)level).m_6106_().f_104832_);
        }
        dos.writeBoolean(level.m_6042_().m_63935_());
        if (level instanceof ServerLevel) {
            dos.writeLong(((ServerLevel)level).m_7328_());
        } else {
            dos.writeLong(level.m_7062_().f_47863_);
        }
        dos.writeInt(SharedConstants.m_183709_().m_183476_().m_193006_());
        dos.writeBoolean(level.m_6042_().f_63854_.isPresent());
        if (level.m_6042_().f_63854_.isPresent()) {
            dos.writeLong(level.m_6042_().f_63854_.getAsLong());
        }
        dos.writeBoolean(level.m_6042_().m_63946_());
        dos.writeInt(level.m_6042_().m_156732_());
        dos.writeFloat(level.m_6042_().f_63838_);
        dos.writeFloat(switch (Minecraft.m_91087_().f_91074_.m_6350_()) {
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> -90.0f;
            case Direction.EAST -> 90.0f;
            default -> 0.0f;
        });
        dos.writeBoolean(level.m_46722_(1.0f) > 0.0f);
        dos.writeBoolean(level.m_46661_(1.0f) > 0.0f);
        blockStateMapper.writePalette(dos);
        biomeMapper.writePalette(dos, level.m_5962_());
        for (i = 0; i < blocks.length; ++i) {
            dos.writeInt(blocks[i]);
        }
        for (i = 0; i < skylightmap.length; ++i) {
            dos.writeByte(skylightmap[i] | blocklightmap[i] << 4);
        }
        for (i = 0; i < biomemap.length; ++i) {
            dos.writeInt(biomemap[i]);
        }
        Header header = new Header();
        header.version = 5;
        header.uncompressedSize = data.size();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream headerStream = new DataOutputStream(output);
        header.write(headerStream);
        Deflater deflater = new Deflater(9);
        deflater.setInput(data.toByteArray());
        deflater.finish();
        byte[] buffer = new byte[0x100000];
        while (!deflater.finished()) {
            int len = deflater.deflate(buffer);
            output.write(buffer, 0, len);
        }
        return output.toByteArray();
    }

    public static void saveAreaToFile(Level world, int xMin, int zMin, int xSize, int zSize, int ground, File file) throws IOException {
        byte[] bytes = MenuWorldExporter.saveArea(world, xMin, zMin, xSize, zSize, ground);
        Files.write((byte[])bytes, (File)file);
    }

    public static FakeBlockAccess loadWorld(byte[] data) throws IOException, DataFormatException {
        BiomeMapper biomeMapper;
        float dimAmbientLight;
        int dimMinY;
        boolean dimHasCeiling;
        int dataVersion;
        ResourceLocation dimName;
        Header header = new Header();
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));){
            header.read(dis);
        }
        if (header.version > 5 || header.version < 2) {
            throw new DataFormatException("Unsupported menu world version: " + header.version);
        }
        Inflater inflater = new Inflater();
        inflater.setInput(data, 8, data.length - 8);
        ByteArrayOutputStream output = new ByteArrayOutputStream(header.uncompressedSize);
        byte[] buffer = new byte[0x100000];
        while (!inflater.finished()) {
            int len = inflater.inflate(buffer);
            output.write(buffer, 0, len);
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(output.toByteArray()));
        int xSize = dis.readInt();
        int ySize = dis.readInt();
        int zSize = dis.readInt();
        int ground = dis.readInt();
        if (header.version < 4) {
            int dimId = dis.readInt();
            dimName = switch (dimId) {
                case -1 -> DimensionType.f_63841_;
                case 1 -> DimensionType.f_63842_;
                default -> DimensionType.f_63840_;
            };
        } else {
            dimName = new ResourceLocation(dis.readUTF());
        }
        boolean isFlat = header.version < 4 ? dis.readUTF().equals("flat") : dis.readBoolean();
        boolean dimHasSkyLight = dis.readBoolean();
        long seed = 0L;
        if (header.version >= 3) {
            seed = dis.readLong();
        }
        if ((dataVersion = header.version == 2 ? 1631 : (header.version == 3 ? 2230 : (header.version == 4 ? 2586 : dis.readInt()))) > SharedConstants.m_183709_().m_183476_().m_193006_()) {
            VRSettings.LOGGER.warn("Vivecraft: Menuworld data version is newer than current, this menu world may not load correctly.");
        }
        OptionalLong dimFixedTime = OptionalLong.empty();
        if (header.version < 5) {
            if (DimensionType.f_63841_.equals((Object)dimName)) {
                dimFixedTime = OptionalLong.of(18000L);
                dimHasCeiling = true;
                dimMinY = 0;
                dimAmbientLight = 0.1f;
            } else if (DimensionType.f_63842_.equals((Object)dimName)) {
                dimFixedTime = OptionalLong.of(6000L);
                dimHasCeiling = false;
                dimMinY = 0;
                dimAmbientLight = 0.0f;
            } else {
                dimHasCeiling = false;
                dimMinY = 0;
                dimAmbientLight = 0.0f;
            }
        } else {
            if (dis.readBoolean()) {
                dimFixedTime = OptionalLong.of(dis.readLong());
            }
            dimHasCeiling = dis.readBoolean();
            dimMinY = dis.readInt();
            dimAmbientLight = dis.readFloat();
        }
        DimensionType dimensionType = DimensionType.m_204497_((OptionalLong)dimFixedTime, (boolean)dimHasSkyLight, (boolean)dimHasCeiling, (boolean)false, (boolean)false, (double)1.0, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)dimMinY, (int)ySize, (int)ySize, (TagKey)BlockTags.f_13058_, (ResourceLocation)dimName, (float)dimAmbientLight);
        float rotation = 0.0f;
        boolean rain = false;
        boolean thunder = false;
        if (header.version >= 5) {
            rotation = dis.readFloat();
            rain = dis.readBoolean();
            thunder = dis.readBoolean();
        }
        BlockStateMapper blockStateMapper = new BlockStateMapper();
        blockStateMapper.readPalette(dis, dataVersion);
        if (header.version >= 5) {
            biomeMapper = new PaletteBiomeMapper();
            ((PaletteBiomeMapper)biomeMapper).readPalette(dis);
        } else {
            biomeMapper = new LegacyBiomeMapper();
        }
        BlockState[] blocks = new BlockState[xSize * ySize * zSize];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = blockStateMapper.getState(dis.readInt());
        }
        short[][] heightmap = new short[xSize][zSize];
        for (int x = 0; x < xSize; ++x) {
            block12: for (int z = 0; z < zSize; ++z) {
                for (int y = ySize - 1; y >= 0; --y) {
                    int index = (y * zSize + z) * xSize + x;
                    if (!blocks[index].m_60767_().m_76334_() && blocks[index].m_60819_().m_76178_()) continue;
                    heightmap[x][z] = (short)(y + 1);
                    continue block12;
                }
            }
        }
        byte[] skylightmap = new byte[xSize * ySize * zSize];
        byte[] blocklightmap = new byte[xSize * ySize * zSize];
        for (int i = 0; i < skylightmap.length; ++i) {
            int b = dis.readByte() & 0xFF;
            skylightmap[i] = (byte)(b & 0xF);
            blocklightmap[i] = (byte)(b >> 4);
        }
        Biome[] biomemap = new Biome[xSize * ySize * zSize / 64];
        if (header.version == 2) {
            Biome[] tempBiomemap = new Biome[xSize * zSize];
            for (int i = 0; i < tempBiomemap.length; ++i) {
                tempBiomemap[i] = biomeMapper.getBiome(dis.readInt());
            }
            for (int x = 0; x < xSize / 4; ++x) {
                for (int z = 0; z < zSize / 4; ++z) {
                    biomemap[z * (xSize / 4) + x] = tempBiomemap[z * 4 * xSize + x * 4];
                }
            }
            int yStride = xSize / 4 * (zSize / 4);
            for (int y = 1; y < ySize / 4; ++y) {
                System.arraycopy(biomemap, 0, biomemap, yStride * y, yStride);
            }
        } else {
            for (int i = 0; i < biomemap.length; ++i) {
                biomemap[i] = biomeMapper.getBiome(dis.readInt());
            }
        }
        return new FakeBlockAccess(header.version, seed, blocks, skylightmap, blocklightmap, biomemap, heightmap, xSize, ySize, zSize, ground, dimensionType, isFlat, rotation, rain, thunder);
    }

    public static FakeBlockAccess loadWorld(InputStream is) throws IOException, DataFormatException {
        int count;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] buffer = new byte[0x100000];
        while ((count = is.read(buffer)) != -1) {
            data.write(buffer, 0, count);
        }
        return MenuWorldExporter.loadWorld(data.toByteArray());
    }

    public static int readVersion(File file) throws IOException {
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            Header header = new Header();
            header.read(dis);
            int n = header.version;
            return n;
        }
    }

    private static <T extends Enum> Optional<T> decodeEnum(Class<T> type, String input) {
        return Arrays.stream((Enum[])type.getEnumConstants()).filter(e -> input.equals(((StringRepresentable)e).m_7912_())).findFirst();
    }

    private static class BlockStateMapper {
        CrudeIncrementalIntIdentityHashBiMap<BlockState> paletteMap = CrudeIncrementalIntIdentityHashBiMap.m_184237_((int)256);

        private BlockStateMapper() {
        }

        int getId(BlockState state) {
            int id = this.paletteMap.m_7447_((Object)state);
            return id == -1 ? this.paletteMap.m_13569_((Object)state) : id;
        }

        BlockState getState(int id) {
            return (BlockState)this.paletteMap.m_7942_(id);
        }

        void readPalette(DataInputStream dis, int dataVersion) throws IOException {
            this.paletteMap.m_13554_();
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                CompoundTag tag = (CompoundTag)CompoundTag.f_128326_.m_7300_((DataInput)dis, 0, NbtAccounter.f_128917_);
                tag = (CompoundTag)DATA_FIXER.update(References.f_16783_, new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)tag), dataVersion, SharedConstants.m_183709_().m_183476_().m_193006_()).getValue();
                this.paletteMap.m_13569_((Object)NbtUtils.m_129241_((CompoundTag)tag));
            }
        }

        void writePalette(DataOutputStream dos) throws IOException {
            dos.writeInt(this.paletteMap.m_183450_());
            for (int i = 0; i < this.paletteMap.m_183450_(); ++i) {
                CompoundTag compoundtag = NbtUtils.m_129202_((BlockState)((BlockState)this.paletteMap.m_7942_(i)));
                compoundtag.m_6434_((DataOutput)dos);
            }
        }
    }

    private static class PaletteBiomeMapper
    implements BiomeMapper {
        private final CrudeIncrementalIntIdentityHashBiMap<Biome> paletteMap = CrudeIncrementalIntIdentityHashBiMap.m_184237_((int)256);

        private PaletteBiomeMapper() {
        }

        @Override
        public int getId(Biome biome) {
            int id = this.paletteMap.m_7447_((Object)biome);
            return id == -1 ? this.paletteMap.m_13569_((Object)biome) : id;
        }

        @Override
        public Biome getBiome(int id) {
            return (Biome)this.paletteMap.m_7942_(id);
        }

        void readPalette(DataInputStream dis) throws IOException {
            this.paletteMap.m_13554_();
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                Biome.BiomeBuilder builder = new Biome.BiomeBuilder();
                dis.readUTF();
                boolean hasPrecipitation = dis.readBoolean();
                float temperature = dis.readFloat();
                builder.m_47597_(hasPrecipitation ? (temperature < 0.15f ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN) : Biome.Precipitation.NONE);
                builder.m_47609_(temperature);
                builder.m_47595_(Biome.BiomeCategory.NONE);
                MenuWorldExporter.decodeEnum(Biome.TemperatureModifier.class, dis.readUTF()).ifPresent(arg_0 -> ((Biome.BiomeBuilder)builder).m_47599_(arg_0));
                builder.m_47611_(dis.readFloat());
                BiomeSpecialEffects.Builder effectsBuilder = new BiomeSpecialEffects.Builder();
                effectsBuilder.m_48019_(dis.readInt());
                effectsBuilder.m_48034_(dis.readInt());
                effectsBuilder.m_48037_(dis.readInt());
                effectsBuilder.m_48040_(dis.readInt());
                if (dis.readBoolean()) {
                    effectsBuilder.m_48043_(dis.readInt());
                }
                if (dis.readBoolean()) {
                    effectsBuilder.m_48045_(dis.readInt());
                }
                MenuWorldExporter.decodeEnum(BiomeSpecialEffects.GrassColorModifier.class, dis.readUTF()).ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)effectsBuilder).m_48031_(arg_0));
                if (dis.readBoolean()) {
                    ParticleType particleType = (ParticleType)Registry.f_122829_.m_7745_(new ResourceLocation(dis.readUTF()));
                    float probability = dis.readFloat();
                    if (particleType instanceof ParticleOptions) {
                        effectsBuilder.m_48029_(new AmbientParticleSettings((ParticleOptions)particleType, probability));
                    }
                }
                Biome biome = builder.m_47603_(effectsBuilder.m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_();
                this.paletteMap.m_13569_((Object)biome);
            }
        }

        void writePalette(DataOutputStream dos, RegistryAccess registryAccess) throws IOException {
            dos.writeInt(this.paletteMap.m_183450_());
            for (int i = 0; i < this.paletteMap.m_183450_(); ++i) {
                Biome biome = (Biome)this.paletteMap.m_7942_(i);
                dos.writeUTF(registryAccess.m_175515_(Registry.f_122885_).m_7981_((Object)biome).toString());
                Biome.ClimateSettings climateSettings = ((BiomeAccessor)biome).getClimateSettings();
                dos.writeBoolean(biome.m_47530_() != Biome.Precipitation.NONE);
                dos.writeFloat(biome.m_47554_());
                dos.writeUTF(climateSettings.f_47682_.m_7912_());
                dos.writeFloat(biome.m_47548_());
                BiomeSpecialEffects specialEffects = Xplat.getBiomeEffects(biome);
                dos.writeInt(specialEffects.m_47967_());
                dos.writeInt(specialEffects.m_47972_());
                dos.writeInt(specialEffects.m_47975_());
                dos.writeInt(specialEffects.m_47978_());
                dos.writeBoolean(specialEffects.m_47981_().isPresent());
                if (specialEffects.m_47981_().isPresent()) {
                    dos.writeInt((Integer)specialEffects.m_47981_().get());
                }
                dos.writeBoolean(specialEffects.m_47984_().isPresent());
                if (specialEffects.m_47984_().isPresent()) {
                    dos.writeInt((Integer)specialEffects.m_47984_().get());
                }
                dos.writeUTF(specialEffects.m_47987_().m_7912_());
                dos.writeBoolean(specialEffects.m_47990_().isPresent());
                if (!specialEffects.m_47990_().isPresent()) continue;
                AmbientParticleSettings ambientParticleSettings = (AmbientParticleSettings)specialEffects.m_47990_().get();
                dos.writeUTF(Registry.f_122829_.m_7981_((Object)ambientParticleSettings.m_47419_().m_6012_()).toString());
                dos.writeFloat(ambientParticleSettings.f_47414_);
            }
        }
    }

    public static class Header {
        public static final int SIZE = 8;
        public int version;
        public int uncompressedSize;

        public void read(DataInputStream dis) throws IOException {
            this.version = dis.readInt();
            this.uncompressedSize = dis.readInt();
        }

        public void write(DataOutputStream dos) throws IOException {
            dos.writeInt(this.version);
            dos.writeInt(this.uncompressedSize);
        }
    }

    private static class LegacyBiomeMapper
    implements BiomeMapper {
        private static final Map<Integer, Biome> MAP = new HashMap<Integer, Biome>();

        private LegacyBiomeMapper() {
        }

        @Override
        public int getId(Biome biome) {
            throw new UnsupportedOperationException("this mapper does not support reversing biomes to IDs");
        }

        @Override
        public Biome getBiome(int id) {
            Biome biome = MAP.get(id);
            return biome != null ? biome : MAP.get(1);
        }

        static {
            MAP.put(1, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.8f).m_47611_(0.4f).m_47595_(Biome.BiomeCategory.PLAINS).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7907327).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(127, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(0.5f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.NONE).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8103167).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(0, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.5f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.OCEAN).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8103167).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(2, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.DESERT).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7254527).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(3, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.2f).m_47611_(0.3f).m_47595_(Biome.BiomeCategory.EXTREME_HILLS).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8233727).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(4, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.7f).m_47611_(0.8f).m_47595_(Biome.BiomeCategory.FOREST).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(5, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.25f).m_47611_(0.8f).m_47595_(Biome.BiomeCategory.TAIGA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8233983).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(6, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.8f).m_47611_(0.9f).m_47595_(Biome.BiomeCategory.SWAMP).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(6388580).m_48037_(2302743).m_48040_(7907327).m_48043_(6975545).m_48031_(BiomeSpecialEffects.GrassColorModifier.SWAMP).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(7, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.5f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.RIVER).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8103167).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(8, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.NETHER).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(0x330808).m_48034_(4159204).m_48037_(329011).m_48040_(7254527).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(9, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(0.5f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.THEEND).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(0xA080A0).m_48034_(4159204).m_48037_(329011).m_48040_(0).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(10, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47609_(0.0f).m_47611_(0.5f).m_47599_(Biome.TemperatureModifier.FROZEN).m_47595_(Biome.BiomeCategory.OCEAN).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(3750089).m_48037_(329011).m_48040_(8364543).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(11, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47609_(0.0f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.RIVER).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(3750089).m_48037_(329011).m_48040_(8364543).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(12, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47609_(0.0f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.ICY).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8364543).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(13, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47609_(0.0f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.ICY).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8364543).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(14, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.9f).m_47611_(1.0f).m_47595_(Biome.BiomeCategory.MUSHROOM).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7842047).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(15, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.9f).m_47611_(1.0f).m_47595_(Biome.BiomeCategory.MUSHROOM).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7842047).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(16, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.8f).m_47611_(0.4f).m_47595_(Biome.BiomeCategory.BEACH).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7907327).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(17, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47595_(Biome.BiomeCategory.DESERT).m_47611_(0.0f).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7254527).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(18, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.7f).m_47595_(Biome.BiomeCategory.FOREST).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(19, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.25f).m_47611_(0.8f).m_47595_(Biome.BiomeCategory.TAIGA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8233983).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(20, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.2f).m_47611_(0.3f).m_47595_(Biome.BiomeCategory.EXTREME_HILLS).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8233727).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(21, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.95f).m_47611_(0.9f).m_47595_(Biome.BiomeCategory.JUNGLE).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7842047).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(22, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.95f).m_47611_(0.9f).m_47595_(Biome.BiomeCategory.JUNGLE).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7842047).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(23, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.95f).m_47611_(0.8f).m_47595_(Biome.BiomeCategory.JUNGLE).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7842047).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(24, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.5f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.OCEAN).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8103167).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(25, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.2f).m_47611_(0.3f).m_47595_(Biome.BiomeCategory.NONE).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8233727).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(26, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47609_(0.05f).m_47611_(0.3f).m_47595_(Biome.BiomeCategory.BEACH).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4020182).m_48037_(329011).m_48040_(8364543).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(27, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.6f).m_47611_(0.6f).m_47595_(Biome.BiomeCategory.FOREST).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8037887).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(28, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.6f).m_47611_(0.6f).m_47595_(Biome.BiomeCategory.FOREST).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8037887).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(29, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.7f).m_47611_(0.8f).m_47595_(Biome.BiomeCategory.FOREST).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48031_(BiomeSpecialEffects.GrassColorModifier.DARK_FOREST).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(30, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47609_(-0.5f).m_47611_(0.4f).m_47595_(Biome.BiomeCategory.TAIGA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4020182).m_48037_(329011).m_48040_(8625919).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(31, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47609_(-0.5f).m_47611_(0.4f).m_47595_(Biome.BiomeCategory.TAIGA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4020182).m_48037_(329011).m_48040_(8625919).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(32, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.3f).m_47611_(0.8f).m_47595_(Biome.BiomeCategory.TAIGA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8168447).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(33, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.3f).m_47611_(0.8f).m_47595_(Biome.BiomeCategory.TAIGA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8168447).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(34, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.2f).m_47611_(0.3f).m_47595_(Biome.BiomeCategory.EXTREME_HILLS).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8233727).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(35, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(1.2f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.SAVANNA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7711487).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(36, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(1.0f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.SAVANNA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7776511).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(37, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.MESA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7254527).m_48043_(10387789).m_48045_(9470285).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(38, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.MESA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7254527).m_48043_(10387789).m_48045_(9470285).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(39, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.MESA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7254527).m_48043_(10387789).m_48045_(9470285).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(40, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(0.5f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.THEEND).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(0xA080A0).m_48034_(4159204).m_48037_(329011).m_48040_(0).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(41, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(0.5f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.THEEND).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(0xA080A0).m_48034_(4159204).m_48037_(329011).m_48040_(0).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(42, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(0.5f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.THEEND).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(0xA080A0).m_48034_(4159204).m_48037_(329011).m_48040_(0).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(43, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(0.5f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.THEEND).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(0xA080A0).m_48034_(4159204).m_48037_(329011).m_48040_(0).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(44, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.5f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.OCEAN).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4445678).m_48037_(270131).m_48040_(8103167).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(45, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.5f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.OCEAN).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4566514).m_48037_(267827).m_48040_(8103167).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(46, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.5f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.OCEAN).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4020182).m_48037_(329011).m_48040_(8103167).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(47, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.5f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.OCEAN).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4445678).m_48037_(270131).m_48040_(8103167).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(48, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.5f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.OCEAN).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4566514).m_48037_(267827).m_48040_(8103167).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(49, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.5f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.OCEAN).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4020182).m_48037_(329011).m_48040_(8103167).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(50, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.5f).m_47611_(0.5f).m_47599_(Biome.TemperatureModifier.FROZEN).m_47595_(Biome.BiomeCategory.OCEAN).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(3750089).m_48037_(329011).m_48040_(8103167).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(129, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.8f).m_47611_(0.4f).m_47595_(Biome.BiomeCategory.PLAINS).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7907327).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(130, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.DESERT).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7254527).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(131, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.2f).m_47611_(0.3f).m_47595_(Biome.BiomeCategory.EXTREME_HILLS).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8233727).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(132, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.7f).m_47611_(0.8f).m_47595_(Biome.BiomeCategory.FOREST).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(133, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.25f).m_47611_(0.8f).m_47595_(Biome.BiomeCategory.TAIGA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8233983).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(134, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.8f).m_47611_(0.9f).m_47595_(Biome.BiomeCategory.SWAMP).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(6388580).m_48037_(2302743).m_48040_(7907327).m_48043_(6975545).m_48031_(BiomeSpecialEffects.GrassColorModifier.SWAMP).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(140, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47609_(0.0f).m_47611_(0.5f).m_47595_(Biome.BiomeCategory.ICY).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8364543).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(149, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.95f).m_47611_(0.9f).m_47595_(Biome.BiomeCategory.JUNGLE).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7842047).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(151, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.95f).m_47611_(0.8f).m_47595_(Biome.BiomeCategory.JUNGLE).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7842047).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(155, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.6f).m_47611_(0.6f).m_47595_(Biome.BiomeCategory.FOREST).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8037887).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(156, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.6f).m_47611_(0.6f).m_47595_(Biome.BiomeCategory.FOREST).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8037887).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(157, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.7f).m_47611_(0.8f).m_47595_(Biome.BiomeCategory.FOREST).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7972607).m_48031_(BiomeSpecialEffects.GrassColorModifier.DARK_FOREST).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(158, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47609_(-0.5f).m_47611_(0.4f).m_47595_(Biome.BiomeCategory.TAIGA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4020182).m_48037_(329011).m_48040_(8625919).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(160, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.25f).m_47611_(0.8f).m_47595_(Biome.BiomeCategory.TAIGA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8233983).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(161, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.25f).m_47611_(0.8f).m_47595_(Biome.BiomeCategory.TAIGA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8233983).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(162, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.2f).m_47611_(0.3f).m_47595_(Biome.BiomeCategory.EXTREME_HILLS).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(8233727).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(163, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(1.1f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.SAVANNA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7776767).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(164, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(1.0f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.SAVANNA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7776511).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(165, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.MESA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7254527).m_48043_(10387789).m_48045_(9470285).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(166, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.MESA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7254527).m_48043_(10387789).m_48045_(9470285).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(167, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.MESA).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7254527).m_48043_(10387789).m_48045_(9470285).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(168, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.95f).m_47611_(0.9f).m_47595_(Biome.BiomeCategory.JUNGLE).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7842047).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(169, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.95f).m_47611_(0.9f).m_47595_(Biome.BiomeCategory.JUNGLE).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(7842047).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(170, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.NETHER).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(1787717).m_48034_(4159204).m_48037_(329011).m_48040_(7254527).m_48029_(new AmbientParticleSettings((ParticleOptions)Registry.f_122829_.m_7745_(new ResourceLocation("minecraft:ash")), 0.00625f)).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(171, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.NETHER).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(0x330303).m_48034_(4159204).m_48037_(329011).m_48040_(7254527).m_48029_(new AmbientParticleSettings((ParticleOptions)Registry.f_122829_.m_7745_(new ResourceLocation("minecraft:crimson_spore")), 0.025f)).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(172, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.NETHER).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(1705242).m_48034_(4159204).m_48037_(329011).m_48040_(7254527).m_48029_(new AmbientParticleSettings((ParticleOptions)Registry.f_122829_.m_7745_(new ResourceLocation("minecraft:warped_spore")), 0.01428f)).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
            MAP.put(173, new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47595_(Biome.BiomeCategory.NETHER).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(6840176).m_48034_(4159204).m_48037_(4341314).m_48040_(7254527).m_48029_(new AmbientParticleSettings((ParticleOptions)Registry.f_122829_.m_7745_(new ResourceLocation("minecraft:white_ash")), 0.118093f)).m_48018_()).m_47601_(DUMMY_GENERATION_SETTINGS).m_47605_(DUMMY_MOB_SPAWN_SETTINGS).m_47592_());
        }
    }

    private static interface BiomeMapper {
        public int getId(Biome var1);

        public Biome getBiome(int var1);
    }
}

