/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.provider;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;

public class InputSimulator {
    private static final Set<Integer> PRESSED_KEYS = new HashSet<Integer>();
    private static final Map<Integer, Integer> PRESSED_MODIFIERS = new HashMap<Integer, Integer>();
    private static long AIR_TYPING_WARNING_TIME;

    public static boolean isKeyDown(int key) {
        return PRESSED_KEYS.contains(key) || PRESSED_MODIFIERS.getOrDefault(key, 0) > 0;
    }

    private static void handleKeyAction(int key, int modifiers, int action) {
        Minecraft.m_91087_().f_91068_.m_90893_(Minecraft.m_91087_().m_91268_().m_85439_(), key, 0, action, modifiers);
    }

    public static void pressKey(int key, int modifiers) {
        PRESSED_KEYS.add(key);
        InputSimulator.handleKeyAction(key, modifiers, 1);
    }

    public static void pressKey(int key) {
        InputSimulator.pressKey(key, 0);
    }

    public static void releaseKey(int key, int modifiers) {
        PRESSED_KEYS.remove(key);
        InputSimulator.handleKeyAction(key, modifiers, 0);
    }

    public static void releaseKey(int key) {
        InputSimulator.releaseKey(key, 0);
    }

    public static void pressModifier(int key, int modifiers) {
        PRESSED_MODIFIERS.merge(key, 1, Integer::sum);
        InputSimulator.handleKeyAction(key, modifiers, 1);
    }

    public static void pressModifier(int key) {
        InputSimulator.pressModifier(key, 0);
    }

    public static void releaseModifier(int key, int modifiers) {
        PRESSED_MODIFIERS.merge(key, -1, Integer::sum);
        InputSimulator.handleKeyAction(key, modifiers, 0);
    }

    public static void releaseModifier(int key) {
        InputSimulator.releaseModifier(key, 0);
    }

    public static void typeChar(char character, int modifiers) {
        Minecraft.m_91087_().f_91068_.m_90889_(Minecraft.m_91087_().m_91268_().m_85439_(), (int)character, modifiers);
    }

    public static void typeChar(char character) {
        InputSimulator.typeChar(character, 0);
    }

    public static void pressMouse(int button, int modifiers) {
        Minecraft.m_91087_().f_91067_.m_91530_(Minecraft.m_91087_().m_91268_().m_85439_(), button, 1, modifiers);
    }

    public static void pressMouse(int button) {
        InputSimulator.pressMouse(button, 0);
    }

    public static void releaseMouse(int button, int modifiers) {
        Minecraft.m_91087_().f_91067_.m_91530_(Minecraft.m_91087_().m_91268_().m_85439_(), button, 0, modifiers);
    }

    public static void releaseMouse(int button) {
        InputSimulator.releaseMouse(button, 0);
    }

    public static void setMousePos(double x, double y) {
        Minecraft.m_91087_().f_91067_.m_91561_(Minecraft.m_91087_().m_91268_().m_85439_(), x, y);
    }

    public static void scrollMouse(double xOffset, double yOffset) {
        Minecraft.m_91087_().f_91067_.m_91526_(Minecraft.m_91087_().m_91268_().m_85439_(), xOffset, yOffset);
    }

    public static void typeChars(CharSequence characters) {
        for (int i = 0; i < characters.length(); ++i) {
            char character = characters.charAt(i);
            InputSimulator.typeChar(character);
        }
    }

    public static void pressKeyForBind(int code) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        if (dataHolder.vrSettings.keyboardPressBinds) {
            if (code != -1) {
                InputSimulator.pressKey(code);
            }
        } else if (minecraft.f_91080_ == null && ClientUtils.milliTime() - AIR_TYPING_WARNING_TIME >= 30000L) {
            ClientUtils.addChatMessage((Component)new TranslatableComponent("vivecraft.messages.airtypingwarning"));
            AIR_TYPING_WARNING_TIME = ClientUtils.milliTime();
        }
    }

    public static void releaseKeyForBind(int code) {
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        if (dataHolder.vrSettings.keyboardPressBinds && code != -1) {
            InputSimulator.releaseKey(code);
        }
    }
}

