/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.Util;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TorchBlock;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3fc;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.trackers.ClimbTracker;
import org.vivecraft.client_vr.gameplay.trackers.SwingTracker;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.ViveItemTags;

public class VivecraftItemRendering {
    private static final ClientDataHolderVR DH = ClientDataHolderVR.getInstance();

    public static VivecraftItemTransformType getTransformType(ItemStack itemStack, AbstractClientPlayer player, ItemRenderer itemRenderer) {
        VivecraftItemTransformType itemTransformType = VivecraftItemTransformType.ITEM;
        Item item = itemStack.m_41720_();
        if (itemStack.m_41780_() == UseAnim.EAT || itemStack.m_41780_() == UseAnim.DRINK) {
            itemTransformType = VivecraftItemTransformType.NOMS;
        } else if (item instanceof BlockItem) {
            BakedModel bakedmodel;
            Block block = ((BlockItem)item).m_40614_();
            itemTransformType = block instanceof TorchBlock ? VivecraftItemTransformType.BLOCK_STICK : ((bakedmodel = itemRenderer.m_174264_(itemStack, player.f_19853_, (LivingEntity)player, 0)).m_7539_() ? VivecraftItemTransformType.BLOCK_3D : VivecraftItemTransformType.BLOCK_ITEM);
        } else if (item instanceof MapItem || itemStack.m_204117_(ViveItemTags.VIVECRAFT_MAPS)) {
            itemTransformType = VivecraftItemTransformType.MAP;
        } else if (itemStack.m_41780_() == UseAnim.BOW && !itemStack.m_204117_(ViveItemTags.VIVECRAFT_BOW_EXCLUSION)) {
            itemTransformType = VivecraftItemTransformType.BOW_SEATED;
            if (VivecraftItemRendering.DH.bowTracker.isActive((LocalPlayer)player)) {
                itemTransformType = VivecraftItemRendering.DH.bowTracker.isDrawing() ? VivecraftItemTransformType.BOW_ROOMSCALE_DRAWING : VivecraftItemTransformType.BOW_ROOMSCALE;
            }
        } else if (itemStack.m_204117_(ViveItemTags.VIVECRAFT_ROTATED_TOOLS)) {
            itemTransformType = VivecraftItemTransformType.ROTATED_TOOL;
        } else if (item instanceof SwordItem || itemStack.m_204117_(ViveItemTags.VIVECRAFT_SWORDS)) {
            itemTransformType = VivecraftItemTransformType.SWORD;
        } else if (item instanceof ShieldItem || itemStack.m_204117_(ViveItemTags.VIVECRAFT_SHIELDS)) {
            itemTransformType = VivecraftItemTransformType.SHIELD;
        } else if (item instanceof TridentItem || itemStack.m_204117_(ViveItemTags.VIVECRAFT_SPEARS)) {
            itemTransformType = VivecraftItemTransformType.SPEAR;
        } else if (item instanceof CrossbowItem || itemStack.m_204117_(ViveItemTags.VIVECRAFT_CROSSBOWS)) {
            itemTransformType = VivecraftItemTransformType.CROSSBOW;
        } else if (item instanceof CompassItem || item == Items.f_42524_ || itemStack.m_204117_(ViveItemTags.VIVECRAFT_COMPASSES)) {
            itemTransformType = VivecraftItemTransformType.COMPASS;
        } else if (SwingTracker.isTool(itemStack)) {
            itemTransformType = VivecraftItemTransformType.TOOL;
            if (item instanceof FoodOnAStickItem || item instanceof FishingRodItem || itemStack.m_204117_(ViveItemTags.VIVECRAFT_FISHING_RODS)) {
                itemTransformType = VivecraftItemTransformType.TOOL_ROD;
            }
        } else if (TelescopeTracker.isTelescope(itemStack)) {
            itemTransformType = VivecraftItemTransformType.TELESCOPE;
        }
        return itemTransformType;
    }

    public static void applyThirdPersonItemTransforms(PoseStack poseStack, VivecraftItemTransformType itemTransformType, boolean mainHand, AbstractClientPlayer player, float equippedProgress, float partialTick, ItemStack itemStack, InteractionHand hand) {
        int k = mainHand ? 1 : -1;
        float scale = 0.525f;
        float translateX = 0.0f;
        float translateY = 0.05f;
        float translateZ = 0.0f;
        boolean useLeftHandModelinLeftHand = false;
        if (ClimbTracker.isClaws(itemStack)) {
            scale = 0.4f;
        }
        poseStack.m_85837_((double)translateX, (double)translateY, (double)translateZ);
        poseStack.m_85841_(scale, scale, scale);
    }

    public static void applyFirstPersonItemTransforms(PoseStack poseStack, VivecraftItemTransformType itemTransformType, boolean mainHand, AbstractClientPlayer player, float equippedProgress, float partialTick, ItemStack itemStack, InteractionHand hand) {
        float gunAngle = VivecraftItemRendering.DH.vr.getGunAngle();
        float scale = 0.7f;
        float translateX = -0.05f;
        float translateY = 0.005f;
        float translateZ = 0.0f;
        Quaternion rotation = Quaternion.f_80118_.m_80161_();
        Quaternion preRotation = Quaternion.f_80118_.m_80161_();
        rotation.m_80148_(Vector3f.f_122223_.m_122240_(-110.0f + gunAngle));
        switch (itemTransformType) {
            case BOW_SEATED: {
                rotation.m_80148_(Vector3f.f_122223_.m_122240_(90.0f - gunAngle));
                translateY += -0.1f;
                translateZ += 0.1f;
                break;
            }
            case BOW_ROOMSCALE: {
                preRotation.m_80143_(rotation.m_80140_(), rotation.m_80150_(), rotation.m_80153_(), rotation.m_80156_());
                rotation.m_80143_(0.0f, 0.0f, 0.0f, 1.0f);
                translateX -= 0.0225f;
                translateY -= 0.25f;
                translateZ += 0.025f + 0.03f * gunAngle / 40.0f;
                scale = 1.0f;
                break;
            }
            case BOW_ROOMSCALE_DRAWING: {
                rotation.m_80143_(0.0f, 0.0f, 0.0f, 1.0f);
                scale = 1.0f;
                int bowHand = 1;
                if (VivecraftItemRendering.DH.vrSettings.reverseShootingEye && ClientNetworking.supportsReversedBow()) {
                    bowHand = 0;
                }
                Vector3fc aim = VivecraftItemRendering.DH.bowTracker.getAimVector();
                org.joml.Vector3f forward = VivecraftItemRendering.DH.vrPlayer.vrdata_world_render.getHand(bowHand).getCustomVector(MathUtils.FORWARD);
                if (VivecraftItemRendering.DH.bowTracker.isCharged()) {
                    long j = Util.m_137550_() - VivecraftItemRendering.DH.bowTracker.startDrawTime;
                    translateX += 0.003f * Mth.m_14031_((float)j);
                }
                poseStack.m_85837_(0.0, 0.0, (double)0.1f);
                poseStack.m_85850_().m_85861_().m_27644_(MathUtils.toMcMat4((Matrix4fc)VivecraftItemRendering.DH.vrPlayer.vrdata_world_render.getController(bowHand).getMatrix().transpose()));
                Quaternionf lookRotation = new Quaternionf().lookAlong(aim, (Vector3fc)forward).conjugate();
                preRotation.m_80143_(lookRotation.x, lookRotation.y, lookRotation.z, lookRotation.w);
                rotation = Vector3f.f_122225_.m_122240_(180.0f);
                rotation.m_80148_(Vector3f.f_122223_.m_122240_(160.0f));
                translateX += 0.125f;
                translateY += 0.1225f;
                translateZ += 0.16f;
                break;
            }
            case CROSSBOW: {
                rotation = Vector3f.f_122225_.m_122240_(10.0f);
                translateX += 0.01f;
                translateZ -= 0.02f;
                translateY -= 0.02f;
                scale = 0.5f;
                break;
            }
            case MAP: {
                rotation = Vector3f.f_122223_.m_122240_(-45.0f);
                translateX = 0.0f;
                translateY = 0.16f;
                translateZ = -0.075f;
                scale = 0.75f;
                break;
            }
            case NOMS: {
                rotation = Vector3f.f_122227_.m_122240_(180.0f);
                rotation.m_80148_(Vector3f.f_122223_.m_122240_(-135.0f));
                translateX += 0.08f;
                translateZ += 0.02f + 0.006f * Mth.m_14031_((float)player.m_21212_());
                scale = 0.4f;
                break;
            }
            case ITEM: 
            case BLOCK_ITEM: {
                rotation = Vector3f.f_122227_.m_122240_(180.0f);
                rotation.m_80148_(Vector3f.f_122223_.m_122240_(-135.0f));
                translateX += 0.08f;
                translateZ += -0.08f;
                scale = 0.4f;
                break;
            }
            case COMPASS: {
                rotation = Vector3f.f_122225_.m_122240_(90.0f);
                rotation.m_80148_(Vector3f.f_122223_.m_122240_(25.0f));
                scale = 0.4f;
                break;
            }
            case BLOCK_3D: {
                translateX += 0.05f;
                translateZ -= 0.1f;
                rotation.m_80148_(Vector3f.f_122223_.m_122240_(90.0f - gunAngle));
                scale = 0.3f;
                break;
            }
            case BLOCK_STICK: {
                rotation = Vector3f.f_122223_.m_122240_(-45.0f + gunAngle);
                translateY += -0.105f + 0.06f * gunAngle / 40.0f;
                translateZ -= 0.1f;
                break;
            }
            case SHIELD: {
                int side;
                int n = side = mainHand ? 1 : -1;
                if (VivecraftItemRendering.DH.vrSettings.reverseHands) {
                    side *= -1;
                }
                scale = 0.4f;
                translateY += 0.18f;
                if (side == 1) {
                    rotation.m_80148_(Vector3f.f_122223_.m_122240_(105.0f - gunAngle));
                    translateX += 0.11f;
                } else {
                    rotation.m_80148_(Vector3f.f_122223_.m_122240_(115.0f - gunAngle));
                    translateX -= 0.015f;
                }
                translateZ += 0.1f;
                if (player.m_6117_() && player.m_21212_() > 0 && player.m_7655_() == hand) {
                    rotation.m_80148_(Vector3f.f_122223_.m_122240_((float)side * 5.0f));
                    rotation.m_80148_(Vector3f.f_122227_.m_122240_(-5.0f));
                    if (side == 1) {
                        translateX += 0.04f;
                        translateY -= 0.12f;
                        translateZ -= 0.1f;
                    } else {
                        translateX += 0.19f;
                        translateY -= 0.12f;
                        translateZ -= 0.11f;
                    }
                    if (player.m_21254_()) {
                        rotation.m_80148_(Vector3f.f_122225_.m_122240_((float)side * 90.0f));
                    } else {
                        rotation.m_80148_(Vector3f.f_122225_.m_122240_((1.0f - equippedProgress) * (float)side * 90.0f));
                    }
                }
                rotation.m_80148_(Vector3f.f_122225_.m_122240_((float)side * -90.0f));
                break;
            }
            case SPEAR: {
                rotation.m_80143_(0.0f, 0.0f, 0.0f, 1.0f);
                translateX -= 0.135f;
                translateZ += 0.575f;
                scale = 0.6f;
                float progress = 0.0f;
                boolean charging = false;
                int riptideLevel = 0;
                if (player.m_6117_() && player.m_21212_() > 0 && player.m_7655_() == hand) {
                    charging = true;
                    riptideLevel = EnchantmentHelper.m_44932_((ItemStack)itemStack);
                    if ((riptideLevel <= 0 || player.m_20070_()) && (progress = (float)itemStack.m_41779_() - ((float)player.m_21212_() - partialTick + 1.0f)) > 10.0f) {
                        float rotationProgress = progress - 10.0f;
                        progress = 10.0f;
                        if (riptideLevel > 0 && player.m_20070_()) {
                            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-rotationProgress * 10.0f * (float)riptideLevel));
                        }
                        if (VivecraftItemRendering.DH.frameIndex % 4L == 0L) {
                            VivecraftItemRendering.DH.vr.triggerHapticPulse(mainHand ? 0 : 1, 200);
                        }
                        translateX += 0.003f * (float)Math.sin(Util.m_137550_());
                    }
                }
                if (player.m_21209_()) {
                    riptideLevel = 5;
                    translateZ -= 0.15f;
                    poseStack.m_85845_(Vector3f.f_122227_.m_122240_((float)(-VivecraftItemRendering.DH.tickCounter * 10 * riptideLevel % 360) - partialTick * 10.0f * (float)riptideLevel));
                    charging = true;
                }
                if (!charging) {
                    translateY += 0.2f * gunAngle / 40.0f;
                    rotation.m_80148_(Vector3f.f_122223_.m_122240_(gunAngle));
                }
                rotation.m_80148_(Vector3f.f_122223_.m_122240_(-65.0f));
                translateZ += -0.75f + progress / 10.0f * 0.25f;
                break;
            }
            case TOOL_ROD: {
                rotation.m_80148_(Vector3f.f_122223_.m_122240_(40.0f));
                translateY += -0.02f + gunAngle / 40.0f * 0.1f;
                translateX += 0.05f;
                translateZ -= 0.15f;
                scale = 0.8f;
                break;
            }
            case ROTATED_TOOL: {
                rotation.m_80148_(Vector3f.f_122223_.m_122240_(90.0f));
                translateY += -0.125f + gunAngle / 40.0f * 0.1f;
                translateZ -= 0.1f;
                break;
            }
            case TOOL: {
                if (!(itemStack.m_41720_() instanceof ArrowItem) && !itemStack.m_204117_(ViveItemTags.VIVECRAFT_ARROWS)) break;
                preRotation = Vector3f.f_122227_.m_122240_(-180.0f);
                rotation.m_80148_(Vector3f.f_122223_.m_122240_(-gunAngle));
                break;
            }
            case TELESCOPE: {
                preRotation.m_80143_(0.0f, 0.0f, 0.0f, 1.0f);
                rotation.m_80143_(0.0f, 0.0f, 0.0f, 1.0f);
                translateX = (mainHand ? -0.03f : 0.03f) * (scale *= 0.625f);
                translateY = 0.0f;
                translateZ = -0.1f * scale;
                break;
            }
        }
        poseStack.m_85845_(preRotation);
        poseStack.m_85837_((double)translateX, (double)translateY, (double)translateZ);
        poseStack.m_85845_(rotation);
        poseStack.m_85841_(scale, scale, scale);
    }

    public static enum VivecraftItemTransformType {
        ITEM,
        BLOCK_3D,
        BLOCK_STICK,
        BLOCK_ITEM,
        SHIELD,
        SWORD,
        TOOL,
        TOOL_ROD,
        BOW_SEATED,
        BOW_ROOMSCALE,
        BOW_ROOMSCALE_DRAWING,
        SPEAR,
        MAP,
        NOMS,
        CROSSBOW,
        TELESCOPE,
        COMPASS,
        ROTATED_TOOL;

    }
}

