/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MethodHolder;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.render.MirrorNotification;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.common.utils.math.Axis;

public class VRHotkeys {
    static final boolean DEBUG = false;
    private static int START_CONTROLLER;
    private static VRData.VRDevicePose START_CONTROLLER_POSE;
    private static Vector3f START_CAMPOS;
    private static Quaternionf START_CAMROT_QUAT;
    private static Triggerer CAM_TRIGGERER;

    public static boolean handleKeyboardInputs(int key, int scanCode, int action, int modifiers) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        boolean gotKey = false;
        if (action == 1) {
            if (MethodHolder.isKeyDown(345)) {
                if (VRState.VR_INITIALIZED) {
                    if (key == 344) {
                        dataHolder.vrSettings.storeDebugAim = true;
                        ClientUtils.addChatMessage((Component)new TranslatableComponent("vivecraft.messages.showaim"));
                        gotKey = true;
                    }
                    if (key == 73) {
                        dataHolder.vrSettings.inertiaFactor = (VRSettings.InertiaFactor)dataHolder.vrSettings.inertiaFactor.getNext();
                        ClientUtils.addChatMessage((Component)new TranslatableComponent("vivecraft.messages.playerinertia", new Object[]{new TranslatableComponent(dataHolder.vrSettings.inertiaFactor.getLangKey())}));
                        gotKey = true;
                    }
                    if (key == 82 && ClientNetworking.SERVER_ALLOWS_DIRECT_TELEPORT) {
                        if (dataHolder.vrPlayer.isTeleportOverridden()) {
                            dataHolder.vrPlayer.setTeleportOverride(false);
                            ClientUtils.addChatMessage((Component)new TranslatableComponent("vivecraft.messages.teleportdisabled"));
                        } else {
                            dataHolder.vrPlayer.setTeleportOverride(true);
                            ClientUtils.addChatMessage((Component)new TranslatableComponent("vivecraft.messages.teleportenabled"));
                        }
                        gotKey = true;
                    }
                }
                if (key == 296) {
                    ClientDataHolderVR.getInstance().vrSettings.vrEnabled = VRState.VR_ENABLED = !VRState.VR_ENABLED;
                    gotKey = true;
                }
            }
            if (key == 301) {
                // empty if block
            }
            if (key == 294 && (minecraft.f_91073_ == null || minecraft.f_91080_ != null) && VRState.VR_INITIALIZED) {
                dataHolder.vrSettings.setOptionValue(VRSettings.VrOptions.MIRROR_DISPLAY);
                MirrorNotification.notify(dataHolder.vrSettings.getButtonDisplayString(VRSettings.VrOptions.MIRROR_DISPLAY), false, 3000);
                gotKey = true;
            }
        }
        if (VRState.VR_INITIALIZED) {
            gotKey |= dataHolder.vr.handleKeyboardInputs(key, scanCode, action, modifiers);
            if (dataHolder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY || dataHolder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON) {
                gotKey |= VRHotkeys.handleMRKeys();
            }
        }
        if (gotKey) {
            dataHolder.vrSettings.saveOptions();
        }
        return gotKey;
    }

    public static boolean handleMRKeys() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        boolean gotKey = false;
        if (MethodHolder.isKeyDown(345)) {
            if (MethodHolder.isKeyDown(344)) {
                if (MethodHolder.isKeyDown(265)) {
                    VRHotkeys.adjustCamRot(Axis.PITCH, 0.5f);
                    gotKey = true;
                }
                if (MethodHolder.isKeyDown(264)) {
                    VRHotkeys.adjustCamRot(Axis.PITCH, -0.5f);
                    gotKey = true;
                }
                if (MethodHolder.isKeyDown(263)) {
                    VRHotkeys.adjustCamRot(Axis.YAW, 0.5f);
                    gotKey = true;
                }
                if (MethodHolder.isKeyDown(262)) {
                    VRHotkeys.adjustCamRot(Axis.YAW, -0.5f);
                    gotKey = true;
                }
                if (MethodHolder.isKeyDown(266)) {
                    VRHotkeys.adjustCamRot(Axis.ROLL, 0.5f);
                    gotKey = true;
                }
                if (MethodHolder.isKeyDown(267)) {
                    VRHotkeys.adjustCamRot(Axis.ROLL, -0.5f);
                    gotKey = true;
                }
            } else {
                if (MethodHolder.isKeyDown(263)) {
                    VRHotkeys.adjustCamPos(-0.01f, 0.0f, 0.0f);
                    gotKey = true;
                }
                if (MethodHolder.isKeyDown(262)) {
                    VRHotkeys.adjustCamPos(0.01f, 0.0f, 0.0f);
                    gotKey = true;
                }
                if (MethodHolder.isKeyDown(265)) {
                    VRHotkeys.adjustCamPos(0.0f, 0.0f, -0.01f);
                    gotKey = true;
                }
                if (MethodHolder.isKeyDown(264)) {
                    VRHotkeys.adjustCamPos(0.0f, 0.0f, 0.01f);
                    gotKey = true;
                }
                if (MethodHolder.isKeyDown(266)) {
                    VRHotkeys.adjustCamPos(0.0f, 0.01f, 0.0f);
                    gotKey = true;
                }
                if (MethodHolder.isKeyDown(267)) {
                    VRHotkeys.adjustCamPos(0.0f, -0.01f, 0.0f);
                    gotKey = true;
                }
                if (MethodHolder.isKeyDown(268)) {
                    VRHotkeys.snapMRCam(0);
                    gotKey = true;
                }
            }
            if (MethodHolder.isKeyDown(344)) {
                if (MethodHolder.isKeyDown(260)) {
                    dataHolder.vrSettings.mixedRealityFov += 1.0f;
                    gotKey = true;
                }
                if (MethodHolder.isKeyDown(261)) {
                    dataHolder.vrSettings.mixedRealityFov -= 1.0f;
                    gotKey = true;
                }
            } else {
                if (MethodHolder.isKeyDown(260)) {
                    minecraft.f_91066_.f_92068_ += 1.0;
                    gotKey = true;
                }
                if (MethodHolder.isKeyDown(261)) {
                    minecraft.f_91066_.f_92068_ -= 1.0;
                    gotKey = true;
                }
            }
        }
        if (gotKey) {
            dataHolder.vrSettings.saveOptions();
            if (dataHolder.vr.mrMovingCamActive) {
                VRHotkeys.logPositionRotation(dataHolder.vrSettings.mrMovingCamOffset, dataHolder.vrSettings.mrMovingCamOffsetRotQuat);
            } else {
                VRHotkeys.logPositionRotation(dataHolder.vrSettings.vrFixedCampos, dataHolder.vrSettings.vrFixedCamrotQuat);
            }
        }
        return gotKey;
    }

    private static void logPositionRotation(Vector3f position, Quaternionf rotation) {
        ClientUtils.addChatMessage((Component)new TranslatableComponent("vivecraft.messages.coords", new Object[]{"%.2f".formatted(Float.valueOf(position.x)), "%.2f".formatted(Float.valueOf(position.y)), "%.2f".formatted(Float.valueOf(position.z))}));
        Vector3f angle = MathUtils.getEulerAnglesYZX(rotation);
        ClientUtils.addChatMessage((Component)new TranslatableComponent("vivecraft.messages.angles", new Object[]{"%.1f".formatted(Math.toDegrees(angle.x)), "%.1f".formatted(Math.toDegrees(angle.y)), "%.1f".formatted(Math.toDegrees(angle.z))}));
    }

    private static void adjustCamPos(float offsetX, float offsetY, float offsetZ) {
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        if (dataHolder.vr.mrMovingCamActive) {
            Vector3f offset = dataHolder.vrSettings.mrMovingCamOffsetRotQuat.transform(offsetX, offsetY, offsetZ, new Vector3f());
            dataHolder.vrSettings.mrMovingCamOffset.add((Vector3fc)offset);
        } else {
            Vector3f offset = dataHolder.vrSettings.vrFixedCamrotQuat.transform(offsetX, offsetY, offsetZ, new Vector3f());
            dataHolder.vrSettings.vrFixedCampos.add((Vector3fc)offset);
        }
    }

    private static void adjustCamRot(Axis axis, float degrees) {
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        float rad = (float)Math.PI / 180 * degrees;
        if (dataHolder.vr.mrMovingCamActive) {
            switch (axis) {
                case PITCH: {
                    dataHolder.vrSettings.mrMovingCamOffsetRotQuat.rotateLocalX(rad);
                    break;
                }
                case YAW: {
                    dataHolder.vrSettings.mrMovingCamOffsetRotQuat.rotateLocalY(rad);
                    break;
                }
                case ROLL: {
                    dataHolder.vrSettings.mrMovingCamOffsetRotQuat.rotateLocalZ(rad);
                }
            }
        } else {
            dataHolder.vrSettings.vrFixedCamrotQuat.rotateAxis(rad, axis.getVector());
        }
    }

    public static void snapMRCam(int controller) {
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        Vector3f pos = dataHolder.vrPlayer.vrdata_room_pre.getController(controller).getPositionF();
        dataHolder.vrSettings.vrFixedCampos.set((Vector3fc)pos);
        dataHolder.vrSettings.vrFixedCamrotQuat.setFromNormalized((Matrix4fc)dataHolder.vrPlayer.vrdata_room_pre.getController(controller).getMatrix());
    }

    public static void updateMovingThirdPersonCam() {
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        if (START_CONTROLLER_POSE != null) {
            VRData.VRDevicePose controllerPose = dataHolder.vrPlayer.vrdata_room_pre.getController(START_CONTROLLER);
            Vector3f startPos = START_CONTROLLER_POSE.getPositionF();
            Vector3f deltaPos = controllerPose.getPositionF().sub((Vector3fc)startPos);
            Matrix4f deltaMatrix = controllerPose.getMatrix().mul((Matrix4fc)START_CONTROLLER_POSE.getMatrix().invert());
            Vector3f offset = START_CAMPOS.sub((Vector3fc)startPos, new Vector3f());
            Vector3f offsetRotated = deltaMatrix.transformPosition((Vector3fc)offset, new Vector3f());
            dataHolder.vrSettings.vrFixedCampos.set((Vector3fc)START_CAMPOS).add((Vector3fc)deltaPos).add((Vector3fc)offsetRotated).sub((Vector3fc)offset);
            dataHolder.vrSettings.vrFixedCamrotQuat = deltaMatrix.getNormalizedRotation(new Quaternionf()).mul((Quaternionfc)START_CAMROT_QUAT, dataHolder.vrSettings.vrFixedCamrotQuat);
        }
    }

    public static void startMovingThirdPersonCam(int controller, Triggerer triggerer) {
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        START_CONTROLLER = controller;
        START_CONTROLLER_POSE = dataHolder.vrPlayer.vrdata_room_pre.getController(controller);
        START_CAMPOS = new Vector3f((Vector3fc)dataHolder.vrSettings.vrFixedCampos);
        START_CAMROT_QUAT = new Quaternionf((Quaternionfc)dataHolder.vrSettings.vrFixedCamrotQuat);
        CAM_TRIGGERER = triggerer;
    }

    public static void stopMovingThirdPersonCam() {
        START_CONTROLLER_POSE = null;
    }

    public static boolean isMovingThirdPersonCam() {
        return START_CONTROLLER_POSE != null;
    }

    public static int getMovingThirdPersonCamController() {
        return START_CONTROLLER;
    }

    public static Triggerer getMovingThirdPersonCamTriggerer() {
        return CAM_TRIGGERER;
    }

    public static void loadExternalCameraConfig(VRSettings vrSettings) {
        File file = new File("ExternalCamera.cfg");
        if (file.exists()) {
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            float rx = 0.0f;
            float ry = 0.0f;
            float rz = 0.0f;
            float fov = 40.0f;
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] tokens = line.split("=", 2);
                    switch (tokens[0]) {
                        case "x": {
                            x = Float.parseFloat(tokens[1]);
                            break;
                        }
                        case "y": {
                            y = Float.parseFloat(tokens[1]);
                            break;
                        }
                        case "z": {
                            z = Float.parseFloat(tokens[1]);
                            break;
                        }
                        case "rx": {
                            rx = Float.parseFloat(tokens[1]);
                            break;
                        }
                        case "ry": {
                            ry = Float.parseFloat(tokens[1]);
                            break;
                        }
                        case "rz": {
                            rz = Float.parseFloat(tokens[1]);
                            break;
                        }
                        case "fov": {
                            fov = Float.parseFloat(tokens[1]);
                        }
                    }
                }
            }
            catch (Exception exception) {
                VRSettings.LOGGER.error("Vivecraft: error reading camera config:", (Throwable)exception);
                return;
            }
            Quaternionf quaternion = vrSettings.externalCameraAngleOrder.getRotation((float)Math.PI / 180 * rx, (float)Math.PI / 180 * ry, (float)Math.PI / 180 * rz).conjugate();
            vrSettings.mrMovingCamOffset.set(x, y, z);
            vrSettings.mrMovingCamOffsetRotQuat.set((Quaternionfc)quaternion);
            vrSettings.vrFixedCampos.set(x, y, z);
            vrSettings.vrFixedCamrotQuat.set((Quaternionfc)quaternion);
            vrSettings.mixedRealityFov = fov;
        }
    }

    public static boolean hasExternalCameraConfig() {
        return new File("ExternalCamera.cfg").exists();
    }

    private static /* synthetic */ void lambda$handleKeyboardInputs$0(Minecraft minecraft, Screen current) {
        minecraft.m_91152_(current);
    }

    public static enum Triggerer {
        BINDING,
        MENUBUTTON,
        INTERACTION;

    }
}

