/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.pipeline.RenderTarget;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vivecraft.Xloader;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.client.render.VRPlayerRenderer;
import org.vivecraft.client.render.armor.VRArmorLayer;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.LangHelper;
import org.vivecraft.client.utils.StencilHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.trackers.DebugRenderTracker;
import org.vivecraft.client_vr.gui.PhysicalKeyboard;
import org.vivecraft.client_vr.provider.ControllerTransform;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.settings.OptionEnum;
import org.vivecraft.client_vr.settings.SettingField;
import org.vivecraft.client_vr.settings.VRHotkeys;
import org.vivecraft.common.utils.math.AngleOrder;

public class VRSettings {
    public static final int VERSION = 2;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Vivecraft");
    public static VRSettings INSTANCE;
    public static final int UNKNOWN_VERSION = 0;
    public static final String DEGREE = "\u00b0";
    @SettingField
    public int version = 0;
    @SettingField(value=VrOptions.VR_PLUGIN)
    public VRProvider stereoProviderPluginID = VRProvider.OPENVR;
    public boolean storeDebugAim = false;
    @SettingField
    public int smoothRunTickCount = 20;
    @SettingField
    public boolean smoothTick = false;
    @SettingField(config="QUICKCOMMAND", separate=true)
    public String[] vrQuickCommands = this.getQuickCommandsDefaults();
    @SettingField(config="RADIAL", separate=true)
    public String[] vrRadialItems = this.getRadialItemsDefault();
    @SettingField(config="RADIALALT", separate=true)
    public String[] vrRadialItemsAlt = this.getRadialItemsAltDefault();
    @SettingField(fixedSize=false)
    public String[] vrServerBlacklist = this.getServerBlacklistDefault();
    @SettingField(fixedSize=false)
    public int[] keyboardCodes = this.getKeyboardCodesDefault();
    @SettingField(value=VrOptions.REVERSE_HANDS)
    public boolean reverseHands = false;
    @SettingField(value=VrOptions.REVERSE_BOW)
    public boolean reverseShootingEye = false;
    @SettingField(value=VrOptions.AIM_DEVICE)
    public AimDevice aimDevice = AimDevice.CONTROLLER;
    @SettingField(value=VrOptions.WORLD_SCALE)
    public float worldScale = 1.0f;
    @SettingField(value=VrOptions.WORLD_ROTATION)
    public float worldRotation = 0.0f;
    public float worldRotationCached;
    @SettingField(value=VrOptions.WORLD_ROTATION_INCREMENT, config="vrWorldRotationIncrement")
    public float worldRotationIncrement = 45.0f;
    @SettingField(value=VrOptions.WORLD_ROTATION_X_SENSITIVITY)
    public float worldRotationXSensitivity = 1.0f;
    @SettingField(value=VrOptions.X_SENSITIVITY)
    public float xSensitivity = 1.0f;
    @SettingField(value=VrOptions.Y_SENSITIVITY)
    public float ySensitivity = 1.0f;
    @SettingField(value=VrOptions.KEYHOLE)
    public float keyholeX = 15.0f;
    @SettingField
    public double headToHmdLength = 0.1f;
    @SettingField
    public float autoCalibration = -1.0f;
    @SettingField
    public float manualCalibration = -1.0f;
    @SettingField
    public boolean fbtCalibrated = false;
    @SettingField
    public boolean fbtExtendedCalibrated = false;
    @SettingField
    public boolean unlabeledTrackersUsed = false;
    @SettingField(value=VrOptions.OSC_TRACKER_PORT)
    public int oscTrackerPort = 9000;
    @SettingField(config="FBTOFFSETS")
    public Vector3f[] fbtOffsets = this.getFbtOffsetDefault();
    @SettingField(config="FBTROTATIONS")
    public Quaternionf[] fbtRotations = this.getFbtRotationsDefault();
    @SettingField
    public boolean alwaysSimulateKeyboard = false;
    @SettingField(value=VrOptions.BOW_MODE)
    public BowMode bowMode = BowMode.ON;
    @SettingField
    public String keyboardKeys = "`1234567890-=qwertyuiop[]\\asdfghjkl;':\"zxcvbnm,./?<>";
    @SettingField
    public String keyboardKeysShift = "~!@#$%^&*()_+QWERTYUIOP{}|ASDFGHJKL;':\"ZXCVBNM,./?<>";
    @SettingField(value=VrOptions.HRTF_SELECTION)
    public int hrtfSelection = 0;
    @SettingField(value=VrOptions.RIGHT_CLICK_DELAY)
    public RightClickDelay rightclickDelay = RightClickDelay.VANILLA;
    @SettingField(value=VrOptions.INGAME_BINDINGS_IN_GUI)
    public boolean ingameBindingsInGui = false;
    @SettingField(value=VrOptions.THIRDPERSON_ITEMTRANSFORMS)
    public boolean thirdPersonItems = false;
    @SettingField(value=VrOptions.THIRDPERSON_ITEMTRANSFORMS_CUSTOM)
    public boolean thirdPersonItemsCustom = true;
    @SettingField(value=VrOptions.INERTIA_FACTOR)
    public InertiaFactor inertiaFactor = InertiaFactor.NORMAL;
    @SettingField(value=VrOptions.WALK_UP_BLOCKS)
    public boolean walkUpBlocks = true;
    @SettingField(value=VrOptions.SIMULATE_FALLING)
    public boolean simulateFalling = true;
    @SettingField(value=VrOptions.WEAPON_COLLISION, config="weaponCollisionNew")
    public WeaponCollision weaponCollision = WeaponCollision.AUTO;
    @SettingField(value=VrOptions.FEET_COLLISION)
    public boolean feetCollision = true;
    @SettingField(value=VrOptions.SWORD_BLOCK_COLLISION)
    public boolean swordBlockCollision = true;
    @SettingField(value=VrOptions.ONLY_SWORD_COLLISION)
    public boolean onlySwordCollision = false;
    @SettingField(value=VrOptions.REDUCED_PLAYER_REACH)
    public boolean reducedPlayerReach = true;
    @SettingField(value=VrOptions.MOVEMENT_MULTIPLIER)
    public float movementSpeedMultiplier = 1.0f;
    @SettingField(value=VrOptions.FREEMOVE_MODE)
    public FreeMove vrFreeMoveMode = FreeMove.CONTROLLER;
    @SettingField(value=VrOptions.FREEMOVE_FLY_MODE)
    public FreeMove vrFreeMoveFlyMode = FreeMove.AUTO;
    @SettingField(value=VrOptions.LIMIT_TELEPORT, config="limitedTeleport")
    public boolean vrLimitedSurvivalTeleport = true;
    @SettingField(value=VrOptions.TELEPORT_UP_LIMIT, config="teleportLimitUp")
    public int vrTeleportUpLimit = 1;
    @SettingField(value=VrOptions.TELEPORT_DOWN_LIMIT, config="teleportLimitDown")
    public int vrTeleportDownLimit = 4;
    @SettingField(value=VrOptions.TELEPORT_HORIZ_LIMIT, config="teleportLimitHoriz")
    public int vrTeleportHorizLimit = 16;
    @SettingField(value=VrOptions.PLAY_MODE_SEATED)
    public boolean seated = false;
    @SettingField(value=VrOptions.SEATED_HMD, config="seatedhmd")
    public boolean seatedUseHMD = false;
    @SettingField
    public float jumpThreshold = 0.05f;
    @SettingField
    public float sneakThreshold = 0.4f;
    @SettingField
    public float crawlThreshold = 0.82f;
    @SettingField(value=VrOptions.REALISTIC_JUMP)
    public RealisticJump realisticJumpEnabled = RealisticJump.AUTO;
    @SettingField(value=VrOptions.REALISTIC_SNEAK)
    public boolean realisticSneakEnabled = true;
    @SettingField(value=VrOptions.REALISTIC_CLIMB)
    public boolean realisticClimbEnabled = true;
    @SettingField(value=VrOptions.REALISTIC_SWIM)
    public boolean realisticSwimEnabled = true;
    @SettingField(value=VrOptions.REALISTIC_ROW)
    public boolean realisticRowEnabled = true;
    @SettingField(value=VrOptions.REALISTIC_DISMOUNT)
    public boolean realisticDismountEnabled = true;
    @SettingField(value=VrOptions.REALISTIC_BLOCK_INTERACT)
    public boolean realisticBlockInteractEnabled = true;
    @SettingField(value=VrOptions.REALISTIC_ENTITY_INTERACT)
    public boolean realisticEntityInteractEnabled = true;
    @SettingField(value=VrOptions.REALISTIC_OPENING)
    public boolean doorHitting = true;
    @SettingField(value=VrOptions.BACKPACK_SWITCH)
    public boolean backpackSwitching = true;
    @SettingField(value=VrOptions.PHYSICAL_GUI)
    public boolean physicalGuiEnabled = false;
    @SettingField(value=VrOptions.WALK_MULTIPLIER)
    public float walkMultiplier = 1.0f;
    @SettingField(value=VrOptions.ALLOW_CRAWLING)
    public boolean allowCrawling = true;
    @SettingField(value=VrOptions.BCB_ON, config="bcbOn")
    public boolean vrShowBlueCircleBuddy = true;
    @SettingField(value=VrOptions.VEHICLE_ROTATION)
    public boolean vehicleRotation = true;
    @SettingField(value=VrOptions.ANALOG_MOVEMENT)
    public boolean analogMovement = true;
    @SettingField(value=VrOptions.DIGITAL_MOVEMENT_DEADZONE)
    public float digitalMovementDeadzone = 0.5f;
    @SettingField(value=VrOptions.AUTO_SPRINT)
    public boolean autoSprint = true;
    @SettingField(value=VrOptions.AUTO_SPRINT_THRESHOLD)
    public float autoSprintThreshold = 0.9f;
    @SettingField
    public Vector3f originOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    @SettingField(value=VrOptions.ALLOW_STANDING_ORIGIN_OFFSET)
    public boolean allowStandingOriginOffset = false;
    @SettingField(value=VrOptions.SEATED_FREE_MOVE)
    public boolean seatedFreeMove = false;
    @SettingField(value=VrOptions.FORCE_STANDING_FREE_MOVE)
    public boolean forceStandingFreeMove = false;
    @SettingField(value=VrOptions.FSAA)
    public boolean useFsaa = false;
    @SettingField(value=VrOptions.LOW_HEALTH_INDICATOR, config="low_health_indicator")
    public boolean lowHealthIndicator = true;
    @SettingField(value=VrOptions.HIT_INDICATOR)
    public boolean hitIndicator = true;
    @SettingField(value=VrOptions.WATER_EFFECT)
    public boolean waterEffect = true;
    @SettingField(value=VrOptions.PORTAL_EFFECT)
    public boolean portalEffect = true;
    @SettingField(value=VrOptions.FREEZE_EFFECT)
    public boolean freezeEffect = true;
    @SettingField(value=VrOptions.PUMPKIN_EFFECT)
    public boolean pumpkinEffect = true;
    @SettingField(value=VrOptions.FOV_REDUCTION, config="fovReduction")
    public boolean useFOVReduction = false;
    @SettingField(value=VrOptions.FOV_REDUCTION_OFFSET)
    public float fovRedutioncOffset = 0.1f;
    @SettingField(value=VrOptions.FOV_REDUCTION_MIN)
    public float fovReductionMin = 0.25f;
    @SettingField(value=VrOptions.STENCIL_ON, config="stencilOn")
    public boolean vrUseStencil = true;
    @SettingField(value=VrOptions.STENCIL_BUFFER_DISABLE)
    public boolean stencilBufferDisable = false;
    @SettingField
    public boolean insideBlockSolidColor = false;
    @SettingField(value=VrOptions.RENDER_SCALEFACTOR)
    public float renderScaleFactor = 1.0f;
    @SettingField(value=VrOptions.MIRROR_DISPLAY)
    public MirrorMode displayMirrorMode = MirrorMode.CROPPED;
    @SettingField(value=VrOptions.MIRROR_CROP)
    public float mirrorCrop = 0.15f;
    @SettingField(value=VrOptions.MIRROR_EYE)
    public boolean displayMirrorLeftEye = false;
    @SettingField(value=VrOptions.MIRROR_CENTER_SMOOTH)
    public float displayMirrorCenterSmooth = 0.0f;
    @SettingField(value=VrOptions.MIRROR_SCREENSHOT_CAMERA)
    public boolean displayMirrorUseScreenshotCamera = false;
    @SettingField(value=VrOptions.MIRROR_OFF_TEXT)
    public boolean showMirrorOffText = true;
    @SettingField(value=VrOptions.SHOW_PLAYER_MODEL)
    public boolean shouldRenderSelf = false;
    @SettingField(value=VrOptions.MAIN_PLAYER_DATA)
    public DataSource mainPlayerDataSource = DataSource.REALTIME;
    @SettingField(value=VrOptions.PLAYER_MODEL_TYPE)
    public PlayerModelType playerModelType = PlayerModelType.VANILLA;
    @SettingField(value=VrOptions.SHOW_PLAYER_MODEL_ARMS)
    public ModelArmsMode modelArmsMode = ModelArmsMode.COMPLETE;
    @SettingField(value=VrOptions.SHOW_PLAYER_HANDS)
    public boolean showPlayerHands = true;
    @SettingField(value=VrOptions.PLAYER_LIMBS_CONNECTED)
    public boolean playerLimbsConnected = true;
    @SettingField(value=VrOptions.PLAYER_LIMBS_LIMIT)
    public boolean playerLimbsLimit = false;
    @SettingField(value=VrOptions.PLAYER_WALK_ANIM)
    public boolean playerWalkAnim = true;
    @SettingField(value=VrOptions.PLAYER_ARM_ANIM)
    public boolean playerArmAnim = true;
    @SettingField(value=VrOptions.PLAYER_MODEL_ARMS_SCALE)
    public float playerModelArmsScale = 0.5f;
    @SettingField(value=VrOptions.PLAYER_MODEL_BODY_SCALE)
    public float playerModelBodyScale = 1.0f;
    @SettingField(value=VrOptions.PLAYER_MODEL_LEGS_SCALE)
    public float playerModelLegScale = 1.0f;
    @SettingField(value=VrOptions.APPLY_PLAYER_WORLDSCALE)
    public boolean applyPlayerWorldscale = false;
    @SettingField(value=VrOptions.MENU_WORLD_SELECTION)
    public MenuWorld menuWorldSelection = MenuWorld.BOTH;
    @SettingField(value=VrOptions.MENU_WORLD_FALLBACK)
    public boolean menuWorldFallbackPanorama = true;
    @SettingField(value=VrOptions.RENDER_DEBUG_HEAD_HITBOX)
    public boolean renderHeadHitbox = false;
    @SettingField(value=VrOptions.RENDER_DEBUG_DEVICE_AXES)
    public boolean renderDeviceAxes = false;
    @SettingField(value=VrOptions.RENDER_DEBUG_PLAYER_AXES)
    public boolean renderVrPlayerAxes = false;
    @SettingField(value=VrOptions.RENDER_DEBUG_TRACKERS)
    public boolean renderTrackerPositions = false;
    @SettingField(value=VrOptions.RENDER_DEBUG_GAMEPLAY_TRACKER)
    public boolean renderGameplayTrackers = false;
    @SettingField(value=VrOptions.GAMEPLAY_TRACKER_TO_RENDER)
    public String gameplayTrackerToRender = "";
    @SettingField(value=VrOptions.CONTROLLER_TRANSFORM)
    public ControllerTransform controllerTransform = ControllerTransform.AUTO;
    @SettingField(value=VrOptions.MIXED_REALITY_KEY_COLOR)
    public Color mixedRealityKeyColor = new Color(0, 0, 0);
    public float mixedRealityAspectRatio = 1.7777778f;
    @SettingField(value=VrOptions.MIXED_REALITY_RENDER_HANDS)
    public boolean mixedRealityRenderHands = false;
    @SettingField(value=VrOptions.MIXED_REALITY_UNITY_LIKE)
    public boolean mixedRealityUnityLike = true;
    @SettingField(value=VrOptions.MIXED_REALITY_UNDISTORTED)
    public boolean mixedRealityUndistorted = true;
    @SettingField(value=VrOptions.MIXED_REALITY_ALPHA_MASK)
    public boolean mixedRealityAlphaMask = false;
    @SettingField(value=VrOptions.MIXED_REALITY_FOV)
    public float mixedRealityFov = 40.0f;
    @SettingField(separate=true)
    public Vector3f vrFixedCampos = new Vector3f(-1.0f, 2.5f, 2.7f);
    @SettingField(config="vrFixedCamrot", separate=true)
    public Quaternionf vrFixedCamrotQuat = new Quaternionf(-0.125f, -0.239f, -0.041f, 0.962f);
    @SettingField(separate=true)
    public Vector3f mrMovingCamOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    @SettingField(config="mrMovingCamOffsetRot", separate=true)
    public Quaternionf mrMovingCamOffsetRotQuat = new Quaternionf();
    @SettingField
    public AngleOrder externalCameraAngleOrder = AngleOrder.XZY;
    @SettingField(value=VrOptions.HANDHELD_CAMERA_FOV)
    public float handCameraFov = 70.0f;
    @SettingField(value=VrOptions.HANDHELD_CAMERA_RENDER_SCALE)
    public float handCameraResScale = 1.0f;
    @SettingField(value=VrOptions.MIXED_REALITY_RENDER_CAMERA_MODEL)
    public boolean mixedRealityRenderCameraModel = true;
    @SettingField(value=VrOptions.TOUCH_HOTBAR)
    public boolean vrTouchHotbar = true;
    @SettingField(value=VrOptions.HUD_SCALE, config="headHudScale")
    public float hudScale = 1.0f;
    @SettingField(value=VrOptions.HUD_DISTANCE)
    public float hudDistance = 1.25f;
    @SettingField
    public float hudPitchOffset = -2.0f;
    @SettingField
    public float hudYawOffset = 0.0f;
    public boolean floatInventory = true;
    @SettingField(value=VrOptions.MENU_ALWAYS_FOLLOW_FACE)
    public boolean menuAlwaysFollowFace;
    @SettingField(value=VrOptions.HUD_LOCK_TO)
    public HUDLock vrHudLockMode = HUDLock.WRIST;
    @SettingField(value=VrOptions.HUD_WRIST_OFFSET)
    public float vrHudWristOffset = 1.0f;
    @SettingField(value=VrOptions.HUD_OCCLUSION)
    public boolean hudOcclusion = true;
    @SettingField(value=VrOptions.CROSSHAIR_SCALE)
    public float crosshairScale = 1.0f;
    @SettingField(value=VrOptions.CROSSHAIR_SCALES_WITH_DISTANCE)
    public boolean crosshairScalesWithDistance = false;
    @SettingField(value=VrOptions.RENDER_CROSSHAIR_MODE)
    public RenderPointerElement renderInGameCrosshairMode = RenderPointerElement.ALWAYS;
    @SettingField(value=VrOptions.RENDER_BLOCK_OUTLINE_MODE)
    public RenderPointerElement renderBlockOutlineMode = RenderPointerElement.ALWAYS;
    @SettingField(value=VrOptions.HUD_OPACITY)
    public float hudOpacity = 1.0f;
    @SettingField(value=VrOptions.RENDER_MENU_BACKGROUND)
    public boolean menuBackground = false;
    @SettingField(value=VrOptions.MENU_CROSSHAIR_SCALE)
    public float menuCrosshairScale = 1.0f;
    @SettingField(value=VrOptions.CROSSHAIR_OCCLUSION)
    public boolean useCrosshairOcclusion = true;
    @SettingField(value=VrOptions.SEATED_HUD_XHAIR)
    public boolean seatedHudAltMode = true;
    @SettingField(value=VrOptions.AUTO_OPEN_KEYBOARD)
    public AutoOpenKeyboard autoOpenKeyboard = AutoOpenKeyboard.OFF;
    @SettingField(value=VrOptions.AUTO_CLOSE_KEYBOARD)
    public boolean autoCloseKeyboard = true;
    @SettingField
    public int forceHardwareDetection = 0;
    @SettingField(value=VrOptions.RADIAL_MODE_HOLD)
    public boolean radialModeHold = true;
    @SettingField(value=VrOptions.RADIAL_NUMBER)
    public int vrRadialButtons = 8;
    @SettingField(value=VrOptions.PHYSICAL_KEYBOARD)
    public boolean physicalKeyboard = true;
    @SettingField(value=VrOptions.PHYSICAL_KEYBOARD_SCALE)
    public float physicalKeyboardScale = 1.0f;
    @SettingField(value=VrOptions.PHYSICAL_KEYBOARD_THEME)
    public PhysicalKeyboard.KeyboardTheme physicalKeyboardTheme = PhysicalKeyboard.KeyboardTheme.DEFAULT;
    @SettingField(value=VrOptions.KEYBOARD_PRESS_BINDS)
    public boolean keyboardPressBinds = false;
    @SettingField(value=VrOptions.ALLOW_ADVANCED_BINDINGS)
    public boolean allowAdvancedBindings = false;
    @SettingField(value=VrOptions.CHAT_NOTIFICATIONS)
    public ChatNotifications chatNotifications = ChatNotifications.NONE;
    @SettingField(value=VrOptions.CHAT_NOTIFICATION_SOUND)
    public String chatNotificationSound = "block.note_block.bell";
    @SettingField(value=VrOptions.GUI_APPEAR_OVER_BLOCK)
    public boolean guiAppearOverBlock = true;
    @SettingField(value=VrOptions.SHADER_GUI_RENDER)
    public ShaderGUIRender shaderGUIRender = ShaderGUIRender.AFTER_SHADER;
    @SettingField(value=VrOptions.SHADER_SHADOW_MODEL_LIMB_SCALE)
    public boolean shaderFullSizeShadowLimbs = true;
    @SettingField(value=VrOptions.SHADER_SLOW)
    public boolean disableShaderOptimization = false;
    @SettingField(value=VrOptions.SHADER_PATCHING)
    public boolean shaderPatching = true;
    @SettingField(value=VrOptions.DOUBLE_GUI_RESOLUTION)
    public boolean doubleGUIResolution = false;
    @SettingField(value=VrOptions.GUI_SCALE)
    public int guiScale = 0;
    @SettingField(value=VrOptions.HUD_MAX_GUI_SCALE)
    public boolean hudMaxScale = false;
    @SettingField(value=VrOptions.GUI_MIPMAPS)
    public boolean guiMipmaps;
    @SettingField(value=VrOptions.GUI_ANISOTROPIC_FILTERING)
    public boolean guiAnisotropicFiltering = true;
    @SettingField(value=VrOptions.SHOW_UPDATES)
    public boolean alwaysShowUpdates = true;
    @SettingField
    public String lastUpdate = "";
    @SettingField(value=VrOptions.UPDATE_TYPE)
    public UpdateType updateType = UpdateType.RELEASE;
    @SettingField(value=VrOptions.SHOW_PLUGIN)
    public ChatServerMessage showServerPluginMessage = ChatServerMessage.SERVER_ONLY;
    @SettingField(value=VrOptions.SHOW_PLUGIN_MISSING)
    public boolean showServerPluginMissingMessageAlways = true;
    @SettingField(value=VrOptions.SHOW_SERVER_VR_CHANGES)
    public ChatServerMessage showServerVrChangesMessage = ChatServerMessage.SERVER_ONLY;
    @SettingField(value=VrOptions.CHAT_MESSAGE_STENCIL)
    public boolean showChatMessageStencil = true;
    @SettingField(value=VrOptions.VR_ENABLED, config="vrEnabled")
    public boolean vrEnabled = false;
    @SettingField(value=VrOptions.VR_CLOSE_WITH_RUNTIME)
    public boolean closeWithRuntime = true;
    @SettingField(value=VrOptions.VR_REMEMBER_ENABLED)
    public boolean rememberVr = true;
    @SettingField(value=VrOptions.VR_HOTSWITCH)
    public boolean vrHotswitchingEnabled = true;
    @SettingField(value=VrOptions.VR_TOGGLE_BUTTON_VISIBLE)
    public boolean vrToggleButtonEnabled = true;
    @SettingField(value=VrOptions.VR_SETTINGS_BUTTON_VISIBLE)
    public boolean vrSettingsButtonEnabled = true;
    @SettingField(value=VrOptions.VR_SETTINGS_BUTTON_POSITION)
    public boolean vrSettingsButtonPositionLeft = true;
    @SettingField(value=VrOptions.MODIFY_PAUSE_MENU)
    public boolean modifyPauseMenu = true;
    @SettingField(value=VrOptions.FULL_RELOAD_ON_INIT)
    public boolean fullReloadOnInit = false;
    @SettingField(value=VrOptions.SEARCH_TYPE)
    public boolean useFuzzySearch = true;
    @SettingField
    public boolean disableGarbageCollectorMessage = false;
    @SettingField
    public boolean selfButtSparklesInFirstPerson = false;
    @SettingField
    public boolean blockIntelWindows = true;
    @SettingField
    public boolean debugCameraTracker;
    @SettingField(value=VrOptions.HUD_HIDE)
    @Deprecated
    public boolean hideGUI;
    @SettingField(value=VrOptions.MONO_FOV)
    @Deprecated
    public float monoFOV;
    public ServerOverrides overrides = new ServerOverrides();
    private final Map<VrOptions, ConfigEntry> fieldEnumMap = new EnumMap<VrOptions, ConfigEntry>(VrOptions.class);
    private final Map<String, ConfigEntry> fieldConfigMap = new HashMap<String, ConfigEntry>();
    private Map<String, String> preservedSettingMap;
    private final File vrCfgFile;
    private final Map<String, String> defaultsMap = new HashMap<String, String>();
    private static final Gson GSON;

    public VRSettings() {
        this.vrCfgFile = Xloader.getConfigPath("vivecraft-client-config.json").toFile();
        this.initializeFieldInfo();
        INSTANCE = this;
        this.storeDefaults();
        this.loadOptions();
        if (this.unlabeledTrackersUsed) {
            this.unlabeledTrackersUsed = false;
            this.fbtCalibrated = false;
            this.fbtExtendedCalibrated = false;
        }
        VRHotkeys.loadExternalCameraConfig(this);
    }

    private void initializeFieldInfo() {
        try {
            for (Field field : VRSettings.class.getFields()) {
                SettingField ann = field.getAnnotation(SettingField.class);
                if (ann == null) continue;
                String config = ann.config().isEmpty() ? field.getName() : ann.config();
                ConfigEntry configEntry = new ConfigEntry(field, ann.value(), config, ann.separate(), ann.fixedSize());
                if (ann.value() != VrOptions.DUMMY) {
                    if (this.fieldEnumMap.containsKey((Object)ann.value())) {
                        throw new RuntimeException("duplicate enum in setting field: " + field.getName());
                    }
                    this.fieldEnumMap.put(ann.value(), configEntry);
                }
                if (ann.separate() && field.getType().isArray()) {
                    int len = Array.getLength(field.get(this));
                    IntStream.range(0, len).forEach(i -> this.fieldConfigMap.put(config + "_" + i, configEntry));
                    continue;
                }
                if (ann.separate() && Quaternionf.class.isAssignableFrom(field.getType())) {
                    Stream.of(Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')).forEach(suffix -> this.fieldConfigMap.put(config + suffix, configEntry));
                    continue;
                }
                if (ann.separate() && Vector3f.class.isAssignableFrom(field.getType())) {
                    Stream.of(Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')).forEach(suffix -> this.fieldConfigMap.put(config + suffix, configEntry));
                    continue;
                }
                this.fieldConfigMap.put(config, configEntry);
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Object loadOption(String name, String value, Object currentValue, VrOptions option, Class<?> type, boolean separate) throws ReflectiveOperationException {
        Object obj = option.convertOption(value);
        if (obj == null) {
            obj = option.loadOption(value);
        }
        if (obj != null) {
            return obj;
        }
        if (type == String.class) {
            return value;
        }
        if (type == Boolean.TYPE) {
            return value.equals("true");
        }
        if (type == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (type == Long.TYPE) {
            return Long.parseLong(value);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (type.isEnum()) {
            Method m = type.getMethod("valueOf", String.class);
            return m.invoke(null, value);
        }
        if (Quaternionf.class.isAssignableFrom(type)) {
            Quaternionf quat = new Quaternionf((Quaternionfc)((Quaternionf)currentValue));
            if (separate) {
                float f = Float.parseFloat(value);
                switch (name.charAt(name.length() - 1)) {
                    case 'W': {
                        quat.w = f;
                        break;
                    }
                    case 'X': {
                        quat.x = -f;
                        break;
                    }
                    case 'Y': {
                        quat.y = -f;
                        break;
                    }
                    case 'Z': {
                        quat.z = -f;
                    }
                }
            } else {
                String[] split = value.split(",");
                quat.w = Float.parseFloat(split[0]);
                quat.x = Float.parseFloat(split[1]);
                quat.y = Float.parseFloat(split[2]);
                quat.z = Float.parseFloat(split[3]);
            }
            return quat;
        }
        if (Vector3f.class.isAssignableFrom(type)) {
            Vector3f vec = new Vector3f((Vector3fc)((Vector3f)currentValue));
            if (separate) {
                float f = Float.parseFloat(value);
                switch (name.charAt(name.length() - 1)) {
                    case 'X': {
                        vec.x = f;
                        break;
                    }
                    case 'Y': {
                        vec.y = f;
                        break;
                    }
                    case 'Z': {
                        vec.z = f;
                    }
                }
            } else {
                String[] split = value.split(",");
                vec.x = Float.parseFloat(split[0]);
                vec.y = Float.parseFloat(split[1]);
                vec.z = Float.parseFloat(split[2]);
            }
            return vec;
        }
        LOGGER.warn("Vivecraft: Don't know how to load VR option {} with type {}", (Object)name, (Object)type.getSimpleName());
        return null;
    }

    private String saveOption(String name, Object obj, VrOptions option, Class<?> type, boolean separate) {
        String value = option.saveOption(obj);
        if (value != null) {
            return value;
        }
        if (type == String.class) {
            return (String)obj;
        }
        if (type == Boolean.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE) {
            return obj.toString();
        }
        if (type.isEnum()) {
            return ((Enum)obj).name();
        }
        if (Quaternionf.class.isAssignableFrom(type)) {
            Quaternionf quat = (Quaternionf)obj;
            if (separate) {
                return Float.toString(switch (name.charAt(name.length() - 1)) {
                    case 'W' -> quat.w;
                    case 'X' -> -quat.x;
                    case 'Y' -> -quat.y;
                    case 'Z' -> -quat.z;
                    default -> 0.0f;
                });
            }
            return quat.w + "," + quat.x + "," + quat.y + "," + quat.z;
        }
        if (Vector3f.class.isAssignableFrom(type)) {
            Vector3f vec = (Vector3f)obj;
            if (separate) {
                return Float.toString(switch (name.charAt(name.length() - 1)) {
                    case 'X' -> vec.x;
                    case 'Y' -> vec.y;
                    case 'Z' -> vec.z;
                    default -> 0.0f;
                });
            }
            return vec.x + "," + vec.y + "," + vec.z;
        }
        LOGGER.warn("Vivecraft: Don't know how to save VR option {} with type {}", (Object)name, (Object)type.getSimpleName());
        return null;
    }

    private Object loadDefault(String name, String value, VrOptions option, Class<?> type, boolean separate, Map<String, String> settingsMap) throws ReflectiveOperationException {
        Object obj;
        if (value == null) {
            value = settingsMap.get(name);
        }
        if ((obj = option.loadOption(value)) != null) {
            return obj;
        }
        if (type == String.class) {
            return value;
        }
        if (type == Boolean.TYPE) {
            return value.equals("true");
        }
        if (type == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (type == Long.TYPE) {
            return Long.parseLong(value);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (type.isEnum()) {
            Method m = type.getMethod("valueOf", String.class);
            return m.invoke(null, value);
        }
        if (Quaternionf.class.isAssignableFrom(type)) {
            Quaternionf quat = new Quaternionf();
            if (separate) {
                Stream.of(Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')).forEach(suffix -> {
                    String str = (String)settingsMap.get(name + suffix);
                    float f = Float.parseFloat(str);
                    switch (suffix.charValue()) {
                        case 'W': {
                            quat.w = f;
                            break;
                        }
                        case 'X': {
                            quat.x = -f;
                            break;
                        }
                        case 'Y': {
                            quat.y = -f;
                            break;
                        }
                        case 'Z': {
                            quat.z = -f;
                        }
                    }
                });
            } else {
                String[] split = value.split(",");
                quat.w = Float.parseFloat(split[0]);
                quat.x = Float.parseFloat(split[1]);
                quat.y = Float.parseFloat(split[2]);
                quat.z = Float.parseFloat(split[3]);
            }
            return quat;
        }
        if (Vector3f.class.isAssignableFrom(type)) {
            Vector3f vec = new Vector3f();
            if (separate) {
                Stream.of(Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')).forEach(suffix -> {
                    String str = (String)settingsMap.get(name + suffix);
                    float f = Float.parseFloat(str);
                    switch (suffix.charValue()) {
                        case 'X': {
                            vec.x = f;
                            break;
                        }
                        case 'Y': {
                            vec.y = f;
                            break;
                        }
                        case 'Z': {
                            vec.z = f;
                        }
                    }
                });
            } else {
                String[] split = value.split(",");
                vec.x = Float.parseFloat(split[0]);
                vec.y = Float.parseFloat(split[1]);
                vec.z = Float.parseFloat(split[2]);
            }
            return vec;
        }
        LOGGER.warn("Vivecraft: Don't know how to load default VR option {} with type {}", (Object)name, (Object)type.getSimpleName());
        return null;
    }

    public void loadDefault(VrOptions option) {
        try {
            ConfigEntry mapping = this.fieldEnumMap.get((Object)option);
            if (mapping == null) {
                return;
            }
            Field field = mapping.field;
            Class<?> type = field.getType();
            String name = mapping.configName;
            if (type.isArray()) {
                Object arr = field.get(this);
                int len = Array.getLength(arr);
                if (mapping.separate) {
                    for (int i = 0; i < len; ++i) {
                        Object obj = Objects.requireNonNull(this.loadDefault(name + "_" + i, null, option, type.getComponentType(), false, this.defaultsMap));
                        Array.set(arr, i, obj);
                    }
                } else {
                    String str = this.defaultsMap.get(name);
                    String[] split = str.split(";", -1);
                    for (int i = 0; i < len; ++i) {
                        Object obj = Objects.requireNonNull(this.loadDefault(name, split[i], option, type.getComponentType(), false, this.defaultsMap));
                        Array.set(arr, i, obj);
                    }
                }
            } else {
                Object obj = Objects.requireNonNull(this.loadDefault(name, null, option, type, mapping.separate, this.defaultsMap));
                field.set(this, obj);
            }
            option.onOptionChange();
        }
        catch (Exception exception) {
            LOGGER.warn("Vivecraft: Failed to load default VR option: {}", (Object)option, (Object)exception);
        }
    }

    public boolean isDefault(VrOptions option) {
        try {
            ConfigEntry mapping = this.fieldEnumMap.get((Object)option);
            if (mapping == null) {
                return true;
            }
            Field field = mapping.field;
            Class<?> type = field.getType();
            String name = mapping.configName;
            if (type.isArray()) {
                Object arr = field.get(this);
                int len = Array.getLength(arr);
                boolean equal = true;
                if (mapping.separate) {
                    for (int i = 0; i < len; ++i) {
                        Object obj = Objects.requireNonNull(this.loadDefault(name + "_" + i, null, option, type.getComponentType(), false, this.defaultsMap));
                        equal &= Objects.equals(Array.get(arr, i), obj);
                    }
                } else {
                    String str = this.defaultsMap.get(name);
                    String[] split = str.split(";", -1);
                    for (int i = 0; i < len; ++i) {
                        Object obj = Objects.requireNonNull(this.loadDefault(name, split[i], option, type.getComponentType(), false, this.defaultsMap));
                        equal &= Objects.equals(Array.get(arr, i), obj);
                    }
                }
                return equal;
            }
            Object obj = Objects.requireNonNull(this.loadDefault(name, null, option, type, mapping.separate, this.defaultsMap));
            return Objects.equals(field.get(this), obj);
        }
        catch (Exception exception) {
            LOGGER.warn("Vivecraft: Failed to get default VR option: {}", (Object)option, (Object)exception);
            return true;
        }
    }

    public boolean hasValue(VrOptions option) {
        return this.fieldEnumMap.containsKey((Object)option);
    }

    private Map<String, String> loadSettingsFile() {
        HashMap<String, String> data = new HashMap<String, String>();
        try {
            File legacyFile = null;
            boolean fileExists = true;
            if (!this.vrCfgFile.exists()) {
                this.vrCfgFile.createNewFile();
                legacyFile = new File(Minecraft.m_91087_().f_91069_, "optionsviveprofiles.txt");
                if (legacyFile.exists()) {
                    LOGGER.info("Vivecraft: Legacy Vivecraft settings File found, converting.");
                } else {
                    fileExists = false;
                    legacyFile = null;
                }
            }
            JsonObject currentConfig = new JsonObject();
            if (fileExists) {
                InputStreamReader inputstreamreader = new InputStreamReader((InputStream)new FileInputStream(legacyFile == null ? this.vrCfgFile : legacyFile), StandardCharsets.UTF_8);
                try {
                    currentConfig = JsonParser.parseReader((Reader)inputstreamreader).getAsJsonObject();
                }
                catch (Exception exception) {
                    LOGGER.error("Vivecraft: Error reading settings file:", (Throwable)exception);
                }
                inputstreamreader.close();
            }
            if (legacyFile != null && currentConfig.has("Profiles")) {
                currentConfig = currentConfig.getAsJsonObject("Profiles").getAsJsonObject("Default").getAsJsonObject("Vr");
            }
            for (String key : currentConfig.keySet()) {
                data.put(key, currentConfig.get(key).getAsString());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Vivecraft: FAILED to read Vivecraft settings:", (Throwable)exception);
        }
        return data;
    }

    public void loadOptions() {
        Map<String, String> settings = this.loadSettingsFile();
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue() != null ? entry.getValue() : "";
            try {
                ConfigEntry mapping = this.fieldConfigMap.get(name);
                if (mapping == null) continue;
                Field field = mapping.field;
                Class<?> type = field.getType();
                Object currentValue = field.get(this);
                if (type.isArray()) {
                    if (mapping.separate) {
                        int index = Integer.parseInt(name.substring(name.lastIndexOf(95) + 1));
                        Object obj = Objects.requireNonNull(this.loadOption(name.substring(0, name.lastIndexOf(95)), value, Array.get(currentValue, index), mapping.vrOption, type.getComponentType(), false));
                        Array.set(currentValue, index, obj);
                        continue;
                    }
                    int len = Array.getLength(currentValue);
                    String[] split = value.split(";", -1);
                    if (split.length != len && !mapping.fixedSize) {
                        Object newValue = Array.newInstance(type.getComponentType(), split.length);
                        System.arraycopy(currentValue, 0, newValue, 0, Math.min(len, split.length));
                        field.set(this, newValue);
                        currentValue = newValue;
                        len = split.length;
                    }
                    for (int i = 0; i < len; ++i) {
                        Object obj = Objects.requireNonNull(this.loadOption(name, split[i], Array.get(currentValue, i), mapping.vrOption, type.getComponentType(), false));
                        Array.set(currentValue, i, obj);
                    }
                    continue;
                }
                Object obj = Objects.requireNonNull(this.loadOption(name, value, currentValue, mapping.vrOption, type, mapping.separate));
                field.set(this, obj);
            }
            catch (Exception exception) {
                LOGGER.warn("Vivecraft: Skipping bad VR option: {}:{}", new Object[]{name, value, exception});
            }
        }
        this.preservedSettingMap = settings;
    }

    public synchronized void saveOptions() {
        HashMap<String, String> data = new HashMap<String, String>();
        this.saveOptions(data);
        JsonObject jsonStorage = new JsonObject();
        data.forEach((key, value) -> jsonStorage.add(key, (JsonElement)new JsonPrimitive(value)));
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.vrCfgFile), StandardCharsets.UTF_8);
            writer.write(GSON.toJson((JsonElement)jsonStorage));
            writer.flush();
            writer.close();
        }
        catch (IOException ioException) {
            LOGGER.error("Vivecraft: Failed to save VR options to disk:", (Throwable)ioException);
        }
    }

    private synchronized void storeDefaults() {
        this.saveOptions(this.defaultsMap);
    }

    private void saveOptions(Map<String, String> data) {
        try {
            if (this.preservedSettingMap != null) {
                data.putAll(this.preservedSettingMap);
            }
            for (Map.Entry<String, ConfigEntry> entry : this.fieldConfigMap.entrySet()) {
                String name = entry.getKey();
                ConfigEntry mapping = entry.getValue();
                Field field = mapping.field;
                Class<?> type = field.getType();
                Object obj = field.get(this);
                try {
                    if (type.isArray()) {
                        if (mapping.separate) {
                            int index = Integer.parseInt(name.substring(name.lastIndexOf(95) + 1));
                            String value = Objects.requireNonNull(this.saveOption(name.substring(0, name.lastIndexOf(95)), Array.get(obj, index), mapping.vrOption, type.getComponentType(), mapping.separate));
                            data.put(name, value);
                            continue;
                        }
                        StringJoiner joiner = new StringJoiner(";");
                        int len = Array.getLength(obj);
                        for (int i = 0; i < len; ++i) {
                            String value = Objects.requireNonNull(this.saveOption(name, Array.get(obj, i), mapping.vrOption, type.getComponentType(), mapping.separate));
                            joiner.add(value);
                        }
                        data.put(name, joiner.toString());
                        continue;
                    }
                    String value = Objects.requireNonNull(this.saveOption(name, obj, mapping.vrOption, type, mapping.separate));
                    data.put(name, value);
                }
                catch (Exception exception) {
                    LOGGER.error("Vivecraft: Failed to save VR option: {}", (Object)name, (Object)exception);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Vivecraft: Failed to save VR options:", (Throwable)exception);
        }
    }

    public String getButtonDisplayString(VrOptions vrOption) {
        return this.getButtonDisplayString(vrOption, false);
    }

    public String getButtonDisplayString(VrOptions vrOption, boolean valueOnly) {
        String name = I18n.m_118938_((String)("vivecraft.options." + vrOption.name()), (Object[])new Object[0]);
        Object label = valueOnly ? "" : name + ": ";
        try {
            String str;
            ConfigEntry mapping = this.fieldEnumMap.get((Object)vrOption);
            if (mapping == null) {
                return name;
            }
            Field field = mapping.field;
            Class<?> type = field.getType();
            Object obj = field.get(this);
            if (this.overrides.hasSetting(vrOption)) {
                obj = this.overrides.getSetting(vrOption).getValue();
            }
            if ((str = vrOption.getDisplayString((String)label, obj)) != null) {
                return str;
            }
            if (type == Boolean.TYPE) {
                Pair<String, String> langKeys = vrOption.getBooleanLangKeys();
                return (Boolean)obj != false ? (String)label + I18n.m_118938_((String)((String)langKeys.getLeft()), (Object[])new Object[0]) : (String)label + I18n.m_118938_((String)((String)langKeys.getRight()), (Object[])new Object[0]);
            }
            if (type == Float.TYPE || type == Double.TYPE) {
                if (vrOption.getDecimalPlaces() < 0) {
                    return (String)label + Math.round(((Number)obj).floatValue() * 100.0f) + "%";
                }
                return (String)label + String.format("%." + vrOption.getDecimalPlaces() + "f", Float.valueOf(((Number)obj).floatValue()));
            }
            if (OptionEnum.class.isAssignableFrom(type)) {
                return (String)label + I18n.m_118938_((String)((OptionEnum)obj).getLangKey(), (Object[])new Object[0]);
            }
            return (String)label + obj.toString();
        }
        catch (Exception exception) {
            LOGGER.error("Vivecraft: Failed to get VR option display string: {}", (Object)vrOption, (Object)exception);
            return name;
        }
    }

    public float getOptionFloatValue(VrOptions vrOption) {
        try {
            ConfigEntry mapping = this.fieldEnumMap.get((Object)vrOption);
            if (mapping == null) {
                return 0.0f;
            }
            Field field = mapping.field;
            float value = ((Number)field.get(this)).floatValue();
            if (this.overrides.hasSetting(vrOption)) {
                value = this.overrides.getSetting(vrOption).getFloat();
            }
            return Objects.requireNonNullElse(vrOption.getOptionFloatValue(value), Float.valueOf(value)).floatValue();
        }
        catch (Exception exception) {
            LOGGER.error("Vivecraft: Failed to get VR option float value: {}", (Object)vrOption, (Object)exception);
            return 0.0f;
        }
    }

    public void setOptionValue(VrOptions vrOption) {
        try {
            ConfigEntry mapping = this.fieldEnumMap.get((Object)vrOption);
            if (mapping != null) {
                Field field = mapping.field;
                Class<?> type = field.getType();
                Object obj = vrOption.setOptionValue(field.get(this));
                if (obj != null) {
                    field.set(this, obj);
                } else if (type == Boolean.TYPE) {
                    field.set(this, (Boolean)field.get(this) == false);
                } else if (OptionEnum.class.isAssignableFrom(type)) {
                    field.set(this, ((OptionEnum)field.get(this)).getNext());
                } else {
                    LOGGER.warn("Vivecraft: Don't know how to set VR option {} with type {}", (Object)mapping.configName, (Object)type.getSimpleName());
                    return;
                }
            }
            vrOption.onOptionChange();
            this.saveOptions();
        }
        catch (Exception exception) {
            LOGGER.error("Vivecraft: Failed to set VR option: {}", (Object)vrOption, (Object)exception);
        }
    }

    public void setOptionFloatValue(VrOptions vrOption, float newValue) {
        try {
            ConfigEntry mapping = this.fieldEnumMap.get((Object)vrOption);
            if (mapping == null) {
                return;
            }
            Field field = mapping.field;
            Class<?> type = field.getType();
            float actualValue = Objects.requireNonNullElse(vrOption.setOptionFloatValue(newValue), Float.valueOf(newValue)).floatValue();
            if (this.overrides.hasSetting(vrOption)) {
                actualValue = Mth.m_14036_((float)actualValue, (float)this.overrides.getSetting(vrOption).getValueMin(), (float)this.overrides.getSetting(vrOption).getValueMax());
            }
            if (type == Integer.TYPE) {
                field.set(this, (int)actualValue);
            } else if (type == Long.TYPE) {
                field.set(this, (long)actualValue);
            } else {
                field.set(this, Float.valueOf(actualValue));
            }
            vrOption.onOptionChange();
            this.saveOptions();
        }
        catch (Exception exception) {
            LOGGER.error("Vivecraft: Failed to set VR option float value: {}", (Object)vrOption, (Object)exception);
        }
    }

    public FreeMove getVrFreeMoveMode(boolean flySwimming, FBTMode fbtMode) {
        FreeMove freeMoveMode = flySwimming && this.vrFreeMoveFlyMode != FreeMove.AUTO ? this.vrFreeMoveFlyMode : this.vrFreeMoveMode;
        return freeMoveMode == FreeMove.WAIST && fbtMode == FBTMode.ARMS_ONLY ? FreeMove.HMD : freeMoveMode;
    }

    public static void initSettings() {
        VRSettings vrSettings = new VRSettings();
        vrSettings.saveOptions();
        ClientDataHolderVR.getInstance().vrSettings = vrSettings;
    }

    public String[] getQuickCommandsDefaults() {
        String[] out = new String[]{"/gamemode survival", "/gamemode creative", "/help", "/home", "/sethome", "/spawn", "hi!", "bye!", "follow me!", "take this!", "thank you!", "praise the sun!"};
        return out;
    }

    public String[] getRadialItemsDefault() {
        String[] out = new String[14];
        out[0] = "key.drop";
        out[1] = "key.chat";
        out[2] = "vivecraft.key.rotateRight";
        out[3] = "key.pickItem";
        out[4] = "vivecraft.key.toggleHandheldCam";
        out[5] = "vivecraft.key.togglePlayerList";
        out[6] = "vivecraft.key.rotateLeft";
        out[7] = "vivecraft.key.quickTorch";
        for (int i = 8; i < 14; ++i) {
            out[i] = "";
        }
        return out;
    }

    public String[] getRadialItemsAltDefault() {
        String[] out = new String[14];
        for (int i = 0; i < 14; ++i) {
            out[i] = "";
        }
        return out;
    }

    public String[] getServerBlacklistDefault() {
        return new String[]{"mc.hypixel.net"};
    }

    public int[] getKeyboardCodesDefault() {
        int[] out = new int[]{96, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 45, 61, 81, 87, 69, 82, 84, 89, 85, 73, 79, 80, 91, 93, 92, 65, 83, 68, 70, 71, 72, 74, 75, 76, 59, 39, -1, -1, 90, 88, 67, 86, 66, 78, 77, 44, 46, 47, -1, -1, -1};
        return out;
    }

    public Vector3f[] getFbtOffsetDefault() {
        Vector3f[] out = new Vector3f[7];
        for (int i = 0; i < 7; ++i) {
            out[i] = new Vector3f();
        }
        return out;
    }

    public Quaternionf[] getFbtRotationsDefault() {
        Quaternionf[] out = new Quaternionf[7];
        for (int i = 0; i < 7; ++i) {
            out[i] = new Quaternionf();
        }
        return out;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    public static enum VRProvider implements OptionEnum<VRProvider>
    {
        OPENVR,
        NULLVR;

    }

    public static enum AimDevice implements OptionEnum<AimDevice>
    {
        CONTROLLER,
        HMD;

    }

    public static enum BowMode implements OptionEnum<BowMode>
    {
        OFF,
        VANILLA,
        ON;

    }

    public static enum RightClickDelay implements OptionEnum<RightClickDelay>
    {
        VANILLA,
        SLOW,
        SLOWER,
        SLOWEST;

    }

    public static enum InertiaFactor implements OptionEnum<InertiaFactor>
    {
        NONE(100.0f),
        NORMAL(1.0f),
        LARGE(0.25f),
        MASSIVE(0.0625f);

        private final float factor;

        private InertiaFactor(float factor) {
            this.factor = factor;
        }

        public float getFactor() {
            return this.factor;
        }
    }

    public static enum WeaponCollision implements OptionEnum<WeaponCollision>
    {
        OFF,
        ON,
        AUTO;

    }

    public static enum FreeMove implements OptionEnum<FreeMove>
    {
        CONTROLLER,
        HMD,
        RUN_IN_PLACE,
        ROOM,
        WAIST,
        AUTO;

    }

    public static enum RealisticJump implements OptionEnum<RealisticJump>
    {
        OFF,
        ON,
        AUTO;

    }

    public static enum MirrorMode implements OptionEnum<MirrorMode>
    {
        OFF,
        CROPPED,
        SINGLE,
        DUAL,
        FIRST_PERSON,
        THIRD_PERSON,
        MIXED_REALITY,
        GUI;

    }

    public static enum DataSource implements OptionEnum<DataSource>
    {
        REALTIME,
        LOCAL,
        SERVER;

    }

    public static enum PlayerModelType implements OptionEnum<PlayerModelType>
    {
        VANILLA,
        SPLIT_ARMS,
        SPLIT_ARMS_LEGS;

    }

    public static enum ModelArmsMode implements OptionEnum<ModelArmsMode>
    {
        OFF,
        SHOULDERS,
        COMPLETE;

    }

    public static enum MenuWorld implements OptionEnum<MenuWorld>
    {
        BOTH,
        CUSTOM,
        OFFICIAL,
        NONE;

    }

    public static enum HUDLock implements OptionEnum<HUDLock>
    {
        WRIST,
        HAND,
        HEAD;

    }

    public static enum RenderPointerElement implements OptionEnum<RenderPointerElement>
    {
        ALWAYS,
        WITH_HUD,
        NEVER;

    }

    public static enum AutoOpenKeyboard implements OptionEnum<AutoOpenKeyboard>
    {
        OFF,
        CHAT,
        ON;

    }

    public static enum ChatNotifications implements OptionEnum<ChatNotifications>
    {
        NONE,
        HAPTIC,
        SOUND,
        BOTH;

    }

    public static enum ShaderGUIRender implements OptionEnum<ShaderGUIRender>
    {
        BEFORE_TRANSLUCENT_SOLID,
        AFTER_TRANSLUCENT,
        AFTER_SHADER;

    }

    public static enum UpdateType implements OptionEnum<UpdateType>
    {
        RELEASE,
        BETA,
        ALPHA;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ChatServerMessage implements OptionEnum<ChatServerMessage>,
    BooleanSupplier
    {
        ALWAYS{

            @Override
            public boolean getAsBoolean() {
                return true;
            }
        }
        ,
        SERVER_ONLY{

            @Override
            public boolean getAsBoolean() {
                return !Minecraft.m_91087_().m_91090_();
            }
        }
        ,
        NEVER{

            @Override
            public boolean getAsBoolean() {
                return false;
            }
        };

    }

    public class ServerOverrides {
        private final Map<VrOptions, Setting> optionMap = new EnumMap<VrOptions, Setting>(VrOptions.class);
        private final Map<String, Setting> networkNameMap = new HashMap<String, Setting>();

        private ServerOverrides() {
            this.registerSetting(VrOptions.LIMIT_TELEPORT, "limitedTeleport", () -> VRSettings.this.vrLimitedSurvivalTeleport);
            this.registerSetting(VrOptions.TELEPORT_UP_LIMIT, "teleportLimitUp", () -> VRSettings.this.vrTeleportUpLimit);
            this.registerSetting(VrOptions.TELEPORT_DOWN_LIMIT, "teleportLimitDown", () -> VRSettings.this.vrTeleportDownLimit);
            this.registerSetting(VrOptions.TELEPORT_HORIZ_LIMIT, "teleportLimitHoriz", () -> VRSettings.this.vrTeleportHorizLimit);
            this.registerSetting(VrOptions.WORLD_SCALE, "worldScale", () -> Float.valueOf(VRSettings.this.worldScale));
            this.registerSetting(VrOptions.THIRDPERSON_ITEMTRANSFORMS, "thirdPersonItems", () -> VRSettings.this.thirdPersonItems);
            this.registerSetting(VrOptions.THIRDPERSON_ITEMTRANSFORMS_CUSTOM, "thirdPersonItemsCustom", () -> VRSettings.this.thirdPersonItemsCustom);
        }

        private void registerSetting(VrOptions option, String networkName, Supplier<Object> originalValue) {
            Setting setting = new Setting(option, networkName, originalValue);
            this.optionMap.put(option, setting);
            this.networkNameMap.put(networkName, setting);
        }

        public void resetAll() {
            for (Setting setting : this.optionMap.values()) {
                setting.valueSet = false;
                setting.valueMinSet = false;
                setting.valueMaxSet = false;
            }
        }

        public boolean hasSetting(VrOptions option) {
            return this.optionMap.containsKey((Object)option);
        }

        public boolean hasSetting(String networkName) {
            return this.networkNameMap.containsKey(networkName);
        }

        public Setting getSetting(VrOptions option) {
            Setting setting = this.optionMap.get((Object)option);
            if (setting == null) {
                throw new IllegalArgumentException("setting not registered: " + option);
            }
            return setting;
        }

        public Setting getSetting(String networkName) {
            Setting setting = this.networkNameMap.get(networkName);
            if (setting == null) {
                throw new IllegalArgumentException("setting not registered: " + networkName);
            }
            return setting;
        }

        public class Setting {
            private final VrOptions option;
            private final String networkName;
            private final Supplier<Object> originalValue;
            private boolean valueSet;
            private Object value;
            private boolean valueMinSet;
            private boolean valueMaxSet;
            private float valueMin;
            private float valueMax;

            public Setting(VrOptions option, String networkName, Supplier<Object> originalValue) {
                this.option = option;
                this.networkName = networkName;
                this.originalValue = originalValue;
            }

            private void checkFloat() {
                if (!this.option.enumFloat) {
                    throw new IllegalArgumentException("not a float option: " + this.option);
                }
            }

            public boolean isFloat() {
                return this.option.enumFloat;
            }

            public Object getOriginalValue() {
                return this.originalValue.get();
            }

            public boolean isValueOverridden() {
                return this.valueSet;
            }

            public Object getValue() {
                Object val = this.valueSet ? this.value : this.originalValue.get();
                if (val instanceof Integer) {
                    val = Mth.m_14045_((int)((Number)val).intValue(), (int)((int)this.getValueMin()), (int)((int)this.getValueMax()));
                } else if (val instanceof Float) {
                    val = Float.valueOf(Mth.m_14036_((float)((Number)val).floatValue(), (float)this.getValueMin(), (float)this.getValueMax()));
                }
                return val;
            }

            public boolean getBoolean() {
                Object val = this.getValue();
                return val instanceof Boolean && (Boolean)val != false;
            }

            public int getInt() {
                Object val = this.getValue();
                return val instanceof Number ? ((Number)val).intValue() : 0;
            }

            public float getFloat() {
                Object val = this.getValue();
                return val instanceof Number ? ((Number)val).floatValue() : 0.0f;
            }

            public String getString() {
                Object val = this.getValue();
                return val instanceof String ? val.toString() : "";
            }

            public void setValue(Object value) {
                this.value = value;
                this.valueSet = true;
            }

            public void resetValue() {
                this.valueSet = false;
            }

            public boolean isValueMinOverridden() {
                this.checkFloat();
                return this.valueMinSet;
            }

            public float getValueMin() {
                this.checkFloat();
                if (this.valueMinSet) {
                    return this.valueMin;
                }
                return Float.MIN_VALUE;
            }

            public void setValueMin(float valueMin) {
                this.checkFloat();
                this.valueMin = valueMin;
                this.valueMinSet = true;
            }

            public void resetValueMin() {
                this.checkFloat();
                this.valueMinSet = false;
            }

            public boolean isValueMaxOverridden() {
                this.checkFloat();
                return this.valueMaxSet;
            }

            public float getValueMax() {
                this.checkFloat();
                if (this.valueMaxSet) {
                    return this.valueMax;
                }
                return Float.MAX_VALUE;
            }

            public void setValueMax(float valueMax) {
                this.checkFloat();
                this.valueMax = valueMax;
                this.valueMaxSet = true;
            }

            public void resetValueMax() {
                this.checkFloat();
                this.valueMaxSet = false;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum VrOptions {
        DUMMY(false, true),
        VR_PLUGIN(false, true){

            @Override
            public boolean isChangeable() {
                return !VRState.VR_INITIALIZED;
            }
        }
        ,
        VR_ENABLED(false, true){

            @Override
            void onOptionChange() {
                VRState.VR_ENABLED = ClientDataHolderVR.getInstance().vrSettings.vrEnabled;
            }
        }
        ,
        VR_CLOSE_WITH_RUNTIME(false, true),
        VR_REMEMBER_ENABLED(false, true),
        HUD_SCALE(true, false, 0.35f, 2.5f, 0.01f, -1),
        HUD_DISTANCE(true, false, 0.25f, 5.0f, 0.01f, 2){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + String.format("%.2f", Float.valueOf(((Float)value).floatValue())) + "m";
            }
        }
        ,
        HUD_LOCK_TO(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return HUDLock.values()[3 - ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        HUD_WRIST_OFFSET(true, false, 0.0f, 4.0f, 0.25f, -1),
        HUD_OPACITY(true, false, 0.15f, 1.0f, 0.05f, -1){

            @Override
            String getDisplayString(String prefix, Object value) {
                if ((double)((Float)value).floatValue() > 0.99) {
                    return prefix + I18n.m_118938_((String)"vivecraft.options.opaque", (Object[])new Object[0]);
                }
                return null;
            }
        }
        ,
        HUD_HIDE(false, true){

            @Override
            Object loadOption(String value) {
                Minecraft.m_91087_().f_91066_.f_92062_ = value.equals("true");
                return false;
            }

            @Override
            String saveOption(Object value) {
                return Boolean.toString(Minecraft.m_91087_().f_91066_.f_92062_);
            }

            @Override
            String getDisplayString(String prefix, Object value) {
                return Minecraft.m_91087_().f_91066_.f_92062_ ? prefix + LangHelper.getYes() : prefix + LangHelper.getNo();
            }

            @Override
            Object setOptionValue(Object value) {
                Minecraft.m_91087_().f_91066_.f_92062_ = !Minecraft.m_91087_().f_91066_.f_92062_;
                return false;
            }
        }
        ,
        RENDER_MENU_BACKGROUND(false, true),
        HUD_OCCLUSION(false, true),
        MENU_ALWAYS_FOLLOW_FACE(false, true, "vivecraft.options.always", "vivecraft.options.seated"){

            @Override
            void onOptionChange() {
                GuiHandler.onScreenChanged(Minecraft.m_91087_().f_91080_, Minecraft.m_91087_().f_91080_, false);
            }
        }
        ,
        CROSSHAIR_OCCLUSION(false, true),
        CROSSHAIR_SCALE(true, false, 0.25f, 1.0f, 0.01f, -1),
        MENU_CROSSHAIR_SCALE(true, false, 0.25f, 2.5f, 0.05f, -1),
        RENDER_CROSSHAIR_MODE(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return RenderPointerElement.values()[ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        CHAT_NOTIFICATIONS(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return ChatNotifications.values()[ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        CHAT_NOTIFICATION_SOUND(false, true){

            @Override
            String getDisplayString(String prefix, Object value) {
                try {
                    SoundEvent se = (SoundEvent)Registry.f_122821_.m_7745_(new ResourceLocation((String)value));
                    return prefix + ClientUtils.getNameFromSoundEvent(se.m_11660_()).getString();
                }
                catch (Exception e) {
                    return prefix + "unknown sound: " + value;
                }
            }

            @Override
            Object setOptionValue(Object value) {
                SoundEvent se = (SoundEvent)Registry.f_122821_.m_7745_(new ResourceLocation((String)value));
                int i = Registry.f_122821_.m_7447_((Object)se);
                if (++i >= Registry.f_122821_.m_6566_().size()) {
                    i = 0;
                }
                return ((SoundEvent)Registry.f_122821_.m_7942_(i)).m_11660_().m_135815_();
            }
        }
        ,
        CROSSHAIR_SCALES_WITH_DISTANCE(false, true),
        RENDER_BLOCK_OUTLINE_MODE(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return RenderPointerElement.values()[ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        SHOW_UPDATES(false, true, "vivecraft.options.always", "vivecraft.options.once"),
        UPDATE_TYPE(false, true),
        SHOW_PLUGIN(false, true),
        SHOW_PLUGIN_MISSING(false, true, "vivecraft.options.always", "vivecraft.options.once"),
        CHAT_MESSAGE_STENCIL(false, true),
        SHOW_SERVER_VR_CHANGES(false, true),
        AUTO_OPEN_KEYBOARD(false, true),
        AUTO_CLOSE_KEYBOARD(false, true),
        RADIAL_MODE_HOLD(false, true, "vivecraft.options.hold", "vivecraft.options.press"),
        RADIAL_NUMBER(false, false, 4.0f, 14.0f, 2.0f, 0),
        PHYSICAL_KEYBOARD(false, true, "vivecraft.options.keyboard.physical", "vivecraft.options.keyboard.pointer"),
        PHYSICAL_KEYBOARD_SCALE(true, false, 0.75f, 1.5f, 0.01f, -1){

            @Override
            void onOptionChange() {
                KeyboardHandler.PHYSICAL_KEYBOARD.setScale(ClientDataHolderVR.getInstance().vrSettings.physicalKeyboardScale);
            }
        }
        ,
        PHYSICAL_KEYBOARD_THEME(false, false){

            @Override
            void onOptionChange() {
                KeyboardHandler.PHYSICAL_KEYBOARD.init();
            }
        }
        ,
        KEYBOARD_PRESS_BINDS(false, true),
        GUI_APPEAR_OVER_BLOCK(false, true),
        SHADER_GUI_RENDER(false, false),
        SHADER_SHADOW_MODEL_LIMB_SCALE(false, false),
        SHADER_SLOW(false, true, "options.off", "vivecraft.options.disableshaderoptimization.auto"),
        SHADER_PATCHING(false, true),
        DOUBLE_GUI_RESOLUTION(false, true){

            @Override
            void onOptionChange() {
                if (VRState.VR_INITIALIZED) {
                    ClientDataHolderVR.getInstance().vrRenderer.resizeFrameBuffers("Gui Res Changed");
                }
            }
        }
        ,
        GUI_MIPMAPS(false, true){

            @Override
            void onOptionChange() {
                if (VRState.VR_INITIALIZED) {
                    ClientDataHolderVR.getInstance().vrRenderer.resizeFrameBuffers("Gui Mips Changed");
                }
            }
        }
        ,
        GUI_ANISOTROPIC_FILTERING(false, true){

            @Override
            void onOptionChange() {
                if (VRState.VR_INITIALIZED && ClientDataHolderVR.getInstance().vrSettings.guiMipmaps) {
                    ClientDataHolderVR.getInstance().vrRenderer.resizeFrameBuffers("Anisotropic filtering Changed");
                }
            }
        }
        ,
        GUI_SCALE(true, true, 0.0f, 6.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                if ((Integer)value == 0) {
                    return prefix + I18n.m_118938_((String)"options.guiScale.auto", (Object[])new Object[0]);
                }
                if (ClientDataHolderVR.getInstance().vrSettings.doubleGUIResolution) {
                    return prefix + value;
                }
                return prefix + (int)Math.ceil((float)((Integer)value).intValue() * 0.5f);
            }

            @Override
            void onOptionChange() {
                if (VRState.VR_INITIALIZED) {
                    ClientDataHolderVR.getInstance().vrRenderer.resizeFrameBuffers("");
                }
            }
        }
        ,
        HUD_MAX_GUI_SCALE(false, true),
        VR_TOGGLE_BUTTON_VISIBLE(false, true),
        VR_SETTINGS_BUTTON_VISIBLE(false, true),
        VR_SETTINGS_BUTTON_POSITION(false, true, "vivecraft.options.left", "vivecraft.options.right"),
        MODIFY_PAUSE_MENU(false, true),
        FULL_RELOAD_ON_INIT(false, true){

            @Override
            void onOptionChange() {
                if (VRState.VR_INITIALIZED) {
                    ClientDataHolderVR.getInstance().vrRenderer.reinitFrameBuffers("Reload on init changed");
                }
            }
        }
        ,
        SEARCH_TYPE(false, true, "vivecraft.options.searchtype.fuzzy", "vivecraft.options.searchtype.exact"),
        FSAA(false, true){

            @Override
            void onOptionChange() {
                if (VRState.VR_INITIALIZED) {
                    ClientDataHolderVR.getInstance().vrRenderer.reinitFrameBuffers("FSAA Setting Changed");
                }
            }
        }
        ,
        LOW_HEALTH_INDICATOR(false, true),
        HIT_INDICATOR(false, true),
        WATER_EFFECT(false, true),
        PORTAL_EFFECT(false, true),
        FREEZE_EFFECT(false, true),
        PUMPKIN_EFFECT(false, true),
        MIRROR_DISPLAY(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return switch (ord) {
                        case 10 -> MirrorMode.OFF;
                        case 11 -> MirrorMode.DUAL;
                        case 12 -> MirrorMode.SINGLE;
                        case 16 -> MirrorMode.CROPPED;
                        default -> MirrorMode.values()[ord - 9];
                    };
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }

            @Override
            void onOptionChange() {
                if (VRState.VR_INITIALIZED) {
                    ClientDataHolderVR.getInstance().vrRenderer.reinitFrameBuffersMaybe("Mirror Setting Changed");
                }
            }
        }
        ,
        MIRROR_CROP(true, false, 0.0f, 0.25f, 0.01f, -1),
        MIRROR_EYE(false, true, "vivecraft.options.left", "vivecraft.options.right"),
        MIRROR_CENTER_SMOOTH(true, false, 0.0f, 1.0f, 0.1f, 1){

            @Override
            String getDisplayString(String prefix, Object value) {
                if (((Float)value).floatValue() == 0.0f) {
                    return prefix + I18n.m_118938_((String)"options.off", (Object[])new Object[0]);
                }
                return prefix + String.format("%.1f", Float.valueOf(((Float)value).floatValue())) + "s";
            }
        }
        ,
        MIRROR_OFF_TEXT(false, true),
        MIRROR_SCREENSHOT_CAMERA(false, true),
        MIXED_REALITY_KEY_COLOR(false, false){
            private static final List<Pair<Color, String>> COLORS = new ArrayList<Pair<Color, String>>();

            @Override
            String getDisplayString(String prefix, Object value) {
                Color color = (Color)value;
                Pair p = COLORS.stream().filter(c -> ((Color)c.getLeft()).equals(color)).findFirst().orElse(null);
                return p != null ? prefix + I18n.m_118938_((String)((String)p.getRight()), (Object[])new Object[0]) : prefix + color.getRed() + " " + color.getGreen() + " " + color.getBlue();
            }

            @Override
            Object loadOption(String value) {
                String[] split = value.split(",");
                return new Color(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
            }

            @Override
            String saveOption(Object value) {
                Color color = (Color)value;
                return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
            }

            @Override
            Object setOptionValue(Object value) {
                int index = IntStream.range(0, COLORS.size()).filter(i -> ((Color)COLORS.get(i).getLeft()).equals(value)).findFirst().orElse(-1);
                return index == -1 || index == COLORS.size() - 1 ? COLORS.get(0).getLeft() : COLORS.get(index + 1).getLeft();
            }

            static {
                COLORS.add((Pair<Color, String>)Pair.of((Object)new Color(0, 0, 0), (Object)"vivecraft.options.color.black"));
                COLORS.add((Pair<Color, String>)Pair.of((Object)new Color(255, 0, 0), (Object)"vivecraft.options.color.red"));
                COLORS.add((Pair<Color, String>)Pair.of((Object)new Color(255, 255, 0), (Object)"vivecraft.options.color.yellow"));
                COLORS.add((Pair<Color, String>)Pair.of((Object)new Color(0, 255, 0), (Object)"vivecraft.options.color.green"));
                COLORS.add((Pair<Color, String>)Pair.of((Object)new Color(0, 255, 255), (Object)"vivecraft.options.color.cyan"));
                COLORS.add((Pair<Color, String>)Pair.of((Object)new Color(0, 0, 255), (Object)"vivecraft.options.color.blue"));
                COLORS.add((Pair<Color, String>)Pair.of((Object)new Color(255, 0, 255), (Object)"vivecraft.options.color.magenta"));
            }
        }
        ,
        MIXED_REALITY_RENDER_HANDS(false, true),
        MIXED_REALITY_UNITY_LIKE(false, true, "vivecraft.options.unity", "vivecraft.options.sidebyside"){

            @Override
            void onOptionChange() {
                if (VRState.VR_INITIALIZED) {
                    ClientDataHolderVR.getInstance().vrRenderer.reinitFrameBuffersMaybe("MR Setting Changed");
                }
            }
        }
        ,
        MIXED_REALITY_UNDISTORTED(false, true){

            @Override
            void onOptionChange() {
                if (VRState.VR_INITIALIZED) {
                    ClientDataHolderVR.getInstance().vrRenderer.reinitFrameBuffersMaybe("MR Setting Changed");
                }
            }
        }
        ,
        MIXED_REALITY_ALPHA_MASK(false, true),
        MIXED_REALITY_FOV(true, false, 0.0f, 179.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + String.format("%.0f\u00b0", Float.valueOf(((Float)value).floatValue()));
            }
        }
        ,
        WALK_UP_BLOCKS(false, true),
        MOVEMENT_MULTIPLIER(true, false, 0.15f, 1.3f, 0.01f, 2),
        INERTIA_FACTOR(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return InertiaFactor.values()[ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        SIMULATE_FALLING(false, true),
        WEAPON_COLLISION(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return WeaponCollision.values()[ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        FEET_COLLISION(false, true),
        SWORD_BLOCK_COLLISION(false, true),
        ONLY_SWORD_COLLISION(false, true),
        REDUCED_PLAYER_REACH(false, true),
        ALLOW_CRAWLING(false, true),
        LIMIT_TELEPORT(false, true),
        REVERSE_HANDS(false, true),
        REVERSE_BOW(false, true),
        AIM_DEVICE(false, true),
        STENCIL_ON(false, true){

            @Override
            void onOptionChange() {
                if (VRState.VR_INITIALIZED && StencilHelper.stencilBufferSupported()) {
                    ClientDataHolderVR.getInstance().vrRenderer.reinitFrameBuffers("Stencil Setting Changed");
                }
            }
        }
        ,
        STENCIL_BUFFER_DISABLE(false, true){

            @Override
            void onOptionChange() {
                if (VRState.VR_INITIALIZED && ClientDataHolderVR.getInstance().vrSettings.vrUseStencil) {
                    ClientDataHolderVR.getInstance().vrRenderer.reinitFrameBuffers("Stencil Override Changed");
                }
            }
        }
        ,
        BCB_ON(false, true),
        WORLD_SCALE(true, false, 0.0f, 29.0f, 1.0f, 2){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + String.format("%.2f", Float.valueOf(((Float)value).floatValue())) + "x";
            }

            @Override
            Float getOptionFloatValue(float value) {
                if (value == 0.1f) {
                    return Float.valueOf(0.0f);
                }
                if (value == 0.25f) {
                    return Float.valueOf(1.0f);
                }
                if (value >= 0.5f && value <= 2.0f) {
                    return Float.valueOf(value / 0.1f - 3.0f);
                }
                if (value == 3.0f) {
                    return Float.valueOf(18.0f);
                }
                if (value == 4.0f) {
                    return Float.valueOf(19.0f);
                }
                if (value == 6.0f) {
                    return Float.valueOf(20.0f);
                }
                if (value == 8.0f) {
                    return Float.valueOf(21.0f);
                }
                if (value == 10.0f) {
                    return Float.valueOf(22.0f);
                }
                if (value == 12.0f) {
                    return Float.valueOf(23.0f);
                }
                if (value == 16.0f) {
                    return Float.valueOf(24.0f);
                }
                if (value == 20.0f) {
                    return Float.valueOf(25.0f);
                }
                if (value == 30.0f) {
                    return Float.valueOf(26.0f);
                }
                if (value == 50.0f) {
                    return Float.valueOf(27.0f);
                }
                if (value == 75.0f) {
                    return Float.valueOf(28.0f);
                }
                if (value == 100.0f) {
                    return Float.valueOf(29.0f);
                }
                return Float.valueOf(7.0f);
            }

            @Override
            Float setOptionFloatValue(float value) {
                if (value == 0.0f) {
                    return Float.valueOf(0.1f);
                }
                if (value == 1.0f) {
                    return Float.valueOf(0.25f);
                }
                if (value >= 2.0f && value <= 17.0f) {
                    return Float.valueOf(value * 0.1f + 0.3f);
                }
                if (value == 18.0f) {
                    return Float.valueOf(3.0f);
                }
                if (value == 19.0f) {
                    return Float.valueOf(4.0f);
                }
                if (value == 20.0f) {
                    return Float.valueOf(6.0f);
                }
                if (value == 21.0f) {
                    return Float.valueOf(8.0f);
                }
                if (value == 22.0f) {
                    return Float.valueOf(10.0f);
                }
                if (value == 23.0f) {
                    return Float.valueOf(12.0f);
                }
                if (value == 24.0f) {
                    return Float.valueOf(16.0f);
                }
                if (value == 25.0f) {
                    return Float.valueOf(20.0f);
                }
                if (value == 26.0f) {
                    return Float.valueOf(30.0f);
                }
                if (value == 27.0f) {
                    return Float.valueOf(50.0f);
                }
                if (value == 28.0f) {
                    return Float.valueOf(75.0f);
                }
                if (value == 29.0f) {
                    return Float.valueOf(100.0f);
                }
                return Float.valueOf(1.0f);
            }

            @Override
            void onOptionChange() {
                if (VRState.VR_RUNNING) {
                    ClientDataHolderVR.getInstance().vrPlayer.roomScaleMovementDelay = 2;
                    ClientDataHolderVR.getInstance().vrPlayer.snapRoomOriginToPlayerEntity((Entity)Minecraft.m_91087_().f_91074_, false, true);
                    VRPlayer.get().preTick();
                }
            }
        }
        ,
        WORLD_ROTATION(true, false, 0.0f, 360.0f, 30.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + String.format("%.0f\u00b0", Float.valueOf(((Float)value).floatValue()));
            }

            @Override
            Float setOptionFloatValue(float value) {
                return null;
            }
        }
        ,
        WORLD_ROTATION_INCREMENT(true, false, -1.0f, 4.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                if (((Float)value).floatValue() == 0.0f) {
                    return prefix + I18n.m_118938_((String)"vivecraft.options.smooth", (Object[])new Object[0]);
                }
                return prefix + String.format("%.0f\u00b0", Float.valueOf(((Float)value).floatValue()));
            }

            @Override
            Float getOptionFloatValue(float value) {
                if (value == 0.0f) {
                    return Float.valueOf(-1.0f);
                }
                if (value == 10.0f) {
                    return Float.valueOf(0.0f);
                }
                if (value == 36.0f) {
                    return Float.valueOf(1.0f);
                }
                if (value == 45.0f) {
                    return Float.valueOf(2.0f);
                }
                if (value == 90.0f) {
                    return Float.valueOf(3.0f);
                }
                if (value == 180.0f) {
                    return Float.valueOf(4.0f);
                }
                return Float.valueOf(2.0f);
            }

            @Override
            Float setOptionFloatValue(float value) {
                if (value == -1.0f) {
                    return Float.valueOf(0.0f);
                }
                if (value == 0.0f) {
                    return Float.valueOf(10.0f);
                }
                if (value == 1.0f) {
                    return Float.valueOf(36.0f);
                }
                if (value == 2.0f) {
                    return Float.valueOf(45.0f);
                }
                if (value == 3.0f) {
                    return Float.valueOf(90.0f);
                }
                if (value == 4.0f) {
                    return Float.valueOf(180.0f);
                }
                return Float.valueOf(45.0f);
            }

            @Override
            void onOptionChange() {
                ClientDataHolderVR.getInstance().vrSettings.worldRotation = 0.0f;
            }
        }
        ,
        TOUCH_HOTBAR(false, true),
        PLAY_MODE_SEATED(false, true, "vivecraft.options.seated", "vivecraft.options.standing"),
        VR_HOTSWITCH(false, true),
        RENDER_SCALEFACTOR(true, false, 0.1f, 9.0f, 0.1f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                if (VRState.VR_INITIALIZED) {
                    RenderTarget eye0 = ClientDataHolderVR.getInstance().vrRenderer.framebufferEye0;
                    return prefix + Math.round(((Float)value).floatValue() * 100.0f) + "% (" + (int)Math.ceil((double)eye0.f_83917_ * Math.sqrt(((Float)value).floatValue())) + "x" + (int)Math.ceil((double)eye0.f_83918_ * Math.sqrt(((Float)value).floatValue())) + ")";
                }
                return prefix + Math.round(((Float)value).floatValue() * 100.0f) + "%";
            }
        }
        ,
        MONO_FOV(true, false, 30.0f, 110.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + String.format("%.0f\u00b0", Minecraft.m_91087_().f_91066_.f_92068_);
            }

            @Override
            Float getOptionFloatValue(float value) {
                return Float.valueOf((float)Minecraft.m_91087_().f_91066_.f_92068_);
            }

            @Override
            Float setOptionFloatValue(float value) {
                Minecraft.m_91087_().f_91066_.f_92068_ = value;
                return Float.valueOf(0.0f);
            }
        }
        ,
        HANDHELD_CAMERA_FOV(true, false, 1.0f, 179.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + String.format("%.0f\u00b0", Float.valueOf(((Float)value).floatValue()));
            }
        }
        ,
        HANDHELD_CAMERA_RENDER_SCALE(true, false, 0.5f, 3.0f, 0.25f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + Math.round(1920.0f * ((Float)value).floatValue()) + "x" + Math.round(1080.0f * ((Float)value).floatValue());
            }
        }
        ,
        MIXED_REALITY_RENDER_CAMERA_MODEL(false, true, "vivecraft.options.yes", "vivecraft.options.no"),
        REALISTIC_JUMP(false, true),
        REALISTIC_SNEAK(false, true),
        PHYSICAL_GUI(false, true){

            @Override
            Object loadOption(String value) {
                return false;
            }
        }
        ,
        REALISTIC_CLIMB(false, true),
        REALISTIC_SWIM(false, true),
        REALISTIC_ROW(false, true),
        REALISTIC_DISMOUNT(false, true),
        REALISTIC_BLOCK_INTERACT(false, true),
        REALISTIC_ENTITY_INTERACT(false, true),
        REALISTIC_OPENING(false, true),
        WALK_MULTIPLIER(true, false, 1.0f, 10.0f, 0.1f, 1),
        FREEMOVE_MODE(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return switch (ord) {
                        case 4 -> FreeMove.CONTROLLER;
                        case 5 -> FreeMove.ROOM;
                        default -> FreeMove.values()[ord - 1];
                    };
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }

            @Override
            Object setOptionValue(Object value) {
                if (value == FreeMove.WAIST) {
                    return FreeMove.CONTROLLER;
                }
                return null;
            }
        }
        ,
        FREEMOVE_FLY_MODE(false, true){

            @Override
            Object setOptionValue(Object value) {
                if (value == FreeMove.CONTROLLER) {
                    return FreeMove.HMD;
                }
                if (value == FreeMove.HMD) {
                    return FreeMove.WAIST;
                }
                if (value == FreeMove.AUTO) {
                    return FreeMove.CONTROLLER;
                }
                return FreeMove.AUTO;
            }
        }
        ,
        VEHICLE_ROTATION(false, true),
        RESET_ORIGIN(false, true){

            @Override
            void onOptionChange() {
                if (VRState.VR_RUNNING) {
                    MCVR.get().resetPosition();
                    Minecraft.m_91087_().m_91152_(null);
                }
            }
        }
        ,
        WORLD_ROTATION_X_SENSITIVITY(true, false, 0.1f, 5.0f, 0.01f, 2),
        X_SENSITIVITY(true, false, 0.1f, 5.0f, 0.01f, 2),
        Y_SENSITIVITY(true, false, 0.1f, 5.0f, 0.01f, 2),
        KEYHOLE(true, false, 0.0f, 40.0f, 5.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + String.format("%.0f\u00b0", Float.valueOf(((Float)value).floatValue()));
            }
        }
        ,
        FOV_REDUCTION(false, true),
        FOV_REDUCTION_MIN(true, false, 0.1f, 0.7f, 0.05f, 2),
        FOV_REDUCTION_OFFSET(true, false, 0.0f, 0.3f, 0.01f, 2),
        SEATED_HMD(false, true, "vivecraft.options.hmd", "vivecraft.options.crosshair"),
        SEATED_HUD_XHAIR(false, true, "vivecraft.options.crosshair", "vivecraft.options.hmd"),
        BACKPACK_SWITCH(false, true),
        ANALOG_MOVEMENT(false, true),
        DIGITAL_MOVEMENT_DEADZONE(true, false, 0.0f, 1.0f, 0.05f, -1),
        AUTO_SPRINT(false, true),
        AUTO_SPRINT_THRESHOLD(true, false, 0.5f, 1.0f, 0.01f, 2),
        THIRDPERSON_ITEMTRANSFORMS(false, true),
        THIRDPERSON_ITEMTRANSFORMS_CUSTOM(false, true),
        SHOW_PLAYER_MODEL(false, true),
        MAIN_PLAYER_DATA(false, true),
        SHOW_PLAYER_MODEL_ARMS(false, true),
        SHOW_PLAYER_HANDS(false, true),
        PLAYER_MODEL_ARMS_SCALE(true, false, 0.1f, 1.0f, 0.05f, -1),
        PLAYER_MODEL_BODY_SCALE(true, false, 0.1f, 1.0f, 0.05f, -1),
        PLAYER_MODEL_LEGS_SCALE(true, false, 0.1f, 1.0f, 0.05f, -1),
        PLAYER_MODEL_TYPE(false, true),
        PLAYER_LIMBS_CONNECTED(false, true){

            @Override
            public void onOptionChange() {
                VRPlayerRenderer.createLayers();
                VRArmorLayer.createLayers();
                Minecraft.m_91087_().m_91391_();
            }
        }
        ,
        PLAYER_LIMBS_LIMIT(false, true),
        PLAYER_WALK_ANIM(false, true),
        PLAYER_ARM_ANIM(false, true),
        APPLY_PLAYER_WORLDSCALE(false, true),
        OSC_TRACKER_PORT(true, true, 0.0f, 65535.0f, 1.0f, 0){

            @Override
            public void onOptionChange() {
                if (VRState.VR_INITIALIZED) {
                    ClientDataHolderVR.getInstance().vr.oscTrackers.changePort(ClientDataHolderVR.getInstance().vrSettings.oscTrackerPort);
                }
            }
        }
        ,
        BOW_MODE(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return BowMode.values()[ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        TELEPORT_DOWN_LIMIT(true, false, 0.0f, 16.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return (Integer)value > 0 ? prefix + LangHelper.get("vivecraft.options.teleportlimit", value) : prefix + I18n.m_118938_((String)"options.off", (Object[])new Object[0]);
            }
        }
        ,
        TELEPORT_UP_LIMIT(true, false, 0.0f, 4.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return (Integer)value > 0 ? prefix + LangHelper.get("vivecraft.options.teleportlimit", value) : prefix + I18n.m_118938_((String)"options.off", (Object[])new Object[0]);
            }
        }
        ,
        TELEPORT_HORIZ_LIMIT(true, false, 0.0f, 32.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return (Integer)value > 0 ? prefix + LangHelper.get("vivecraft.options.teleportlimit", value) : prefix + I18n.m_118938_((String)"options.off", (Object[])new Object[0]);
            }
        }
        ,
        ALLOW_STANDING_ORIGIN_OFFSET(false, true, "vivecraft.options.yes", "vivecraft.options.no"),
        SEATED_FREE_MOVE(false, true, "vivecraft.options.freemove", "vivecraft.options.teleport"),
        FORCE_STANDING_FREE_MOVE(false, true, "vivecraft.options.yes", "vivecraft.options.no"),
        ALLOW_ADVANCED_BINDINGS(false, true, "vivecraft.options.yes", "vivecraft.options.no"),
        MENU_WORLD_SELECTION(false, false){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return MenuWorld.values()[ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        MENU_WORLD_FALLBACK(false, true, "vivecraft.options.menuworldfallback.panorama", "vivecraft.options.menuworldfallback.dirtbox"),
        HRTF_SELECTION(false, false){

            @Override
            String getDisplayString(String prefix, Object value) {
                int hrtfSelection = (Integer)value;
                if (hrtfSelection == -1) {
                    return prefix + I18n.m_118938_((String)"options.off", (Object[])new Object[0]);
                }
                if (hrtfSelection == 0) {
                    return prefix + I18n.m_118938_((String)"vivecraft.options.default", (Object[])new Object[0]);
                }
                if (hrtfSelection <= ClientDataHolderVR.getInstance().hrtfList.size()) {
                    return prefix + ClientDataHolderVR.getInstance().hrtfList.get(hrtfSelection - 1);
                }
                return prefix;
            }

            @Override
            Object setOptionValue(Object value) {
                int hrtfSelection = (Integer)value;
                if (++hrtfSelection > ClientDataHolderVR.getInstance().hrtfList.size()) {
                    hrtfSelection = -1;
                }
                return hrtfSelection;
            }

            @Override
            void onOptionChange() {
                if (VRState.VR_RUNNING) {
                    SoundManager soundManager = Minecraft.m_91087_().m_91106_();
                    soundManager.m_194526_();
                    soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                }
            }
        }
        ,
        RELOAD_EXTERNAL_CAMERA(false, false){

            @Override
            void onOptionChange() {
                VRHotkeys.loadExternalCameraConfig(ClientDataHolderVR.getInstance().vrSettings);
            }
        }
        ,
        INGAME_BINDINGS_IN_GUI(false, true),
        RIGHT_CLICK_DELAY(false, false),
        CONTROLLER_TRANSFORM(false, true){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + ((ControllerTransform)value).name().replace("_", "/");
            }

            @Override
            void onOptionChange() {
                if (VRState.VR_INITIALIZED) {
                    MCVR.get().refreshControllerTransforms();
                }
            }
        }
        ,
        RENDER_DEBUG_HEAD_HITBOX(false, true),
        RENDER_DEBUG_DEVICE_AXES(false, true),
        RENDER_DEBUG_PLAYER_AXES(false, true),
        RENDER_DEBUG_TRACKERS(false, true),
        RENDER_DEBUG_GAMEPLAY_TRACKER(false, true),
        GAMEPLAY_TRACKER_TO_RENDER(false, false){

            @Override
            Object setOptionValue(Object value) {
                Tracker cur;
                List<Tracker> t = ClientDataHolderVR.getInstance().getTrackers().stream().filter(d -> d instanceof DebugRenderTracker).sorted(Comparator.comparing(d -> d.getClass().getSimpleName())).toList();
                return t.indexOf(cur = (Tracker)t.stream().filter(d -> d.getClass().getName().equals(value)).findFirst().orElse(null)) + 1 >= t.size() ? "" : t.get(t.indexOf(cur) + 1).getClass().getName();
            }

            @Override
            String getDisplayString(String prefix, Object value) {
                if (((String)value).isEmpty()) {
                    return prefix + I18n.m_118938_((String)"vivecraft.options.all", (Object[])new Object[0]);
                }
                String s = (String)value;
                return prefix + s.substring(s.lastIndexOf(".") + 1);
            }
        };

        private final boolean enumFloat;
        private final boolean enumBoolean;
        private final float valueStep;
        private final float valueMin;
        private final float valueMax;
        private final int decimalPlaces;
        private final Pair<String, String> booleanLangKeys;

        private VrOptions(boolean isFloat, boolean isBoolean) {
            this(isFloat, isBoolean, 0.0f, 1.0f, 0.0f, 0);
        }

        private VrOptions(boolean isFloat, boolean isBoolean, String trueLangKey, String falseLangKey) {
            this(isFloat, isBoolean, 0.0f, 1.0f, 0.0f, 0, trueLangKey, falseLangKey);
        }

        private VrOptions(boolean isFloat, boolean isBoolean, float min, float max, float step, int decimalPlaces) {
            this(isFloat, isBoolean, min, max, step, decimalPlaces, "options.on", "options.off");
        }

        private VrOptions(boolean isFloat, boolean isBoolean, float min, float max, float step, int decimalPlaces, String trueLangKey, String falseLangKey) {
            this.enumFloat = isFloat;
            this.enumBoolean = isBoolean;
            this.valueMin = min;
            this.valueMax = max;
            this.valueStep = step;
            this.decimalPlaces = decimalPlaces;
            this.booleanLangKeys = Pair.of((Object)trueLangKey, (Object)falseLangKey);
        }

        Object convertOption(String value) {
            return null;
        }

        Object loadOption(String value) {
            return null;
        }

        String saveOption(Object value) {
            return null;
        }

        String getDisplayString(String prefix, Object value) {
            return null;
        }

        Object setOptionValue(Object value) {
            return null;
        }

        Float getOptionFloatValue(float value) {
            return null;
        }

        Float setOptionFloatValue(float value) {
            return null;
        }

        void onOptionChange() {
        }

        public boolean isChangeable() {
            return true;
        }

        public boolean getEnumFloat() {
            return this.enumFloat;
        }

        public boolean getEnumBoolean() {
            return this.enumBoolean;
        }

        public int returnEnumOrdinal() {
            return this.ordinal();
        }

        public float getValueMax() {
            return this.valueMax;
        }

        public float getValueMin() {
            return this.valueMin;
        }

        public int getDecimalPlaces() {
            return this.decimalPlaces;
        }

        public Pair<String, String> getBooleanLangKeys() {
            return this.booleanLangKeys;
        }

        protected float snapToStep(float value) {
            if (this.valueStep > 0.0f) {
                value = this.valueStep * (float)Math.round(value / this.valueStep);
            }
            return value;
        }

        public double normalizeValue(float value) {
            return Mth.m_14036_((float)((this.snapToStep(value) - this.valueMin) / (this.valueMax - this.valueMin)), (float)0.0f, (float)1.0f);
        }

        public double denormalizeValue(float value) {
            return this.snapToStep(this.valueMin + (this.valueMax - this.valueMin) * Mth.m_14036_((float)value, (float)0.0f, (float)1.0f));
        }
    }

    record ConfigEntry(Field field, VrOptions vrOption, String configName, boolean separate, boolean fixedSize) {
    }
}

