/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.data.VRBodyPartData;
import org.vivecraft.common.api_impl.data.VRBodyPartDataImpl;
import org.vivecraft.common.network.CommonNetworkHelper;
import org.vivecraft.common.utils.MathUtils;

public record Pose(Vector3fc position, Quaternionfc orientation) {
    public static Pose deserialize(FriendlyByteBuf buffer) {
        return new Pose(CommonNetworkHelper.deserializeFVec3(buffer), (Quaternionfc)CommonNetworkHelper.deserializeVivecraftQuaternion(buffer));
    }

    public void serialize(FriendlyByteBuf buffer) {
        CommonNetworkHelper.serializeF(buffer, this.position);
        CommonNetworkHelper.serialize(buffer, this.orientation);
    }

    public VRBodyPartData asBodyPartData(Vec3 playerPos) {
        return new VRBodyPartDataImpl(MathUtils.toMcVec3(this.position).m_82549_(playerPos), MathUtils.toMcVec3((Vector3fc)this.orientation.transform(MathUtils.BACK, new Vector3f())), this.orientation);
    }
}

