/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.player;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_vr.utils.external.jinfinadeck;
import org.vivecraft.client_vr.utils.external.jkatvr;
import org.vivecraft.common.network.packet.c2s.TeleportPayloadC2S;
import org.vivecraft.mixin.client_vr.player.LocalPlayer_PlayerVRMixin;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerVRMixin
extends LocalPlayer_PlayerVRMixin
implements PlayerExtension {
    @Unique
    private Vec3 vivecraft$moveMulIn = Vec3.f_82478_;
    @Unique
    private boolean vivecraft$initFromServer;
    @Unique
    private boolean vivecraft$teleported;
    @Unique
    private double vivecraft$additionX;
    @Unique
    private double vivecraft$additionZ;
    @Unique
    private boolean vivecraft$walkUpBlocksActive = false;
    @Unique
    private final ClientDataHolderVR vivecraft$dataholder = ClientDataHolderVR.getInstance();
    @Unique
    public String vivecraft$lastMsg = null;
    @Final
    @Shadow
    protected Minecraft f_108619_;

    @Shadow
    protected abstract void m_108743_(float var1, float var2);

    @Shadow
    public abstract boolean m_6144_();

    @Shadow
    public abstract InteractionHand m_7655_();

    @Shadow
    public abstract boolean m_6117_();

    @Inject(method={"startRiding"}, at={@At(value="TAIL")})
    private void vivecraft$startRidingTracker(Entity vehicle, boolean force, CallbackInfoReturnable<Boolean> cir) {
        if (VRState.VR_INITIALIZED && this.vivecraft$isLocalPlayer(this)) {
            ClientDataHolderVR.getInstance().vehicleTracker.onStartRiding(vehicle);
        }
    }

    @Inject(method={"removeVehicle"}, at={@At(value="TAIL")})
    private void vivecraft$stopRidingTracker(CallbackInfo ci) {
        if (VRState.VR_INITIALIZED && this.vivecraft$isLocalPlayer(this)) {
            ClientDataHolderVR.getInstance().vehicleTracker.onStopRiding();
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;tick()V")})
    private void vivecraft$preTick(CallbackInfo ci) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this)) {
            ClientDataHolderVR.getInstance().vrPlayer.doPermanentLookOverride((LocalPlayer)this, ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_pre);
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;tick()V", shift=At.Shift.AFTER)})
    private void vivecraft$postTick(CallbackInfo ci) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this)) {
            ClientNetworking.overridePose((LocalPlayer)this);
            ClientDataHolderVR.getInstance().vrPlayer.doPermanentLookOverride((LocalPlayer)this, ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_pre);
        }
    }

    @ModifyVariable(method={"sendPosition"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isPassenger()Z"), ordinal=3)
    private boolean vivecraft$directTeleport(boolean updateRotation) {
        if (this.vivecraft$teleported) {
            updateRotation = true;
            ClientNetworking.sendServerPacket(new TeleportPayloadC2S((float)this.m_20185_(), (float)this.m_20186_(), (float)this.m_20189_()));
        }
        return updateRotation;
    }

    @WrapWithCondition(method={"sendPosition"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isPassenger()Z"))})
    private boolean vivecraft$noMovePacketsOnTeleport(ClientPacketListener instance, Packet packet) {
        return !this.vivecraft$teleported;
    }

    @Inject(method={"sendPosition"}, at={@At(value="FIELD", target="Lnet/minecraft/client/player/LocalPlayer;lastOnGround:Z", shift=At.Shift.AFTER, ordinal=1)})
    private void vivecraft$noAutoJump(CallbackInfo ci) {
        this.vivecraft$teleported = false;
        if (VRState.VR_RUNNING && ClientDataHolderVR.getInstance().vrSettings.walkUpBlocks) {
            this.f_108619_.f_91066_.f_92036_ = false;
        }
    }

    @Inject(method={"chat"}, at={@At(value="TAIL")})
    private void vivecraft$chatMsg(String string, CallbackInfo ci) {
        this.vivecraft$lastMsg = string;
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;aiStep()V")})
    private void vivecraft$VRPlayerTick(CallbackInfo ci) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this)) {
            ClientDataHolderVR.getInstance().vrPlayer.tick((LocalPlayer)this);
        }
    }

    @Inject(method={"move"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$overwriteMove(MoverType type, Vec3 pos, CallbackInfo ci) {
        if (!VRState.VR_RUNNING || !this.vivecraft$isLocalPlayer(this) || Minecraft.m_91087_().m_91288_() != this) {
            if (this.vivecraft$walkUpBlocksActive) {
                this.f_19793_ = 0.6f;
                this.vivecraft$walkUpBlocksActive = false;
            }
            return;
        }
        this.vivecraft$moveMulIn = this.f_19865_;
        if (pos.m_82553_() == 0.0 || this.m_20159_()) {
            super.m_6478_(type, pos);
        } else {
            boolean doY;
            boolean freeMove = VRPlayer.get().getFreeMove();
            boolean bl = doY = freeMove || ClientDataHolderVR.getInstance().vrSettings.simulateFalling && !this.m_6147_() && !this.m_6144_();
            if (ClientDataHolderVR.getInstance().climbTracker.isActive((LocalPlayer)this) && (freeMove || ClientDataHolderVR.getInstance().climbTracker.isGrabbingLadder())) {
                doY = true;
            }
            Vec3 roomOrigin = VRPlayer.get().roomOrigin;
            if ((ClientDataHolderVR.getInstance().climbTracker.isGrabbingLadder() || freeMove || ClientDataHolderVR.getInstance().swimTracker.isActive((LocalPlayer)this)) && (this.f_20902_ != 0.0f || this.m_21255_() || Math.abs(this.m_20184_().f_82479_) > 0.01 || Math.abs(this.m_20184_().f_82481_) > 0.01)) {
                double xOffset = roomOrigin.f_82479_ - this.m_20185_();
                double zOffset = roomOrigin.f_82481_ - this.m_20189_();
                double oldX = this.m_20185_();
                double oldZ = this.m_20189_();
                super.m_6478_(type, pos);
                if (ClientDataHolderVR.getInstance().vrSettings.walkUpBlocks) {
                    this.f_19793_ = this.m_20098_() == 1.0f ? 1.0f : 0.6f;
                    this.vivecraft$walkUpBlocksActive = this.m_20098_() == 1.0f;
                } else {
                    if (this.vivecraft$walkUpBlocksActive) {
                        this.f_19793_ = 0.6f;
                        this.vivecraft$walkUpBlocksActive = false;
                    }
                    this.m_108743_((float)(this.m_20185_() - oldX), (float)(this.m_20189_() - oldZ));
                }
                VRPlayer.get().setRoomOrigin(this.m_20185_() + xOffset, this.m_20186_() + this.vivecraft$getRoomYOffsetFromPose(), this.m_20189_() + zOffset, false);
            } else if (doY) {
                super.m_6478_(type, new Vec3(0.0, pos.f_82480_, 0.0));
                VRPlayer.get().setRoomOrigin(VRPlayer.get().roomOrigin.f_82479_, this.m_20186_() + this.vivecraft$getRoomYOffsetFromPose(), VRPlayer.get().roomOrigin.f_82481_, false);
            } else {
                this.m_6853_(true);
            }
        }
        ci.cancel();
    }

    @ModifyArg(method={"updateAutoJump"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;sin(F)F"))
    private float vivecraft$modifyAutoJumpSin(float original) {
        return VRState.VR_RUNNING ? ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_pre.getBodyYawRad() : original;
    }

    @ModifyArg(method={"updateAutoJump"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;cos(F)F"))
    private float vivecraft$modifyAutoJumpCos(float original) {
        return VRState.VR_RUNNING ? ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_pre.getBodyYawRad() : original;
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")})
    private void vivecraft$hapticsOnEvent(byte id, CallbackInfo ci) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this) && id == 3) {
            ClientDataHolderVR.getInstance().vr.triggerHapticPulse(0, 2000);
            ClientDataHolderVR.getInstance().vr.triggerHapticPulse(1, 2000);
        }
    }

    @Inject(method={"getRopeHoldPosition"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$vrRopePosition(CallbackInfoReturnable<Vec3> cir) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this)) {
            cir.setReturnValue((Object)RenderHelper.getControllerRenderPos(0));
        }
    }

    @Override
    protected void vivecraft$beforeEat(CallbackInfoReturnable<ItemStack> cir, @Local(argsOnly=true) ItemStack food) {
        if (VRState.VR_INITIALIZED && food.m_41614_() && this.vivecraft$isLocalPlayer(this)) {
            ClientDataHolderVR.getInstance().hapticTracker.handleEat(food);
            if (food.m_41786_().getString().equals("EAT ME")) {
                ClientDataHolderVR.getInstance().vrPlayer.wfMode = 0.5;
                ClientDataHolderVR.getInstance().vrPlayer.wfCount = 400;
            }
        }
    }

    @Override
    protected void vivecraft$beforeReleaseUsingItem(CallbackInfo ci) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this)) {
            ClientNetworking.sendActiveHand(this.m_6117_() ? this.m_7655_() : InteractionHand.MAIN_HAND, false);
        }
    }

    @Override
    protected void vivecraft$afterAbsMoveTo(CallbackInfo ci) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this) && this.vivecraft$initFromServer) {
            ClientDataHolderVR.getInstance().vrPlayer.snapRoomOriginToPlayerEntity((Entity)((LocalPlayer)this), false, false);
        }
    }

    @Override
    protected void vivecraft$wrapSetPos(double x, double y, double z, Operation<Void> original) {
        this.vivecraft$initFromServer = true;
        if (!VRState.VR_RUNNING || !this.vivecraft$isLocalPlayer(this)) {
            original.call(new Object[]{x, y, z});
            return;
        }
        boolean wasZero = this.m_20182_() == Vec3.f_82478_;
        double oldX = this.m_20185_();
        double oldY = this.m_20186_();
        double oldZ = this.m_20189_();
        original.call(new Object[]{x, y, z});
        double newX = this.m_20185_();
        double newY = this.m_20186_();
        double newZ = this.m_20189_();
        if (Minecraft.m_91087_().m_91288_() == this && this.m_20159_()) {
            ClientDataHolderVR.getInstance().vehicleTracker.updateRiderPos(x, y, z, this.m_20202_());
        } else if (!ClientDataHolderVR.getInstance().vehicleTracker.isRiding()) {
            if (wasZero) {
                VRPlayer.get().snapRoomOriginToPlayerEntity((Entity)((LocalPlayer)this), x + y + z == 0.0, false);
            } else {
                Vec3 roomOrigin = ClientDataHolderVR.getInstance().vrPlayer.roomOrigin;
                VRPlayer.get().setRoomOrigin(roomOrigin.f_82479_ + (newX - oldX), roomOrigin.f_82480_ + (newY - oldY), roomOrigin.f_82481_ + (newZ - oldZ), x + y + z == 0.0);
            }
        }
    }

    @Override
    protected Vec3 vivecraft$controllerMovement(Vec3 relative, float amount, float facing, Operation<Vec3> original) {
        if (!VRState.VR_RUNNING || !this.vivecraft$isLocalPlayer(this)) {
            return (Vec3)original.call(new Object[]{relative, Float.valueOf(amount), Float.valueOf(facing)});
        }
        double up = relative.f_82480_;
        double strafe = relative.f_82479_;
        double forward = relative.f_82481_;
        VRPlayer vrplayer = this.vivecraft$dataholder.vrPlayer;
        Vec3 movement = Vec3.f_82478_;
        if (vrplayer.getFreeMove()) {
            double speed = strafe * strafe + forward * forward;
            double mX = 0.0;
            double mZ = 0.0;
            double mY = 0.0;
            double addFactor = 1.0;
            if (speed >= (double)1.0E-4f || ClientDataHolderVR.getInstance().katVr) {
                boolean isFlyingOrSwimming;
                if ((speed = (double)Mth.m_14116_((float)((float)speed))) < 1.0 && !ClientDataHolderVR.getInstance().katVr) {
                    speed = 1.0;
                }
                speed = (double)amount / speed;
                Vec3 direction = new Vec3(strafe *= speed, 0.0, forward *= speed);
                boolean bl = isFlyingOrSwimming = !this.m_20159_() && (this.m_150110_().f_35935_ || this.m_6069_());
                if (ClientDataHolderVR.getInstance().katVr) {
                    jkatvr.query();
                    speed = jkatvr.getSpeed() * jkatvr.walkDirection() * this.vivecraft$dataholder.vrSettings.movementSpeedMultiplier;
                    direction = new Vec3(0.0, 0.0, speed);
                    if (isFlyingOrSwimming) {
                        direction = direction.m_82496_(vrplayer.vrdata_world_pre.hmd.getPitchRad());
                    }
                    direction = direction.m_82524_(-jkatvr.getYaw() * ((float)Math.PI / 180) + vrplayer.vrdata_world_pre.rotation_radians);
                } else if (ClientDataHolderVR.getInstance().infinadeck) {
                    jinfinadeck.query();
                    speed = jinfinadeck.getSpeed() * jinfinadeck.walkDirection() * this.vivecraft$dataholder.vrSettings.movementSpeedMultiplier;
                    direction = new Vec3(0.0, 0.0, speed);
                    if (isFlyingOrSwimming) {
                        direction = direction.m_82496_(vrplayer.vrdata_world_pre.hmd.getPitchRad());
                    }
                    direction = direction.m_82524_(-jinfinadeck.getYaw() * ((float)Math.PI / 180) + vrplayer.vrdata_world_pre.rotation_radians);
                } else if (this.vivecraft$dataholder.vrSettings.seated) {
                    int c = 0;
                    if (this.vivecraft$dataholder.vrSettings.seatedUseHMD) {
                        c = 1;
                    }
                    if (isFlyingOrSwimming) {
                        direction = direction.m_82496_(vrplayer.vrdata_world_pre.getController(c).getPitchRad());
                    }
                    direction = direction.m_82524_(-vrplayer.vrdata_world_pre.getController(c).getYawRad());
                } else {
                    VRSettings.FreeMove freeMoveType = this.vivecraft$dataholder.vrSettings.getVrFreeMoveMode(!this.m_20159_() && this.m_150110_().f_35935_, vrplayer.vrdata_world_pre.fbtMode);
                    if (isFlyingOrSwimming) {
                        switch (freeMoveType) {
                            case CONTROLLER: {
                                Vec3 vec3 = direction.m_82496_(vrplayer.vrdata_world_pre.getController(1).getPitchRad());
                                break;
                            }
                            case HMD: 
                            case RUN_IN_PLACE: 
                            case ROOM: 
                            case WAIST: {
                                Vec3 vec3 = direction.m_82496_(vrplayer.vrdata_world_pre.hmd.getPitchRad());
                                break;
                            }
                            default: {
                                Vec3 vec3 = direction = direction;
                            }
                        }
                    }
                    if (this.vivecraft$dataholder.jumpTracker.isjumping()) {
                        direction = direction.m_82524_(-vrplayer.vrdata_world_pre.hmd.getYawRad());
                    } else {
                        direction = switch (freeMoveType) {
                            case VRSettings.FreeMove.CONTROLLER -> direction.m_82524_(-vrplayer.vrdata_world_pre.getController(1).getYawRad());
                            case VRSettings.FreeMove.HMD -> direction.m_82524_(-vrplayer.vrdata_world_pre.hmd.getYawRad());
                            case VRSettings.FreeMove.RUN_IN_PLACE -> direction.m_82524_((float)(-this.vivecraft$dataholder.runTracker.getYaw())).m_82490_(this.vivecraft$dataholder.runTracker.getSpeed());
                            case VRSettings.FreeMove.ROOM -> direction.m_82524_((180.0f + this.vivecraft$dataholder.vrSettings.worldRotation) * ((float)Math.PI / 180));
                            case VRSettings.FreeMove.WAIST -> direction.m_82524_(-vrplayer.vrdata_world_pre.waist.getYawRad());
                            default -> direction;
                        };
                    }
                }
                mX = direction.f_82479_;
                mY = direction.f_82480_;
                mZ = direction.f_82481_;
                if (this.m_20096_() && !this.m_150110_().f_35935_ && !this.f_19798_) {
                    addFactor = this.vivecraft$dataholder.vrSettings.inertiaFactor.getFactor();
                }
                float yAdd = 1.0f;
                if (this.m_150110_().f_35935_) {
                    yAdd = 5.0f;
                }
                movement = new Vec3(mX * addFactor, mY * (double)yAdd, mZ * addFactor);
                this.vivecraft$additionX = mX;
                this.vivecraft$additionZ = mZ;
            }
        }
        return movement;
    }

    @Override
    protected void vivecraft$afterMoveRelative(CallbackInfo ci) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this) && ClientDataHolderVR.getInstance().vrPlayer.getFreeMove() && this.m_20096_() && !this.m_150110_().f_35935_ && !this.f_19798_) {
            this.vivecraft$doDrag();
        }
    }

    @Unique
    private void vivecraft$doDrag() {
        double friction = 0.91;
        if (this.m_20096_()) {
            friction *= (double)this.f_19853_.m_8055_(this.m_20099_()).m_60734_().m_49958_();
        }
        this.m_20334_(this.m_20184_().f_82479_ / friction, this.m_20184_().f_82480_, this.m_20184_().f_82481_ / friction);
        double addFactor = this.vivecraft$dataholder.vrSettings.inertiaFactor.getFactor();
        double boundedAdditionX = this.vivecraft$getBoundedAddition(this.vivecraft$additionX);
        double targetLimitX = friction * boundedAdditionX / (1.0 - friction);
        double multiFactorX = targetLimitX / (friction * (targetLimitX + boundedAdditionX * addFactor));
        double xFactor = friction * multiFactorX;
        double boundedAdditionZ = this.vivecraft$getBoundedAddition(this.vivecraft$additionZ);
        double targetLimitZ = friction * boundedAdditionZ / (1.0 - friction);
        double multiFactorZ = targetLimitZ / (friction * (targetLimitZ + boundedAdditionZ * addFactor));
        double zFactor = friction * multiFactorZ;
        this.m_20334_(this.m_20184_().f_82479_ * xFactor, this.m_20184_().f_82480_, this.m_20184_().f_82481_ * zFactor);
    }

    @Unique
    private double vivecraft$getBoundedAddition(double orig) {
        return orig >= -1.0E-6 && orig <= 1.0E-6 ? 1.0E-6 : orig;
    }

    @Unique
    private boolean vivecraft$isLocalPlayer(Object player) {
        return player.getClass().equals(LocalPlayer.class) || Minecraft.m_91087_().f_91074_ == player;
    }

    @Override
    @Unique
    public boolean vivecraft$getInitFromServer() {
        return this.vivecraft$initFromServer;
    }

    @Override
    @Unique
    public float vivecraft$getMuhSpeedFactor() {
        return this.vivecraft$moveMulIn != null && this.vivecraft$moveMulIn.m_82556_() > 0.0 ? this.m_6041_() * (float)(this.vivecraft$moveMulIn.f_82479_ + this.vivecraft$moveMulIn.f_82481_) * 0.5f : this.m_6041_();
    }

    @Override
    @Unique
    public float vivecraft$getMuhJumpFactor() {
        return this.vivecraft$moveMulIn != null && this.vivecraft$moveMulIn.m_82556_() > 0.0 ? this.m_20098_() * (float)this.vivecraft$moveMulIn.f_82480_ : this.m_20098_();
    }

    @Override
    @Unique
    public void vivecraft$stepSound(BlockPos blockPos, Vec3 soundPos) {
        BlockState blockState = this.f_19853_.m_8055_(blockPos);
        SoundType soundType = blockState.m_60827_();
        BlockState aboveBlockState = this.f_19853_.m_8055_(blockPos.m_7494_());
        if (aboveBlockState.m_60713_(Blocks.f_50125_)) {
            soundType = aboveBlockState.m_60827_();
        }
        if (!this.m_20067_() && !blockState.m_60767_().m_76332_()) {
            float volume = soundType.m_56773_();
            float pitch = soundType.m_56774_();
            SoundEvent soundevent = soundType.m_56776_();
            this.f_19853_.m_6263_(null, soundPos.f_82479_, soundPos.f_82480_, soundPos.f_82481_, soundevent, this.m_5720_(), volume, pitch);
        }
    }

    @Override
    @Unique
    public void vivecraft$setTeleported(boolean teleported) {
        this.vivecraft$teleported = teleported;
    }

    @Override
    @Unique
    public void vivecraft$setItemInUseRemainingClient(int count) {
        this.f_20936_ = count;
    }

    @Override
    @Unique
    public double vivecraft$getRoomYOffsetFromPose() {
        if (this.m_20089_() == Pose.FALL_FLYING || this.m_20089_() == Pose.SPIN_ATTACK || this.m_20089_() == Pose.SWIMMING && !ClientDataHolderVR.getInstance().crawlTracker.crawlsteresis) {
            return -1.2;
        }
        return 0.0;
    }

    @Override
    @Unique
    public String vivecraft$getLastMsg() {
        return this.vivecraft$lastMsg;
    }

    @Override
    @Unique
    public void vivecraft$setLastMsg(String string) {
        this.vivecraft$lastMsg = string;
    }
}

