/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.renderer;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.io.IOException;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.extensions.RenderTargetExtension;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MultiPassList;
import org.vivecraft.client_vr.MultiPassRenderTarget;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.PostChainExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_xr.render_pass.RenderPassManager;
import org.vivecraft.client_xr.render_pass.RenderPassType;
import org.vivecraft.client_xr.render_pass.WorldRenderPass;

@Mixin(value={PostChain.class})
public abstract class PostChainVRMixin
implements PostChainExtension {
    @Shadow
    @Final
    private RenderTarget f_110006_;
    @Shadow
    @Final
    @Mutable
    private List<PostPass> f_110009_;
    @Shadow
    @Final
    private String f_110008_;
    @Shadow
    @Final
    private ResourceManager f_110007_;
    @Unique
    private final EnumMap<RenderPass, PostChain> vivecraft$VRPostChains = new EnumMap(RenderPass.class);
    @Unique
    private boolean vivecraft$mainPostChain;

    @Accessor
    public abstract List<PostPass> getPasses();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void vivecraft$createVRChains(TextureManager textureManager, ResourceManager resourceManager, RenderTarget screenTarget, ResourceLocation name, CallbackInfo ci) throws IOException {
        if (this.f_110006_ == RenderPassManager.INSTANCE.vanillaRenderTarget) {
            this.vivecraft$mainPostChain = true;
            ClientDataHolderVR.getInstance().activePostchains.put(this.f_110008_, this);
            this.vivecraft$updatePasses();
            this.f_110009_ = new MultiPassList<PostPass>(this.f_110009_, pass -> this.vivecraft$VRPostChains.containsKey(pass) ? ((PostChainVRMixin)this.vivecraft$VRPostChains.get(pass)).getPasses() : null);
        } else {
            this.vivecraft$mainPostChain = false;
        }
    }

    @Inject(method={"getTempTarget"}, at={@At(value="RETURN")}, cancellable=true)
    private void vivecraft$getVRTempTarget(String attributeName, CallbackInfoReturnable<RenderTarget> cir) {
        if (cir.getReturnValue() != null && VRState.VR_INITIALIZED && this.vivecraft$mainPostChain) {
            cir.setReturnValue((Object)new MultiPassRenderTarget((RenderTarget)cir.getReturnValue(), pass -> this.vivecraft$VRPostChains.containsKey(pass) ? this.vivecraft$VRPostChains.get(pass).m_110036_(attributeName) : null));
        }
    }

    @ModifyVariable(method={"addTempTarget"}, at=@At(value="STORE"), ordinal=0)
    private RenderTarget vivecraft$vrTargetStencil(RenderTarget renderTarget) {
        if (((RenderTargetExtension)this.f_110006_).vivecraft$hasStencil()) {
            ((RenderTargetExtension)renderTarget).vivecraft$setStencil(true);
            renderTarget.m_83941_(renderTarget.f_83915_, renderTarget.f_83916_, Minecraft.f_91002_);
        }
        return renderTarget;
    }

    @Inject(method={"close"}, at={@At(value="TAIL")})
    private void vivecraft$closeVRChains(CallbackInfo ci) {
        for (PostChain postChain : this.vivecraft$VRPostChains.values()) {
            postChain.close();
        }
        this.vivecraft$VRPostChains.clear();
        if (this.vivecraft$mainPostChain) {
            ClientDataHolderVR.getInstance().activePostchains.remove(this.f_110008_);
        }
    }

    @Inject(method={"resize"}, at={@At(value="TAIL")})
    private void vivecraft$resizeVRChains(CallbackInfo ci) {
        for (Map.Entry<RenderPass, PostChain> entry : this.vivecraft$VRPostChains.entrySet()) {
            RenderTarget target = null;
            if (entry.getKey() == RenderPass.GUI) {
                target = GuiHandler.GUI_FRAMEBUFFER;
            } else {
                WorldRenderPass pass = WorldRenderPass.getByRenderPass(entry.getKey());
                if (pass != null) {
                    target = pass.target;
                }
            }
            if (target == null) continue;
            entry.getValue().m_110025_(target.f_83915_, target.f_83916_);
        }
    }

    @Inject(method={"process"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$renderVRChain(float partialTick, CallbackInfo ci) {
        if (!RenderPassType.isVanilla() && this.vivecraft$VRPostChains.containsKey((Object)ClientDataHolderVR.getInstance().currentPass)) {
            this.vivecraft$VRPostChains.get((Object)ClientDataHolderVR.getInstance().currentPass).m_110023_(partialTick);
            ci.cancel();
        }
    }

    @Override
    @Unique
    public void vivecraft$updatePasses() throws IOException {
        if (!this.vivecraft$mainPostChain) {
            return;
        }
        for (PostChain chain : this.vivecraft$VRPostChains.values()) {
            chain.close();
        }
        this.vivecraft$VRPostChains.clear();
        if (VRState.VR_INITIALIZED) {
            TextureManager textureManager = Minecraft.m_91087_().m_91097_();
            ResourceLocation resourceLocation = new ResourceLocation(this.f_110008_);
            for (RenderPass pass : RenderPass.values()) {
                RenderTarget target = null;
                if (pass == RenderPass.GUI) {
                    target = GuiHandler.GUI_FRAMEBUFFER;
                } else {
                    if (WorldRenderPass.getByRenderPass(pass) == null) continue;
                    target = WorldRenderPass.getByRenderPass((RenderPass)pass).target;
                }
                if (target == null) continue;
                PostChain subChain = new PostChain(textureManager, this.f_110007_, target, resourceLocation);
                this.vivecraft$VRPostChains.put(pass, subChain);
                subChain.m_110025_(target.f_83915_, target.f_83916_);
            }
        }
    }
}

