/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Vector3f;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.client.utils.UpdateChecker;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ConfigBuilder;
import org.vivecraft.server.config.ServerConfig;

public class ServerUtil {
    public static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor();

    public static void scheduleWelcomeMessageOrKick(ServerPlayer serverPlayer) {
        if (((Boolean)ServerConfig.MESSAGES_ENABLED.get()).booleanValue() || ((Boolean)ServerConfig.VIVE_ONLY.get()).booleanValue() || ((Boolean)ServerConfig.VR_ONLY.get()).booleanValue()) {
            SCHEDULER.schedule(() -> {
                if (!serverPlayer.m_9232_()) {
                    ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer(serverPlayer);
                    String message = "";
                    if (ServerUtil.kickIfNotAllowed(serverPlayer)) {
                        return;
                    }
                    if (((Boolean)ServerConfig.MESSAGES_ENABLED.get()).booleanValue() && !(message = vivePlayer == null ? (String)ServerConfig.MESSAGES_WELCOME_VANILLA.get() : (!vivePlayer.isVR() ? (String)ServerConfig.MESSAGES_WELCOME_NONVR.get() : (vivePlayer.isSeated() ? (String)ServerConfig.MESSAGES_WELCOME_SEATED.get() : (String)ServerConfig.MESSAGES_WELCOME_VR.get()))).isEmpty()) {
                        try {
                            serverPlayer.f_8924_.m_6846_().m_11264_((Component)new TextComponent(message.formatted(serverPlayer.m_7755_().getString())), ChatType.SYSTEM, Util.f_137441_);
                        }
                        catch (IllegalFormatException e) {
                            ServerNetworking.LOGGER.error("Vivecraft: Welcome message '{}' has errors: ", (Object)message, (Object)e);
                        }
                    }
                }
            }, (long)((Double)ServerConfig.MESSAGE_KICK_DELAY.get() * 1000.0), TimeUnit.MILLISECONDS);
        }
    }

    public static boolean kickIfNotAllowed(ServerPlayer player) {
        if (!player.m_9232_()) {
            boolean isOpAndAllowed;
            ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer(player);
            boolean bl = isOpAndAllowed = (Boolean)ServerConfig.ALLOW_OP.get() != false && player.f_8924_.m_6846_().m_11303_(player.m_36316_());
            if (!(isOpAndAllowed || !((Boolean)ServerConfig.VR_ONLY.get()).booleanValue() || vivePlayer != null && vivePlayer.isVR())) {
                String kickMessage = (String)ServerConfig.MESSAGES_KICK_VR_ONLY.get();
                try {
                    kickMessage = kickMessage.formatted(player.m_7755_().getString());
                }
                catch (IllegalFormatException e) {
                    ServerNetworking.LOGGER.error("Vivecraft: KickVROnly message '{}' has errors: ", (Object)kickMessage, (Object)e);
                }
                player.f_8906_.m_9942_((Component)new TextComponent(kickMessage));
                return true;
            }
            if (!isOpAndAllowed && ((Boolean)ServerConfig.VIVE_ONLY.get()).booleanValue() && vivePlayer == null) {
                String kickMessage = (String)ServerConfig.MESSAGES_KICK_VIVE_ONLY.get();
                try {
                    kickMessage = kickMessage.formatted(player.m_7755_().getString());
                }
                catch (IllegalFormatException e) {
                    ServerNetworking.LOGGER.error("Vivecraft: KickViveOnly message '{}' has errors: ", (Object)kickMessage, (Object)e);
                }
                player.f_8906_.m_9942_((Component)new TextComponent(kickMessage));
                return true;
            }
        }
        return false;
    }

    public static void sendUpdateNotificationIfOP(ServerPlayer serverPlayer) {
        if (((Boolean)ServerConfig.CHECK_FOR_UPDATES.get()).booleanValue() && serverPlayer.f_8924_.m_6982_() && serverPlayer.f_8924_.m_6846_().m_11303_(serverPlayer.m_36316_())) {
            SCHEDULER.schedule(() -> {
                if (UpdateChecker.checkForUpdates()) {
                    serverPlayer.m_6352_((Component)new TextComponent("Vivecraft update available: \u00a7a" + UpdateChecker.NEWEST_VERSION), Util.f_137441_);
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"vivecraft-server-config").requires(source -> source.m_6761_(4))).then(Commands.m_82127_((String)"reload").executes(context -> {
            ServerConfig.init((action, path, incorrectValue, correctedValue) -> {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Corrected \u00a7a[%s]\u00a7r: was '(%s)%s', is now '(%s)%s'".formatted(String.join((CharSequence)"\u00a7r.\u00a7a", path), incorrectValue.getClass().getSimpleName(), incorrectValue, correctedValue.getClass().getSimpleName(), correctedValue)), true);
                String pathString = String.join((CharSequence)".", path);
                ServerConfig.getConfigValues().stream().filter(c -> c.getPath().equals(pathString)).findFirst().ifPresent(setting -> {
                    setting.onUpdate(((CommandSourceStack)context.getSource()).m_81377_());
                    ServerNetworking.sendUpdatePacketToAll(((CommandSourceStack)context.getSource()).m_81377_(), setting);
                });
            });
            return 1;
        })));
        for (ConfigBuilder.ConfigValue setting : ServerConfig.getConfigValues()) {
            IntegerArgumentType argument;
            String argumentName;
            Class<?> clazz = setting.get().getClass();
            if (clazz == Integer.class) {
                argumentName = "int";
                argument = IntegerArgumentType.integer();
            } else if (clazz == Double.class) {
                argumentName = "double";
                argument = DoubleArgumentType.doubleArg();
            } else if (clazz == Boolean.class) {
                argumentName = "bool";
                argument = BoolArgumentType.bool();
            } else {
                argumentName = "string";
                argument = StringArgumentType.string();
            }
            LiteralArgumentBuilder baseCommand = Commands.m_82127_((String)setting.getPath());
            if (setting instanceof ConfigBuilder.InListValue) {
                ConfigBuilder.InListValue inListValue = (ConfigBuilder.InListValue)setting;
                baseCommand.then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)argumentName, (ArgumentType)argument).suggests((context, builder) -> {
                    for (Object value : inListValue.getValidValues()) {
                        if (!value.toString().toLowerCase().contains(builder.getRemainingLowerCase())) continue;
                        builder.suggest(value.toString());
                    }
                    return builder.buildFuture();
                }).executes(context -> {
                    Object newValue = context.getArgument(argumentName, clazz);
                    if (inListValue.getValidValues().contains(newValue)) {
                        setting.set(newValue);
                        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("set \u00a7a[%s]\u00a7r to '%s'".formatted(setting.getPath(), newValue)), true);
                        setting.onUpdate(((CommandSourceStack)context.getSource()).m_81377_());
                        ServerNetworking.sendUpdatePacketToAll(((CommandSourceStack)context.getSource()).m_81377_(), setting);
                        return 1;
                    }
                    throw new CommandSyntaxException((CommandExceptionType)CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument(), (Message)new TextComponent("Unsupported value: " + newValue.toString()));
                })));
            } else if (setting instanceof ConfigBuilder.EnumValue) {
                ConfigBuilder.EnumValue enumValue = (ConfigBuilder.EnumValue)setting;
                baseCommand.then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)argumentName, (ArgumentType)argument).suggests((context, builder) -> {
                    for (Enum value : enumValue.getValidValues()) {
                        if (!value.toString().toLowerCase().contains(builder.getRemainingLowerCase())) continue;
                        builder.suggest(value.toString());
                    }
                    return builder.buildFuture();
                }).executes(context -> {
                    Object newValue = context.getArgument(argumentName, String.class);
                    Object newEnumValue = enumValue.getEnumValue(newValue);
                    if (newEnumValue != null) {
                        setting.set(newEnumValue);
                        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("set \u00a7a[%s]\u00a7r to '%s'".formatted(setting.getPath(), newEnumValue)), true);
                        setting.onUpdate(((CommandSourceStack)context.getSource()).m_81377_());
                        ServerNetworking.sendUpdatePacketToAll(((CommandSourceStack)context.getSource()).m_81377_(), setting);
                        return 1;
                    }
                    throw new CommandSyntaxException((CommandExceptionType)CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument(), (Message)new TextComponent("Unsupported value: " + newValue.toString()));
                })));
            } else if (!(setting.get() instanceof List)) {
                baseCommand.then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)argumentName, (ArgumentType)argument).executes(context -> {
                    Object newValue = context.getArgument(argumentName, clazz);
                    setting.set(newValue);
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("set \u00a7a[%s]\u00a7r to '%s'".formatted(setting.getPath(), newValue)), true);
                    setting.onUpdate(((CommandSourceStack)context.getSource()).m_81377_());
                    ServerNetworking.sendUpdatePacketToAll(((CommandSourceStack)context.getSource()).m_81377_(), setting);
                    return 1;
                })));
            } else {
                ConfigBuilder.ConfigValue listConfig = setting;
                baseCommand.then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"block", (ArgumentType)BlockStateArgument.m_116120_()).executes(context -> {
                    try {
                        String newValue = Registry.f_122824_.m_7981_((Object)((BlockInput)context.getArgument("block", BlockInput.class)).m_114669_().m_60734_()).toString();
                        List list = (List)listConfig.get();
                        list.add(newValue);
                        listConfig.set(list);
                        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("added '%s' to \u00a7a[%s]\u00a7r".formatted(newValue, setting.getPath())), true);
                        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("is now '%s'".formatted(setting.get())), true);
                        setting.onUpdate(((CommandSourceStack)context.getSource()).m_81377_());
                        ServerNetworking.sendUpdatePacketToAll(((CommandSourceStack)context.getSource()).m_81377_(), setting);
                        return 1;
                    }
                    catch (Exception e) {
                        ServerNetworking.LOGGER.error("Vivecraft: error adding block to list:", (Throwable)e);
                        return 0;
                    }
                })));
                baseCommand.then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"block", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
                    for (String block : (List)listConfig.get()) {
                        if (!block.contains(builder.getRemaining())) continue;
                        builder.suggest(block);
                    }
                    return builder.buildFuture();
                }).executes(context -> {
                    String newValue = (String)context.getArgument("block", String.class);
                    List list = (List)listConfig.get();
                    list.remove(newValue);
                    listConfig.set(list);
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("removed '%s' from \u00a7a[%s]\u00a7r".formatted(newValue, setting.getPath())), true);
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("is now '%s'".formatted(setting.get())), true);
                    setting.onUpdate(((CommandSourceStack)context.getSource()).m_81377_());
                    ServerNetworking.sendUpdatePacketToAll(((CommandSourceStack)context.getSource()).m_81377_(), setting);
                    return 1;
                })));
            }
            baseCommand.then(Commands.m_82127_((String)"reset").executes(context -> {
                Object newValue = setting.reset();
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("reset \u00a7a[%s]\u00a7r to '%s'".formatted(setting.getPath(), newValue)), true);
                setting.onUpdate(((CommandSourceStack)context.getSource()).m_81377_());
                ServerNetworking.sendUpdatePacketToAll(((CommandSourceStack)context.getSource()).m_81377_(), setting);
                return 1;
            }));
            baseCommand.executes(context -> {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("\u00a7a[%s]\u00a7r is set to '%s'".formatted(setting.getPath(), setting.get())), true);
                return 1;
            });
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"vivecraft-server-config").requires(source -> source.m_6761_(4))).then((ArgumentBuilder)baseCommand));
        }
    }

    public static void debugParticleAxes(ServerVivePlayer vivePlayer) {
        if (vivePlayer.isVR() && vivePlayer.vrPlayerState() != null) {
            for (VRBodyPart bodyPart : VRBodyPart.values()) {
                if (!bodyPart.availableInMode(vivePlayer.vrPlayerState().fbtMode()) || bodyPart == VRBodyPart.HEAD) continue;
                ServerUtil.debugParticleAxes(vivePlayer.player.m_183503_(), vivePlayer.getBodyPartPos(bodyPart), vivePlayer.vrPlayerState().getBodyPartPose(bodyPart).orientation());
            }
            if (((Boolean)ServerConfig.DEBUG_PARTICLES_HEAD.get()).booleanValue()) {
                ServerUtil.debugParticleAxes(vivePlayer.player.m_183503_(), vivePlayer.getHMDPos(), vivePlayer.vrPlayerState().hmd().orientation());
            }
        }
    }

    public static void debugParticleAxes(ServerLevel level, Vec3 position, Quaternionfc rot) {
        org.joml.Vector3f red = new org.joml.Vector3f(1.0f, 0.0f, 0.0f);
        org.joml.Vector3f green = new org.joml.Vector3f(0.0f, 1.0f, 0.0f);
        org.joml.Vector3f blue = new org.joml.Vector3f(0.0f, 0.0f, 1.0f);
        org.joml.Vector3f forward = rot.transform(MathUtils.BACK, new org.joml.Vector3f());
        org.joml.Vector3f up = rot.transform(MathUtils.UP, new org.joml.Vector3f());
        org.joml.Vector3f right = rot.transform(MathUtils.RIGHT, new org.joml.Vector3f());
        ServerUtil.spawnParticlesDirection(level, blue, position, forward);
        ServerUtil.spawnParticlesDirection(level, green, position, up);
        ServerUtil.spawnParticlesDirection(level, red, position, right);
    }

    public static void spawnParticlesDirection(ServerLevel level, org.joml.Vector3f color, Vec3 position, org.joml.Vector3f direction) {
        DustParticleOptions particle = new DustParticleOptions(new Vector3f(color.x, color.y, color.z), 0.25f);
        for (int i = 0; i < 5; ++i) {
            org.joml.Vector3f offset = direction.mul(0.0625f * (float)i, new org.joml.Vector3f());
            level.m_8767_((ParticleOptions)particle, position.f_82479_ + (double)offset.x, position.f_82480_ + (double)offset.y, position.f_82481_ + (double)offset.z, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(SCHEDULER::shutdownNow));
    }
}

