/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server.config;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import org.vivecraft.client.gui.framework.screens.GuiStringListEditorScreen;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.config.ConfigBuilder;

public class WidgetBuilder {
    public static Supplier<AbstractWidget> getBaseWidget(ConfigBuilder.ConfigValue<?> value, int width, int height) {
        return () -> new Button(0, 0, width, height, (Component)new TranslatableComponent("" + value.get()), button -> {});
    }

    public static Supplier<AbstractWidget> getOnOffWidget(ConfigBuilder.BooleanValue booleanValue, int width, int height) {
        return () -> CycleButton.m_168916_((boolean)((Boolean)booleanValue.get())).m_168929_().m_168936_(0, 0, width, height, TextComponent.f_131282_, (button, bool) -> {
            booleanValue.set(bool);
            WidgetBuilder.updateSettingsSinglePlayer(booleanValue);
        });
    }

    public static Supplier<AbstractWidget> getEditBoxWidget(final ConfigBuilder.StringValue stringValue, int width, int height) {
        return () -> {
            EditBox box = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, width - 1, height, (Component)new TextComponent((String)stringValue.get())){

                public boolean m_5534_(char character, int modifiers) {
                    boolean ret = super.m_5534_(character, modifiers);
                    stringValue.set(this.m_94155_());
                    return ret;
                }

                public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
                    boolean ret = super.m_7933_(keyCode, scanCode, modifiers);
                    stringValue.set(this.m_94155_());
                    return ret;
                }
            };
            box.m_94199_(1000);
            box.m_94144_((String)stringValue.get());
            return box;
        };
    }

    public static <T> Supplier<AbstractWidget> getCycleWidget(ConfigBuilder.ConfigValue<T> configValue, Collection<? extends T> values, int width, int height) {
        return () -> CycleButton.m_168894_(newValue -> new TranslatableComponent("vivecraft.serverSettings." + configValue.getPath() + "." + newValue)).m_168948_(configValue.get()).m_168961_(values.toArray()).m_168948_(configValue.get()).m_168929_().m_168936_(0, 0, width, height, TextComponent.f_131282_, (button, newValue) -> {
            configValue.set(newValue);
            WidgetBuilder.updateSettingsSinglePlayer(configValue);
        });
    }

    public static <E extends Number> Supplier<AbstractWidget> getSliderWidget(final ConfigBuilder.NumberValue<E> numberValue, int width, int height) {
        return () -> new AbstractSliderButton(0, 0, width, height, (Component)new TextComponent("" + numberValue.get()), numberValue.normalize()){

            protected void m_5695_() {
                this.m_93666_((Component)new TextComponent("" + numberValue.get()));
            }

            protected void m_5697_() {
                numberValue.fromNormalized(this.f_93577_);
                WidgetBuilder.updateSettingsSinglePlayer(numberValue);
            }
        };
    }

    public static <T> Supplier<AbstractWidget> getEditListWidget(ConfigBuilder.ListValue<T> listValue, int width, int height) {
        Object first;
        Object object = first = ((List)listValue.get()).isEmpty() ? null : (Object)((List)listValue.get()).get(0);
        if (first == null || first instanceof String) {
            ConfigBuilder.ListValue stringValue = listValue;
            return () -> new Button(0, 0, width, height, (Component)new TranslatableComponent("vivecraft.options.editlist"), button -> Minecraft.m_91087_().m_91152_((Screen)new GuiStringListEditorScreen((Component)new TranslatableComponent("vivecraft.serverSettings." + listValue.getPath()), Minecraft.m_91087_().f_91080_, false, stringValue::get, stringValue::reset, list -> {
                stringValue.set(list);
                WidgetBuilder.updateSettingsSinglePlayer(stringValue);
            })));
        }
        throw new RuntimeException("Unsupported listvalue type: " + first.getClass().getName());
    }

    private static void updateSettingsSinglePlayer(ConfigBuilder.ConfigValue<?> configValue) {
        if (Minecraft.m_91087_().m_91091_()) {
            configValue.onUpdate((MinecraftServer)Minecraft.m_91087_().m_91092_());
            ServerNetworking.sendUpdatePacketToAll((MinecraftServer)Minecraft.m_91087_().m_91092_(), configValue);
        }
    }
}

