/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.vivecraft.client.gui.framework.screens.GuiListScreen;
import org.vivecraft.client.gui.framework.widgets.SettingsList;

public class GuiStringListEditorScreen
extends GuiListScreen {
    private final Supplier<List<String>> valuesSupplier;
    private final Runnable loadDefaults;
    private final Consumer<List<String>> save;
    private final boolean fixedEntryCount;
    private List<String> elements;

    public GuiStringListEditorScreen(Component title, Screen lastScreen, boolean fixedEntryCount, Supplier<List<String>> valuesSupplier, Runnable loadDefaults, Consumer<List<String>> save) {
        super(title, lastScreen);
        this.fixedEntryCount = fixedEntryCount;
        this.valuesSupplier = valuesSupplier;
        this.loadDefaults = loadDefaults;
        this.save = save;
        this.searchable = false;
    }

    @Override
    protected void addLowerButtons(int top) {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"vivecraft.gui.loaddefaults"), button -> {
            this.loadDefaults.run();
            this.elements = null;
            this.reinit = true;
        }).bounds(this.width / 2 - 155, top, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.back"), button -> this.onClose()).bounds(this.width / 2 + 5, top, 150, 20).build());
    }

    @Override
    public void onClose() {
        this.save.accept(this.elements);
        super.onClose();
    }

    private List<String> getCurrentValues() {
        return this.list.children().stream().map(entry -> {
            if (entry instanceof StringValueEntry) {
                StringValueEntry listValueEntry = (StringValueEntry)((Object)entry);
                return listValueEntry.getString();
            }
            return "";
        }).filter(string -> !string.isEmpty()).collect(Collectors.toList());
    }

    @Override
    protected List<SettingsList.BaseEntry> getEntries() {
        LinkedList<SettingsList.BaseEntry> entries = new LinkedList<SettingsList.BaseEntry>();
        if (this.elements == null) {
            this.elements = new ArrayList<String>((Collection)this.valuesSupplier.get());
        }
        int i = 0;
        for (String item : this.elements) {
            EditBox box = new EditBox(this.minecraft.font, 0, 0, 350, 20, (Component)Component.literal((String)item));
            box.setMaxLength(1000);
            box.setValue(item);
            int index = i++;
            box.setResponder(s -> this.elements.set(index, (String)s));
            entries.add(new StringValueEntry((Component)Component.empty(), box, button -> {
                this.elements.remove(index);
                this.reinit = true;
            }, !this.fixedEntryCount));
        }
        if (!this.fixedEntryCount) {
            entries.add(new SettingsList.WidgetEntry((Component)Component.literal((String)""), (AbstractWidget)Button.builder((Component)Component.translatable((String)"vivecraft.options.addnew"), button -> {
                this.elements = this.getCurrentValues();
                this.elements.add("");
                this.reinit = true;
            }).size(145, 20).build()));
        }
        return entries;
    }

    private static class StringValueEntry
    extends SettingsList.BaseEntry {
        private final EditBox editBox;
        private final Button deleteButton;

        public StringValueEntry(Component name, EditBox editBox, Button.OnPress deleteAction, boolean deletable) {
            super(name, null);
            this.editBox = editBox;
            this.deleteButton = Button.builder((Component)Component.literal((String)(deletable ? "-" : "X")), (Button.OnPress)(deletable ? deleteAction : b -> this.editBox.setValue(""))).tooltip(Tooltip.create((Component)Component.translatable((String)"selectWorld.delete"))).bounds(0, 0, 20, 20).build();
        }

        @Override
        public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.editBox.setX(left);
            this.editBox.setY(top);
            this.editBox.setWidth(width - 20);
            this.editBox.render(guiGraphics, mouseX, mouseY, partialTick);
            this.deleteButton.setX(left + width - 20);
            this.deleteButton.setY(top);
            this.deleteButton.render(guiGraphics, mouseX, mouseY, partialTick);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (this.getFocused() == this.editBox && keyCode == 262 && this.editBox.getValue().length() == this.editBox.getCursorPosition()) {
                return false;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.editBox, (Object)this.deleteButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.editBox, (Object)this.deleteButton);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.editBox.active = active;
            this.deleteButton.active = active;
        }

        public String getString() {
            return this.editBox.getValue();
        }
    }
}

